UNIT Endecode;

{***************************************************************************
 *                                                                         *
 *                     Copyright 1988 Trevor J Carlsen                     *
 *                   Rovert Software Consulting Services                   *
 *                                PO Box 568                               *
 *                   Port Hedland Western Australia 6721                   *
 *                                                                         *
 *                                                                         *
 *                  Simple encryption decryption routines.                 *
 *                                                                         *
 ***************************************************************************}


interface

FUNCTION MakeCodeStr(len : byte;st : string): string;
FUNCTION EncryptStr(st : string): string;
FUNCTION DecryptStr(st : string): string;

implementation

FUNCTION MakeCodeStr(len: byte;st : string): string;
{ Creates a "randomly" constructed string of a similar length as the string
  which is to be encrypted. The ASCII code of the last character of that
  string is used (along with the string length) to produce a number for the
  random generator seed that will be almost unique. I say almost, because it
  is obvious that two identical length strings that share a common last
  character will produce the same code string. However this would be rare
  enough for normal encryption needs.
  This code string is then XORd with the original string to produce the
  encrypted string. The last character however must be treated differently
  so that it can be easily decoded in order to produce the coded string used
  for decoding. This is done by XORing it with the length of the string. To
  decrypt a string the last character must be decoded first and then the key
  coded string produced in order to decrypt each character.}

  VAR x : word;
  begin
    RandSeed := (123456 * len) DIV ord(st[len]);
    {This ensures that no two code strings will be similar UNLESS they are
     of identical length and have identical last characters. Use any number
     you wish as the numerical constant.}
    MakeCodeStr[0] := chr(ord(len));
    for x := 1 to len do
      MakeCodeStr[x] := chr(32 + Random(95));
      {Keeping the character between 32 and 127 ensures that the high bit
       is never set on the original encrypted character and therefore allows
       this to be used as flag to indicate that the coded char was < #32.
       This will then permit the encrypted string to be printed without fear
       of having embedded control codes play havoc with the printer.}
  end;


FUNCTION EncryptStr(st : string): string;
  VAR
    cnt,x,len : byte;
    temp,CodeStr : string;
  begin
    len := length(st);
    CodeStr := MakeCodeStr(len,st);
    temp[0] := st[0];
    temp[len] := st[len];
    for x := 1 to len-1 do begin
      cnt := ord(st[x]) xor ord(CodeStr[x]);
      inc(cnt,128*ord(cnt < 32));
      temp[x] := chr(cnt);
      end;
    cnt := ord(st[len]) xor (len and 127);
    inc(cnt,128*ord(cnt < 32));
    temp[len] := chr(cnt);
    EncryptStr := temp;
  end;

FUNCTION DecryptStr(st : string): string;
  VAR
    cnt,x,len : byte;
    temp,CodeStr : string;
    ch : char;
  begin
    len := ord(st[0]);
    cnt := ord(st[len]) and 127;
    st[len] := chr(cnt xor len);
    CodeStr := MakeCodeStr(len,st);
    temp[0] := st[0];
    temp[len] := st[len];
    for x := 1 to len-1 do begin
      cnt := ord(st[x]);
      dec(cnt,128*ord(cnt > 127));
      st[x] := chr(cnt);
      temp[x] := chr(ord(st[x]) xor ord(CodeStr[x]));
      end;
      DecryptStr := temp;
  end;

end.
