;  COPYRIGHT 1982 BY WALTER H RAUSER
       PAGE 50,80
TITLE VIDEO2  -- PASCAL PROCEDURE FOR VIDEO IO
;
;PROCEDURE VIDEO( AX2DX:ARRAY[1..4] OF WORD); EXTERN;

;
;FRAME STRUCTURE
;OFFSET   LEN    VARIABLE DEF
;                see Tech Ref Manual, page A-43 for definitions
;[BP]+ 6   2     AX_DX  - VarP to 8 byte array/record; 
;                (low)  AL,AH,BL,BH,CL,CH,DL,DH (high memory)
;      4   2     SEGMENT FOR RETURN ADDRESS
;      2   2     OFFSET  FOR RETURN ADDRESS
;[BP]+ 0   2     OLD FRAME POINTER
;
;
WHR1   SEGMENT  PARA  PUBLIC  'CODE'
       ASSUME   CS:WHR1    ;DS:DGROUP,SS:DGROUP
       PUBLIC   VIDEO
;
VIDEO  PROC FAR
       PUSH BP          ;old frame pointer
       MOV BP,SP        ;new frame pointer
       MOV SI,[BP].6    ;addr of reg array
       MOV AX,[SI].0    ;load AX
       MOV BX,[SI].2    ;load BX
       MOV CX,[SI].4    ;load CX
       MOV DX,[SI].6    ;load DX
;
       INT 10H          ;VIDEO_IO in BIOS, A-43
;                       ;flags not on stack
;
       MOV SI,[BP].6    ;addr of reg array
       MOV [SI].0,AX    ;return AX
       MOV [SI].2,BX    ;return BX
       MOV [SI].4,CX    ;return CX
       MOV [SI].6,DX    ;return DX
;
       POP BP           ;restore frame pointer
       RET 2            ;pop parameters
VIDEO  ENDP
WHR1   ENDS
       END
