UNIT uclock;

INTERFACE
(* Public Domain.  Inspired by a C version by David L. Fox, *)
(* which in turn depended on an article by Byron Sheppard,  *)
(* Byte, Jan 1987, p157..164. This code is quite different. *)
(* C.B. Falconer, 17 Feb 1990.      1:141/209.1@fidonet     *)

(* Warning - the timer is left in mode 2, rather than the   *)
(* original mode 3.  This means that the interrupt signal   *)
(* will be a pulse about 1 uS long, rather than a square    *)
(* wave.  Under some conditions this may fail to interrupt. *)
(* I do not anticipate problems outside the PS2 family.     *)

  FUNCTION clock : real;
  (* Returns time in hours after midnight, with 128 added.  *)
  (* See notes in CLOCK.ASM.  This format allows speed.     *)

  (* 1---------------1 *)

  FUNCTION version(print : boolean) : integer;
  (* Show version number, optionally display *)

IMPLEMENTATION

  CONST
    ver      = 100;   (* 1.00 - initial release *)
    copyrite = ' Public Domain 1990 by C.B. Falconer';

(*$l clock.obj *)

  (* 1---------------1 *)

  PROCEDURE initc; external;
  (* changes the timer mode *)

  (* 1---------------1 *)

  FUNCTION clk : real; external;  (* the real work *)

  (* 1---------------1 *)

  FUNCTION clock : real;

    BEGIN
    clock := clk;
    END;

  (* 1---------------1 *)

  FUNCTION version(print : boolean) : integer;
  (* Show version number, optionally display *)

    BEGIN (* version *)
    version := ver;
    IF print THEN BEGIN
      write('UCLOCK   module Version ', ver DIV 100 : 1, '.');
      IF ver MOD 100 < 10 THEN write('0');
      writeln(ver MOD 100, '.', copyrite); END;
    END; (* version *)

  (* 1---------------1 *)

  BEGIN (* uclock initialization *)
  initc;
  END. (* uclock initialization *)
 