unit BIGMEM;
{ ************************************
  User Runtime Error Demo 3

  This routine demonstrates how FRTE can be used.  This program has a "unit"
  which allocates heap space for a particular type of data struture.  When
  a heap error occurs, rather than a runtime error ocurring where the actual
  new() procedure was called, it occurs where the program called the "unit"
  routine that does memory allocation.  This allows user written "units" to
  be linked into Turbo's runtime error support.
  ************************************ }

{=======================================
 Ok here is our "unit".  It allocates memory to a datatype.  If the routine
 calling this "unit" ask for too much memory, a heap error is generated. Where
 we want to see the error is where our unit is called, not where the new() that
 caused the error is located.
 =======================================}
interface
	uses FRTE;
  {$F+}
  const
    InUnit : boolean = true;
  type
		bigmemarray =array[1..$fffe] of byte;
		bigmemptr = ^bigmemarray;
  procedure get_bigmem(var BM:bigmemptr);

implementation
var
  errsize:word;
	UNITID:word;
{-----------------------------------------}
{ This is the routine that traps Turbo's Heap Error.  It replaces Turbo's
  Heap error routine (which basically does nothing), and calls FRTE passing
  the errorcode and location of the call that caused the error.  If FRTE
  is told to trap the error, this routine is never returned to, and control
  never passes back to Heap Manager.  FRTE then handles the error via
  TURBO's IDE error system.  However, if FRTE is told not to trap
  error, control will pass here.  This routine then must tell Heap Manager
  how to handle the error.  Returning a 0 means generate a runtime error
  from location of new() or whatever, 1 causes new() and getmem() to return
  a nil pointer, 2 indicates problem has been corrected and retry.
                  }
{$F+}
function trapheaperror(Size:word):integer; far;
var
  generation : word;
begin
  if Size>0 then  { Ignore this call, Heapptr just moved Thnx}
    begin
    ShowFRTEmessage := true;
    errsize := size;
		{ Error is 3 generations back, 1 Internal, 2 is new() and
      3 is Get_BIGMEM() }
	  if InUnit then Generation := 2 else Generation := 3;
    FRTError(Find_far_Caller(generation),203 or UnitID);
    trapheaperror := 0;
    end;
end;

{-----------------------------------------}
{ This routine simply displays an interpretive message, and then decides
  where the error should be handled, i.e FRTE and then dumped into Turbo's
  run time error routine, or returned to the Heap manager, who will dumpit.
  This is done via the InUnit variable.  Essentially, when InUnit is true,
  the the error will be trapped where it occurs in the Unit's code and the
  IDE will go there.  If InUnit is false, the error is trapped in the Unit
  but the IDE takes you to where the UNIT was called. }

function showheaperror(eaddr:pointer;errcode:word):integer;
begin
  writeln('Heap overflow, request was for ',errsize,' bytes, only ',
          maxavail,' bytes are available');
  if InUnit then
    showheaperror := 0
  else
    showheaperror := 1;
end;

{-----------------------------------------}
{ This is just a dummy procedure we are using to demonstrate trapping heap
  errors }

procedure init_bigmem;
begin
  { Set up to Trap Turbo's Heap Error }
	HeapError := @trapheaperror;
  { This installs the FRTE system }
	UNITID := InstallFRTE(showHeapError);
end;
{========================================}

{ Ok here is main program, it tries and hog
  memory, but we find out who the culprit is!
  If you want to debug the unit, set InUnit to true,
  if you want to debug the program set InUnit to false;
  Try it ! You'll like it !
}
{-----------------------------------------}
{ Allocates memory }
procedure get_bigmem(var BM:bigmemptr);
begin
	writeln('This is Get_bigmem ');
  {Here is where the actual allocation is made }
  new(BM);
end;
{-----------------------------------------}
begin
  init_bigmem;
end.


