/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FindMac {
    public static final String getMacAddress() {
        String mac = "";
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                mac = FindMac.windowsParseMacAddress(FindMac.windowsRunIpConfigCommand());
            } else if (os.startsWith("Linux")) {
                mac = FindMac.getUniqueId();
            } else if (os.startsWith("Mac OS X")) {
                mac = FindMac.osxParseMacAddress(FindMac.osxRunIfConfigCommand());
            }
        }
        catch (Exception ex) {
            return null;
        }
        return mac;
    }

    private static String getUniqueId() {
        String text = "";
        try {
            Process p = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String temp = in.readLine();
            while (temp != null) {
                if (temp.length() >= 8 && !temp.substring(0, 8).equals("bogomips") && !temp.substring(0, 7).equals("cpu MHz")) {
                    text = String.valueOf(text) + temp;
                }
                temp = in.readLine();
            }
            text = FindMac.CheesyCheckSum(text);
        }
        catch (Exception ex) {
            return ex.toString();
        }
        return text;
    }

    private static String CheesyCheckSum(String input) {
        long checksum = 0L;
        try {
            checksum = 0L;
            int i = 0;
            while (i < input.length()) {
                checksum += (long)input.charAt(i);
                ++i;
            }
            checksum %= 2048L;
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return String.valueOf(checksum);
    }

    private static final String linuxParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !FindMac.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean linuxIsMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0 -9a-fA-F]{2}[-:][0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String Windows_Check_Mac(StringTokenizer tokenizer, String searchkey) {
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if (line.indexOf(searchkey) < 0) continue;
            while (tokenizer.hasMoreTokens()) {
                String line2 = tokenizer.nextToken().trim();
                if (!line2.startsWith("Physical Address")) continue;
                lastMacAddress = line2.substring(line2.length() - 18);
                return lastMacAddress;
            }
        }
        return null;
    }

    private static final String windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = FindMac.Windows_Check_Mac(tokenizer, "Ethernet adapter Local Area Connection");
        if (lastMacAddress == null) {
            tokenizer = new StringTokenizer(ipConfigResponse, "\n");
            lastMacAddress = FindMac.Windows_Check_Mac(tokenizer, "Ethernet adapter");
        }
        if (lastMacAddress == null) {
            tokenizer = new StringTokenizer(ipConfigResponse, "\n");
            lastMacAddress = FindMac.Windows_Check_Mac(tokenizer, "Ethernet adapter");
        }
        if (FindMac.windowsIsMacAddress(lastMacAddress)) {
            return lastMacAddress;
        }
        return lastMacAddress;
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0 -9a-fA-F]{2}[-:][0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String osxParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            boolean containsLocalHost = line.indexOf(localHost) >= 0;
            int macAddressPosition = line.indexOf("ether");
            if (macAddressPosition != 0 || !FindMac.osxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            return macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean osxIsMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0-9a-fA-F]{2}[-:][0 -9a-fA-F]{2}[-:][0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    private static final String osxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    public static final void main(String[] args) {
        try {
            System.out.println("  MAC Address: " + FindMac.getMacAddress());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

