/*
 * Decompiled with CFR 0.152.
 */
package unity.relational;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.util.Convert;

public class Tuple {
    protected Object[] values;
    protected Relation relation;
    static /* synthetic */ Class class$0;

    public Tuple(Relation r) {
        this.relation = r;
        this.values = new Object[r.getNumAttributes()];
    }

    public Tuple() {
        this.relation = new Relation();
        this.values = null;
    }

    public Tuple(Object[] vals, Relation r) {
        this.relation = r;
        this.values = new Object[vals.length];
        int i = 0;
        while (i < vals.length) {
            this.values[i] = vals[i];
            ++i;
        }
    }

    public Tuple(Tuple t) {
        this.relation = t.relation;
        this.values = new Object[t.values.length];
        int i = 0;
        while (i < t.values.length) {
            this.values[i] = t.values[i];
            ++i;
        }
    }

    public Tuple(Tuple t1, Tuple t2, Relation r) {
        this.relation = r;
        this.values = new Object[t1.values.length + t2.values.length];
        int i = 0;
        while (i < t1.values.length) {
            this.values[i] = t1.values[i];
            ++i;
        }
        i = 0;
        while (i < t2.values.length) {
            this.values[i + t1.values.length] = t2.values[i];
            ++i;
        }
    }

    public Object[] filterValues(int[] idx) {
        Object[] tmp = new Object[idx.length];
        int i = 0;
        while (i < idx.length) {
            tmp[i] = this.values[idx[i]];
            ++i;
        }
        return tmp;
    }

    public void addField(Object val) {
        Object[] tmp = new Object[this.values.length + 1];
        int i = 0;
        while (i < this.values.length) {
            tmp[i] = this.values[i];
            ++i;
        }
        tmp[this.values.length] = val;
        this.values = tmp;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] vals) {
        this.values = vals;
    }

    public int numValues() {
        return this.values.length;
    }

    public void setValue(int i, Object o) {
        this.values[i] = o;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getString(int i) {
        return this.values[i].toString();
    }

    public Object getObject(int i) {
        return this.values[i];
    }

    public boolean isNull(int i) {
        return this.values[i] == null;
    }

    public int getInt(int i) {
        Class<?> clazz = this.values[i].getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return Integer.parseInt((String)this.values[i]);
        }
        return (Integer)this.values[i];
    }

    public Object[] getValuesCopy() {
        Object[] vals = new Object[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            vals[i] = this.values[i];
            ++i;
        }
        return vals;
    }

    public boolean readText(BufferedReader in) throws IOException {
        String st = in.readLine();
        if (st == null) {
            return false;
        }
        StringTokenizer myTokenizer = new StringTokenizer(st);
        int numVals = myTokenizer.countTokens();
        this.values = new Object[numVals];
        int i = 0;
        while (i < numVals) {
            String val = myTokenizer.nextToken();
            int attrType = this.relation.getAttributeType(i);
            this.values[i] = attrType == Attribute.TYPE_INT ? new Integer(Integer.parseInt(val)) : val;
            ++i;
        }
        return true;
    }

    public void writeText(PrintWriter out) {
        int i = 0;
        while (i < this.numValues()) {
            out.print(this.getObject(i) + "\t");
            ++i;
        }
        out.println();
    }

    public boolean read(BufferedInputStream in) throws IOException {
        byte[] tmp = new byte[1000];
        int header = in.read();
        if (header == -1) {
            return false;
        }
        in.read(tmp, 0, 4);
        int numFields = Convert.toInt(tmp);
        if (numFields > 10000) {
            throw new IOException("I/O error.  Reading tuple from disk");
        }
        short[] offsets = new short[numFields];
        boolean[] isNull = new boolean[numFields];
        int i = 0;
        while (i < numFields) {
            isNull[i] = in.read() > 0;
            ++i;
        }
        i = 0;
        while (i < numFields) {
            if (!isNull[i]) {
                in.read(tmp, 0, 2);
                offsets[i] = Convert.toShort(tmp);
            }
            ++i;
        }
        i = 0;
        while (i < numFields) {
            this.values[i] = !isNull[i] ? Attribute.read(in, this.relation.getAttributeType(i)) : null;
            ++i;
        }
        return true;
    }

    public boolean read(RandomAccessFile in) throws IOException {
        byte[] tmp = new byte[1000];
        int header = in.read();
        if (header == -1) {
            return false;
        }
        in.read(tmp, 0, 4);
        int numFields = Convert.toInt(tmp);
        if (numFields > 10000) {
            throw new IOException("I/O error.  Reading tuple from disk");
        }
        short[] offsets = new short[numFields];
        boolean[] isNull = new boolean[numFields];
        int i = 0;
        while (i < numFields) {
            isNull[i] = in.read() > 0;
            ++i;
        }
        i = 0;
        while (i < numFields) {
            if (!isNull[i]) {
                in.read(tmp, 0, 2);
                offsets[i] = Convert.toShort(tmp);
            }
            ++i;
        }
        i = 0;
        while (i < numFields) {
            this.values[i] = !isNull[i] ? Attribute.read(in, this.relation.getAttributeType(i)) : null;
            ++i;
        }
        return true;
    }

    public void write(BufferedOutputStream out) throws IOException {
        int b = 1;
        short[] offsets = new short[this.values.length];
        boolean[] isNull = new boolean[this.values.length];
        int curPos = 0;
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == null) {
                isNull[i] = true;
            } else {
                isNull[i] = false;
                offsets[i] = (short)curPos;
                int attrType = this.relation.getAttributeType(i);
                int size = Attribute.getByteSize(attrType, this.values[i]);
                curPos += size;
            }
            ++i;
        }
        out.write(b);
        out.write(Convert.toByte(this.values.length));
        i = 0;
        while (i < this.values.length) {
            if (isNull[i]) {
                out.write(1);
            } else {
                out.write(0);
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (!isNull[i]) {
                out.write(Convert.toByte(offsets[i]));
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (!isNull[i]) {
                Attribute.write(out, this.relation.getAttributeType(i), this.values[i]);
            }
            ++i;
        }
    }

    public void write(RandomAccessFile out) throws IOException {
        int b = 1;
        short[] offsets = new short[this.values.length];
        boolean[] isNull = new boolean[this.values.length];
        int curPos = 0;
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == null) {
                isNull[i] = true;
            } else {
                isNull[i] = false;
                offsets[i] = (short)curPos;
                int attrType = this.relation.getAttributeType(i);
                int size = Attribute.getByteSize(attrType, this.values[i]);
                curPos += size;
            }
            ++i;
        }
        out.write(b);
        out.write(Convert.toByte(this.values.length));
        i = 0;
        while (i < this.values.length) {
            if (isNull[i]) {
                out.write(1);
            } else {
                out.write(0);
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (!isNull[i]) {
                out.write(Convert.toByte(offsets[i]));
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (!isNull[i]) {
                Attribute.write(out, this.relation.getAttributeType(i), this.values[i]);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.numValues() > 0) {
            buf.append(this.getObject(0));
        }
        int i = 1;
        while (i < this.numValues()) {
            buf.append("," + this.getObject(i));
            ++i;
        }
        return buf.toString();
    }
}

