/*
 * Decompiled with CFR 0.152.
 */
package unity.globalschema;

import java.util.ArrayList;

public class SemanticName {
    String name;
    ArrayList items = new ArrayList();
    ArrayList connectors = new ArrayList();

    public SemanticName() {
    }

    public SemanticName(String semanticName) {
        this.name = semanticName;
        if (this.name.indexOf("[") > -1) {
            this.buildConnectors();
            this.items = this.parseSemanticName();
        } else {
            this.parseDotName();
        }
    }

    public void parseDotName() {
        String item = "";
        int dotIndex = this.name.indexOf(".");
        int previousDot = 0;
        while (dotIndex > -1) {
            item = this.name.substring(previousDot, dotIndex);
            this.items.add(item);
            previousDot = dotIndex + 1;
            dotIndex = this.name.indexOf(".", dotIndex + 1);
        }
        int lastDot = this.name.lastIndexOf(".");
        if (lastDot > -1) {
            item = this.name.substring(lastDot + 1);
            this.items.add(item);
        } else {
            this.items.add(this.name);
        }
    }

    public void buildConnectors() {
        int nextSemi = this.name.indexOf(";");
        int nextInherits = this.name.indexOf("<");
        int endBracket = this.name.indexOf("]");
        int withDot = this.name.indexOf("].");
        while ((nextSemi > 0 || nextInherits > 0) && nextSemi < endBracket && nextInherits < endBracket) {
            String s;
            if (nextSemi > 0 && nextInherits > 0 && nextSemi < nextInherits) {
                s = ";";
                nextSemi = this.name.indexOf(";", nextSemi + 1);
            } else if (nextSemi > 0 && nextInherits > 0 && nextInherits < nextSemi) {
                s = "<";
                nextInherits = this.name.indexOf("<", nextInherits + 1);
            } else if (nextSemi < 0 && nextInherits > 0) {
                s = "<";
                nextInherits = this.name.indexOf("<", nextInherits + 1);
            } else {
                s = ";";
                nextSemi = this.name.indexOf(";", nextSemi + 1);
            }
            this.connectors.add(s);
        }
        if (withDot > 0) {
            this.connectors.add("].");
        } else {
            this.connectors.add("]");
        }
    }

    public String getCanonicalForm() {
        String s = (String)this.items.get(0);
        int i = 1;
        while (i < this.size()) {
            s = String.valueOf(s) + "**" + this.items.get(i);
            ++i;
        }
        s = s.toLowerCase();
        return s;
    }

    public String buildCanonicalForm(int depth) {
        String s = (String)this.items.get(0);
        int i = 1;
        while (i < depth) {
            s = String.valueOf(s) + "**" + this.items.get(i);
            ++i;
        }
        s = s.toLowerCase();
        return s;
    }

    public String buildDotForm(int depth) {
        String s = (String)this.items.get(0);
        int i = 1;
        while (i < depth) {
            s = String.valueOf(s) + "." + this.items.get(i);
            ++i;
        }
        return s;
    }

    public String buildDotForm() {
        String s = (String)this.items.get(0);
        int i = 1;
        while (i < this.size()) {
            s = String.valueOf(s) + "." + this.items.get(i);
            ++i;
        }
        return s;
    }

    public String buildSemanticName(int depth) {
        if (this.name.indexOf("[") > -1) {
            String s = "[";
            if (this.size() > 1 && depth > 1) {
                int i = 1;
                while (i < depth) {
                    s = String.valueOf(s) + this.getItem(i) + (String)this.connectors.get(i - 1);
                    if (i == depth - 1) {
                        s = String.valueOf(s) + this.getItem(depth);
                    }
                    ++i;
                }
                if (depth <= this.size() && s.indexOf("].") < 0) {
                    s = String.valueOf(s) + "]";
                }
            } else {
                s = String.valueOf(s) + this.getItem(1) + "]";
            }
            return s;
        }
        return this.buildDotForm(depth);
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.size() <= 0;
    }

    public String getItem(int depth) {
        if (!this.isEmpty() && depth - 1 < this.size() && depth > 0) {
            return (String)this.items.get(depth - 1);
        }
        return null;
    }

    public boolean isProperty(int depth) {
        return depth == this.size();
    }

    public int size() {
        return this.items.size();
    }

    public String getContext() {
        if (this.isProperty(this.size())) {
            if (this.name.indexOf("[") > -1) {
                return "" + this.items.get(this.size() - 2);
            }
            return (String)this.items.get(this.size() - 2);
        }
        return null;
    }

    private ArrayList parseSemanticName() {
        int index = 1;
        int i = 0;
        while (i < this.connectors.size()) {
            String connector = (String)this.connectors.get(i);
            int connectorIndex = this.name.indexOf(connector, index);
            this.items.add(this.name.substring(index, connectorIndex));
            index = connectorIndex + 1;
            ++i;
        }
        if (this.name.indexOf("].") > -1) {
            int afterDot = this.name.indexOf("].") + 2;
            this.items.add(this.name.substring(afterDot));
        }
        this.items.trimToSize();
        return this.items;
    }

    public String toString() {
        String s = this.name;
        int i = 0;
        while (i < this.items.size()) {
            s = String.valueOf(s) + "\nItem " + i + ": " + this.items.get(i);
            if (i > 0) {
                s = String.valueOf(s) + "\n     " + i + ": " + this.connectors.get(i - 1);
            }
            ++i;
        }
        return s;
    }
}

