/*
 * Decompiled with CFR 0.152.
 */
package unity.globalschema;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.CommonMethods;
import unity.globalschema.GlobalConcept;
import unity.globalschema.SemanticName;
import unity.io.FileManager;
import unity.util.DGraph;
import unity.util.StringFunc;

public class GlobalSchema {
    protected ArrayList annotatedDatabases = new ArrayList();
    protected HashMap globalConcepts = new HashMap();
    protected HashMap tableIdentifiers = new HashMap();
    protected HashMap fieldIdentifiers = new HashMap();
    protected GlobalConcept root = new GlobalConcept("V");
    protected String sourcesURL;
    static /* synthetic */ Class class$0;

    public ArrayList getAnnotatedDatabases() {
        return this.annotatedDatabases;
    }

    public boolean isConcept(String sn) {
        return this.globalConcepts.containsKey(sn);
    }

    public GlobalConcept getRoot() {
        return this.root;
    }

    public AnnotatedSourceDatabase getDB(String dbName) {
        int i = 0;
        while (i < this.annotatedDatabases.size()) {
            AnnotatedSourceDatabase asd = (AnnotatedSourceDatabase)this.annotatedDatabases.get(i);
            if (dbName.equals(asd.getDatabaseName().toLowerCase())) {
                return asd;
            }
            ++i;
        }
        return null;
    }

    public void createAnnotatedSources(BufferedReader file, String fullPathName) throws SQLException {
        String urlJava = "";
        String driverJava = "";
        String xSpecLocation = "";
        String xSpecPassword = "";
        this.sourcesURL = fullPathName;
        DOMParser dom = new DOMParser();
        try {
            InputSource source = new InputSource(file);
            dom.parse(source);
        }
        catch (Exception e) {
            throw new SQLException("Parse error reading sources file: " + e.toString());
        }
        Node databaseInfo = dom.getDocument().getDocumentElement();
        databaseInfo = databaseInfo.getFirstChild();
        while (!databaseInfo.getNodeName().equals("DATABASE")) {
            databaseInfo = databaseInfo.getNextSibling();
        }
        while (databaseInfo != null) {
            if (databaseInfo.getNodeName().equals("DATABASE")) {
                Node child = databaseInfo.getFirstChild();
                while (child != null) {
                    if (child.getNodeName().equals("URL")) {
                        urlJava = CommonMethods.getName(child);
                    } else if (child.getNodeName().equals("DRIVER")) {
                        driverJava = CommonMethods.getName(child);
                    } else if (child.getNodeName().equals("XSPEC")) {
                        xSpecLocation = CommonMethods.getName(child);
                    } else if (child.getNodeName().equals("PASSWORD")) {
                        xSpecPassword = CommonMethods.getName(child);
                    }
                    child = child.getNextSibling();
                }
                DGraph joinGraph = new DGraph();
                AnnotatedSourceDatabase asd = this.importXML(xSpecLocation, joinGraph, xSpecPassword);
                asd.setURLJava(urlJava);
                asd.setJavaDriverName(driverJava);
                this.annotatedDatabases.add(asd);
            }
            databaseInfo = databaseInfo.getNextSibling();
        }
    }

    private void addTableIdentifier(String key, Object ref) {
        if (this.tableIdentifiers.containsKey(key)) {
            ArrayList a = (ArrayList)this.tableIdentifiers.get(key);
            if (!a.contains(ref)) {
                a.add(ref);
            }
        } else {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(ref);
            this.tableIdentifiers.put(key, a);
        }
    }

    private void addFieldIdentifier(String key, Object ref) {
        if (this.fieldIdentifiers.containsKey(key)) {
            ArrayList a = (ArrayList)this.fieldIdentifiers.get(key);
            if (!a.contains(ref)) {
                a.add(ref);
            }
        } else {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(ref);
            this.fieldIdentifiers.put(key, a);
        }
    }

    public ArrayList findTable(String tableName) {
        return (ArrayList)this.tableIdentifiers.get(tableName);
    }

    public ArrayList findField(String fieldName) {
        return (ArrayList)this.fieldIdentifiers.get(fieldName);
    }

    public String getSourcesURL() {
        return this.sourcesURL;
    }

    private AnnotatedSourceDatabase importXML(String file, DGraph joinGraph, String password) throws SQLException {
        InputStream in = null;
        try {
            in = file.indexOf(".xme") < 0 ? FileManager.getStream(file) : FileManager.getDecryptedStream(file, password);
        }
        catch (FileNotFoundException e) {
            throw new SQLException("Parse error reading sources file: " + e.toString());
        }
        catch (IOException e) {
            throw new SQLException("Parse error reading sources file: " + e.toString());
        }
        return this.importXML(in, joinGraph);
    }

    private AnnotatedSourceDatabase importXML(InputStream file, DGraph joinGraph) throws SQLException {
        DOMParser dom = new DOMParser();
        try {
            InputSource source = new InputSource(file);
            dom.parse(source);
        }
        catch (Exception e) {
            throw new SQLException("Parse error reading sources file: " + e.toString());
        }
        Document d = dom.getDocument();
        AnnotatedSourceDatabase db = new AnnotatedSourceDatabase();
        Node tables = db.importXML(d);
        String dbName = db.getDatabaseName().toLowerCase();
        while (tables != null) {
            AnnotatedSourceTable table = new AnnotatedSourceTable();
            Node fieldKeyJoin = table.importXML(tables);
            table.setParentDatabase(db);
            this.insertGlobalConcept(table.getSemanticTableName(), table);
            String tmp = table.getSQLTableName();
            if (tmp.indexOf("\"") < 0) {
                tmp = tmp.toLowerCase();
            }
            String tableName = tmp;
            this.addTableIdentifier(tableName, table);
            String dbTableName = String.valueOf(dbName) + "." + tableName;
            this.addTableIdentifier(dbTableName, table);
            tmp = table.getSQLTableNameWithSchema();
            if (tmp.indexOf("\"") < 0) {
                tmp = tmp.toLowerCase();
            }
            String schemaTableName = tmp;
            this.addTableIdentifier(tmp, table);
            tmp = table.getFullSQLTableName();
            if (tmp.indexOf("\"") < 0) {
                tmp = tmp.toLowerCase();
            }
            String fullTableName = tmp;
            this.addTableIdentifier(tmp, table);
            tmp = table.getSemanticTableName().toLowerCase();
            this.addTableIdentifier(tmp, table);
            joinGraph.addNode(tableName, 1, table);
            fieldKeyJoin = this.getType(fieldKeyJoin);
            while (fieldKeyJoin != null) {
                AnnotatedSourceKey key;
                if (fieldKeyJoin.getNodeName().equals("FIELD")) {
                    AnnotatedSourceField field = new AnnotatedSourceField();
                    field.importXML(fieldKeyJoin);
                    field.setTableName(tableName);
                    field.setTableSchema(table.getSchemaName());
                    field.setParentTable(table);
                    this.insertGlobalConcept(field.getSemanticFieldName(), field);
                    table.addField(field);
                    tmp = field.getSQLColumnName();
                    if (tmp.indexOf("\"") < 0) {
                        tmp = tmp.toLowerCase();
                    }
                    String fieldName = tmp;
                    this.addFieldIdentifier(fieldName, field);
                    this.addFieldIdentifier(String.valueOf(tableName) + "." + fieldName, field);
                    this.addFieldIdentifier(String.valueOf(dbTableName) + "." + fieldName, field);
                    this.addFieldIdentifier(String.valueOf(schemaTableName) + "." + fieldName, field);
                    this.addFieldIdentifier(String.valueOf(fullTableName) + "." + fieldName, field);
                    tmp = field.getFullSQLColumnName();
                    if (tmp.indexOf("\"") < 0) {
                        tmp = tmp.toLowerCase();
                    }
                    this.addFieldIdentifier(tmp, field);
                    tmp = field.getSemanticFieldName().toLowerCase();
                    this.addFieldIdentifier(tmp, field);
                } else if (fieldKeyJoin.getNodeName().equals("PRIMARYKEY")) {
                    key = new AnnotatedSourceKey(table);
                    key.importXML(fieldKeyJoin, table.getSourceFields());
                    key.setTable(table);
                    table.setPrimaryKey(key);
                } else if (fieldKeyJoin.getNodeName().equals("FOREIGNKEY")) {
                    AnnotatedSourceForeignKey fkey = new AnnotatedSourceForeignKey(table);
                    fkey.importXML(fieldKeyJoin, table.getSourceFields());
                    fkey.setTable(table);
                    table.addForeignKey(fkey);
                } else if (fieldKeyJoin.getNodeName().equals("REFERENCEKEY")) {
                    key = new AnnotatedSourceKey(table);
                    key.importXML(fieldKeyJoin, table.getSourceFields());
                    key.setTable(table);
                    table.addReferenceKey(key);
                } else if (fieldKeyJoin.getNodeName().equals("JOIN")) {
                    AnnotatedSourceJoin join = new AnnotatedSourceJoin();
                    join.importXML(fieldKeyJoin, table.getSourceFields());
                    table.addJoin(join);
                }
                fieldKeyJoin = fieldKeyJoin.getNextSibling();
                fieldKeyJoin = this.getType(fieldKeyJoin);
            }
            db.addTable(table);
            tables = tables.getNextSibling();
            tables = this.getTable(tables);
        }
        HashMap tbls = db.getSourceTables();
        this.linkForeignKeysAndJoins(tbls, joinGraph);
        db.setJoinGraph(joinGraph);
        return db;
    }

    private Node getTable(Node fkj) {
        while (!fkj.getNodeName().equals("TABLE")) {
            if ((fkj = fkj.getNextSibling()) != null) continue;
            return null;
        }
        return fkj;
    }

    private Node getType(Node fkj) {
        while (!this.find(fkj)) {
            fkj = fkj.getNextSibling();
        }
        return fkj;
    }

    private boolean find(Node fkj) {
        if (fkj == null) {
            return true;
        }
        if (fkj.getNodeName().equals("FIELD")) {
            return true;
        }
        if (fkj.getNodeName().equals("PRIMARYKEY")) {
            return true;
        }
        if (fkj.getNodeName().equals("FOREIGNKEY")) {
            return true;
        }
        if (fkj.getNodeName().equals("REFERENCEKEY")) {
            return true;
        }
        if (fkj.getNodeName().equals("JOIN")) {
            return true;
        }
        return fkj.getNodeName().equals("/TABLE");
    }

    private void linkForeignKeysAndJoins(HashMap tables, DGraph joinGraph) {
        Iterator it = tables.values().iterator();
        while (it.hasNext()) {
            AnnotatedSourceTable st = (AnnotatedSourceTable)it.next();
            ArrayList fkey = st.getForeignKeys();
            int i = 0;
            while (i < fkey.size()) {
                AnnotatedSourceForeignKey fk = (AnnotatedSourceForeignKey)fkey.get(i);
                String toTableName = fk.getToTableName();
                AnnotatedSourceTable table = (AnnotatedSourceTable)tables.get(toTableName.toLowerCase());
                if (table != null) {
                    fk.setToSourceTable(table);
                    fk.setToKey(table.getPrimaryKey());
                } else {
                    System.out.println("Unable to find foreign key table: " + toTableName);
                }
                ++i;
            }
            ArrayList joins = st.getJoins();
            String currentTableName = st.getTableName();
            int i2 = 0;
            while (i2 < joins.size()) {
                AnnotatedSourceForeignKey fk;
                AnnotatedSourceJoin join = (AnnotatedSourceJoin)joins.get(i2);
                String fromTableName = join.getFromTableName();
                joinGraph.addEdge(fromTableName, join.getToTableName(), join.getJoinName(), 1, join);
                if (fromTableName.equals(currentTableName)) {
                    AnnotatedSourceTable toTable;
                    if (join.getFromKeyName().equals(st.getPrimaryKey().getName())) {
                        join.setFromKey(st.getPrimaryKey());
                        String toKeyName = join.getToKeyName();
                        toTable = (AnnotatedSourceTable)tables.get(join.getToTableName().toLowerCase());
                        ArrayList toTableFkeys = toTable.getForeignKeys();
                        int j = 0;
                        while (j < toTableFkeys.size()) {
                            fk = (AnnotatedSourceForeignKey)toTableFkeys.get(j);
                            if (fk.getName().equals(toKeyName)) {
                                join.setToKey(fk);
                                break;
                            }
                            ++j;
                        }
                    } else {
                        String fromKeyName = join.getFromKeyName();
                        toTable = (AnnotatedSourceTable)tables.get(join.getToTableName().toLowerCase());
                        int j = 0;
                        while (j < fkey.size()) {
                            AnnotatedSourceForeignKey fk2 = (AnnotatedSourceForeignKey)fkey.get(j);
                            if (fk2.getName().equals(fromKeyName)) {
                                join.setFromKey(fk2);
                                break;
                            }
                            ++j;
                        }
                        join.setToKey(toTable.getPrimaryKey());
                    }
                } else {
                    join.setToKey(st.getPrimaryKey());
                    AnnotatedSourceTable fromTable = (AnnotatedSourceTable)tables.get(join.getFromTableName().toLowerCase());
                    String fromKeyName = join.getFromKeyName();
                    ArrayList fromfkey = fromTable.getForeignKeys();
                    int j = 0;
                    while (j < fromfkey.size()) {
                        fk = (AnnotatedSourceForeignKey)fromfkey.get(j);
                        if (fk.getName().equals(fromKeyName)) {
                            join.setFromKey(fk);
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
    }

    private void insertGlobalConcept(String semanticString, Object source) {
        GlobalConcept node = this.root;
        SemanticName semantic = new SemanticName(semanticString);
        int type = 1;
        int i = 1;
        while (i <= semantic.size()) {
            String itemAtDepth = semantic.getItem(i);
            String element = semantic.buildCanonicalForm(i);
            if (this.exists(node, element)) {
                node = (GlobalConcept)node.getChildren().get(element);
                if (i == semantic.size()) {
                    node.addSource(source);
                }
            } else {
                SemanticName subSemantic = new SemanticName(semantic.buildSemanticName(i));
                if (i == semantic.size()) {
                    Class<?> clazz = source.getClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("unity.annotation.AnnotatedSourceField");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) {
                        type = 2;
                    }
                }
                GlobalConcept newGC = new GlobalConcept(subSemantic, subSemantic.getCanonicalForm(), node, type, i, itemAtDepth);
                if (i == semantic.size()) {
                    newGC.addSource(source);
                }
                node.addChild(newGC);
                this.globalConcepts.put(subSemantic.getCanonicalForm(), newGC);
                node = newGC;
            }
            ++i;
        }
    }

    public GlobalConcept getGlobalConcept(String semanticName) {
        GlobalConcept gc = null;
        gc = (GlobalConcept)this.globalConcepts.get(semanticName);
        return gc;
    }

    private boolean exists(GlobalConcept gc, String item) {
        HashMap children = gc.getChildren();
        return children.containsKey(item);
    }

    public void printTreeToFile(File file) {
        FileOutputStream to = null;
        PrintWriter pw = null;
        try {
            to = new FileOutputStream(file);
            pw = new PrintWriter(to, true);
            pw.println("Global Schema");
            pw.println();
            this.printTree(this.root, pw);
        }
        catch (Exception e) {
            System.err.println("Error in printTreeToFile");
        }
    }

    void printTree(GlobalConcept gc, PrintWriter pw) {
        pw.println(gc);
        TreeMap childrenNodes = new TreeMap(gc.getChildren());
        Iterator children = childrenNodes.keySet().iterator();
        while (children.hasNext()) {
            String key = (String)children.next();
            this.printTree((GlobalConcept)childrenNodes.get(key), pw);
        }
    }

    void printHashMap() {
        File file = new File("SemTree.txt");
        FileOutputStream to1 = null;
        PrintWriter pw1 = null;
        try {
            to1 = new FileOutputStream(file);
            pw1 = new PrintWriter(to1, true);
            pw1.println("HashMap Global Concept Keys");
            pw1.println();
            TreeMap concepts = new TreeMap(this.globalConcepts);
            Iterator cons = concepts.keySet().iterator();
            while (cons.hasNext()) {
                String key = (String)cons.next();
                int depth = ((GlobalConcept)this.globalConcepts.get(key)).getDepth();
                pw1.println(String.valueOf(StringFunc.spaces(4 * depth)) + key);
            }
        }
        catch (Exception e) {
            System.err.println("Error in printHashMap " + e);
        }
    }
}

