/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.util.ArrayList;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class A_Avg
extends Aggregate_Function {
    protected double currentTotal;
    protected int currentCount;
    protected boolean isIntType;

    public A_Avg(Expression exp) {
        this.children = new ArrayList(1);
        this.children.add(exp);
        this.computedExpr = exp;
        this.returnType = exp.getReturnType();
        this.isIntType = this.returnType == Attribute.TYPE_INT;
    }

    public void reset() {
        this.currentTotal = 0.0;
        this.currentCount = 0;
    }

    public Object compute() {
        if (this.currentCount == 0) {
            return null;
        }
        return new Double(this.currentTotal / (double)this.currentCount);
    }

    public void add(Tuple t) {
        Object val = this.computedExpr.evaluate(t);
        if (val != null) {
            this.currentTotal = this.isIntType ? (this.currentTotal += (double)((Number)val).intValue()) : (this.currentTotal += ((Number)val).doubleValue());
            ++this.currentCount;
        }
    }

    public String toString(Relation relation, Attribute outputAttribute) {
        return "AVG(" + this.computedExpr.toString(relation) + ") AS " + outputAttribute.getName();
    }
}

