/*
 * Decompiled with CFR 0.152.
 */
package unity.extractor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JTextArea;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceField;

public class AnnotatedExtractor {
    protected DatabaseMetaData dmd;
    protected String dbName;
    protected AnnotatedSourceDatabase db;
    protected Connection con;
    protected JTextArea outputBox = null;
    protected String dbProduct;
    protected String dbVersion;
    protected String url;
    protected String driver;

    public void setOutputArea(JTextArea a) {
        this.outputBox = a;
    }

    public void setDatabaseName(String n) {
        this.db.setDatabaseName(n);
    }

    public void extract(Connection c) throws SQLException {
        boolean access = false;
        this.con = c;
        this.dmd = this.con.getMetaData();
        this.dbName = this.con.getCatalog();
        this.dbProduct = this.dmd.getDatabaseProductName();
        this.dbVersion = this.dmd.getDatabaseProductVersion();
        this.url = this.dmd.getURL();
        this.driver = this.dmd.getDriverName();
        int slashIndex = this.dbName.lastIndexOf("\\");
        if (slashIndex > 0) {
            this.dbName = this.dbName.substring(slashIndex + 1);
        }
        this.db = new AnnotatedSourceDatabase(this.dbName, this.dbProduct, this.dbVersion, this.url, this.driver);
        if (this.dbProduct.indexOf("CCESS") > -1) {
            access = true;
        }
        HashMap tablesCreated = this.createAnnotatedSourceTables(this.con, access);
        this.db.setSourceTables(tablesCreated);
    }

    public HashMap createAnnotatedSourceTables(Connection con, boolean access) throws SQLException {
        HashMap<String, AnnotatedSourceTable> tables = new HashMap<String, AnnotatedSourceTable>();
        AnnotatedSourceTable st = null;
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet rs1 = this.dmd.getTables(null, null, "%", tableTypes);
        while (rs1.next()) {
            AnnotatedSourceField asf;
            Iterator it;
            String tableName = rs1.getString(3);
            String schemaName = rs1.getString(2);
            String catalogName = rs1.getString(1);
            String comment = rs1.getString(5);
            String message = "Processing Table: " + tableName + "  Schema: " + schemaName + "  Catalog: " + catalogName;
            if (this.outputBox == null) {
                System.out.println("Table: " + tableName + "  Schema: " + schemaName + "  Catalog: " + catalogName);
            } else {
                this.outputBox.append(String.valueOf(message) + "\n");
            }
            HashMap fields = this.createFields(schemaName, tableName);
            if (access) {
                st = new AnnotatedSourceTable(catalogName, schemaName, tableName, comment, fields, null);
                if (schemaName != null && !schemaName.equals("")) {
                    st.setSemanticTableName(String.valueOf(this.dbName) + "." + schemaName + "." + tableName);
                } else {
                    st.setSemanticTableName(String.valueOf(this.dbName) + "." + tableName);
                }
                tables.put(tableName, st);
            } else {
                AnnotatedSourceKey pkey = this.createPrimaryKey(tableName, fields);
                st = new AnnotatedSourceTable(catalogName, schemaName, tableName, comment, fields, pkey);
                if (schemaName != null && !schemaName.equals("")) {
                    st.setSemanticTableName(String.valueOf(this.dbName) + "." + schemaName + "." + tableName);
                } else {
                    st.setSemanticTableName(String.valueOf(this.dbName) + "." + tableName);
                }
                pkey.setTable(st);
                ArrayList fkeys = this.createForeignKeys(tableName, fields, st);
                st.setForeignKeys(fkeys);
                tables.put(tableName, st);
            }
            StringBuffer sql = new StringBuffer(500);
            int count = 0;
            AnnotatedSourceField[] asfs = new AnnotatedSourceField[fields.size()];
            if (!access) {
                sql.append("SELECT COUNT(*)");
                it = fields.values().iterator();
                while (it.hasNext()) {
                    asf = (AnnotatedSourceField)it.next();
                    if (asf.isBlob()) continue;
                    sql.append(",count(distinct " + asf.getSQLColumnName() + ")");
                    asfs[count++] = asf;
                }
                sql.append("\nFROM " + st.getSQLTableNameWithSchema());
            } else if (this.dbVersion.indexOf("3.50") >= 0) {
                sql.append("SELECT count(*)");
                it = fields.values().iterator();
                while (it.hasNext()) {
                    asf = (AnnotatedSourceField)it.next();
                    if (asf.isBlob()) continue;
                    sql.append(",count(*)");
                    asfs[count++] = asf;
                }
                sql.append("\nFROM " + st.getSQLTableNameWithSchema());
            } else {
                sql.append("SELECT * FROM");
                String tbName = st.getSQLTableNameWithSchema();
                sql.append("(SELECT COUNT(*) FROM (SELECT * FROM " + tbName + ") AS C) AS X0");
                Iterator it2 = fields.values().iterator();
                while (it2.hasNext()) {
                    AnnotatedSourceField asf2 = (AnnotatedSourceField)it2.next();
                    if (asf2.isBlob()) continue;
                    sql.append(",(SELECT COUNT(*) FROM (SELECT DISTINCT " + asf2.getSQLColumnName() + " FROM " + tbName + ") AS T" + count + ") AS Z" + count);
                    asfs[count++] = asf2;
                }
            }
            try {
                Statement stmt = con.createStatement();
                if (this.outputBox == null) {
                    System.out.println("  Computing table statistics...");
                } else {
                    this.outputBox.append("  Computing table statistics...");
                }
                ResultSet rst = stmt.executeQuery(sql.toString());
                if (rst.next()) {
                    if (st != null) {
                        st.setNumTuples(rst.getInt(1));
                    }
                    int i = 0;
                    while (i < count) {
                        asfs[i].setNumDistinctValues(rst.getInt(i + 2));
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                if (this.outputBox == null) {
                    System.out.println("  Error while computing table statistics..." + e);
                }
                this.outputBox.append("  Error while computing table statistics..." + e + "\n");
            }
            if (this.outputBox == null) {
                System.out.println("Done processing table.");
                continue;
            }
            this.outputBox.append("Done processing table.\n");
        }
        Iterator it = tables.values().iterator();
        while (it.hasNext()) {
            this.fillForeignKeysAndCreateJoins((AnnotatedSourceTable)it.next(), tables);
        }
        return tables;
    }

    public HashMap createFields(String schemaName, String tableName) throws SQLException {
        HashMap<String, AnnotatedSourceField> fieldsCreated = new HashMap<String, AnnotatedSourceField>();
        ResultSet rs2 = this.dmd.getColumns(null, schemaName, tableName, "%");
        while (rs2.next()) {
            String f1 = rs2.getString(1);
            String f2 = rs2.getString(2);
            String f3 = rs2.getString(3);
            String f4 = rs2.getString(4);
            int f5 = rs2.getInt(5);
            String f6 = rs2.getString(6);
            int f7 = rs2.getInt(7);
            int f9 = rs2.getInt(9);
            int f10 = rs2.getInt(10);
            int f11 = rs2.getInt(11);
            String f12 = rs2.getString(12);
            String f13 = rs2.getString(13);
            int f16 = rs2.getInt(16);
            int f17 = rs2.getInt(17);
            String f18 = rs2.getString(18);
            AnnotatedSourceField sf = new AnnotatedSourceField(f1, f2, f3, f4, f5, f6, f7, f9, f10, f11, f12, f13, f16, f17, f18);
            fieldsCreated.put(f4, sf);
        }
        return fieldsCreated;
    }

    public AnnotatedSourceKey createPrimaryKey(String tableName, HashMap fields) throws SQLException {
        ResultSet rs3 = this.dmd.getPrimaryKeys(null, null, tableName);
        String keyName = "";
        ArrayList newKey = new ArrayList();
        while (rs3.next()) {
            String key = rs3.getString(6);
            keyName = keyName.length() < 1 && !key.equals(null) ? key : (key.equals(keyName) ? key : (!key.equals(null) ? String.valueOf(keyName) + "##" + key : "PK_" + tableName));
            newKey.add(fields.get(rs3.getString(4).trim()));
        }
        AnnotatedSourceKey pkey = new AnnotatedSourceKey(newKey, 1, keyName);
        return pkey;
    }

    public ArrayList createForeignKeys(String tableName, HashMap fields, AnnotatedSourceTable st) throws SQLException {
        ArrayList<AnnotatedSourceForeignKey> fkey = new ArrayList<AnnotatedSourceForeignKey>();
        ResultSet rs3 = this.dmd.getImportedKeys(null, null, tableName);
        ArrayList key = new ArrayList();
        String keyName = "";
        String toTblName = "";
        ArrayList<String> fkFieldNames = new ArrayList<String>();
        while (rs3.next()) {
            if (toTblName.equals(rs3.getString(3).trim())) {
                key.add(fields.get(rs3.getString(8).trim()));
                fkFieldNames.add(rs3.getString(4).trim());
                continue;
            }
            if (!rs3.isFirst()) {
                fkey.add(new AnnotatedSourceForeignKey(st, key, fkFieldNames, keyName, toTblName));
                key = new ArrayList();
                keyName = "";
                toTblName = "";
                fkFieldNames = new ArrayList();
            }
            key.add(fields.get(rs3.getString(8).trim()));
            keyName = rs3.getString(12).trim();
            toTblName = rs3.getString(3).trim();
            fkFieldNames.add(rs3.getString(4).trim());
        }
        if (key.size() > 0) {
            fkey.add(new AnnotatedSourceForeignKey(st, key, fkFieldNames, keyName, toTblName));
        }
        return fkey;
    }

    private void fillForeignKeysAndCreateJoins(AnnotatedSourceTable st, HashMap tables) {
        ArrayList fkey = st.getForeignKeys();
        int i = 0;
        while (i < fkey.size()) {
            AnnotatedSourceForeignKey fk = (AnnotatedSourceForeignKey)fkey.get(i);
            String toTableName = fk.getToTableName();
            ArrayList fieldNames = fk.getFieldNames();
            AnnotatedSourceTable table = (AnnotatedSourceTable)tables.get(toTableName);
            fk.setToSourceTable(table);
            fk.setToKey(table.getPrimaryKey());
            ArrayList<SourceField> fields = new ArrayList<SourceField>();
            int j = 0;
            while (j < fieldNames.size()) {
                fields.add(table.getField((String)fieldNames.get(j)));
                ++j;
            }
            String joinName = String.valueOf(st.getTableName()) + "->" + table.getTableName();
            String reverseJoinName = String.valueOf(table.getTableName()) + "->" + st.getTableName();
            AnnotatedSourceJoin join = new AnnotatedSourceJoin(fk, table.getPrimaryKey(), joinName, 3);
            AnnotatedSourceJoin reverse = new AnnotatedSourceJoin(table.getPrimaryKey(), fk, reverseJoinName, 2);
            join.setReverseJoin(reverse);
            st.addJoin(join);
            reverse.setReverseJoin(join);
            table.addJoin(reverse);
            ++i;
        }
    }

    public AnnotatedSourceKey createPrimaryKeyAccess(String tableName, HashMap fields) throws SQLException {
        Statement stmt = this.con.createStatement();
        ResultSet foreignKeys = stmt.executeQuery("SELECT  szRelationship, szObject, szReferencedObject, szColumn, szReferencedColumn FROM MSysRelationships WHERE szObject like '" + tableName + "'");
        while (foreignKeys.next()) {
            String fkName = foreignKeys.getString(1);
            if (fkName != null) continue;
            fkName = foreignKeys.getString(2);
        }
        return null;
    }

    public void exportXML(File file) throws IOException {
        FileOutputStream to = null;
        PrintWriter pw = null;
        to = new FileOutputStream(file);
        pw = new PrintWriter(to, true);
        this.exportXML(pw);
    }

    public void exportXML(PrintWriter pw) throws IOException {
        pw.println("<?xml version = \"1.0\"?>");
        pw.println();
        pw.println("<XSPEC xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xspec.xsd\">");
        pw.println(this.db.toXML());
        TreeMap sourceTables = new TreeMap(this.db.getSourceTables());
        Iterator tables = sourceTables.keySet().iterator();
        while (tables.hasNext()) {
            pw.println("   <TABLE>");
            AnnotatedSourceTable table = (AnnotatedSourceTable)sourceTables.get(tables.next());
            pw.println(table.toXML());
            TreeMap sourceFields = new TreeMap(table.getSourceFields());
            Iterator fields = sourceFields.keySet().iterator();
            while (fields.hasNext()) {
                pw.println("     <FIELD>");
                AnnotatedSourceField field = (AnnotatedSourceField)sourceFields.get(fields.next());
                pw.println(field.toXML());
                pw.println("     </FIELD>");
                pw.println();
            }
            AnnotatedSourceKey pKey = (AnnotatedSourceKey)table.getPrimaryKey();
            if (pKey != null) {
                pw.println(String.valueOf(pKey.toXML()) + "\n");
            }
            ArrayList fkeys = table.getForeignKeys();
            int i = 0;
            while (i < fkeys.size()) {
                pw.println(((AnnotatedSourceForeignKey)fkeys.get(i)).toXML());
                pw.println();
                ++i;
            }
            ArrayList joins = table.getJoins();
            int i2 = 0;
            while (i2 < joins.size()) {
                pw.println("     <JOIN>");
                pw.println(((AnnotatedSourceJoin)joins.get(i2)).toXML());
                pw.println("     </JOIN>\n");
                ++i2;
            }
            pw.println("   </TABLE>\n");
        }
        pw.println("</XSPEC>\n");
        pw.close();
    }
}

