/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;

public class OracleJDBCRowSet
extends OracleRowSet
implements RowSet,
JdbcRowSet {
    private Connection connection;
    private static boolean driverManagerInitialized;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public OracleJDBCRowSet() throws SQLException {
        driverManagerInitialized = false;
    }

    public OracleJDBCRowSet(Connection connection) throws SQLException {
        this();
        this.connection = connection;
    }

    public void execute() throws SQLException {
        this.connection = this.getConnection(this);
        this.connection.setTransactionIsolation(this.getTransactionIsolation());
        this.connection.setTypeMap(this.getTypeMap());
        if (this.preparedStatement == null) {
            this.preparedStatement = this.connection.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.preparedStatement.setFetchSize(this.getFetchSize());
        this.preparedStatement.setFetchDirection(this.getFetchDirection());
        this.preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        this.preparedStatement.setMaxRows(this.getMaxRows());
        this.preparedStatement.setQueryTimeout(this.getQueryTimeout());
        this.preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        this.resultSet = this.preparedStatement.executeQuery();
        this.notifyRowSetChanged();
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
        this.notifyRowSetChanged();
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        Connection connection = null;
        if (this.connection != null && !this.connection.isClosed()) {
            connection = this.connection;
        } else if (rowSet.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(rowSet.getDataSourceName());
                if (rowSet.getUsername() == null || rowSet.getPassword() == null) {
                    connection = dataSource.getConnection();
                }
                connection = dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        } else if (rowSet.getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = rowSet.getUrl();
            String string2 = rowSet.getUsername();
            String string3 = rowSet.getPassword();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            connection = DriverManager.getConnection(string, string2, string3);
        }
        return connection;
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new OracleRowSetMetaData(this.resultSet.getMetaData());
    }

    public int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string);
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.getConnection(this);
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.preparedStatement = this.connection.prepareStatement(string, this.getType(), this.getConcurrency());
    }

    public void setReadOnly(boolean bl) throws SQLException {
        super.setReadOnly(bl);
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.setReadOnly(bl);
    }

    public void setFetchDirection(int n) throws SQLException {
        super.setFetchDirection(n);
        this.resultSet.setFetchDirection(this.fetchDirection);
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLException("This JdbcRowSet implementation does not allow deleted rows to be visible");
        }
        super.setShowDeleted(bl);
    }

    public boolean next() throws SQLException {
        boolean bl = this.resultSet.next();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        boolean bl = this.resultSet.previous();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.resultSet.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.resultSet.afterLast();
            this.notifyCursorMoved();
        }
    }

    public boolean first() throws SQLException {
        boolean bl = this.resultSet.first();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean last() throws SQLException {
        boolean bl = this.resultSet.last();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl = this.resultSet.absolute(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        boolean bl = this.resultSet.relative(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.preparedStatement.setNull(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.preparedStatement.setNull(n, n2, string);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.preparedStatement.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.preparedStatement.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.preparedStatement.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.preparedStatement.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.preparedStatement.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.preparedStatement.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.preparedStatement.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.preparedStatement.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.preparedStatement.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.preparedStatement.setTime(n, time);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.preparedStatement.setObject(n, object);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.preparedStatement.setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.preparedStatement.setArray(n, array);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.preparedStatement.setBinaryStream(n, inputStream, n2);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.preparedStatement.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.preparedStatement.setTimestamp(n, timestamp, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.preparedStatement.setAsciiStream(n, inputStream, n2);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.preparedStatement.setCharacterStream(n, reader, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.preparedStatement.setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.preparedStatement.setObject(n, object, n2);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.preparedStatement.setDate(n, date, calendar);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.resultSet.getObject(n, map);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.resultSet.getBigDecimal(n);
    }

    public Ref getRef(int n) throws SQLException {
        return this.resultSet.getRef(n);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.resultSet.getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        return this.resultSet.getClob(n);
    }

    public Array getArray(int n) throws SQLException {
        return this.resultSet.getArray(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(n, calendar);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.resultSet.getCharacterStream(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(n, calendar);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.resultSet.getBinaryStream(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(n, calendar);
    }

    public String getString(int n) throws SQLException {
        return this.resultSet.getString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.resultSet.getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        return this.resultSet.getByte(n);
    }

    public short getShort(int n) throws SQLException {
        return this.resultSet.getShort(n);
    }

    public long getLong(int n) throws SQLException {
        return this.resultSet.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        return this.resultSet.getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        return this.resultSet.getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.resultSet.getBigDecimal(n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.resultSet.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        return this.resultSet.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.resultSet.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.resultSet.getTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.resultSet.getAsciiStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.resultSet.getUnicodeStream(n);
    }

    public int getInt(int n) throws SQLException {
        return this.resultSet.getInt(n);
    }

    public Object getObject(int n) throws SQLException {
        return this.resultSet.getObject(n);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.resultSet.getBigDecimal(string, n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.resultSet.getBytes(string);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Time getTime(String string) throws SQLException {
        return this.resultSet.getTime(string);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.resultSet.getAsciiStream(string);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.resultSet.getUnicodeStream(string);
    }

    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.resultSet.getCharacterStream(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.resultSet.getObject(string, map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.resultSet.getRef(string);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.resultSet.getBlob(string);
    }

    public Clob getClob(String string) throws SQLException {
        return this.resultSet.getClob(string);
    }

    public Array getArray(String string) throws SQLException {
        return this.resultSet.getArray(string);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.resultSet.getBigDecimal(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(string, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(string, calendar);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.resultSet.getBinaryStream(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(string, calendar);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public byte getByte(String string) throws SQLException {
        return this.resultSet.getByte(string);
    }

    public short getShort(String string) throws SQLException {
        return this.resultSet.getShort(string);
    }

    public void updateNull(int n) throws SQLException {
        this.resultSet.updateNull(n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.resultSet.updateCharacterStream(n, reader, n2);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(n, timestamp);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateBinaryStream(n, inputStream, n2);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateAsciiStream(n, inputStream, n2);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(n, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.resultSet.updateByte(n, by);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.resultSet.updateShort(n, s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.resultSet.updateInt(n, n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.resultSet.updateLong(n, l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.resultSet.updateFloat(n, f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.resultSet.updateDouble(n, d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(n, bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.resultSet.updateString(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(n, byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.resultSet.updateDate(n, date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.resultSet.updateTime(n, time);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.resultSet.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.resultSet.updateObject(n, object, n2);
    }

    public void updateNull(String string) throws SQLException {
        this.resultSet.updateNull(string);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(string, bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.resultSet.updateByte(string, by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.resultSet.updateShort(string, s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.resultSet.updateInt(string, n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.resultSet.updateLong(string, l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.resultSet.updateFloat(string, f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.resultSet.updateDouble(string, d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(string, bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.resultSet.updateString(string, string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(string, byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.resultSet.updateDate(string, date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.resultSet.updateTime(string, time);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.resultSet.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.resultSet.updateObject(string, object, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, n);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(string, timestamp);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, n);
    }

    public URL getURL(int n) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(string);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(string, ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(string, blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(string, clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(string, array);
    }

    public void commit() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.rollback(savepoint);
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        ((OracleConnection)this.connection).oracleRollback(oracleSavepoint);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.connection != null) {
            return this.connection.getAutoCommit();
        }
        throw new SQLException("Connection not open");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open");
        }
        this.connection.setAutoCommit(bl);
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    String getTableName() throws SQLException {
        return this.getMetaData().getTableName(this.getMatchColumnIndexes()[0]);
    }
}

