.code
;
; ****************************
; *****  %_lshift.giant  *****  logical left shift giant
; *****  %_ushift.giant  *****  arithmetic left shift giant
; ****************************
;
; in:	edx:eax = source operand
;	ecx = number of bits to shift
; out:	edx:eax = result
;
; destroys: nothing
;
%_lshift.giant:										; left logical and arithmetic shifts are the same
%_ushift.giant:
cmp	ecx,0													; shifting zero or fewer bits?
jle	> ushift_ret									; yes: result = input
cmp	ecx,64												; shifting 64 or more bits?
jge	> ushift_ret									; yes: result = input
cmp	cl,32
je	> glshift32										; shifting exactly 32 bits
ja	> glshift33										; shifting more than 32 bits
;																	; shifting less than 32 bits
shld	edx,eax,cl
shl	eax,cl
ret
glshift32:												; shift left exactly 32 bits
mov	edx,eax												; copy least significant half to most signif.
xor	eax,eax												; clear least significant half
ret
glshift33:												; shift left more than 32 bits
mov	edx,eax												; copy least significant half to most signif.
xor	eax,eax												; clear least significant half
shl	edx,cl												; shift (cl - 32) bits
ushift_ret:
ret
