/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import XMLConsumer.IEntry;
import hhapplet.IActionSink;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public abstract class ListView
extends Panel
implements Runnable,
AdjustmentListener,
IActionSink {
    private static final int HEIGHT_HORIZONTAL_SB = 16;
    private static final int WIDTH_VERTICAL_SB = 16;
    private Vector m_vToDo;
    private Scrollbar m_sbHorizontal = new Scrollbar(0);
    private Scrollbar m_sbVertical = new Scrollbar(1);
    private Button m_btnScrollerCorner;
    private int m_nHVisible;
    private int m_nVisible;
    private int m_nUHeight;
    private int m_nMouseX;
    private int m_nMouseY;
    private IEntry m_HighLightedEntry;
    private IEntry m_SelectedEntry;
    private int m_nHighLightedPos;
    private int m_nSelectedPos;
    private Image m_bgImage;
    private int m_nbgWidth;
    private int m_nbgHeight;
    private Image m_cachebgImage;
    private int m_nOldWidth;
    private int m_nOldHeight;
    private boolean m_bBgUpdated;
    private Image m_imgbackground;

    protected void procResize() {
        this.doLayout();
    }

    public Image getBackgroundImage() {
        if (this.m_nbgWidth <= 0 || this.m_nbgHeight <= 0 || this.m_bgImage == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.height == this.m_nOldHeight && rectangle.width == this.m_nOldWidth && !this.m_bBgUpdated) {
            return this.m_cachebgImage;
        }
        this.m_nOldWidth = rectangle.width;
        this.m_nOldHeight = rectangle.height;
        this.m_cachebgImage = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = this.m_cachebgImage.getGraphics();
        this.drawBackGround(graphics);
        return this.m_cachebgImage;
    }

    protected abstract void listPaint(Graphics var1, Image var2);

    public void clearHightLighted() {
        if (this.m_HighLightedEntry != null) {
            this.m_HighLightedEntry.highLight(false);
        }
        this.m_HighLightedEntry = null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 101 || aWTEvent.getID() == 102) {
            this.procResize();
            return;
        }
        if (aWTEvent.getID() == 500) {
            this.m_nMouseX = ((MouseEvent)aWTEvent).getX();
            this.m_nMouseY = ((MouseEvent)aWTEvent).getY();
            this.procClicked();
            return;
        }
        if (aWTEvent.getID() == 503) {
            this.m_nMouseX = ((MouseEvent)aWTEvent).getX();
            this.m_nMouseY = ((MouseEvent)aWTEvent).getY();
            this.procMoved();
            return;
        }
        if (aWTEvent.getID() == 1004) {
            int n;
            IEntry iEntry;
            if (this.m_SelectedEntry == null && (iEntry = this.getEntryByPos(n = this.getTop())) != null) {
                this.selectEntry(n, n, iEntry);
                return;
            }
        } else if (aWTEvent.getID() == 401) {
            if (this.m_SelectedEntry == null) {
                return;
            }
            switch (((KeyEvent)aWTEvent).getKeyCode()) {
                case 40: {
                    IEntry iEntry;
                    int n = this.getTop();
                    int n2 = this.m_nSelectedPos;
                    int n3 = this.getVerticalMax() - 1;
                    if (n2 >= n3 || (iEntry = this.getEntryByPos(++n2)) == null) break;
                    if (n2 < n || n2 > n + this.getVisible() - 2) {
                        n = n2 - this.getVisible() + 2;
                        this.setTop(n);
                    }
                    this.selectEntry(n, n2, iEntry);
                    return;
                }
                case 38: {
                    IEntry iEntry;
                    int n = this.getTop();
                    int n4 = this.m_nSelectedPos;
                    int n5 = 0;
                    if (n4 <= n5 || (iEntry = this.getEntryByPos(--n4)) == null) break;
                    if (n4 < n || n4 > n + this.getVisible() - 2) {
                        n = n4;
                        this.setTop(n);
                    }
                    this.selectEntry(n, n4, iEntry);
                    return;
                }
                case 34: {
                    int n = this.getTop();
                    int n6 = n + this.getVisible() - 2;
                    int n7 = this.getVerticalMax() - 1;
                    if (n6 > n7) {
                        n6 = n7;
                    }
                    if (this.m_nSelectedPos != n6) {
                        IEntry iEntry = this.getEntryByPos(n6);
                        this.selectEntry(n, n6, iEntry);
                        return;
                    }
                    if ((n = n + this.getVisible() - 1) > n7 - this.getVisible() + 2) {
                        n = n7 - this.getVisible() + 2;
                    }
                    if (n <= 0) break;
                    n6 = n + this.getVisible() - 2;
                    IEntry iEntry = this.getEntryByPos(n6);
                    this.setTop(n);
                    this.selectEntry(n, n6, iEntry);
                    return;
                }
                case 33: {
                    int n = this.getTop();
                    if (this.m_nSelectedPos != n) {
                        IEntry iEntry = this.getEntryByPos(n);
                        this.selectEntry(n, n, iEntry);
                        return;
                    }
                    if ((n = n - this.getVisible() + 1) < 0) {
                        n = 0;
                    }
                    IEntry iEntry = this.getEntryByPos(n);
                    this.setTop(n);
                    this.selectEntry(n, n, iEntry);
                    return;
                }
                case 36: {
                    IEntry iEntry = this.getEntryByPos(0);
                    if (iEntry == null) break;
                    this.setTop(0);
                    this.selectEntry(0, 0, iEntry);
                    return;
                }
                case 35: {
                    int n = this.getVerticalMax() - 1;
                    IEntry iEntry = this.getEntryByPos(n);
                    if (iEntry == null) break;
                    int n8 = n - this.getVisible() + 2;
                    if (n8 > 0) {
                        this.setTop(n8);
                        this.selectEntry(n8, n, iEntry);
                        return;
                    }
                    this.setTop(0);
                    this.selectEntry(0, n, iEntry);
                    return;
                }
                case 10: {
                    if (this.m_SelectedEntry == null) break;
                    this.m_SelectedEntry.action(this);
                    return;
                }
            }
        }
    }

    protected void selectEntry(int n, int n2, IEntry iEntry) {
        Graphics graphics = this.getGraphics();
        this.translate(graphics);
        if (this.m_SelectedEntry != null) {
            this.m_SelectedEntry.select(false);
            if (graphics != null && this.m_nSelectedPos - n >= 0) {
                this.m_SelectedEntry.display(graphics, this.m_nSelectedPos - n, this.m_nUHeight, this.getBackground(), this.m_imgbackground);
            }
        }
        if (iEntry != null) {
            iEntry.select(true);
            if (graphics != null) {
                this.getFontMetrics(graphics.getFont());
                iEntry.display(graphics, n2 - n, this.m_nUHeight, this.getBackground(), this.m_imgbackground);
            }
        }
        this.m_nSelectedPos = n2;
        this.m_SelectedEntry = iEntry;
        this.selectedEntry(this.m_SelectedEntry);
    }

    public int getHorizontalPos() {
        return this.m_sbHorizontal.getValue();
    }

    public abstract void accept(Vector var1);

    public void setBgImage(Image image) {
        this.m_bgImage = image;
        this.m_nbgHeight = this.m_bgImage.getHeight(this);
        this.m_nbgWidth = this.m_bgImage.getWidth(this);
    }

    public void dispatchToDo(String string) {
        if (string == "repaint") {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawBackGround(Graphics graphics) {
        if (this.m_nbgWidth > 0 && this.m_nbgHeight > 0 && this.m_bgImage != null) {
            Rectangle rectangle = this.getBounds();
            int n = 0;
            while (n <= (rectangle.width - 1) / this.m_nbgWidth) {
                int n2 = 0;
                while (n2 <= (rectangle.height - 1) / this.m_nbgHeight) {
                    if (!graphics.drawImage(this.m_bgImage, n * this.m_nbgWidth, n2 * this.m_nbgHeight, this.m_nbgWidth, this.m_nbgHeight, null)) {
                        this.setTimeout("repaint", 100);
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.m_bBgUpdated) {
                this.m_bBgUpdated = false;
                return;
            }
        } else {
            Color color = graphics.getColor();
            Color color2 = this.getBackground();
            graphics.setColor(color2);
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.m_bgImage) {
            this.m_nbgWidth = n4;
            this.m_nbgHeight = n5;
            this.m_bBgUpdated = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public void active() {
        if (this.m_SelectedEntry != null) {
            this.m_SelectedEntry.action(this);
        }
    }

    public void setHorizontalMax(int n) {
        if ((n += 16) <= this.m_nHVisible) {
            int n2 = this.m_sbHorizontal.getValue();
            this.m_sbHorizontal.setValues(n2, this.m_nHVisible - 1, 0, n);
            if (!this.m_sbVertical.isVisible()) {
                this.m_btnScrollerCorner.setVisible(false);
            }
            this.m_sbHorizontal.setVisible(false);
            if (n2 != this.m_sbHorizontal.getValue()) {
                this.repaint();
                return;
            }
        } else {
            this.m_sbHorizontal.setValues(this.m_sbHorizontal.getValue(), this.m_nHVisible - 1, 0, n);
            if (!this.m_sbVertical.isVisible()) {
                this.m_btnScrollerCorner.setVisible(true);
            }
            this.m_sbHorizontal.setVisible(true);
        }
    }

    public int getUnitHeight() {
        return this.m_nUHeight;
    }

    public void setUnitHeight(int n) {
        if (n > 0) {
            this.m_nUHeight = n;
            this.m_sbHorizontal.setUnitIncrement(this.m_nUHeight);
        }
    }

    private void translateBack(Graphics graphics) {
        int n = this.getHorizontalPos();
        graphics.translate(n - 4, -2);
    }

    public final void setTimeout(String string, int n) {
        ToDo toDo = new ToDo(string, n);
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            this.m_vToDo.addElement(toDo);
            Object var6_5 = null;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void doLayout() {
        this.m_sbVertical.setBounds(this.getBounds().width - 16, 0, 16, this.getBounds().height - 16);
        this.m_sbHorizontal.setBounds(0, this.getBounds().height - 16, this.getBounds().width - 16, 16);
        this.m_btnScrollerCorner.setBounds(this.getBounds().width - 16, this.getBounds().height - 16, 16, 16);
        this.m_nVisible = this.getBounds().height / this.m_nUHeight;
        if (this.m_sbVertical.getBlockIncrement() != this.m_nVisible - 1 && this.m_nVisible - 1 > 0) {
            this.m_sbVertical.setBlockIncrement(this.m_nVisible - 1);
        }
        if (this.m_sbVertical.getVisibleAmount() != this.m_nVisible - 1) {
            this.m_sbVertical.setVisibleAmount(this.m_nVisible - 1);
            if (this.m_sbVertical.getMaximum() < this.m_nVisible) {
                if (!this.m_sbHorizontal.isVisible()) {
                    this.m_btnScrollerCorner.setVisible(false);
                }
                this.m_sbVertical.setVisible(false);
            } else {
                if (!this.m_sbHorizontal.isVisible()) {
                    this.m_btnScrollerCorner.setVisible(true);
                }
                this.m_sbVertical.setVisible(true);
            }
        }
        this.m_nHVisible = this.getBounds().width;
        if (this.m_sbHorizontal.getBlockIncrement() != this.m_nHVisible - 1 && this.m_nHVisible - 1 > 0) {
            this.m_sbHorizontal.setBlockIncrement(this.m_nHVisible - 1);
        }
        if (this.m_sbHorizontal.getVisibleAmount() != this.m_nHVisible - 1) {
            this.m_sbHorizontal.setVisibleAmount(this.m_nHVisible - 1);
            if (this.m_sbHorizontal.getMaximum() < this.m_nHVisible) {
                if (!this.m_sbVertical.isVisible()) {
                    this.m_btnScrollerCorner.setVisible(false);
                }
                this.m_sbHorizontal.setVisible(false);
                return;
            }
            if (!this.m_sbVertical.isVisible()) {
                this.m_btnScrollerCorner.setVisible(true);
            }
            this.m_sbHorizontal.setVisible(true);
        }
    }

    protected void selectedEntry(IEntry iEntry) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getID() == 601) {
            this.procScroll();
        }
    }

    protected void procClicked() {
        if (this.m_nUHeight != 0) {
            int n;
            int n2 = this.m_sbVertical.getValue();
            int n3 = n2 + (n = this.m_nMouseY / this.m_nUHeight);
            IEntry iEntry = this.getEntryByPos(n3);
            if (iEntry != this.m_SelectedEntry) {
                this.selectEntry(n2, n3, iEntry);
            }
            if (iEntry != null) {
                iEntry.action(this);
            }
        }
    }

    public ListView() {
        this.m_sbHorizontal.setBackground(new Color(192, 192, 192));
        this.add(this.m_sbHorizontal);
        this.m_sbVertical.setBackground(new Color(192, 192, 192));
        this.add(this.m_sbVertical);
        this.m_btnScrollerCorner = new Button();
        this.m_btnScrollerCorner.setEnabled(false);
        this.add(this.m_btnScrollerCorner);
        this.enableEvents(61L);
        this.m_sbVertical.addAdjustmentListener(this);
        this.m_sbHorizontal.addAdjustmentListener(this);
        this.m_nVisible = 0;
        this.m_nHVisible = 0;
        this.m_vToDo = new Vector();
        this.setUnitHeight(16);
        this.m_nbgWidth = -1;
        this.m_nbgHeight = -1;
        this.m_bgImage = null;
    }

    protected void procMoved() {
        int n;
        int n2;
        int n3;
        IEntry iEntry;
        if (this.m_nUHeight != 0 && (iEntry = this.getEntryByPos(n3 = (n2 = this.m_sbVertical.getValue()) + (n = this.m_nMouseY / this.m_nUHeight))) != this.m_HighLightedEntry) {
            this.highLightEntry(n2, n3, iEntry);
        }
    }

    private void translate(Graphics graphics) {
        int n = this.getHorizontalPos();
        graphics.translate(-n + 4, 2);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.m_sbVertical.isVisible()) {
            rectangle.width -= 16;
        }
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.m_imgbackground = this.getBackgroundImage();
        if (this.m_imgbackground != null) {
            graphics2.drawImage(this.m_imgbackground, 0, 0, this);
        }
        this.translate(graphics2);
        this.listPaint(graphics2, this.m_imgbackground);
        this.translateBack(graphics2);
        this.paintBorder(graphics2, rectangle);
        graphics.drawImage(image, 0, 0, this);
    }

    public int getVisible() {
        return this.m_nVisible;
    }

    public int getTop() {
        return this.m_sbVertical.getValue();
    }

    public void setTop(int n) {
        this.m_sbVertical.setValue(n);
        this.procScroll();
    }

    protected abstract IEntry getEntryByPos(int var1);

    protected void highLightEntry(int n, int n2, IEntry iEntry) {
        Graphics graphics = this.getGraphics();
        this.translate(graphics);
        if (this.m_HighLightedEntry != null) {
            this.m_HighLightedEntry.highLight(false);
            if (graphics != null) {
                this.m_HighLightedEntry.display(graphics, this.m_nHighLightedPos - n, this.m_nUHeight, this.getBackground(), this.m_imgbackground);
            }
        }
        if (iEntry != null) {
            iEntry.highLight(true);
            if (graphics != null) {
                iEntry.display(graphics, n2 - n, this.m_nUHeight, this.getBackground(), this.m_imgbackground);
            }
        }
        this.m_HighLightedEntry = iEntry;
        this.m_nHighLightedPos = n2;
    }

    public void setVerticalMax(int n) {
        this.m_sbVertical.setValues(this.m_sbVertical.getValue(), this.m_nVisible - 1, 0, n);
        if (n <= this.m_nVisible) {
            if (!this.m_sbHorizontal.isVisible()) {
                this.m_btnScrollerCorner.setVisible(false);
            }
            this.m_sbVertical.setVisible(false);
            return;
        }
        if (!this.m_sbHorizontal.isVisible()) {
            this.m_btnScrollerCorner.setVisible(true);
        }
        this.m_sbVertical.setVisible(true);
    }

    public int getVerticalMax() {
        return this.m_sbVertical.getMaximum();
    }

    protected void paintBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        Color color2 = this.getBackground();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        Color color5 = color4.darker();
        graphics.setColor(color4);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color5);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void procScroll() {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getParent().getSize();
    }

    public void run() {
        ToDo toDo;
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            toDo = (ToDo)this.m_vToDo.elementAt(0);
            this.m_vToDo.removeElementAt(0);
            Object var4_3 = null;
        }
        try {
            Thread.sleep(toDo.m_nMSec);
            this.dispatchToDo(toDo.m_sToDo);
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    public void clearSelected() {
        if (this.m_SelectedEntry != null) {
            this.m_SelectedEntry.select(false);
        }
        this.m_SelectedEntry = null;
        this.selectedEntry(this.m_SelectedEntry);
    }

    private class ToDo {
        public String m_sToDo;
        public int m_nMSec;

        public ToDo(String string, int n) {
            ListView.this.getClass();
            this.m_sToDo = string;
            this.m_nMSec = n;
        }
    }
}

