#include <stdio.h>

/*
** This program only runs with go32 or rsx (not emx!)
*/

inline unsigned char peek_dos_byte(int addr)
{
    unsigned char _v;
    __asm__ ("movb %%gs:(%1),%0":"=r" (_v):"r" (addr));
    return _v;
}

inline unsigned short peek_dos_word(int addr)
{
    unsigned short _v;
    __asm__ ("movw %%gs:(%1),%0":"=r" (_v):"r" (addr));
    return _v;
}

inline unsigned long peek_dos_long(int addr)
{
    unsigned long _v;
    __asm__ ("movl %%gs:(%1),%0":"=r" (_v):"r" (addr)); \
    return _v;
}

inline void poke_dos_byte(char val,unsigned int addr)
{
    __asm__ ("movb %0,%%gs:(%1)"::"q" (val),"r" (addr));
}

inline void poke_dos_word(short val,unsigned int addr)
{
    __asm__ ("movw %0,%%gs:(%1)"::"r" (val),"r" (addr));
}

inline void poke_dos_long(long val,unsigned int addr)
{
    __asm__ ("movl %0,%%gs:(%1)"::"r" (val),"r" (addr));
}

static char name[]="hello writing screen memory";

int main(int argc,char **argv,char **env)
{
    int i,screen;

    screen = 0xB0000;

    printf("hallo");

    for (i=0; name[i]; i++)
	poke_dos_word(name[i] | 0x0700, screen + i*2);

    return 0;
}
