/* exec.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __EMX__
#include <process.h>
#include <signal.h>
#else
#include <sys\_process.h>
#include <sys\_signal.h>
#endif

static int wp;
static int gpid;

static void do_wait (void)
{
  int p, t;

  p = wait (&t);
  if (p == -1)
    perror ("wait");
  else
    {
      if ((t & 0xff) == 0)
        fprintf (stderr, "Process %d terminated normally, rc=%d\n",
                 p, t >> 8);
      else if ((t & 0xff) == 127)
        fprintf (stderr, "Process %d stopped by signal %d\n",
                 p, t >> 8);
      else
        fprintf (stderr, "Process %d terminated by signal %d\n",
                 p, t & 0xff);
    }
}


static void handler (int sig)
{
  if (sig == SIGCLD)
    {
      fprintf (stderr, "SIGCLD: "); fflush (stderr);
      do_wait ();
      fflush (stderr);
      signal (SIGCLD, SIG_ACK);
    }
  else
    {
      printf ("Signal %d received. Process stopped.\n", sig);
      exit (1);
    }
}


int main (int argc, char **argv, char **env)
{
  char buf[100], *p, *q, *r;
  char *nenvp[1];
  char *nargv[100];
  char args[5000];
  int i, j, mode, ask;
  
  signal (SIGINT, handler);
  signal (SIGCLD, handler);
  if (argc >= 2)
    {
      i = spawnve (mode, argv[1], argv+1, env);
      if (i < 0)
        perror ("spawnve");
      else
        printf ("rc=%d\n", i);
      return (0);
    }
  ask = 0; wp = 0;
  for (;;)
    {
      printf ("pid=%d\n", (int)getpid ());
      printf ("command: ");
      fflush (stdout);
      if (fgets (buf, sizeof (buf), stdin) == NULL)
        {
          perror ("fgets"); return (1);
        }
      p = strchr (buf, '\n');
      if (p != NULL) *p = 0;
      p = buf;
      if (*p == '?')
        {
          puts ("?      display help");
          puts ("v=n    set environment variable V to value N");
          puts ("-s p   send signal s to process p");
          puts ("~c     run C asynchronously");
          puts ("*c     run C as overlay");
          puts ("#c     run C for debugging");
          puts ("&c     run C detached");
          puts ("%c     start session running C");
          puts ("       Flags after %:");
          puts ("         + maximized");
          puts ("         - minimized");
          puts ("         % full-screen");
          puts ("         ! don't close window automatically");
          puts ("         $ background");
          puts ("+a      Toggle flag: ask for parameters");
          puts ("+w      Toggle flag: use waitpid()");
        }
      else if (strchr (p, '=') != NULL)
        {
          if (putenv (p) != 0)
            perror ("putenv");
        }
      else if (sscanf (p, "-%d %d", &i, &j) == 2)
        {
          if (kill (j, i) < 0)
            perror ("kill");
        }
      else if (p[0] == '+' && p[1] == 'a')
        ask = !ask;
      else if (p[0] == '+' && p[1] == 'w')
        wp = !wp;
      else
        {
          if (*p == '*')
            {
              mode = P_OVERLAY; ++p;
            }
          else if (*p == '#')
            {
              mode = P_DEBUG; ++p;
            }
          else if (*p == '~')
            {
              mode = P_NOWAIT; ++p;
            }
          else if (*p == '&')
            {
              mode = P_DETACH; ++p;
            }
          else if (*p == '%')
            {
              mode = P_SESSION;
              ++p;
/*	      if (*p == '-')
                {
                  mode |= P_MINIMIZE; ++p;
                }
              else if (*p == '+')
                {
                  mode |= P_MAXIMIZE; ++p;
                }
              else if (*p == '%')
                {
                  mode |= P_FULLSCREEN; ++p;
                }
              else
                mode |= P_WINDOWED;
              if (*p == '!')
                {
                  mode |= P_NOCLOSE; ++p;
                }
              if (*p == '$')
                {
                  mode |= P_BACKGROUND; ++p;
                }
*/	    }
          else
            mode = P_WAIT;
          if (*p == 0)
            {
              printf ("done\n");
              return (0);
            }
          i = 0;
          q = p;
          while ((nargv[i++] = strtok (q, " \t")) != NULL)
            q = NULL;
          if (ask)
            {
              printf ("Enter arguments, one per line (. to end):\n");
              q = args; --i;
              for (;;)
                {
                  r = fgets (q, sizeof (args) - (q - args), stdin);
                  if (r == NULL)
                    return (0);
                  r = strchr (q, '\n');
                  if (r != NULL)
                    *r = 0;
                  else
                    r = strchr (q, 0);
                  if (strcmp (q, ".") == 0)
                    break;
                  nargv[i++] = q;
                  q = r + 1;
                }
              nargv[i] = NULL;
            }
          nenvp[0] = NULL;

	  gpid = spawnvpe (mode, p, (const char * const *)nargv, NULL);

	  if (gpid < 0)
            {
	      perror ("spawnvpe");
            }
          else
            printf ("rc=%d\n", gpid);
        }
    }
  return (1);
}

