/* This file is GDT.C
**
** this program shows the GDT, IDT and LDT tables
*/

#include <stdlib.h>
#include <stdio.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "START16.H"

void protected_program()
{
    GDTR gdtr;               /* struct for sgdt,sidt call ,6 Byte Buffer */
    WORD sel,ldtsel,idtsel;
    DWORD gdtbase,ldtbase,idtbase,gdtlimit,ldtlimit,idtlimit;
    unsigned i;
    DESCRIPTOR d;
    LPDESCRIPTOR gdt ;   /* pointer to gdt of DPMI server */
    LPDESCRIPTOR idt;    /* pointer to idt of DPMI server */

    sgdt16(&gdtr) ;
    printf("\nGDT : limit %04X address %04X%04X \n",
            gdtr.limit,gdtr.hi,gdtr.lo);
    printf("LDT selector= %X\n",(ldtsel=sldt16()) );
    printf("Task selector= %X\n",str16());

    /* now we must alloced one selector and set the address
    **    to the gdt address and limit */

    gdtbase=(DWORD)gdtr.hi<<16 | gdtr.lo ;
    gdtlimit=gdtr.limit;

    if (AllocLDT(1,&sel)==-1) {
        printf("error allocldt\n") ;
        return ;
        }
    if ((SetBaseAddress(sel,gdtbase))==-1) {
        printf("err setbase\n");
        return ;
        }
    if ((SetLimit(sel,gdtlimit))==-1) {
        printf("err setlimit\n");
        return ;
        }

    /* the same procedure for the idt table */
    sidt16(&gdtr) ;
    printf("IDT : limit %04X address %04X%04X \n",gdtr.limit,gdtr.hi,gdtr.lo);
    idtbase=((DWORD)gdtr.hi <<16) | gdtr.lo ;
    idtlimit=gdtr.limit;

    printf("GLOBALE DESCRIPTOR TABELLE:\n");

    gdt=(LPDESCRIPTOR)MK_FP(sel,0);          /* protected mode pointer */
    gdtlimit++;
    gdtlimit/=8;            /* one descriptor = 8 bytes */

    for (i=0;i< gdtlimit ;i++) {
            printf("g=%04X ",i<<3);
            PrintDescriptor(gdt+i);
            if (ldtsel==i*8) {   /* to get the address of the ldt table */
                ldtlimit=DESC_LIMIT(gdt[i]);
                ldtbase=DESC_BASE(gdt[i]);
                }
            }

    printf("ldtbase ldt=%lX  limit %lX\n",ldtbase,ldtlimit);
    printf("gebrauchter selektor %X\n",sel);
    if ((SetBaseAddress(sel,ldtbase))==-1) {printf("err setbase\n"); return ; } ;
    if ((SetLimit(sel,ldtlimit))==-1) {printf("err setlimit\n"); return ; } ;

    printf("LOKALE DESCRIPTOR TABELLE:\n");
    ldtlimit++;
    ldtlimit/=8;
    for (i=0;i< ldtlimit ;i++) {
        if (gdt[i].access!=0)  {  /* exclude null selectors */
            printf("l=%04X ",(i<<3)+7);
            PrintDescriptor(gdt+i);
            }
        }

    printf("INTERRUPT DESCRIPTOR TABELLE:\n");
    if ((SetBaseAddress(sel,idtbase))==-1) {
        printf("err setbase\n");
        return ;
        }
    if ((SetLimit(sel,idtlimit))==-1) {
        printf("err setlimit\n");
        return ;
        }

    idt=(LPDESCRIPTOR)MK_FP(sel,0);
    idtlimit++;
    idtlimit/=8;

    for (i=0;i<idtlimit;i++) {
        printf("int %3X ",i);
        PrintDescriptor(idt+i);
        }

    if ((FreeLDT(sel))==-1) {
        printf("err freeldt\n");
        return ;
        }
}

void main()
{
    if (real_to_protected(0))
        exit(1);
    if (hangin_extender()) {
        fprintf(stderr,"ERROR: can't hang in extensions\n");
        protected_to_real(1);
        }
    protected_program();
    protected_to_real(0);
}
