/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 8                         
                                                                            
Shows how the region fill function works with various shapes.               
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int x;
int oldmode;
color palette[256];


void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();
  vga256();
  wcls(0);

  wsetcolor(1);
  wcircle(160,100,50);		/* try filling a circle */
  getch();

  wsetcolor(40);
  wregionfill(160,100);
  delay(1000);
  wsetcolor(170);
  wregionfill(0,0);

  getch();

  wcls(0);
  for (x = 1; x < 10000; x++)     /* try filling 10,000 random pixels */
  {
    wsetcolor(rand() % 255);
    wputpixel(rand() % 320,rand() % 200);
  }
  getch();
  wsetcolor(40);
  wclip(50,50,250,150);		 /* fill works with clipping too! */
  wregionfill(160,100);

  wsetcolor(7);
  wclip(10,10,40,40);
  wregionfill(20,20);

  wsetcolor(9);
  wclip(260,160,300,190);
  wregionfill(270,170);

  wsetcolor(10);
  wclip(0,0,319,199);
  wregionfill(0,0);

  getch();
  wsetmode(oldmode);
}