7  m    cU4  \  c      d  }REM Scrollbar for OPLREM by Dr. Thomas Tensi, Am Rothenanger 24b, D-85521 RiemerlingREMREM Conventions used:REM   - procedures are grouped in MODULEs and prefixed by module nameREM   - private procedures start with an underscoreREM *******************************************************************REMREM version history:REM   1.0 initial version 971231INCLUDE "Const.oph"INCLUDE "Scrollbar.oph"REM ---------------------------------------------------------------REM            1         2         3REM   12345678901234567890123456789012   length ruler for namesCONST _Scrollbar_numberOfWindows% = 64CONST _Scrollbar_p0% = 1REM constants for status setREM TYPE ScrollbarStatusType = SET OF (button1Pressed, button1Greyed,REM                                    button2Pressed, button2Greyed);CONST _Scrollbar_button1Pressed% = 1CONST _Scrollbar_button1Greyed%  = 2CONST _Scrollbar_button2Pressed% = 4CONST _Scrollbar_button2Greyed%  = 8REM *** private methodsEXTERNAL _Scrollbar_drawTriangle:(size%, triangleDirection%)EXTERNAL _Scrollbar_findNewButtonState%:(oldstate%, cond%, val%)EXTERNAL _Scrollbar_WCtoDC%:(x&, min&, max&, compartmentLength&, minLength%, p0%,length%)PROC _Scrollbar_changeInternally:(scrollbarID%, low&, high&, min&, max&, updateIsNecessary%, buttonPressed%)  LOCAL width%, length%, isVertical%, p3%, p4%, mode%  LOCAL buttonState%, newButtonState%, mask%  LOCAL oldWindow%  REM *** update scrollbar variables  _Scrollbar_low&(scrollbarID%)   = low&  _Scrollbar_delta&(scrollbarID%) = high&-low&  _Scrollbar_min&(scrollbarID%)   = min&  _Scrollbar_max&(scrollbarID%)   = max&  REM *** redraw container  oldWindow% = gIDENTITY  gUSE scrollbarID%  IF low&=min& AND high&=max& OR min&>=max&    gVISIBLE OFF  ELSE    gVISIBLE ON    length% = _Scrollbar_length%(scrollbarID%)    width%  = _Scrollbar_width%(scrollbarID%)    isVertical% = _Scrollbar_isVertical%(scrollbarID%)    _Scrollbar_findScrollbarCoords:(scrollbarID%, low&, high&-low&, min&, max&, width%, length%)    p3% = _Scrollbar_p%(3)    p4% = _Scrollbar_p%(4)    _Scrollbar_redrawSlider:(scrollbarID%, width%, length%)    REM *** update scrollbar buttons if necessary ***    buttonState% = _Scrollbar_buttonState%(scrollbarID%)    newButtonState% = _Scrollbar_findNewButtonState%:(buttonState%, buttonPressed%=1, _Scrollbar_button1Pressed%)    newButtonState% = _Scrollbar_findNewButtonState%:(newButtonState%, low&=min&, _Scrollbar_button1Greyed%)    mask% = _Scrollbar_button1Greyed%+_Scrollbar_button1Pressed%    IF (buttonState% AND mask%)<>(newButtonState% AND mask%)      IF buttonPressed%=1 : mode% = KButtS5SemiPressed% : ELSE : mode% = KButtS5Raised% : ENDIF      _Scrollbar_drawArrowButton:(isVertical%, p3%, KTrue%, width%-2, p4%-p3%, low&=min&, mode%)    ENDIF    newButtonState% = _Scrollbar_findNewButtonState%:(newButtonState%, buttonPressed%=2, _Scrollbar_button2Pressed%)    newButtonState% = _Scrollbar_findNewButtonState%:(newButtonState%, high&=max&, _Scrollbar_button2Greyed%)    mask% = _Scrollbar_button2Greyed%+_Scrollbar_button2Pressed%    IF (buttonState% AND mask%)<>(newButtonState% AND mask%)      IF buttonPressed%=2 : mode% = KButtS5SemiPressed% : ELSE : mode% = KButtS5Raised% : ENDIF      _Scrollbar_drawArrowButton:(isVertical%, p4%, KFalse%, width%-2, p4%-p3%, high&=max&, mode%)    ENDIF    _Scrollbar_buttonState%(scrollbarID%) = newButtonState%  ENDIF  gUSE oldWindow%  IF updateIsNecessary%    @(_Scrollbar_updateProc$(scrollbarID%)):(low&)  ENDIFENDPPROC _Scrollbar_DCtoWC&:(x%, p0%, length%, minLength%, min&, max&, compartmentLength&)  REM device coordinates to world coordinates  LOCAL l%, part, effectiveLength%  effectiveLength% = length%-2*p0%  part = INTF(compartmentLength&)/(max&-min&)  l% = part*effectiveLength%/(1+part)  IF l%>=minLength%    RETURN min& + (x%-p0%)*(max&-min&)/effectiveLength%  ELSE    RETURN min& + (x%-p0%)*(max&-compartmentLength&-min&)/(effectiveLength%-minLength%)  ENDIFENDPPROC _Scrollbar_drawArrowButton:(isVertical%, pos%, isFirstButton%, w%, l%, isGrey%, mode%)  IF isVertical%    gAT 1,pos% : gBUTTON "", KButtS5%, w%,l%, mode%    gAT w%/2+1,pos%+l%/2    IF isGrey% : gCOLOR 128, 128, 128 : ENDIF    IF isFirstButton%      _Scrollbar_drawTriangle:(l%/3, 90)    ELSE      _Scrollbar_drawTriangle:(l%/3, 270)    ENDIF  ELSE    gAT pos%,1 : gBUTTON "",KButtS5%,l%,w%,mode%    gAT pos%+l%/2,w%/2+1    IF isGrey% : gCOLOR 128, 128, 128 : ENDIF    IF isFirstButton%      _Scrollbar_drawTriangle:(l%/3, 180)    ELSE      _Scrollbar_drawTriangle:(l%/3, 0)    ENDIF  ENDIF  gCOLOR 0, 0, 0ENDPPROC _Scrollbar_drawTriangle:(size%, triangleDirection%)  REM <size> tells size in device pixels  REM <triangleDirection> tells the direction of the triangle in degrees  LOCAL x%, y%, i%, j%, xSgn%, ySgn%  x% = gX : y% = gY  IF triangleDirection%=0    xSgn% = 1  : ySgn% = 0  ELSEIF triangleDirection%=90    xSgn% = 0  : ySgn% = -1  ELSEIF triangleDirection%=180    xSgn% = -1 : ySgn% = 0  ELSEIF triangleDirection%=270    xSgn% = 0  : ySgn% = 1  ENDIF  gAT x%+xSgn%*size%/2,y%+ySgn%*size%/2  i% = 0  WHILE i%<size%    gMOVE -xSgn%,-ySgn%    j% = (i%*7)/10+1    gLINEBY  j%*ySgn%, j%*xSgn%    gMOVE   -j%*ySgn%,-j%*xSgn%    gLINEBY -j%*ySgn%,-j%*xSgn%    gMOVE    j%*ySgn%, j%*xSgn%    i% = i%+1  ENDWH  gAT x%,y%ENDPPROC _Scrollbar_findNewButtonState%:(oldstate%, cond%, val%)  IF cond%    RETURN oldstate% OR val%  ELSE    RETURN oldstate% AND NOT val%  ENDIFENDPPROC _Scrollbar_findScrollbarCoords:(scrollbarID%, l&, compartmentLength&, min&, max&, width%, length%)  LOCAL diff%, minLength%  LOCAL p0%, p1%, p2%  LOCAL oldWindow%  oldWindow% = gIDENTITY  gUSE scrollbarID%  _Scrollbar_p%(3) = length%  IF _Scrollbar_isVertical%(scrollbarID%)    _Scrollbar_p%(5) = gHEIGHT  ELSE    _Scrollbar_p%(5) = gWIDTH  ENDIF  _Scrollbar_p%(4) = (_Scrollbar_p%(3)+_Scrollbar_p%(5)) / 2  gUSE oldWindow%  p0% = _Scrollbar_p0%  minLength% = width%/2  p1% = _Scrollbar_WCtoDC%:(l&, min&, max&, compartmentLength&, minLength%, p0%, length%)  p2% = _Scrollbar_WCtoDC%:(l&+compartmentLength&, min&, max&, compartmentLength&, minLength%, p0%, length%)  IF p2%-p1%<minLength% : p2% = p1%+minLength% : ENDIF  _Scrollbar_p%(1) = p1%  _Scrollbar_p%(2) = p2%ENDPPROC _Scrollbar_handleEvent%:(scrollbarID%, pointerType&, x%, y%)  LOCAL low&, delta&, min&, max&  LOCAL width%, length%, offset&, interval%, coordinate%, button%, diff%  REM *** check whether scrollbar exists  length% = _Scrollbar_length%(scrollbarID%)  IF length%=0    RAISE KErrInvalidWindow%  ENDIF  REM *** process event  low&   = _Scrollbar_low&(scrollbarID%)  delta& = _Scrollbar_delta&(scrollbarID%)  min&   = _Scrollbar_min&(scrollbarID%)  max&   = _Scrollbar_max&(scrollbarID%)  width% = _Scrollbar_width%(scrollbarID%)  IF _Scrollbar_isVertical%(scrollbarID%)    coordinate% = y%  ELSE    coordinate% = x%  ENDIF  _Scrollbar_findScrollbarCoords:(scrollbarID%, low&, delta&, min&, max&, width%, length%)  interval% = 0  WHILE KTrue%    IF coordinate%<=_Scrollbar_p%(interval%+1) : BREAK : ENDIF    interval% = interval%+1  ENDWH  IF pointerType&=KEvPtrPenUp&    _Scrollbar_changeInternally:(scrollbarID%, low&, low&+delta&, min&, max&, KFalse%, 0)  ELSE    IF pointerType&=KEvPtrPenDown&      _Scrollbar_delta% = coordinate%-_Scrollbar_p%(1)      _Scrollbar_initialCoordinate% = coordinate%      _Scrollbar_initialInterval% = interval%    ENDIF    IF pointerType&=KEvPtrPenDown& OR pointerType&=KEvPtrDrag&      IF (_Scrollbar_initialInterval%=1) OR (_Scrollbar_initialInterval%=interval%)        IF _Scrollbar_initialInterval%=1          IF pointerType&=KEvPtrPenDown&            offset& = 0          ELSE            offset& = _Scrollbar_DCtoWC&:(coordinate%-_Scrollbar_delta%, _Scrollbar_p0%, length%, width%, min&, max&, delta&)            offset& = offset&-low&          ENDIF        ELSE          IF     interval%=0            offset& = MIN(-delta&, -1)          ELSEIF interval%=1            REM already done!          ELSEIF interval%=2            offset& = MAX(delta&, 1)          ELSEIF interval%=3            offset& = -1          ELSE            offset& = 1          ENDIF        ENDIF        IF low&+delta&+offset&>max&          low& = max&-delta&        ELSEIF low&+offset&<min&          low& = min&        ELSE          low& = low& + offset&        ENDIF        IF interval%=3     : button%=1        ELSEIF interval%=4 : button%=2        ELSE               : button%=0        ENDIF        _Scrollbar_changeInternally:(scrollbarID%, low&, low&+delta&, min&, max&, KTrue%, button%)      ENDIF    ENDIF  ENDIFENDPPROC _Scrollbar_redrawSlider:(scrollbarID%, width%, length%)  REM REQUIRE gIDENTITY=scrollbarID%  LOCAL i%, pos%, count%, diff%, offset%, increment%, w%  gAT 0,0  IF _Scrollbar_isVertical%(scrollbarID%)    gBOX width%,length%    gAT 1,_Scrollbar_p0%    gFILL width%-2,length%-2*_Scrollbar_p0%, KgModeClear%    gAT 1,_Scrollbar_p%(1)    gBUTTON "", KButtS5%, width%-2,_Scrollbar_p%(2)-_Scrollbar_p%(1), KButtS5Raised%  ELSE    gBOX length%,width%    gAT _Scrollbar_p0%,1    gFILL length%-2*_Scrollbar_p0%,width%-2, KgModeClear%    gAT _Scrollbar_p%(1),1    gBUTTON "", KButtS5%, _Scrollbar_p%(2)-_Scrollbar_p%(1),width%-2, KButtS5Raised%  ENDIF  REM *** draw lines ***  w% = width%/4  diff% = (_Scrollbar_p%(2)-_Scrollbar_p%(1))/3  increment% = w%  count% = diff%/increment% + 1  offset% = diff% + (diff%-increment%*(count%-1))/2  pos% = _Scrollbar_p%(1)+offset%  i% = 1  WHILE i%<=count%    IF _Scrollbar_isVertical%(scrollbarID%)      gAT width%/2,pos% : gLINEBY -w%,0 : gMOVE w%,0 : gLINEBY w%,0 : gMOVE -w%,0    ELSE      gAT pos%,width%/2 : gLINEBY 0,-w% : gMOVE 0,w% : gLINEBY 0,w% : gMOVE 0,-w%    ENDIF    pos% = pos%+increment% : i% = i%+1  ENDWHENDPPROC _Scrollbar_WCtoDC%:(x&, min&, max&, compartmentLength&, minLength%, p0%, length%)  REM world coordinates to device coordinates  LOCAL l%, part, effectiveLength%  effectiveLength% = length%-2*p0%  part = INTF(compartmentLength&)/(max&-min&)  l% = part*effectiveLength%/(1+part)  IF l%>=minLength%    RETURN p0% + INTF(x&-min&)*effectiveLength%/(max&-min&)  ELSE    RETURN p0% + INTF(x&-min&)*(effectiveLength%-minLength%)/(max&-compartmentLength&-min&)  ENDIFENDPREM *** public methodsPROC Scrollbar_change:(scrollbarID%, low&, high&, min&, max&, updateIsNecessary%)  LOCAL length%, l&, h&  REM *** check whether scrollbar exists  length% = _Scrollbar_length%(scrollbarID%)  IF length%=0    RAISE KErrInvalidWindow%  ENDIF  REM *** adjust box interval  IF low&>max& : l& = max& : ELSEIF low&<min& : l& = min& : ELSE : l& = low&  : ENDIF  IF high&<min& : h& = min& : ELSEIF high&>max& : h& = max& : ELSE : h& = high& : ENDIF  _Scrollbar_changeInternally:(scrollbarID%, l&, h&, min&, max&, updateIsNecessary%,0)ENDPPROC Scrollbar_close:(scrollbarID%)  IF _Scrollbar_length%(scrollbarID%)>0    gCLOSE scrollbarID%  ENDIF  _Scrollbar_length%(scrollbarID%) = 0ENDPPROC Scrollbar_create%:(isVertical%, x%, y%, w%, l%, buttonLength%, updateProc$)  LOCAL scrollbarID%, state%  LOCAL low&, high&, min&, max&  LOCAL oldWindow%  oldWindow% = gIDENTITY  IF buttonLength%<2 OR w%<4 OR l%<3*buttonLength%    RAISE KErrInvalidArgs%  ENDIF  IF isVertical%    scrollbarID% = gCREATE(x%, y%, w%, l%, KgCreateVisible%, KgCreate4ColourMode%)  ELSE    scrollbarID% = gCREATE(x%, y%, l%, w%, KgCreateVisible%, KgCreate4ColourMode%)  ENDIF  gXBORDER KgXBorderS5Type%, KBordSglShadow%  gUSE oldWindow%  _Scrollbar_isVertical%(scrollbarID%)   = isVertical%  _Scrollbar_length%(scrollbarID%)       = l%-2*buttonLength%  _Scrollbar_width%(scrollbarID%)        = w%  _Scrollbar_updateProc$(scrollbarID%)   = updateProc$  REM --- set button state to junk value --> redraw necessary  state% = _Scrollbar_button1Greyed%+_Scrollbar_button1Pressed%  state% = state%+_Scrollbar_button2Greyed%+_Scrollbar_button2Pressed%  _Scrollbar_buttonState%(scrollbarID%) = state%  low& = 0 : high& = 0 : min& = 0 : max& = 0  _Scrollbar_changeInternally:(scrollbarID%, low&, high&, min&, max&, KFalse%, 0)  RETURN scrollbarID%ENDPPROC Scrollbar_offer%:(windowID%, pointerType&, x%, y%)  REM offer pen event to scrollbar manager  IF _Scrollbar_length%(windowID%)=0    RETURN KFalse%  ELSE    _Scrollbar_handleEvent%:(windowID%, pointerType&, x%, y%)    RETURN KTrue%  ENDIFENDPPROC Scrollbar_initMODULE:(nextProc$)  GLOBAL _Scrollbar_isVertical%(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_low&(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_delta&(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_min&(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_max&(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_length%(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_width%(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_buttonState%(_Scrollbar_numberOfWindows%)  GLOBAL _Scrollbar_updateProc$(_Scrollbar_numberOfWindows%, 32)  GLOBAL _Scrollbar_delta%, _Scrollbar_initialInterval%  GLOBAL _Scrollbar_initialCoordinate%  GLOBAL _Scrollbar_p%(5)  @(nextProc$):ENDP                                         \  c  4  e      f      d              \  c  
4  e      f      d    .  A     *TextEd.app      4    4  