/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class TObject {
    private int _id;
    private int _flags;
    private TProperty[] _properties;
    private int[] _superclasses;
    private Vector _vocab;
    private boolean _is_numbered = false;
    private byte[] _data;

    public TObject(int n, int n2, int[] nArray, TProperty[] tPropertyArray) {
        this._id = n;
        this._flags = n2;
        this._properties = tPropertyArray;
        this._superclasses = nArray;
        this._vocab = new Vector();
        this._data = null;
    }

    public TObject(int n, byte[] byArray) {
        this._id = n;
        this._data = byArray;
    }

    public int get_id() {
        return this._id;
    }

    public byte[] get_data() {
        return this._data;
    }

    public int[] get_superclasses() {
        return this._superclasses;
    }

    public Vector get_vocab() {
        return this._vocab;
    }

    public boolean is_object() {
        return this._data == null;
    }

    public boolean is_class() {
        return this.is_object() && (this._flags & 1) != 0;
    }

    public boolean is_dynamic() {
        return this.is_object() && (this._flags & 0x16) != 0;
    }

    public boolean is_numbered() {
        return this._is_numbered;
    }

    public void add_vocab(VocabWord vocabWord) {
        if (!this._vocab.contains(vocabWord)) {
            this._vocab.addElement(vocabWord);
        }
        if (vocabWord.get_word().equals("#")) {
            this._is_numbered = true;
        }
    }

    public void rem_vocab(VocabWord vocabWord) {
        for (int i = 0; i < this._vocab.size(); ++i) {
            VocabWord vocabWord2 = (VocabWord)this._vocab.elementAt(i);
            if (!vocabWord2.get_word().equals(vocabWord.get_word())) continue;
            this._vocab.removeElementAt(i);
            --i;
        }
        if (vocabWord.get_word().equals("#")) {
            this._is_numbered = false;
        }
    }

    public boolean inherits_from(int n) throws HaltTurnException {
        for (int i = 0; i < this._superclasses.length; ++i) {
            if (this._superclasses[i] == n) {
                return true;
            }
            TObject tObject = Jetty.state.lookup_object(this._superclasses[i]);
            if (!tObject.inherits_from(n)) continue;
            return true;
        }
        return false;
    }

    public TValue lookup_property(int n) throws HaltTurnException {
        return this.lookup_property(n, true, true);
    }

    public TValue lookup_property(int n, boolean bl) throws HaltTurnException {
        return this.lookup_property(n, bl, true);
    }

    public TValue lookup_property(int n, boolean bl, boolean bl2) throws HaltTurnException {
        return this.lookup_property(n, bl, bl2, null);
    }

    public TValue lookup_property(int n, boolean bl, boolean bl2, TObject[] tObjectArray) throws HaltTurnException {
        TValue tValue;
        if (Jetty.get_debug_level() >= 3) {
            Jetty.out.print_error("Looking up self=" + this.get_id() + " property=" + n, 3);
        }
        if ((tValue = this.lookup_local_property(n)) != null) {
            if (bl2) {
                if (tObjectArray != null) {
                    tObjectArray[0] = this;
                }
                return tValue;
            }
            if (Jetty.get_debug_level() >= 3) {
                Jetty.out.print_error("Found locally, but use_first was false", 3);
            }
            bl2 = true;
        }
        if (!bl) {
            return null;
        }
        if (Jetty.get_debug_level() >= 3) {
            Jetty.out.print_error("Not found locally, inheriting", 3);
        }
        TObject tObject = null;
        TValue tValue2 = null;
        for (int i = 0; i < this._superclasses.length; ++i) {
            TObject[] tObjectArray2;
            TObject tObject2 = Jetty.state.lookup_object(this._superclasses[i]);
            TValue tValue3 = tObject2.lookup_property(n, true, true, tObjectArray2 = new TObject[1]);
            if (tValue3 == null) continue;
            if (tValue2 == null || tObjectArray2[0].inherits_from(tObject.get_id())) {
                if (!bl2) {
                    if (Jetty.get_debug_level() >= 3) {
                        Jetty.out.print_error("Found in superclass, but use_first was false", 3);
                    }
                    bl2 = true;
                    continue;
                }
                if (Jetty.get_debug_level() >= 3) {
                    Jetty.out.print_error("Found in superclass=" + tObjectArray2[0].get_id() + "; using new value", 3);
                }
                tValue2 = tValue3;
                tObject = tObjectArray2[0];
                continue;
            }
            if (Jetty.get_debug_level() < 3) continue;
            Jetty.out.print_error("Found in superclass=" + tObjectArray2[0].get_id() + " but not using that", 3);
        }
        if (tObjectArray != null) {
            tObjectArray[0] = tObject;
        }
        return tValue2;
    }

    public TValue lookup_local_property(int n) {
        if (Jetty.get_debug_level() >= 4) {
            Jetty.out.print_error("Doing lookup for id=" + this._id + ", pid=" + n, 3);
        }
        if (this._properties == null) {
            Jetty.out.print_error("lookup_property() called on function (self=" + this._id + " pid=" + n + ")", 1);
            return null;
        }
        for (int i = 0; i < this._properties.length; ++i) {
            if (this._properties[i].id != n) continue;
            return this._properties[i].value;
        }
        return null;
    }

    public static TValue[] arg_array() {
        return new TValue[0];
    }

    public static TValue[] arg_array(TValue tValue) {
        TValue[] tValueArray = new TValue[]{tValue == null ? new TValue(5, 0) : tValue};
        return tValueArray;
    }

    public static TValue[] arg_array(TValue tValue, TValue tValue2) {
        TValue[] tValueArray = new TValue[]{tValue == null ? new TValue(5, 0) : tValue, tValue2 == null ? new TValue(5, 0) : tValue2};
        return tValueArray;
    }

    public static TValue[] arg_array(TValue tValue, TValue tValue2, TValue tValue3) {
        TValue[] tValueArray = new TValue[]{tValue == null ? new TValue(5, 0) : tValue, tValue2 == null ? new TValue(5, 0) : tValue2, tValue3 == null ? new TValue(5, 0) : tValue3};
        return tValueArray;
    }

    public static TValue[] arg_array(TValue tValue, TValue tValue2, TValue tValue3, TValue tValue4) {
        TValue[] tValueArray = new TValue[]{tValue == null ? new TValue(5, 0) : tValue, tValue2 == null ? new TValue(5, 0) : tValue2, tValue3 == null ? new TValue(5, 0) : tValue3, tValue4 == null ? new TValue(5, 0) : tValue4};
        return tValueArray;
    }

    public static TValue[] arg_array(TValue tValue, TValue tValue2, TValue tValue3, TValue tValue4, TValue tValue5) {
        TValue[] tValueArray = new TValue[]{tValue == null ? new TValue(5, 0) : tValue, tValue2 == null ? new TValue(5, 0) : tValue2, tValue3 == null ? new TValue(5, 0) : tValue3, tValue4 == null ? new TValue(5, 0) : tValue4, tValue5 == null ? new TValue(5, 0) : tValue5};
        return tValueArray;
    }

    public TValue eval_property(int n, TValue[] tValueArray) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        return this.eval_property(this, n, tValueArray);
    }

    public TValue eval_property(TObject tObject, int n, TValue[] tValueArray) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        return this.eval_property(tObject, n, tValueArray, true);
    }

    public TValue eval_property(TObject tObject, int n, TValue[] tValueArray, boolean bl) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        if (this._properties == null) {
            Jetty.out.print_error("eval_property() called on function (self=" + this._id + " pid=" + n + ")", 1);
            Thread.dumpStack();
            return new TValue(5, 0);
        }
        TObject[] tObjectArray = new TObject[1];
        TValue tValue = this.lookup_property(n, true, bl, tObjectArray);
        if (tValue == null) {
            return new TValue(5, 0);
        }
        if (tValue.get_type() == 6) {
            byte[] byArray = tValue.get_code();
            if (Jetty.get_debug_level() >= 3) {
                Jetty.out.print_error("Evaluating id=" + this._id + " pid=" + n, 3);
            }
            return Jetty.runner.run(byArray, tValueArray, tObject, tObjectArray[0]);
        }
        if (tValue.get_type() == 9) {
            Jetty.out.print(tValue.get_dstring());
            return new TValue(5, 0);
        }
        if (tValue.get_type() == 16) {
            TObject tObject2 = Jetty.state.lookup_object(tValue.get_redir());
            return tObject2.eval_property(n, tValueArray);
        }
        if (tValue.get_type() == 15) {
            return this.eval_property(tValue.get_synonym(), tValueArray);
        }
        return tValue;
    }

    public void set_property(int n, TValue tValue) {
        this.set_property(n, tValue, true);
    }

    public void set_property(int n, TValue tValue, boolean bl) {
        if (this._properties == null) {
            Jetty.out.print_error("set_property() called on function (self=" + this._id + " pid=" + n + ")", 1);
            return;
        }
        for (int i = 0; i < this._properties.length; ++i) {
            if (this._properties[i].id != n) continue;
            if (bl) {
                Jetty.state.save_prop_undo(this, n, this._properties[i].value);
            }
            this._properties[i].value = tValue;
            return;
        }
        if (bl) {
            Jetty.state.save_prop_undo(this, n, null);
        }
        TProperty[] tPropertyArray = new TProperty[this._properties.length + 1];
        System.arraycopy(this._properties, 0, tPropertyArray, 0, this._properties.length);
        tPropertyArray[this._properties.length] = new TProperty(n, tValue);
        this._properties = tPropertyArray;
    }

    public void del_property(int n) {
        if (this._properties == null) {
            Jetty.out.print_error("del_property() called on function (self=" + this._id + " pid=" + n + ")", 1);
            return;
        }
        for (int i = 0; i < this._properties.length; ++i) {
            if (this._properties[i].id != n) continue;
            TProperty[] tPropertyArray = new TProperty[this._properties.length - 1];
            System.arraycopy(this._properties, 0, tPropertyArray, 0, i);
            System.arraycopy(this._properties, i + 1, tPropertyArray, i, tPropertyArray.length - i);
            this._properties = tPropertyArray;
            break;
        }
    }
}

