#include <wadv.t>


sprayVerb: deepverb
  verb = 'spray'
  sdesc = "spray"
  prepDefault = atPrep
  ioAction (atPrep) = 'SprayAt'
;

modify class thing
  verDoSprayAt(a, i) = {
   "%You% can't spray that! ";
  }
  ioSprayAt(a, i) = {
    "Mmm.  Lemon scent! ";
  }
  verIoSprayAt(a) = {}
;

modify global
  maxscore = 5
;

replace userinit:function
{
    "\b\tYesterday, as you were walking through the park, a meteorite crashed
     near you, bathing you in cosmic radiation.  Little did you realize that
     the result of that exposure would be....";

    "\b\(The Underoos that ate New York!\) by G.\ Kevin Wilson.\n";
    "(c) 1994.  All Rights Reserved. \b\b";

    Me.location := shazam;                // move player to initial location
    shazam.lookAround( true );                    // show player where he is
    shazam.isseen := true;                  // note that we've seen the room
    "\bUh oh.  Your date with Cindy is in 20 minutes.  Better hurry and get
     dressed!  Now, where's that underwear?\b";
   scoreStatus();
}
;

modify class darkroom
  replace lookAround( verbosity ) =
  {
     if(self.islit) pass lookAround;
     else "It's pitch black.  You are likely to be eaten by a sock. ";
  }
  replace roomCheck( v ) =
    {
        if ( self.islit or v.issysverb or v.isTravelVerb ) return( true );
	else
	{
	    "It's pitch black.  You are likely to be eaten by a sock. \n";
	    return( nil );
	}
    }
;

replace darkTravel: function
{
  "Oh no!  You walked into the slavering fangs of a lurking sock. ";
  die();
  abort;
}

shazam: beditem, underHider
  noun = 'bed'
  adjective = 'my'
  sdesc = "your bed"
  adesc = "your bed"
  thedesc = "your bed"
  ldesc = "This is your bed. "
  location = Bedroom
  underCont = [Underoos]
  autoTake = nil
  verDoLookunder(actor) =
  {
     if(actor.location = self)
       "You lean over the edge and try to peer under the bed, but the blood
        rushes to your head and your eyes refuse to focus. ";
  }
  doLookunder(actor) =
  {
     Underoos.found := true;
     pass doLookunder;
  }
;

Underoos: hiddenItem, clothingItem
  sdesc = "your Ruby Poo underoos"
  adesc = "your Ruby Poo underoos"
  thedesc = "your Ruby Poo underoos"
  noun = 'underoos' 'underwear'
  found = nil
  adjective = 'ruby' 'poo'
  ldesc = "Ah.  Your good ole Ruby Poo underoos.  The luckiest of lucky
    underwear.  You've worn them every time you've ever gotten lucky.  But
    then, maybe that has something to do with never changing them.  Naaah. "
  doTake (actor) =
  {
     "As you pick your underwear up, something utterly unbelievable happens.
    The underwear begins struggling in your grasp!  Finally, it bites you on
    the hand, causing you to drop it.  It huddles in the corner, growling. ";
    LiveUndies.moveInto(Bedroom);
    self.moveInto(nil);
    setit(LiveUndies);
  }
;

DeadUndies: clothingItem
  sdesc = "your Ruby Poo underoos"
  adesc = "your Ruby Poo underoos"
  thedesc = "your Ruby Poo underoos"
  noun = 'underoos' 'underwear'
  adjective = 'ruby' 'poo'
  ldesc = "Your relationship with your underoos may never be the same again,
    but at least you can wear them again. "
;

LiveUndies: movableActor
  noun = 'underoos' 'underwear'
  adjective = 'ruby' 'poo'
  actorDesc = "\bYour Ruby Poo underoos are huddling in the corner. "
  ldesc = "They look like your underoos, but in a surprise move, right out
   of 'Night of the Comet', they seem to have come to life. (Well, maybe
   not a surprise move.  After all, the title of the game WAS The Underoos
   that ate New York, and they can hardly do that without coming to life,
   can they?) "
  verDoTake(actor) = { "They snarl manacingly, and you decide not to. "; }
  disavow = "The underoos give you a puzzled look. "
  verDoAttackWith(actor, io) = {}
  doAttackWith(actor, io) =
  {
      switch(io)
      {
       case Broom:
         "You tentatively poke the broom towards the underoos.  The broom is
         almost jerked out of your hands, and you hurriedly pull it back.
         The bristly end has been bitten clean off.  You look accusingly at
         your underoos, but they only belch up a Rubbermade sticker. ";
         Staff.moveInto(Me);
#ifdef BITTY_COMBAT
	 if (Broom = Me.ready)
	   Me.ready := Staff;
#endif
         Sticker.moveInto(Bedroom);
	 setit(LiveUndies);
         Broom.moveInto(nil);
        break;
       case Staff:
         "Angered at the wanton destruction of your broom, you assume a
         karate movie stance.  \"En garde, you elastic nightmare!\" you
         yell, and wade in with a flurry of blows, thrusts, and parries that
         leave the underoos dazed and confused.  Finally, you begin spinning
         the broom handle over your head, and change its momentum into a
         tremendous blow that hurls the underoos across the room to lie still
         by your bed. ";
         LiveUndies.moveInto(nil);
         DeadUndies.moveInto(Bedroom);
	 setit(DeadUndies);
         incscore(1);
        break;
       default:
         "With that?  That'd never work. ";
      }
  }
;

Bedroom: room
  sdesc = "Your Bedroom"
  ldesc = "Home sweet home for a '60s throwback bachelor like yourself.  Assorted, but
    unimportant decorations litter the walls and ceiling.  To the west is a
    door that, as you fuzzily recall, leads into your walk-in closet.  To the
    east is a hallway, that, as you even more fuzzily recall, leads to the
    kitchen. "
  east =
  {
    if (Underoos.found = nil) {
      "But you haven't even found your underoos! ";
      return(nil);
    }
    return(Kitchen);
  }
  west = ClosetDoor
;

Decorations: fixeditem
  noun = 'decorations'
  sdesc = "decorations"
  ldesc = "Assorted, but useless. "
  location = Bedroom
;

ClosetDoor: doorway
  sdesc = "closet door"
  noun = 'door'
  adjective = 'closet'
  location = Bedroom
  otherside = IClosetDoor
  doordest = Closet
;

IClosetDoor: doorway, lightsource
  sdesc = "closet door"
  noun = 'door'
  adjective = 'closet'
  otherside = ClosetDoor
  doordest = Bedroom
  location = Closet
  islit =
  {
     if (self.isopen) return(true);
       return(nil);
  }
;

Closet: darkroom
  sdesc = "Your Closet"
  ldesc = "Ah, the cathedral of clothes.  Only, um.  I wonder why it's
    empty?  The exit lies back to the east."
  east = IClosetDoor
;

Kitchen: room
  sdesc = "Your Kitchen"
  ldesc = "Kitchen (ki' chun) n. - A place in which food is prepared.  This
    particular ki' chun has a toaster, a fridge, a hallway leading west, a
    dark passageway leading into the cellar, and a hallway leading north to
    the entryway. "
  west = Bedroom
  warn = nil
  down =
  {
      if (not warn and not Shoes.isworn) {
	"As you recall, there's an awful lot of broken glass, rusting staples,
        and the like down there.  It would probably be good to make sure you're
        wearing shoes before you go down these stairs.  But, if you want to chance
	it anyways, then on your head lies the blame. ";
	warn := true;
        return(nil);
      }
      else if(not DeadUndies.isworn) {
         "You want to walk down into that freezing cellar without even the
          barest of protection for your little buddy?  Unh unh, go put some
          underwear on. ";
         return(nil);
      } else return(Cellar);
  }
  north = Entryway
  roomCheck (v) =
  {
    if ((v = yellVerb) and (Sock.location = Toaster))
    {
       Sock.kill;
    }
    return(true);
  }
;

Broom: item, qcontainer // , weapon // Add this when using BITTY_COMBAT.
  noun = 'broom'
  isListed = nil
  adjective = 'rubbermade'
  sdesc = "broom"
  ldesc = "Your broom.  There is a rubbermade sticker on the end of it, near
     the bristles. "
  isactor = true
  location = Kitchen
  actorDesc = "\bThere is a broom leaning against the counter. "
  verIoAttackWith(actor) = {}
  ioAttackWith(a, d) = { d.doAttackWith(a, self); }
  doTake(actor) =
  {
    self.isactor := nil;
    self.isListed := true;
    pass doTake;
  }
;

Sticker: item
  noun = 'sticker'
  sdesc = "sticker"
  adjective = 'rubbermade'
  location = Broom
  verDoTake (actor) = { if (self.location = Broom) "It's stuck to the broom. "; }
  doTake(actor) =
  {
     "Respectfully, you pick up the sticker, then, on a sudden impulse, you
     tie it around your head, like a bandana.  Your broom will not go
     unavenged! ";
     self.moveInto(nil);
     Bandana.moveInto(Me);
     Bandana.isworn := true;
     notify(Bandana, &Music, 0);
  }
  ldesc = "It reads 'Rubbermade'. "
;

Bandana: clothingItem
  sdesc = "rubbermade bandana"
  noun = 'bandana' 'sticker'
  adjective = 'rubbermade'
  ldesc = "The bandana says, \"Rubbermade\".  Watch out world! "
  monce = nil
  Music =
  {
     local h;

     h := rand(100);
     if (isworn and h<10) { "\bWheoweo!  Wanh WANH Wanh! ";
        if (not monce) {
          " [A little 'Good, Bad, and Ugly' mood music for you.] \b";
          monce := true;
        } else "\n";
     }
  }
;

Staff: item
  noun = 'handle' 'staff'
  adjective = 'broom'
  sdesc = "broom handle"
  verIoAttackWith(actor) = {}
  ioAttackWith(a, d) = { d.doAttackWith(a, self); }
  ldesc = "The remains of your once proud broom.  Tears fill your eyes as
    you remember all those hours spent sweeping pizza crumbs off the kitchen
    ceiling. "
;

Toaster: item, qcontainer
  noun = 'toaster'
  sdesc = "toaster"
  verDoTake(a) = { "Why bother? "; }
  ldesc = { "The toaster has a lever on its side.  The lever is currently ";
      if (Lever.on = true) "down. A warm glow comes from the toaster. ";
                    else "up. ";
      if (Sock.location = self)
         "There is a sock in each slot.  They are asleep.  Apparently they
          have built a nest in your toaster. ";
      if (DeadSock.location = self)
         "There is a well toasted sock in each slot.  So much for the toaster
          warming party.  Heheheh. ";
  }
  location = Kitchen
;

Lever: fixeditem
  noun = 'lever'
  sdesc = "lever"
  on = nil
  location = Toaster
  verDoPush (a) = { if(on) "It's already been pushed! "; }
  verDoPull (a) = { if(on) "It's already been pushed! "; }
  doPush (a) =
  {
     if (Sock.location = Toaster) {
        "Gently, so as not to wake the fearsome socks, you push down the
         lever. ";
        on := true;
        notify(Sock, &die2, 2);
     } else {
         "You push down the lever. ";
         on := true;
        notify(self, &pop, 2);
     }
  }
  doPull (a) =
  {
     if (Sock.location = Toaster) {
        "Gently, so as not to wake the fearsome socks, you pull down the
         lever. ";
        on := true;
        notify(Sock, &die2, 2);
     } else {
         "You pull down the lever. ";
         on := true;
        notify(self, &pop, 2);
     }
  }
  pop = { "\bThe lever pops up with a cheery snap. "; Lever.on := nil; }
;

Sock: item
  noun = 'sock' 'socks'
  sdesc = "socks"
  ldesc = "Your socks have mutated into something fearsome that likes to
    lurk in dark places and eat unwitting adventurers such as yourself.
    The sock's natural habitat is apparently the toaster.  I wouldn't wake
    those socks up if I were you.... "
  verDoTake(a) = {}
  verDoPush(a) = {}
  verDoWear(a) = {}
  verDoPull(a) = {}
  verDoTouch(a) = {}
  verDoPoke(a) = {}
  verDoMove(a) = {}
  verDoAttackWith(a, i) = {}
  doTake(a) = {  kill; }
  doPush(a) = { kill;  }
  doWear(a) = { kill;  }
  doPull(a) = {  kill; }
  doTouch(a) = { kill;  }
  doPoke(a) = { kill;  }
  doMove(a) = { kill;  }
  doAttackWith(a, i) = { kill;  }
  die2 =
  {
     "\bThe socks are overcome by heat stroke and die.  The lever pops up with
      a cheery snap. ";
     self.moveInto(nil);
     setit(DeadSock);
     DeadSock.moveInto(Toaster);
     Lever.on := nil;
     incscore(1);
  }
  verDoAskAbout(a, i) = {}
  disavow = { kill; }
  kill =
  {
	"The socks leap from the toaster in a flash, fastening themselves
	onto your body with their terrible elastic mouths.  You struggle
       mightily in their grip, but to no avail.  Gradually, the venom from
	their bite drags you down into oblivion. ";
	die();
	abort;
  }
  location = Toaster
;

DeadSock: clothingItem
  noun = 'sock' 'socks'
  sdesc = "socks"
  adesc = "a pair of socks"
  thedesc = "the pair of socks"
  ldesc = "Ordinary old socks, now that you've vanquished them. "
;

Fridge: item, openable
  isopen = nil
  sdesc = "fridge"
  noun = 'fridge' 'refrigerator'
  ldesc = {
   "The fridge is the newest in bachelor fridges, made entirely of baking soda.
    After awhile in there with the door shut, anything smells better.\n\t";
   pass ldesc;
  }
  location = Kitchen
  verDoTake(a) = { "You consider the fridge as visions of hernias dance
    before your eyes.  No thanks. "; }
  doClose(actor) =
  {
     if (LiveShoes.location = self) {
       notify(self, &first, 1);
       notify(self, &next, 2);
       notify(self, &last, 3);
     }
  pass doClose;
  }
  doOpen(actor) =
  {
     if (LiveShoes.location = self) {
       unnotify(self, &first);
       unnotify(self, &next);
       unnotify(self, &last);
       "The shoes hop out of the fridge.\b ";
       LiveShoes.moveInto(Kitchen);
     }
    pass doOpen;
  }
  first = { "A frantic pounding comes from within the fridge. "; }
  next = { "The pounding grows weaker. "; }
  last = { "The pounding stops. "; LiveShoes.moveInto(nil);
            Shoes.moveInto(self); incscore(1); }
;

LiveShoes: movableActor
  noun = 'shoe' 'shoes'
  sdesc = "shoes"
  adesc = "a pair of shoes"
  thedesc = "the pair of shoes"
  actorDesc = "\bYour shoes are here, hopping about and smelling terribly. "
  ldesc = "Welp.  That's something you don't see every day.  But man, do they stink! "
  verDoTake(actor) = { "They hop playfully out of reach. "; }
  disavow = "One of the shoes says something surprisingly like \"Momma!\".  Awww, it
    thinks you're its mommy.  Isn't that cute? "
  verDoAttackWith(a, i) = { "But they're so cute!  They just stink is all. "; }
  location = Closet
  ioSprayAt(a, d) = {
     switch(self.location)
     {
       case Closet:
        "The shoes bolt out into your bedroom. ";
        self.moveInto(Bedroom);
        break;
       case Bedroom:
        "The shoes hop into the kitchen. ";
        self.moveInto(Kitchen);
        break;
       case Kitchen:
         if (Fridge.isopen)
         {
           "The shoes flee into the fridge. ";
           self.moveInto(Fridge);
         } else
           "The shoes hop around in circles. ";
         break;
        case Fridge:
          "The shoes huddle back into the rear of the fridge. ";
         break;
     }
  }
;

Shoes: clothingItem
  noun = 'shoe' 'shoes'
  sdesc = "shoes"
  adesc = "a pair of shoes"
  thedesc = "the pair of shoes"
  ldesc = "Poor things.  They must've gotten trapped in the fridge and
    suffocated to death.  Oh well, they're wearable once more, at any rate! "
  verDoWear(a) = { if (not DeadSock.isworn) "Those chilly shoes on your bare
     feet?  Are you sick?  Where are your socks? "; }
;

GlowStick: item, lightsource
  islit = true
  noun = 'glowstick' 'stick'
  adjective = 'glow'
  sdesc = "glowstick"
  ldesc = "You put this in the fridge after the little light burned out.  It's
    guaranteed for another six centuries or so. "
  location = Fridge
;

Lysol: item
  noun = 'lyesmall' 'can'
  adjective = 'can'
  sdesc = "can of lyesmall"
  ldesc = "Lyesmall.  Hmm.  Guaranteed to clear up any odor.  Just 'spray can
    at <object>' to use.  There's also a warning label that says not to use the
    stuff near open fires.  Good thing there aren't any open fires in this game. "
  location = Fridge
  verDoSprayAt(a, i) = {}
  doSprayAt(a, i) = { i.ioSprayAt(a, self); }
  ioSprayAt(a, d) = { "Physically impossible. "; }
;

Cellar: darkroom
  sdesc = "Your Cellar"
  up = Kitchen
  ldesc = "Illuminated by the green glow of your glowstick, the cellar is
    indeed a fearsome place.  The floor is littered with various sharp rusty
    objects. "
  firstseen =
  {
     if (Shoes.isworn = nil) {
        "\bAs you walk out onto the floor, you step on a sharp, rusty nail.
         You try to scream, but your jaw has already frozen up, and you
         quickly succumb to tetanus. ";
        die();
        abort;
     } else "\bThe shoes protect your feet from the various sharp, rusty items. ";
     incscore(1);
     notify(Moth, &check, 0);
     notify(Suit, &ambush, 1);
  }
;

Jar: transparentItem, openable
  noun = 'jar'
  isopen = nil
  adjective = 'clear' 'plastic'
  sdesc = "clear, plastic jar"
  location = Cellar
;

Moth: Actor
  noun = 'moth'
  sdesc = "moth"
  disavow = "Moths can't talk. "
  actorDesc = "A moth flutters around. "
  ldesc = "The moth flutters around your glowstick, seeming to like it quite
    a bit. "
  verDoTake(actor) = { "You can't seem to catch it. "; }
  location = Cellar
  scored = nil
  check =
  {
    if (self.location = Suit.location) {
      "\bThe moth, seeing the delicious looking shirt and pants, makes a beeline
      for the living clothes.  The clothes make a break for the door, but the
      moth is upon them before they can get away.  It darts inside the shirt.
      The clothes go wild and start beating at themselves, but the moth is
      apparently eating whatever makes them move, for they slow down
      and crumple to the ground.  A rather fat moth flies out, and weaves its
      way outside, with a final dip in its flight as though to say, \"Thanks
      for dinner, buddy!\".  You resolve to throw away all your mothballs. ";
      "\n\t\"W-What was that?\" stammers Cindy.\n
       \t\"I'll tell you on the way to dinner.  Right now, let me finish getting
       dressed.  It's been a long day.\"\n";
      Suit.moveInto(nil);
      Shirt.moveInto(Entryway);
      Pants.moveInto(Entryway);
      self.moveInto(nil);
      unnotify(self, &check);
    } else if ((GlowStick.location = Jar) and (Jar.isopen) and (Me.location = self.location) and not (self.location = Jar))
    {
       "\bThe moth flutters into the jar. \b";
       if (not self.scored) {
          self.scored := true;
          incscore(1);
       }
       self.moveInto(Jar);
    } else if (self.location = Jar)
    {
       if (Jar.isopen) {
          "\bThe moth flutters back out of the jar. \b";
         if (Jar.location = Me) self.moveInto(Me.location);
         else self.moveInto(Jar.location);
       } else "\bThe moth flutters around in the jar. \b";
    }
 }
;

Suit: Actor
  noun = 'shirt' 'pants' 'clothing'
  sdesc = "your shirt and pants"
  adesc = "your shirt and pants"
  thedesc = "your shirt and pants"
  ldesc = "Your shirt and pants are here, holding Cindy hostage with a knife. "
  actorDesc = "\bYour shirt and pants are here, holding Cindy hostage with a
    knife. "
  ambush =
  {
      "\bYou hear a faint knock at the front door, followed by the sounds of
     it opening, and a scream!  \n\t\"Hang on, Cindy!  I'm coming!\" you shout. ";
     self.moveInto(Entryway);
     Cindy.moveInto(Entryway);
  }
  verDoAttackWith(a,i) = {}
  doAttackWith(a,i) =
  { 
     "As you move near, the shirt presses the knife against Cindy's neck.  You
      back off. ";
  }
;

knife: item
  noun = 'knife'
  sdesc = "knife"
  ldesc = "Nice and sharp.  Damn, when did clothes figure out the difference
    between a butter knife and a butcher knife? "
  location = Suit
;

Shirt: clothingItem
  noun = 'shirt'
  adjective = 'my'
  sdesc = "your shirt"
  adesc = "your shirt"
  thedesc = "your shirt"
  ldesc = "Your shirt, recently disarmed. "
;

Pants: clothingItem
  noun = 'pants'
  adjective = 'my'
  sdesc = "your pants"
  adesc = "your pants"
  thedesc = "your pants"
  ldesc = "Your pants, recently disarmed. "
;

Cindy: Actor
  noun = 'cindy'
  sdesc = "Cindy"
  adesc = "Cindy"
  thedesc = "Cindy"
  actorDesc =
  {
     if (Suit.location = self.location) "";
     else "\bCindy is here, looking grateful. ";
  }
  ldesc = {
      "This is Cindy, your girlfriend. ";
      if (Suit.location = self.location)
        "She is currently being held captive by your shirt and pants. ";
  }
;

Entryway: room
  sdesc = "Your Entryway"
  ldesc = "This is your plain old entryway.  There are a thousand places for
    clothing to hide.  The only thing to do is let the clothing make the
    first move.  The front door leads north. The kitchen lies south. "
  north =
  {
    if (not (Shirt.isworn and Pants.isworn)) {
      "You're not dressed yet";
    if (Suit.location = Me.location)
      " (and Cindy's still a prisoner)";
    ". ";
    } else self.Win;
  }
  south = Kitchen
  Win =
  {
       "\b\tYou and Cindy walk out to the car, and drive to a nice little
    Italian bistro.  You explain the whole sordid affair to her over garlic
    bread and wine, while waiting for your meal.  You pause periodically to
    allow her to gasp in fear as you tackle the nine-foot killer Underoos,
    the ravenous mutant shoes, the horrible socks, and after embellishing
    only somewhat, you arrive at the point where you rescued her.  She leans
    forward, gazing into your eyes.\n\t
    \"My hero.\" she murmurs, and kisses you gently on the lips.\n\tAbruptly,
    a wolf whistle, followed by a crude \"Hot Momma!\" pipes from between your
    legs.\n\t
    \"That better be my underoos.\" you think to yourself, heading for the
    bathroom....";
    "\b\ \ \ \ \ * * * Congratulations, you've won! * * *\b";
    scoreRank();
    "\bYou may restore a saved game, start over, or quit.\n";
    while ( 1 )
    {
        local resp, j;

      if(not j)
	"\nPlease enter (R)ESTORE, RE(S)TART, or (Q)UIT: >";
      else
	"\nPlease enter (R)ESTORE, RE(S)TART, or (Q)UIT: >";
        j := true;
        resp := upper(input());     /* get input, convert to uppercase */
        if ( resp = 'RESTORE' or resp = 'R')
	{
	    resp := askfile( 'File to restore' );       /* find filename */
	    if ( resp = nil ) "Restore failed. ";
	    else if ( restore( resp )) "Restore failed. ";
	    else
	    {
	        /*
		 *   We've successfully restored a game.  Reset the status
		 *   line's score/turn counter, and resume play.
		 */
	        scoreStatus();
		abort;
	    }
	}
        else if ( resp = 'RESTART' or resp = 'S')
	{
	    /*
	     *   We're going to start over.  Reset the status line's
	     *   score/turn counter and start from the beginning.
	     */
	    scoreStatus();
            restart();
	}
	else if ( resp = 'QUIT' or resp = 'Q')
        {
	    /*
	     *   We're quitting the game.  Do any final activity necessary,
	     *   and exit.
	     */
	    terminate();
            quit();
	    abort;
        }
    }
  }
;