/*
 *  Demonstration and test case of TADSMap.
 *
 *  This game was specifically designed to show
 *  all hallway cases: horizontal and vertical, and
 *  the same with "intersects," meaning the corners
 *  of other hallways to the NW, NE, SW, or SE.
 */

#include <adv.t>
#include <std.t>


#include "tadsmap.t"




#pragma C+



class shapeVerb: sysverb

    action(actor) =
    {
		if(testroom.maptype != self.shape)
		{
		    testroom.maptype = self.shape;
		    tadsmap.draw_this_turn = true;
		    tadsmap.map;
		}
        abort;
    }
;
roundVerb: shapeVerb
	verb = 'round'

    shape = 'round'
;
squareVerb: shapeVerb
	verb = 'square'

    shape = 'square'
;
smallVerb: shapeVerb
	verb = 'small'

    shape = 'small'
;



class testroom : tadsmap_room_basic

    ldesc = 
    {
        "This room's absolute coordinates are ("; self.sdesc;
        ") in a grid from (1, 1) to (5, 9). ";
        if(!testroom.note_shown)
        {
            testroom.note_shown = true;
            "\bNote #1: the relative TADSMap grid coordinates start at
            (0, 0) instead of (1, 1).\b
            
            Note #2: Type in ROUND or SQUARE or SMALL to change the
            shape of the rooms.";
        }
    }
    
    note_shown = nil
;


startroom : testroom

    sdesc = "3, 3"

	north = room_x3_y1
	north_distance = 2
	
	south = room_x3_y5
	south_distance = 2
	
	west = room_x1_y3
	west_distance = 2
	
	east = room_x5_y3
	east_distance = 2

    up = startroom
    down = startroom
	
	map_has_special_symbol = true
;

room_x3_y1 : testroom

    sdesc = "3, 1"

	south = startroom
	south_distance = 2
	
	sw = room_x1_y3
	sw_distance = 2
	
	se = room_x5_y3
	se_distance = 2
	
	map_has_special_symbol = true
;

room_x1_y3 : testroom

    sdesc = "1, 3"

	ne = room_x3_y1
	ne_distance = 2
	
	east = startroom
	east_distance = 2
	
	se = room_x3_y5
	se_distance = 2
	
	south = room_x1_y6
	south_distance = 3

    down = room_x1_y3
	
	map_has_special_symbol = true
;

room_x5_y3 : testroom

    sdesc = "5, 3"

	nw = room_x3_y1
	nw_distance = 2
	
	west = startroom
	west_distance = 2
	
	sw = room_x3_y5
	sw_distance = 2
	
	south = room_x5_y6
	south_distance = 3

    up = room_x5_y3
	
	map_has_special_symbol = true
;

room_x3_y5 : testroom

    sdesc = "3, 5"

	north = startroom
	north_distance = 2
	
	nw = room_x1_y3
	nw_distance = 2
	
	ne = room_x5_y3
	ne_distance = 2
;

room_x1_y6 : testroom

    sdesc = "1, 6"

	north = room_x1_y3
	north_distance = 3
	
	east = room_x3_y6
	east_distance = 2
	
	south = room_x1_y8
	south_distance = 2

    down = room_x1_y6
;

room_x3_y6 : testroom

    sdesc = "3, 6"

	west = room_x1_y6
	west_distance = 2
	
	east = room_x5_y6
	east_distance = 2
;

room_x5_y6 : testroom

    sdesc = "5, 6"

	north = room_x5_y3
	north_distance = 3
	
	west = room_x3_y6
	west_distance = 2
	
	south = room_x5_y8
	south_distance = 2

    up = room_x5_y6
;

room_x2_y7 : testroom

    sdesc = "2, 7"

	east = room_x3_y7
	sw = room_x1_y8
;

room_x3_y7 : testroom

    sdesc = "3, 7"

	west = room_x2_y7
	east = room_x4_y7
	
	south = room_x3_y8

	sw = room_x1_y9
	sw_distance = 2

	se = room_x5_y9
	se_distance = 2
;

room_x4_y7 : testroom

    sdesc = "4, 7"

	west = room_x3_y7
	se = room_x5_y8
;

room_x1_y8 : testroom

    sdesc = "1, 8"

	north = room_x1_y6
	north_distance = 2
	
	ne = room_x2_y7
;

room_x3_y8 : testroom

    sdesc = "3, 8"

	north = room_x3_y7
	
	sw = room_x2_y9
	se = room_x4_y9
;

room_x5_y8 : testroom

    sdesc = "5, 8"

	north = room_x5_y6
	north_distance = 2
	
	nw = room_x4_y7
;

room_x1_y9 : testroom

    sdesc = "1, 9"

	ne = room_x3_y7
	ne_distance = 2
	
	east = room_x2_y9
;

room_x2_y9 : testroom

    sdesc = "2, 9"

	ne = room_x3_y8
	west = room_x1_y9
;


room_x4_y9 : testroom

    sdesc = "4, 9"

	nw = room_x3_y8
	east = room_x5_y9
;

room_x5_y9 : testroom

    sdesc = "5, 9"

	nw = room_x3_y7
	nw_distance = 2
	
	west = room_x4_y9
;
