/* Literal Capture Verb testgame. Adapted from Mike Robert's t3 sample
 * game.
 */

/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT

/* include the standard TADS libraries */
#include <adv.t>
#include <std.t>
#include <lit_verb.t>

/* at game startup, turn on HTML mode */
replace commonInit: function
{
    /* display the special code sequence to turn on HTML recognition */
    "\H+";
}

/* starting location */
startroom: room
    sdesc = "Start Room"
    ldesc = "This is the starting room. "
;

replace typeVerb: literalCaptureVerb // a test verb.
    verb = 'type'
    sdesc = "type"
    literalAction(actor) = {
        if (literalCaptureVerb.commandStringBuffer = '')
            "You can use the verb like this: ><b>type Dearest Edna,</b>\n ";
        else
            typewriter.typeWords(literalCaptureVerb.commandStringBuffer);
    }
;

typewriter: fixeditem
    location = startroom
    noun = 'typewriter'
    sdesc = "typewriter"
    typeWords(str) = {

        /* add the literal text to the paper */
        typewriterPaper.addText(str);

        "With some effort, you work the keys of the ancient
        machine, noisily impressing '<<str>>' on the paper.\n";
    }
;

typewriterPaper: readable
    sdesc = "piece of paper"
    adjective = 'piece'
    noun = 'paper'
    location = typewriter
    ldesc = {
        if (self.textList = [])
            "The paper is blank.\n ";
        else {
            local i;
            "The typewritten letters on the page have that uneven
            darkness and wandering alignment characteristic of
            the work a well-worn manual typewriter:<tt>\b";

            for (i := 1 ; i <= length(textList) ; i++) {
                "<<self.textList[i]>>\n";
            }
            "</tt>";
        }
    }
    addText(txt) = {
        self.textList += txt;
    }
    textList = []
    moveInto(obj) =
    {
        "On second thought, you'd rather leave the
            paper in the typewriter in case someone needs to do
            some typing.\n";
        abort;
    }
;

