#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// BMDAEMON
// ROOM CLASSES
// THE PANEL
// THE SIGNS
// STATUES
// LETTERS
// ROOMS
// ROOM MODIFICATIONS
// ANCILLARY ROOM MODIFICATION STUFF
// DEBUGGING STUFF
// BOOK/MOVIE MAZES: MAPS: "STAR WARS"
// BOOK/MOVIE MAZES: MAPS: "CASABLANCA"
// BOOK/MOVIE MAZES: MAPS: "PLANET OF THE APES"
// BOOK/MOVIE MAZES: MAPS: "LAWRENCE OF ARABIA"
// BOOK/MOVIE MAZES: MAPS: "SAVING PRIVATE RYAN"
// BOOK/MOVIE MAZES: MAPS: "THE UNTOUCHABLES"
// BOOK/MOVIE MAZES: MAPS: "THE SILENCE OF THE LAMBS"
// BOOK/MOVIE MAZES: MAPS: "THE BRIDGE ON THE RIVER KWAI"
// BOOK/MOVIE MAZES: MAPS: "THE MANCHURIAN CANDIDATE"
// BOOK/MOVIE MAZES: MAPS: "THE SHAWSHANK REDEMPTION"
// BOOK/MOVIE MAZES: MAPS: "THE MAN WHO SHOT LIBERTY VALANCE"
// BOOK/MOVIE MAZES: MAPS: "ONE FLEW OVER THE CUCKOO'S NEST"
// BOOK/MOVIE MAZES: MAPS: "CROUCHING TIGER, HIDDEN DRAGON"
// BOOK/MOVIE MAZES: MAPS: "WAR AND PEACE"
// BOOK/MOVIE MAZES: MAPS: "THE SCARLET LETTER"
// BOOK/MOVIE MAZES: MAPS: "THE THREE MUSKETEERS"
// BOOK/MOVIE MAZES: MAPS: "A TALE OF TWO CITIES"
// BOOK/MOVIE MAZES: MAPS: "ROBINSON CRUSOE"
// BOOK/MOVIE MAZES: MAPS: "PRIDE AND PREJUDICE"
// BOOK/MOVIE MAZES: MAPS: "ALICE IN WONDERLAND"
// BOOK/MOVIE MAZES: MAPS: "THE BROTHERS KARAMAZOV"
// BOOK/MOVIE MAZES: MAPS: "THE CANTERBURY TALES"
// BOOK/MOVIE MAZES: MAPS: "REMEMBRANCE OF THINGS PAST"
// BOOK/MOVIE MAZES: MAPS: "THE ADVENTURES OF TOM SAWYER"
// BOOK/MOVIE MAZES: MAPS: "THE THOUSAND AND ONE NIGHTS"
// BOOK/MOVIE MAZES: MAPS: "ONE HUNDRED YEARS OF SOLITUDE"

// -------------------------------------------------------------------
// BMDAEMON
// -------------------------------------------------------------------

bmDaemon: DaemonComponent
  //location = gPlayerChar
  location = nil
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      daemonID = new Daemon(self, &daemon, 1);
      moveInto(gPlayerChar);
    }
  }
  daemon {
    if (gPlayerChar.getOutermostRoom.lettersSpelled &&
        gPlayerChar.getOutermostRoom.lettersSpelled
        .endsWith(gPlayerChar.getOutermostRoom.solution)) {
      local next = gPlayerChar.getOutermostRoom.nextMaze;
      "Then, from out of nowhere, a hollow voice says, 
        <.q>Yes, <i><<gPlayerChar.getOutermostRoom.workTitle>>,</i> ";
      if (gPlayerChar.getOutermostRoom.workAuthor)
        "by <<gPlayerChar.getOutermostRoom.workAuthor>>, ";
      "that<./s>s absolutely right!<./q> ";
      if (next && next.ofKind(BookMovieMaze)) {
        "<p>With that, the room fades from Sheila<./s>s vision\ .\ .\ . ";
        nbmPause();
        nbmCls();
        ". . . and, gradually, a new scene comes into view. 
          After a few seconds of disorientation, 
          Sheila looks around and finds herself
          in a room not much different from the previous one. ";
        "<p>";
        //endDaemon();
        //if (x.ofKind(CasablancaRoom)) { local k = 0; k=k/k; }
        gPlayerChar.moveIntoForTravel(next);
        next.enteringRoom(gPlayerChar);
        nestedActorAction(gPlayerChar, Look);
        nbmBanner.updateMe();
      }
      else {
        //"[In the real game, something would happen at this point.] ";
        "<.p>With that, suddenly a trap door opens up 
          beneath Sheila<./s>s feet. She tries to grab on to something, 
          but can<./s>t, and so she collapses through the floor 
          and keeps falling down and down\ .\ .\ . ";
        returnToCaveVictoriously('Finally, we<./s>re out of there!
          I thought those '
          + (gPlayerChar.getOutermostRoom.ofKind(BookMaze) ? 'book' : 'movie')
          + ' mazes would never end.');
      }
    }
  }
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
;

// -------------------------------------------------------------------
// ROOM CLASSES
// -------------------------------------------------------------------

// The BookMovieMaze class is a Room subclass. Each object in class 
// BookMovieMaze represents an entire maze, not just a single room.
// This is done in order to save memory.
// 
// Originally my book and movie mazes comprised some 290 rooms,
// 26+ room classes, 394 room connectors, and 684 functions.
// 
// Later on, in an effort to un-bloat my game and conserve memory,
// I reworked the book/movie mazes in a more efficient way.
// 
// Afterwards, in an email exchange with Krister Fundin, I showed
// him my reworked implementation, and he responded with a new 
// version of his own, which was even better.
// 
// I then reworked this according to my specific needs, and the 
// result is as you see it here.
// 
// Thus, many thanks to Krister Fundin, without whose help these
// book/movie mazes would take up more memory than they presently do.
// 
// Any kludges you see here are my own, not Krister's.
class BookMovieMaze: Room
  // Our room list. Each item is a sub-list, where the first item is 
  // the letter of the room (that is, an object belonging to class
  // Letter, e.g. letterA, letterD1, etc.), and the other items 
  // define the connections in clockwise order from north to northwest.
  roomList = []
  // our solution
  solution = ''
  workTitle = ''
  workAuthor = nil
  nextMaze = nil
  // Our current location in the maze, given as an index into the 
  // roomList. We always start in room number 1.
  curRoom = 1
  // for convenience, extract the letter of the current room
  curLetter = (roomList[curRoom][1])
  // and, for further convenience, get the string representing 
  // the current letter
  curLetterStr = (roomList[curRoom][1].letterStr)
  // derive our room name and description
  roomName = (curLetterStr + ' Room')
  roomDesc {
    if (curStatue)
      "In the middle of this room is 
        <<curStatue.aMaterialAdj>> 
        statue in the shape of the letter <<curLetterStr>>. ";
    describeExits;
    "<p>On the wall, a panel reads, <.q><<lettersSpelled>>.<./q> ";
    //if (ofKind(HawthorneRoom)) { local k; k=k/k; }
    if (xyzzyString && xyzzyIsKnown)
      "Below that, it reads, <.q>XYZZY = <.s><<xyzzyString>><./s>.<./q> ";
    else if (xyzzyString)
      "Below that, it reads, <.q>MAGIC WORD: XYZZY.<./q> ";
    //"<br>";
    //for (local a = 1; a <= solution.length; a++) {
    //  "<<solution[a]>>";
    //}
    //"<br>";
    //for (local a = solution.length; a >= 1; a--) {
    //  "<<solution[a]>>";
    //}
  }
  describeExits {
    local dirList = [
       'north'
      ,'northeast'
      ,'east'
      ,'southeast'
      ,'south'
      ,'southwest'
      ,'west'
      ,'northwest'
    ];
    local totalExits = 0;
    local count = 0;
    for (local a = 1; a <= 8; a++) {
      if (getDestFor(a))
        totalExits++;
    }
    if (totalExits == 1)
      "An exit leads ";
    else
      "Exits lead ";
    for (local a = 1; a <= 8; a++) {
      if (getDestFor(a)) {
        "<<dirList[a]>>";
        count++;
        if (totalExits > 2 && count < totalExits)
          ", ";
        if (count == totalExits - 1)
          " and ";
      }
    }
    ". ";
  }
  // we always move in circles from and back to this room
  isCircularPassage = true
  // Don't remember circular passages, though. This would make the 
  // EXITS command confused, since all exits are circular.
  rememberCircularPassage = nil
  // note traversal to/from this room
  enteringRoom(traveler) {
    local dir, newRoom;
    // get the direction of travel.
    if (gAction && gAction.getDirection() && 
        gAction.getDirection().ofKind(CompassDirection))
      dir = gAction.getDirection();
    else if (gAction && gAction.parentAction 
             && gAction.parentAction.getDirection()
             && gAction.parentAction.getDirection().ofKind(CompassDirection))
      dir = gAction.parentAction.getDirection();
    if (dir) {
      // convert the direction to a clockwise index
      dir = dir.clockwiseOrder;
      // find the room that we're going to
      newRoom = roomList[curRoom][dir + 1];
      // remember that we have traversed this connection
      if (!connVisited(curRoom, newRoom))
        usedConnections.append([curRoom, newRoom]);
      // change into the new room
      curRoom = newRoom;
    }
    // Move out any unwanted statues/signs and put the 
    // appropriate objects in.
    changeMazeObjects;
    // If lettersSpelled is at its maximum length, then
    // remove the first letter of it before continuing,
    // to make sure it doesn't exceed the maximum length.
    if (lettersSpelled.length == maxLetters)
      lettersSpelled = lettersSpelled.substr(2);
    // Add the current letter to the end of the lettersSpelled
    // string.
    lettersSpelled = lettersSpelled + curLetterStr;
    // if bmDaemon hasn't been started by this time, start it now
    bmDaemon.startDaemon();
    // update the banner
    nbmBanner.updateMe();
//    // $$$ see if we have solved the maze
//    if (lettersSpelled.endsWith(solution))
//      "This is the winning move!<.p>";
  }
  // Update the maze for cases where you walk
  // from one pseudo-room to another. This requires that
  // the proper statue is in place, and as well as any
  // signs, or anything else where different objects
  // need to be present in one room rather than another.
  changeMazeObjects {
    // adjust statues
    if (curStatue != curLetter.asscStatue) {
      if (curStatue) {
        curStatue.moveInto(nil);
        curStatue = nil;
      }
      curLetter.asscStatue.moveInto(self);
      curStatue = curLetter.asscStatue;
    }
    // adjust signs
    // For the first room of the first book maze, move in the book sign
    if (self == tolstoyMaze && curRoom == 1) {
      if (curSign) curSign.moveInto(nil);
      bookSign.moveInto(self);
      curSign = bookSign;
    }
    // For the first room of the first movie maze, move in the movie sign
    else if (self == starwarsMaze && curRoom == 1) {
      if (curSign) curSign.moveInto(nil);
      movieSign.moveInto(self);
      curSign = movieSign;
    }
    // Otherwise, get rid of any and all signs
    else if (curSign) {
      curSign.moveInto(nil);
      curSign = nil;
    }
    // Move any MazePortable objects into or out of the room.
    for (local cur = firstObj(MazePortable); cur != nil;
         cur = nextObj(cur, MazePortable)) {
      // If the given MazePortable object is in this room when it's
      // no longer supposed to be, then get rid of it.
      if (cur.isIn(self) && !cur.isIn(gPlayerChar) &&
          cur.mazeRoomNumber != curRoom) {
        cur.baseMoveInto(nil);
      }
      // If the MazePortable object is not currently in the room
      // when it should be, then move it in.
      else if (!cur.isIn(self) && cur.mazeLocation && 
          (cur.mazeLocation == self || cur.mazeLocation.isIn(self)) && 
          cur.mazeRoomNumber == curRoom) {
        cur.baseMoveInto(cur.mazeLocation);
      }
    }
  }
  // the current room's one and only statue
  curStatue = nil
  // the current room's one and only sign
  curSign = nil
//  // do some special initialization
//  initializeThing() {
//    // fetch the length of the solution
//    local len = solution.length;
//    // Create a vector to hold the letters that the player has so 
//    // far spelled by moving through the maze. Fill it with nil
//    // values.
//    lettersSpelled = new Vector(len, len);
//    // the player starts out in room number 1, so add that to the 
//    // end of the vector
//    lettersSpelled[len] = roomList[1][1].letterStr;
//    // carry on as usual
//    inherited();
//  }
  // have we visited a given room?
  roomVisited(room) {
    // a special case: room number 1 is always visited, since that 
    // is where we start out
    if (room == 1)
      return true;
    // go through the list of connections that we have traversed, 
    // since we know that the room has been visited if we have 
    // either left it our entered it at some point
    return (usedConnections.indexWhich(
      { x: x[1] == room || x[2] == room }) != nil);
  }
  // have we used a given connection?
  connVisited(room1, room2) {
    // look for a traversal either from room1 to room2 or in the 
    // opposite direction
    return (usedConnections.indexWhich(
      { x: (x[1] == room1 && x[2] == room2)
           || (x[1] == room2 && x[2] == room1) }) != nil);
  }
  roomMapState(ltid) { // ltid = letter ID, e.g. letterA or letterT1
    if (roomList[curRoom][1] == ltid)
      return 2;
    if (roomList[1][1] == ltid)
      return 1;
    if (usedConnections.indexWhich(
        { x: roomList[x[1]][1] == ltid || roomList[x[2]][1] == ltid }
        ) != nil)
      return 1;
    else
      return 0;
  }
  connMapState(ltid1, ltid2) {
    // look for a traversal either from room1 to room2 or in the 
    // opposite direction
    if (usedConnections.indexWhich(
        { x: (roomList[x[1]][1] == ltid1 && roomList[x[2]][1] == ltid2)
        || (roomList[x[1]][1] == ltid2 && roomList[x[2]][1] == ltid1) }) != nil)
      return 'x';
    else
      return '&#45;';
  }
  // A vector of connections that we have traversed. Each entry is a 
  // tuplet giving the indices of the origin and the destination.
  usedConnections = perInstance(new Vector(23))
  // the letters that the player has spelled thus far
  lettersSpelled = ''
  maxLetters = 32
  xyzzyString = nil
  xyzzyIsKnown = nil
  roomBeforeAction() { 
    if(gActionIs(Xyzzy) && xyzzyString) { 
      lettersSpelled = lettersSpelled + xyzzyString;
      if (lettersSpelled.length > maxLetters)
        lettersSpelled = lettersSpelled.substr(lettersSpelled.length - maxLetters + 1);
      xyzzyIsKnown = true;
      "A hollow voice says, <.q>Done.<./q> ";
      "<p>Suddenly the panel on the wall changes. It now reads,
        <.q><<lettersSpelled>>.<./q> ";
      if (xyzzyString && xyzzyIsKnown)
        "Below that, it reads, <.q>XYZZY = <.s><<xyzzyString>><./s>.<./q> ";
      else if (xyzzyString)
        "Below that, it reads, <.q>MAGIC WORD XYZZY.<./q> ";
      nbmBanner.updateMe;
      exit; 
    }     
  }
  // amend
  resetThisMaze {
    // Make it so the current room is the first room.
    curRoom = 1;
    // Make it so no rooms or connectors in this maze have been
    // visited
    // 
    // This implementation has not been tested!
    self.usedConnections = new Vector(23);
    // Set it so the "xyzzy" of this maze is unknown
    xyzzyIsKnown = nil;
    // Reset bookMovieString
    lettersSpelled = '';
    // Reset the specificHintState for this particular maze
    specificHintState = 0;
    // ... And for the mazes in general, just in case this is 
    // part of the Tolstoy or Starwars mazes.
    glob.bookHintState = 0;
    glob.movieHintState = 0;
    // ... And reset the information we've stored about whether
    // to clue people in to what XYZZY does.
    glob.xyzzyBookHintState = 0;
    glob.xyzzyMovieHintState = 0;
    // restore location of MazePortable objects to where they were
    // at the beginning of this particular maze. As far as I can tell,
    // if an item is located in this particular room, then the PC must
    // necessarily have been holding it when she entered this room,
    // so move it back to the PC.
    for (local cur = firstObj(MazePortable); cur != nil;
         cur = nextObj(cur, MazePortable)) {
      if (!cur.isIn(gPlayerChar) && cur.mazeLocation == self) {
        cur.moveInto(gPlayerChar);
      }
    }
  }
  // amend
  giveHint {
    glob.(generalHintProp)++;
    if ((gPlayerChar.getOutermostRoom == tolstoyMaze || 
         gPlayerChar.getOutermostRoom == starwarsMaze)
        && glob.(generalHintProp) < 5) {
      switch (glob.(generalHintProp)) {
        case 1:
          "Sheila says, <.q>Well, the sign at the beginning of this
            maze says, <.s>Can you find all the
            <<ofKind(MovieMaze) ? 'movies' : 'books'>>?<./s> 
            Apparently that is our goal here, in one way
            or another.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 5))
            glob.(potentialScoreProp) = glob.(initialPsp) - 5;
          break;
        case 2:
          "Sheila says, <.q>The panels on the walls are interesting.
            The letters on them change depending on what rooms 
            I<./s>ve visited. Surely that must be significant
            somehow.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 10))
            glob.(potentialScoreProp) = glob.(initialPsp) - 10;
          break;
        case 3:
          "Sheila says, <.q>The goal of this maze is to travel 
            through its rooms in such a way as to spell out 
            the title of a <<ofKind(MovieMaze) ? 'movie' : 'book'>> 
            on the panel. Don<./s>t forget, you can always 
            type RESET to go back to the beginning of the maze 
            and clear out the letters on the panels.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 15))
            glob.(potentialScoreProp) = glob.(initialPsp) - 15;
          break;
        case 4:
          "Sheila says, <.q>Here<./s>s one more hint: to spell
            the proper title, you<./s>ll need to visit all the rooms
            and go through all the passageways at least once.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 20))
            glob.(potentialScoreProp) = glob.(initialPsp) - 20;
          break;
      }
    }
    else if ((gPlayerChar.getOutermostRoom == nightsMaze || 
         gPlayerChar.getOutermostRoom == cuckooMaze)
        && glob.(xyzzyHintProp) < 2) {
      glob.(xyzzyHintProp)++;
      switch (glob.(xyzzyHintProp)) {
        case 1:
          "Sheila says, <.q>This room has one additional wrinkle.
            As you can see, the panel says, ";
          if (!gPlayerChar.getOutermostRoom.xyzzyIsKnown)
            "<.s>MAGIC WORD XYZZY.<./s> 
              You should definitely take note of what happens 
              when you type XYZZY.<./q> ";
          else
            "<.s>XYZZY = <.q><<xyzzyString>><./q>.<./s> 
              That is, when you type XYZZY, the letters 
              <.s><<xyzzyString>><./s> are added to the panel. 
              That is significant.<./q> ";
          glob.(potentialScoreProp) = glob.(potentialScoreProp) - 10;
          if (glob.(potentialScoreProp) < 0) glob.(potentialScoreProp) = 0;
          break;
        case 2:
          "Sheila says, <.q>So, in case you hadn<./s>t already 
            figured this out, you will not only have to 
            travel to various rooms in this maze, 
            but you will also have to type XYZZY at various times, 
            in order to spell the correct title.<./q> ";
          break;
      }
    }
    else {
      specificHintState++;
      switch (specificHintState) {
        case 1:
          "Sheila says, <.q>Okay, here<./s>s a hint. ";
          if (ofKind(BookMaze))
            "The book in question is <<bmSpecificHint1>>.";
          else
            "<<bmSpecificHint1>>";
          "<./q> ";
          glob.(potentialScoreProp) = glob.(potentialScoreProp) - 5;
          if (glob.(potentialScoreProp) < 0) glob.(potentialScoreProp) = 0;
          break;
        case 2:
          "Sheila says, <.q>Okay, here<./s>s another hint.
            <<bmSpecificHint2>><./q> ";
          break;
        case 3:
          "Sheila says, <.q>All I can do now is tell you the complete solution
            for this particular maze. Is that what you want?<./q> ";
          if (!sayYesOrNo()) {
            "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
            specificHintState--;
          }
          else {
            // In this first instance of giving the complete solution
            // to this particular maze, decrease the player's score accordingly.
            giveCompleteSolution();
            glob.(potentialScoreProp) = glob.(potentialScoreProp) - 10;
            if (glob.(potentialScoreProp) < 0) glob.(potentialScoreProp) = 0;
          }
          break;
        default:
          // Do not decrease the player's score when giving him 
          // complete solutions he's already seen before.
          giveCompleteSolution();
          break;
      }
    }
  }
  // amend
  giveCompleteSolution {
    "<.q>Okay, here<./s>s the solution,<./q> says Sheila. <.q>\^";
    "The <<ofKind(BookMaze) ? 'book' : 'movie'>> in question is
      <i><<workTitle>>.</i> \^";
    //if (lettersSpelled.length > 1)
    //  "Clear out the panels by typing RESET, then ";
    "walk around to the various rooms to spell the title.";
    // It might be overkill to give too many reminders that
    // aren't strictly necessary, so say at most one of the 
    // following two things.
    if (xyzzyString)
      " And remember, you<./s>ll have to type XYZZY 
        to add the letters <.s><<xyzzyString>><./s> as needed.";
    else if (lettersSpelled.length > 1)
      " If you want, you can type RESET beforehand to clear 
        out the panels first, though that is not necessary.";
    "<./q> ";
  }
  // specificHintState = 
  // how many times the player has requested a hint for this maze
  // *and gotten a hint that specifically pertains to this particular 
  // maze*.
  specificHintState = 0
  // This is a totally useless property. I include it only
  // for the sake of consistency with my old, outdated code
  // which presently I don't feel like changing.
  firstRoomInThisMaze = self
  // return self if we can move in a given direction (1 for north, 2 
  // for northeast, etc.), or nil otherwise
  getDestFor(dir) {
    if (roomList[curRoom][dir + 1] != nil)
      return self;
    else
      return nil;
  }
  // route all directional properties through getDestFor()
  north     = getDestFor(1)
  northeast = getDestFor(2)
  east      = getDestFor(3)
  southeast = getDestFor(4)
  south     = getDestFor(5)
  southwest = getDestFor(6)
  west      = getDestFor(7)
  northwest = getDestFor(8)
;
class BookMaze: BookMovieMaze
  firstRoomInThisMazeSet = tolstoyMaze
  holeSound = 'the sound of book pages turning'
  resetThisMazeSet {
    tolstoyMaze   .resetThisMaze;
    hawthorneMaze .resetThisMaze;
    dumasMaze     .resetThisMaze;
    dickensMaze   .resetThisMaze;
    defoeMaze     .resetThisMaze;
    austenMaze    .resetThisMaze;
    carrollMaze   .resetThisMaze;
    dostoevskyMaze.resetThisMaze;
    chaucerMaze   .resetThisMaze;
    proustMaze    .resetThisMaze;
    twainMaze     .resetThisMaze;
    nightsMaze    .resetThisMaze;
    marquezMaze   .resetThisMaze;
    bmDaemon.endDaemon;
    inherited();
  }
  // amend : un-comment-out these as needed
  generalHintProp = &bookHintState
  xyzzyHintProp = &xyzzyBookHintState
  potentialScoreProp = &potentialScoreBooks
  initialPsp = &initialPotentialScoreBooks
;
class MovieMaze: BookMovieMaze
  firstRoomInThisMazeSet = starwarsMaze
  holeSound = 'the sound of a projector<./s>s reels turning'
  resetThisMazeSet {
    starwarsMaze  .resetThisMaze;
    casablancaMaze.resetThisMaze;
    planetMaze    .resetThisMaze;
    lawrenceMaze  .resetThisMaze;
    savingMaze    .resetThisMaze;
    untouchMaze   .resetThisMaze;
    silenceMaze   .resetThisMaze;
    bridgeMaze    .resetThisMaze;
    manchurianMaze.resetThisMaze;
    shawshankMaze .resetThisMaze;
    valanceMaze   .resetThisMaze;
    cuckooMaze    .resetThisMaze;
    crouchingMaze .resetThisMaze;
    bmDaemon.endDaemon;
    inherited();
  }
  // amend : un-comment-out these as needed
  generalHintProp = &movieHintState
  xyzzyHintProp = &xyzzyMovieHintState
  potentialScoreProp = &potentialScoreMovies
  initialPsp = &initialPotentialScoreMovies
;

// A helpful modification to the 8 compass directions.

modify northDirection     clockwiseOrder =  1;
modify northeastDirection clockwiseOrder =  2;
modify eastDirection      clockwiseOrder =  3;
modify southeastDirection clockwiseOrder =  4;
modify southDirection     clockwiseOrder =  5;
modify southwestDirection clockwiseOrder =  6;
modify westDirection      clockwiseOrder =  7;
modify northwestDirection clockwiseOrder =  8;
modify upDirection        clockwiseOrder =  9;
modify downDirection      clockwiseOrder = 10;

// -------------------------------------------------------------------
// THE PANEL
// -------------------------------------------------------------------

bmPanel: MultiLoc, Fixture
  '(blue) panel/display/lights/screen'
  'panel'
  initialLocationClass = BookMovieMaze
  desc {
    "The panel is set into the wall, a little lower than Sheila<./s>s 
      eye level. In blue lights, it reads, 
      <.q><<gPlayerChar.location.lettersSpelled>>.<./q> ";
    if (gPlayerChar.location.xyzzyString &&
        gPlayerChar.location.xyzzyIsKnown)
      "Below that, it reads, <.q>XYZZY = 
        <.s><<gPlayerChar.location.xyzzyString>><./s>.<./q> ";
    else if (gPlayerChar.location.xyzzyString)
      "Below that, it reads, <.q>MAGIC WORD: XYZZY.<./q> ";
  }
;

// -------------------------------------------------------------------
// THE SIGNS
// -------------------------------------------------------------------

bookSign: Readable, Fixture
  '(tourist) engraved metal pole/sign/marker' 'sign'
  @nil
  specialDesc = "There is a sign standing here. "
  desc =
    "A slender metal pole, embedded in the floor, rises and widens
        to form a handsome sign. In engraved letters it reads:
      <p><.q>The bards of Earth greet thee! On ancient Earth, 
        as on ancient Oo, people wrote books. But whereas we Oo 
        have long since outgrown books as an art form, 
        the inhabitants of Earth kept on writing novels, poems, and so on, 
        even after the advent of interactive fiction. 
        Here, then, is a tribute to a quaint 
        pastime -- a maze devoted to the literature of ancient Earth! 
        Can you find all the books?
      <p><.q>Note: When you started this game, the VR infusion process 
        should have given you knowledge of Earth books. You will 
        need this knowledge to complete the maze. Good luck!<./q> "
;

movieSign: Readable, Fixture
  '(tourist) engraved metal pole/sign/marker' 'sign'
  @nil
  specialDesc = "There is a sign standing here. "
  desc =
    "A slender metal pole, embedded in the floor, rises and widens
        to form a handsome sign. In engraved letters it reads:
      <p><.q><.s>Hello, sailor!<./s> -- <i>The Muppet Movie</i> (1979)
      <p><.q>Movies were a very popular form of art on Earth, 
        even more popular than interactive fiction. 
        Although nowadays we tend to watch few Earth movie scenes 
        except for that one in <i>Big</i> where the kid is playing 
        a text adventure, Earth movies went far beyond that. 
        Accordingly, here is a tribute to the movies of ancient Earth! 
        Can you find all of them?
      <p><.q>Note: When you started this game, the VR infusion process 
        should have given you knowledge of Earth movies. You will 
        need this knowledge to complete the maze. Good luck!<./q> "
;

// -------------------------------------------------------------------
// STATUES
// -------------------------------------------------------------------

// I would have just used one MultiLoc for all the statues, but I 
// can't do it that way because I need to vary the vocabulary
// rather wildly for the various statues.

class BmStatue: Fixture
  name = (materialAdj + ' statue')
  //asscRoomClass = initialLocationClass
  specialDesc = ""
  materialNoun = ''
  materialAdj = materialNoun
  aMaterialAdj = aNameFrom(materialAdj)
  anAsscLetter = ('a ' + asscLetter)
;

bmStatueA: BmStatue
  vocabWords = 'a aluminum aluminium acute amazing attractive metal letter angle/statue/sculpture/artifact'
  desc = "The aluminum A ascends in an acute angle, an amazing and attractive artifact. "
  asscLetter = 'A' anAsscLetter=('an '+asscLetter)
  materialNoun = 'aluminum'
  //initialLocationClass = BmLetterRoomA
;
bmStatueB: BmStatue
  vocabWords = 'b bronze big metal alloy letter statue/sculpture/artifact'
  desc = "Before your bot, the big bronze B bends up several feet into the air. "
  asscLetter = 'B'
  materialNoun = 'bronze'
  //initialLocationClass = BmLetterRoomB
;
bmStatueC: BmStatue
  vocabWords = 'c concrete cement colossal curvy letter character curve/statue/sculpture/artifact'
  desc = "The concrete character circles towards the ceiling in a curve, creating a colossal C. "
  asscLetter = 'C'
  materialNoun = 'concrete'
  //initialLocationClass = BmLetterRoomC
;
bmStatueD: BmStatue
  vocabWords = 'd diamond dazzling letter stone rock gem/gemstone/statue/sculpture/artifact'
  desc = "Dumbfounded, your bot discerns the D. Decked with diamonds, it is downright dazzling. "
  asscLetter = 'D'
  materialNoun = 'diamond'
  //initialLocationClass = BmLetterRoomD
;
bmStatueE: BmStatue
  vocabWords = 'e emerald extraordinary enormous letter stone rock gem/gemstone/statue/sculpture/artifact'
  desc = "Enthralled, Sheila eyes the extraordinary E. The enormous statue is entirely encrusted with emeralds. "
  asscLetter = 'E' anAsscLetter=('an '+asscLetter)
  materialNoun = 'emerald'
  //initialLocationClass = BmLetterRoomE
;
bmStatueF: BmStatue
  vocabWords = 'f flint stone rock letter statue/sculpture/artifact'
  desc = "The F, fantastically formed from flint, flies far above your bot<./s>s head. "
  asscLetter = 'F' anAsscLetter=('an '+asscLetter)
  materialNoun = 'flint'
  //initialLocationClass = BmLetterRoomF
;
bmStatueG: BmStatue
  vocabWords = 'g glass genuine giant gleaming glassware gargantuan letter statue/sculpture/artifact'
  desc = "A genuine giant of gleaming glassware, this gargantuan G glimmers gracefully in the light. "
  asscLetter = 'G'
  materialNoun = 'glass'
  //initialLocationClass = BmLetterRoomG
;
bmStatueH: BmStatue
  vocabWords = 'h hematite huge high metal letter statue/sculpture/artifact'
  desc = "The huge H, hewn from hematite, hangs high overhead. "
  asscLetter = 'H' anAsscLetter=('an '+asscLetter)
  materialNoun = 'hematite'
  //initialLocationClass = BmLetterRoomH
;
bmStatueI: BmStatue
  vocabWords = 'i iron incredibly incredible immense metal letter ingot/statue/sculpture/artifact'
  desc = "The I is an incredibly immense ingot of iron. "
  asscLetter = 'I' anAsscLetter=('an '+asscLetter)
  materialNoun = 'iron'
  //initialLocationClass = BmLetterRoomI
;
bmStatueJ: BmStatue
  vocabWords = 'j jade jumbo jumbo-size jumbo-sized solid stone rock letter block/jewel/statue/sculpture/artifact'
  desc = "The jumbo-sized J juts several feet into the air, sparkling like a jewel. Sheila drops her jaw, for it is a solid block of jade. "
  asscLetter = 'J'
  materialNoun = 'jade'
  //initialLocationClass = BmLetterRoomJ
;
bmStatueK: BmStatue
  vocabWords = 'k kimberlite king (size) (sized) king-size king-sized colossal stone rock letter colossus/statue/sculpture/artifact'
  desc = "The kimberlite K rises above, a king-size colossus, keenly shining. "
  asscLetter = 'K'
  materialNoun = 'kimberlite'
  //initialLocationClass = BmLetterRoomK
;
bmStatueL: BmStatue
  vocabWords = 'l limestone large stone rock letter landmark/statue/sculpture/artifact'
  desc = "The letter L looms above, a large limestone landmark. "
  asscLetter = 'L' anAsscLetter=('an '+asscLetter)
  materialNoun = 'limestone'
  //initialLocationClass = BmLetterRoomL
;
bmStatueM: BmStatue
  vocabWords = 'm marble mammoth massive stone rock letter mountain/mountains/monolith/statue/sculpture/artifact'
  desc = "The M is a mammoth monolith of marble, molded in the shape of two massive mountains. "
  asscLetter = 'M' anAsscLetter=('an '+asscLetter)
  materialNoun = 'marble'
  //initialLocationClass = BmLetterRoomM
;
bmStatueN: BmStatue
  vocabWords = 'n nickel enormous metal letter nugget/statue/sculpture/artifact'
  desc = "No, this N is not just a normal statue, for it is an enormous nugget of nickel. "
  asscLetter = 'N' anAsscLetter=('an '+asscLetter)
  materialNoun = 'nickel'
  //initialLocationClass = BmLetterRoomN
;
bmStatueO: BmStatue
  vocabWords = 'o obsidian oversize outsize oversized outsized stone rock letter oval/statue/sculpture/artifact'
  desc = "The O looms high overhead, an oversized oval of obsidian. "
  asscLetter = 'O' anAsscLetter=('an '+asscLetter)
  materialNoun = 'obsidian'
  //initialLocationClass = BmLetterRoomO
;
bmStatueP: BmStatue
  vocabWords = 'p plastic proud prodigious letter pillar/statue/sculpture/artifact'
  desc = "The proud P looms above, a prodigious pillar of plastic. "
  asscLetter = 'P'
  materialNoun = 'plastic'
  //initialLocationClass = BmLetterRoomP
;
bmStatueQ: BmStatue // will never be used
  vocabWords = 'q quartz quality letter statue/sculpture/artifact'
  desc = "A quality statue is here, crafted of quartz. "
  asscLetter = 'Q'
  materialNoun = 'quartz'
  //initialLocationClass = BmLetterRoomQ
;
bmStatueR: BmStatue
  vocabWords = 'r rare resilient rubber latex letter relic/statue/sculpture/artifact'
  desc = "The R, a rare relic of resilient rubber, rises high into the air. "
  asscLetter = 'R' anAsscLetter=('an '+asscLetter)
  materialNoun = 'rubber'
  //initialLocationClass = BmLetterRoomR
;
bmStatueS: BmStatue
  vocabWords = 's silver sizeable sloping sinuous spectacular metal letter sight/shape/statue/sculpture/artifact'
  desc = "The sizeable silver statue soars above Sheila, sloping in the shape of a sinuous S. Sheila stares, shocked by the spectacular sight. "
  asscLetter = 'S' anAsscLetter=('an '+asscLetter)
  materialNoun = 'silver'
  //initialLocationClass = BmLetterRoomS
;
bmStatueT: BmStatue
  vocabWords = 't titanium tremendous tall metal letter tribute/statue/sculpture/artifact'
  desc = "The tremendous T towers above, a tall titanium tribute. "
  asscLetter = 'T'
  materialNoun = 'titanium'
  //initialLocationClass = BmLetterRoomT
;
bmStatueU: BmStatue
  vocabWords = 'u uranium unique unalloyed unstable metal letter statue/sculpture/artifact'
  desc = "The U soars up and up, a unique artifact of unalloyed uranium. Underneath it, Sheila says, <.q>Uh oh. Uranium is unstable. Unless I up and leave, it could be my undoing.<./q> "
  asscLetter = 'U'
  materialNoun = 'uranium' aMaterialAdj = 'a uranium'
  //initialLocationClass = BmLetterRoomU
;
bmStatueV: BmStatue
  vocabWords = 'v vanadium vertical very letter metal piece/pieces/vision/statue/sculpture/artifact'
  desc = "The V vaults upward as two vertical pieces of metal. To the vigilant observer, this is the very vision of vanadium. "
  asscLetter = 'V'
  materialNoun = 'vanadium'
  //initialLocationClass = BmLetterRoomV
;
bmStatueW: BmStatue
  vocabWords = 'w wood wooden woodwork work whopping letter statue/sculpture/artifact'
  desc = "The W is a whopping piece of woodwork, which wends its way upwards. "
  asscLetter = 'W'
  materialNoun = 'wood' materialAdj = 'wooden'
  //initialLocationClass = BmLetterRoomW
;
bmStatueX: BmStatue // will never be used
  vocabWords = 'x xenite metal ore letter statue/sculpture/artifact'
  desc = "This is a statue in the shape of an X. It is made of xenite. "
  asscLetter = 'X' anAsscLetter=('an '+asscLetter)
  materialNoun = 'xenite'
  //initialLocationClass = BmLetterRoomX
;
bmStatueY: BmStatue
  vocabWords = 'y yttrium metal letter statue/sculpture/artifact'
  desc = "Yes, the yttrium Y rises a couple of yards above your bot. "
  asscLetter = 'Y'
  materialNoun = 'yttrium'
  //initialLocationClass = BmLetterRoomY
;
bmStatueZ: BmStatue
  vocabWords = 'z zirconium zig zag zig-zag metal letter shape/statue/sculpture/artifact'
  desc = "The zirconium Z zooms up high in the shape of a large zig-zag. "
  asscLetter = 'Z'
  materialNoun = 'zirconium'
  //initialLocationClass = BmLetterRoomZ
;

// -------------------------------------------------------------------
// LETTERS
// -------------------------------------------------------------------

class Letter: object;
letterA: Letter letterStr = 'A' asscStatue = bmStatueA;
letterB: Letter letterStr = 'B' asscStatue = bmStatueB;
letterC: Letter letterStr = 'C' asscStatue = bmStatueC;
letterD: Letter letterStr = 'D' asscStatue = bmStatueD;
letterE: Letter letterStr = 'E' asscStatue = bmStatueE;
letterF: Letter letterStr = 'F' asscStatue = bmStatueF;
letterG: Letter letterStr = 'G' asscStatue = bmStatueG;
letterH: Letter letterStr = 'H' asscStatue = bmStatueH;
letterI: Letter letterStr = 'I' asscStatue = bmStatueI;
letterJ: Letter letterStr = 'J' asscStatue = bmStatueJ;
letterK: Letter letterStr = 'K' asscStatue = bmStatueK;
letterL: Letter letterStr = 'L' asscStatue = bmStatueL;
letterM: Letter letterStr = 'M' asscStatue = bmStatueM;
letterN: Letter letterStr = 'N' asscStatue = bmStatueN;
letterO: Letter letterStr = 'O' asscStatue = bmStatueO;
letterP: Letter letterStr = 'P' asscStatue = bmStatueP;
letterQ: Letter letterStr = 'Q' asscStatue = bmStatueQ;
letterR: Letter letterStr = 'R' asscStatue = bmStatueR;
letterS: Letter letterStr = 'S' asscStatue = bmStatueS;
letterT: Letter letterStr = 'T' asscStatue = bmStatueT;
letterU: Letter letterStr = 'U' asscStatue = bmStatueU;
letterV: Letter letterStr = 'V' asscStatue = bmStatueV;
letterW: Letter letterStr = 'W' asscStatue = bmStatueW;
letterX: Letter letterStr = 'X' asscStatue = bmStatueX;
letterY: Letter letterStr = 'Y' asscStatue = bmStatueY;
letterZ: Letter letterStr = 'Z' asscStatue = bmStatueZ;
letterT1: letterT;
letterT2: letterT;
letterE1: letterE;
letterE2: letterE;
letterO1: letterO;
letterO2: letterO;
letterS1: letterS;
letterS2: letterS;
letterD1: letterD;
letterD2: letterD;

// -------------------------------------------------------------------
// ROOMS
// -------------------------------------------------------------------

tolstoyMaze: BookMaze
  roomList = [     
    [letterW , nil, nil, nil, nil, nil, nil, nil, 2  ],
    [letterA , nil, 8  , 3  , 1  , 4  , nil, nil, 7  ],
    [letterR , nil, nil, nil, nil, nil, nil, 2  , nil],
    [letterN , 2  , nil, nil, nil, nil, nil, 5  , nil],
    [letterD , 6  , nil, 4  , nil, nil, nil, nil, nil],
    [letterP , 7  , nil, nil, nil, 5  , nil, nil, nil],
    [letterE , nil, nil, 8  , 2  , 6  , nil, nil, nil],
    [letterC , nil, nil, nil, nil, nil, 2  , 7  , nil]
  ]
;
hawthorneMaze: BookMaze
  roomList = [   
    [letterT1, nil, nil, nil, nil, 2  , 3  , 9  , nil],
    [letterH , 1  , nil, nil, nil, nil, nil, 3  , nil],
    [letterE , 9  , 1  , 2  , 4  , nil, nil, 7  , 8  ],
    [letterS , nil, nil, nil, nil, nil, nil, 5  , 3  ],
    [letterC , nil, nil, 4  , nil, nil, nil, 6  , nil],
    [letterA , 7  , nil, 5  , nil, nil, nil, nil, nil],
    [letterR , 8  , nil, 3  , nil, 6  , nil, nil, nil],
    [letterL , nil, nil, 9  , 3  , 7  , nil, nil, nil],
    [letterT2, nil, nil, 1  , nil, 3  , nil, 8  , nil]
  ]
;
dumasMaze: BookMaze
  roomList = [       
    [letterT , 2  , 3  , 5  , nil, nil, nil, nil, nil],
    [letterH , 4  , nil, 3  , nil, 1  , nil, nil, nil],
    [letterE1, nil, 9  , nil, nil, 5  , 1  , 2  , 4  ],
    [letterR , nil, nil, 8  , 3  , 2  , nil, nil, nil],
    [letterE2, 3  , nil, 6  , nil, nil, nil, 1  , nil],
    [letterM , 7  , nil, nil, nil, nil, nil, 5  , nil],
    [letterU , nil, nil, nil, nil, 6  , nil, nil, 8  ],
    [letterS , nil, nil, 9  , 7  , nil, nil, 4  , nil],
    [letterK , nil, nil, nil, nil, nil, 3  , 8  , nil]
  ]
;
dickensMaze: BookMaze
  roomList = [     
    [letterA , 2  , nil, 3  , nil, nil, nil, nil, nil],
    [letterT , 6  , 7  , 9  , nil, 1  , nil, nil, nil],
    [letterL , 4  , nil, nil, nil, nil, nil, 1  , nil],
    [letterE , 10 , nil, nil, nil, 3  , 9  , nil, 5  ],
    [letterO , nil, nil, nil, 4  , 8  , 7  , 6  , nil],
    [letterF , nil, nil, 5  , nil, 2  , nil, nil, nil],
    [letterW , nil, 5  , nil, nil, nil, 2  , nil, nil],
    [letterC , 5  , nil, nil, nil, 9  , nil, nil, nil],
    [letterI , 8  , 4  , nil, nil, nil, nil, 2  , nil],
    [letterS , nil, nil, nil, nil, 4  , nil, nil, nil]
  ]
;
defoeMaze: BookMaze
  roomList = [
    [letterR , nil, nil, 2  , 8  , 7  , nil, nil, nil],
    [letterO , nil, nil, 9  , 3  , 5  , 6  , 1  , nil],
    [letterB , nil, nil, nil, 4  , nil, nil, nil, 2  ],
    [letterI , nil, nil, nil, nil, nil, nil, 5  , 3  ],
    [letterN , 2  , nil, 4  , nil, nil, nil, 7  , 6  ],
    [letterS , nil, 2  , nil, 5  , nil, nil, 8  , nil],
    [letterC , 1  , nil, 5  , nil, nil, nil, nil, nil],
    [letterU , nil, nil, 6  , nil, nil, nil, nil, 1  ],
    [letterE , nil, nil, nil, nil, nil, nil, 2  , nil]
  ]
;
austenMaze: BookMaze
  roomList = [      
    [letterP , nil, nil, nil, nil, 4  , nil, 2  , nil],
    [letterR , nil, nil, 1  , 3  , 5  , nil, nil, nil],
    [letterI , nil, nil, nil, 4  , nil, 10 , nil, 2  ],
    [letterD , 1  , nil, nil, nil, 7  , 9  , 5  , 3  ],
    [letterE , 2  , 10 , 4  , 8  , 6  , nil, nil, nil],
    [letterA , 5  , nil, 7  , nil, nil, nil, nil, nil],
    [letterN , 4  , nil, nil, nil, nil, nil, 6  , nil],
    [letterJ , nil, nil, 9  , nil, nil, nil, nil, 5  ],
    [letterU , nil, 4  , nil, nil, nil, nil, 8  , nil],
    [letterC , nil, 3  , nil, nil, nil, 5  , nil, nil]
  ]
;
carrollMaze: BookMaze
  roomList = [
    [letterA , 2  , nil, nil, nil, nil, nil, nil, 6  ],
    [letterL , nil, nil, nil, nil, 1  , 3  , 10 , nil],
    [letterI , nil, 2  , nil, nil, 6  , 4  , 5  , nil],
    [letterC , nil, 3  , nil, nil, nil, nil, nil, 5  ],
    [letterE , 10 , nil, 3  , 4  , 9  , nil, nil, nil],
    [letterN , 3  , nil, nil, 1  , 8  , 7  , 9  , nil],
    [letterW , nil, 6  , 8  , nil, nil, nil, nil, nil],
    [letterO , 6  , nil, nil, nil, nil, nil, 7  , nil],
    [letterD , 5  , nil, 6  , nil, nil, nil, nil, nil],
    [letterR , nil, nil, 2  , nil, 5  , nil, nil, nil]
  ]
;
dostoevskyMaze: BookMaze
  roomList = [
    [letterT , nil, nil, nil, nil, 2  , nil, 6  , nil],
    [letterH , 1  , nil, nil, nil, 3  , nil, nil, nil],
    [letterE , 2  , nil, nil, nil, nil, nil, 5  , 4  ],
    [letterB , nil, nil, nil, 3  , nil, 5  , nil, nil],
    [letterR , 6  , 4  , 3  , nil, nil, nil, 7  , 9  ],
    [letterO , nil, nil, 1  , 12 , 5  , nil, 11 , nil],
    [letterS , nil, nil, 5  , nil, nil, nil, 8  , nil],
    [letterK , nil, 9  , 7  , nil, nil, nil, nil, nil],
    [letterA , nil, nil, nil, 5  , nil, 8  , 10 , 11 ],
    [letterM , nil, nil, 9  , nil, nil, nil, nil, nil],
    [letterZ , nil, nil, 6  , 9  , nil, nil, nil, nil],
    [letterV , nil, nil, nil, nil, nil, nil, nil, 6  ]
  ]
;
chaucerMaze: BookMaze
  roomList = [
    [letterT , nil, nil, 10 , 2  , 3  , 5  , 6  , nil],
    [letterH , nil, nil, nil, nil, nil, 3  , nil, 1  ],
    [letterE , 1  , 2  , 7  , nil, 12 , 4  , 11 , nil],
    [letterC , nil, 3  , nil, nil, nil, nil, nil, 5  ],
    [letterA , 6  , 1  , 11 , 4  , nil, nil, nil, nil],
    [letterN , nil, nil, 1  , nil, 5  , nil, nil, nil],
    [letterR , 10 , nil, nil, nil, 8  , 9  , 3  , nil],
    [letterB , 7  , nil, nil, nil, nil, nil, 9  , nil],
    [letterU , nil, 7  , 8  , nil, nil, nil, nil, nil],
    [letterY , nil, nil, nil, nil, 7  , nil, 1  , nil],
    [letterL , nil, nil, 3  , nil, nil, nil, 5  , nil],
    [letterS , 3  , nil, nil, nil, nil, nil, nil, nil]
  ]
;
proustMaze: BookMaze
  roomList = [
    [letterR , 5  , nil, 2  , nil, 4  , nil, nil, nil],
    [letterE , 8  , nil, nil, nil, 3  , nil, 1  , 7  ],
    [letterM , 2  , nil, nil, nil, nil, nil, 4  , nil],
    [letterB , 1  , nil, 3  , nil, nil, nil, nil, nil],
    [letterA , 15 , 14 , nil, 6  , 1  , nil, nil, nil],
    [letterN , 13 , nil, 12 , 7  , nil, nil, nil, 5  ],
    [letterC , nil, nil, nil, 2  , nil, nil, nil, 6  ],
    [letterO , 9  , nil, nil, nil, 2  , nil, nil, nil],
    [letterF , 10 , nil, nil, nil, 8  , nil, nil, nil],
    [letterT , nil, nil, nil, nil, 9  , 11 , 14 , nil],
    [letterH , nil, 10 , nil, nil, 12 , nil, nil, nil],
    [letterI , 11 , nil, nil, nil, nil, nil, 6  , nil],
    [letterG , 14 , nil, nil, nil, 6  , nil, nil, nil],
    [letterS , nil, nil, 10 , nil, 13 , 5  , 15 , nil],
    [letterP , nil, nil, 14 , nil, 5  , nil, nil, nil]
  ]
;
twainMaze: BookMaze
  roomList = [
    [letterT , 12 , 11 , nil, 7  , 2  , 8  , nil, nil],
    [letterH , 1  , nil, 3  , nil, nil, nil, nil, nil],
    [letterE , 10 , 4  , 6  , 15 , nil, 9  , 2  , 7  ],
    [letterA , nil, nil, nil, 14 , 5  , 3  , 10 , nil],
    [letterD , 4  , nil, nil, nil, nil, nil, 6  , nil],
    [letterV , nil, nil, 5  , nil, nil, nil, 3  , nil],
    [letterN , nil, nil, nil, 3  , nil, nil, nil, 1  ],
    [letterU , nil, 1  , nil, 9  , nil, nil, nil, nil],
    [letterR , nil, 3  , nil, nil, nil, nil, nil, 8  ],
    [letterS , 13 , nil, 4  , nil, 3  , nil, nil, 11 ],
    [letterO , nil, 13 , nil, 10 , nil, 1  , nil, 12 ],
    [letterF , nil, nil, nil, 11 , 1  , nil, nil, nil],
    [letterM , nil, nil, nil, nil, 10 , 11 , nil, nil],
    [letterW , nil, nil, nil, nil, nil, 15 , nil, 4  ],
    [letterY , nil, 14 , nil, nil, nil, nil, nil, 3  ]
  ]
;
nightsMaze: BookMaze
  roomList = [
    [letterT , nil, nil, 6  , 2  , 3  , nil, nil, nil],
    [letterH , nil, nil, 4  , nil, 9  , 3  , nil, 1  ],
    [letterE , 1  , 2  , 7  , nil, nil, nil, nil, nil],
    [letterO , 5  , nil, nil, nil, 7  , nil, 2  , 6  ],
    [letterU , nil, nil, nil, nil, 4  , nil, 6  , nil],
    [letterS , nil, nil, 5  , 4  , nil, nil, 1  , nil],
    [letterN , 4  , nil, nil, nil, nil, nil, 3  , 8  ],
    [letterI , nil, nil, nil, 7  , nil, nil, 9  , nil],
    [letterG , 2  , nil, 8  , nil, nil, nil, nil, nil]
  ]
  xyzzyString = 'AND'
;
marquezMaze: BookMaze
  roomList = [
    [letterO , 2  , nil, nil, nil, nil, nil, nil, nil],
    [letterN , nil, 6  , nil, 3  , 1  , nil, nil, 5  ],
    [letterE , 6  , 8  , 7  , 9  , nil, nil, 4  , 2  ],
    [letterH , 5  , nil, 3  , nil, nil, nil, nil, nil],
    [letterU , nil, nil, 6  , 2  , 4  , nil, 13 , nil],
    [letterD , nil, nil, 8  , 7  , 3  , 2  , 5  , nil],
    [letterR , nil, nil, nil, nil, 10 , 9  , 3  , 6  ],
    [letterY , nil, nil, nil, nil, nil, 3  , 6  , nil],
    [letterA , nil, 7  , nil, nil, nil, nil, nil, 3  ],
    [letterF , 7  , nil, nil, nil, nil, nil, 11 , nil],
    [letterL , nil, nil, 10 , nil, nil, nil, 12 , nil],
    [letterI , 13 , nil, 11 , nil, nil, nil, nil, nil],
    [letterT , nil, nil, 5  , nil, 12 , nil, nil, nil]
  ]
  xyzzyString = 'SO'
;
starwarsMaze: MovieMaze
  roomList = [
    [letterS , nil, nil, nil, nil, 2  , nil, nil, 4  ],
    [letterT , 1  , nil, nil, nil, nil, nil, nil, 3  ],
    [letterA , 4  , nil, nil, 2  , nil, nil, nil, 5  ],
    [letterR , nil, nil, nil, 1  , 3  , nil, 5  , nil],
    [letterW , nil, nil, 4  , 3  , nil, nil, nil, nil]
  ]
;
casablancaMaze: MovieMaze
  roomList = [
    [letterC , nil, nil, nil, 2  , 6  , nil, nil, nil],
    [letterA , 5  , nil, 4  , 3  , nil, 6  , nil, 1  ],
    [letterS , nil, nil, nil, nil, nil, nil, nil, 2  ],
    [letterB , nil, nil, nil, nil, nil, nil, 2  , 5  ],
    [letterL , nil, nil, nil, 4  , 2  , nil, nil, nil],
    [letterN , 1  , 2  , nil, nil, nil, nil, nil, nil]
  ]
;
planetMaze: MovieMaze
  roomList = [
    [letterP , 5  , nil, nil, nil, nil, nil, 2  , 3  ],
    [letterL , 3  , nil, 1  , nil, nil, nil, nil, nil],
    [letterA , 4  , 5  , nil, 1  , 2  , nil, nil, nil],
    [letterN , nil, nil, nil, 5  , 3  , nil, nil, nil],
    [letterE , 10 , 9  , 6  , nil, 1  , 3  , nil, 4  ],
    [letterT , nil, nil, nil, nil, 7  , 8  , 5  , 9  ],
    [letterO , 6  , nil, nil, nil, nil, nil, nil, 8  ],
    [letterF , nil, 6  , nil, 7  , nil, nil, nil, nil],
    [letterH , nil, nil, nil, 6  , nil, 5  , nil, nil],
    [letterS , nil, nil, nil, nil, 5  , nil, nil, nil]
  ]
;
lawrenceMaze: MovieMaze
  roomList = [
    [letterL , 2  , nil, nil, nil, nil, nil, nil, nil],
    [letterA , 4  , 3  , 10 , 11 , 1  , 9  , nil, nil],
    [letterW , nil, nil, nil, nil, nil, 2  , nil, 4  ],
    [letterR , 5  , nil, nil, 3  , 2  , nil, nil, nil],
    [letterE , nil, nil, 7  , 6  , 4  , nil, 8  , nil],
    [letterN , 7  , nil, nil, nil, nil, nil, nil, 5  ],
    [letterC , nil, nil, nil, nil, 6  , nil, 5  , nil],
    [letterO , nil, nil, 5  , nil, 9  , nil, nil, nil],
    [letterF , 8  , 2  , nil, nil, nil, nil, nil, nil],
    [letterB , nil, nil, nil, nil, 11 , nil, 2  , nil],
    [letterI , 10 , nil, nil, nil, nil, nil, nil, 2  ]
  ]
;
savingMaze: MovieMaze
  roomList = [
    [letterS , nil, nil, nil, nil, nil, nil, nil, 2  ],
    [letterA , 3  , nil, 5  , 1  , nil, 9  , 11 , nil],
    [letterV , nil, nil, 4  , nil, 2  , nil, nil, nil],
    [letterI , nil, nil, nil, nil, 5  , nil, 3  , 8  ],
    [letterN , 4  , nil, 6  , nil, nil, nil, 2  , nil],
    [letterG , 7  , nil, nil, nil, nil, nil, 5  , nil],
    [letterP , nil, nil, nil, nil, 6  , nil, 8  , nil],
    [letterR , nil, nil, 7  , 4  , 11 , 10 , nil, nil],
    [letterT , nil, 2  , nil, nil, nil, nil, nil, 10 ],
    [letterE , nil, 8  , nil, 9  , nil, nil, nil, nil],
    [letterY , 8  , nil, 2  , nil, nil, nil, nil, nil]
  ]
;
untouchMaze: MovieMaze
  roomList = [
    [letterT , nil, nil, 6  , 5  , 2  , nil, nil, nil],
    [letterH , 1  , 7  , 3  , nil, 8  , nil, nil, nil],
    [letterE , 4  , nil, nil, nil, 10 , 11 , 2  , nil],
    [letterU , 6  , nil, nil, nil, 3  , 7  , nil, 5  ],
    [letterN , nil, nil, nil, 4  , nil, nil, nil, 1  ],
    [letterO , nil, nil, nil, nil, 4  , nil, 1  , nil],
    [letterC , nil, 4  , nil, nil, nil, 2  , nil, nil],
    [letterA , 2  , nil, 9  , nil, nil, nil, nil, nil],
    [letterB , 10 , nil, nil, nil, nil, nil, 8  , nil],
    [letterL , 3  , nil, nil, nil, 9  , nil, nil, nil],
    [letterS , nil, 3  , nil, nil, nil, nil, nil, nil]
  ]
;
silenceMaze: MovieMaze
  roomList = [
    [letterT , nil, nil, nil, nil, 10 , nil, 2  , nil],
    [letterH , nil, nil, 1  , nil, 3  , nil, nil, nil],
    [letterE , 2  , nil, 9  , 8  , 7  , nil, 4  , 6  ],
    [letterS , nil, nil, 3  , nil, 13 , nil, 5  , nil],
    [letterI , nil, 6  , 4  , nil, nil, nil, nil, nil],
    [letterL , nil, nil, nil, 3  , nil, 5  , 11 , nil],
    [letterN , 3  , nil, 8  , nil, nil, nil, nil, nil],
    [letterC , nil, nil, nil, nil, nil, nil, 7  , 3  ],
    [letterO , nil, nil, nil, 10 , nil, nil, 3  , nil],
    [letterF , 1  , nil, nil, nil, nil, nil, nil, 9  ],
    [letterA , nil, nil, 6  , nil, 12 , nil, nil, nil],
    [letterM , 11 , nil, 13 , nil, nil, nil, nil, nil],
    [letterB , 4  , nil, nil, nil, nil, nil, 12 , nil]
  ]
;
bridgeMaze: MovieMaze
  roomList = [
    [letterT , 10 , nil, nil, nil, 2  , nil, nil, nil],
    [letterH , 1  , nil, nil, nil, nil, nil, nil, 3  ],
    [letterE , 9  , nil, nil, 2  , 4  , 5  , 11 , 8  ],
    [letterB , 3  , nil, nil, nil, nil, nil, 5  , nil],
    [letterR , 6  , 3  , 4  , nil, nil, nil, 12 , nil],
    [letterI , 7  , nil, 11 , nil, 5  , nil, nil, 14 ],
    [letterD , nil, nil, 8  , nil, 6  , nil, nil, nil],
    [letterG , nil, nil, nil, 3  , nil, nil, 7  , nil],
    [letterO , nil, nil, 10 , nil, 3  , nil, nil, nil],
    [letterN , nil, nil, nil, nil, 1  , nil, 9  , nil],
    [letterV , nil, nil, 3  , nil, nil, nil, 6  , nil],
    [letterK , 13 , nil, 5  , nil, nil, nil, nil, nil],
    [letterW , 14 , nil, nil, nil, 12 , nil, nil, nil],
    [letterA , nil, nil, nil, 6  , 13 , nil, nil, nil]
  ]
;
manchurianMaze: MovieMaze
  roomList = [
    [letterT , nil, nil, 2  , nil, 3  , nil, nil, 5  ],
    [letterH , 7  , nil, nil, nil, 8  , 3  , 1  , nil],
    [letterE , 1  , 2  , nil, nil, nil, nil, nil, 4  ],
    [letterM , 5  , nil, nil, 3  , nil, nil, nil, nil],
    [letterA , 11 , 6  , 7  , 1  , 4  , nil, nil, 10 ],
    [letterN , nil, nil, nil, 7  , nil, 5  , 11 , nil],
    [letterC , nil, nil, nil, nil, 2  , nil, 5  , 6  ],
    [letterU , 2  , nil, nil, nil, nil, nil, 9  , nil],
    [letterR , 10 , nil, 8  , nil, nil, nil, nil, nil],
    [letterI , nil, nil, 11 , 5  , 9  , nil, nil, nil],
    [letterD , nil, nil, 6  , nil, 5  , nil, 10 , nil]
  ]
;
shawshankMaze: MovieMaze
  roomList = [
    [letterT , 12 , nil, nil, 2  , nil, nil, nil, 13 ],
    [letterH , nil, 3  , 4  , nil, nil, 5  , nil, 1  ],
    [letterE , 9  , nil, nil, nil, 4  , 2  , 10 , 11 ],
    [letterS , 3  , nil, nil, nil, 6  , nil, 2  , nil],
    [letterA , nil, 2  , 6  , nil, nil, nil, 7  , nil],
    [letterW , 4  , nil, nil, nil, nil, nil, 5  , nil],
    [letterN , 8  , 14 , 5  , nil, nil, nil, nil, nil],
    [letterK , nil, nil, 9  , nil, 7  , nil, nil, nil],
    [letterR , nil, nil, nil, nil, 3  , nil, 8  , nil],
    [letterD , nil, nil, 3  , nil, nil, nil, nil, nil],
    [letterM , nil, nil, nil, 3  , nil, nil, 12 , nil],
    [letterP , nil, nil, 11 , nil, 1  , nil, nil, nil],
    [letterI , nil, nil, nil, 1  , 14 , nil, nil, nil],
    [letterO , 13 , nil, nil, nil, nil, 7  , nil, nil]
  ]
;
valanceMaze: MovieMaze
  roomList = [
    [letterT , 2  , 8  , 14 , 10 , nil, nil, 13 , nil],
    [letterH , nil, nil, 9  , 8  , 1  , 3  , 7  , nil],
    [letterE , nil, 2  , 13 , 12 , 4  , nil, 16 , nil],
    [letterM , 3  , nil, 5  , nil, nil, nil, nil, nil],
    [letterA , nil, 10 , 15 , nil, nil, 6  , 4  , nil],
    [letterN , 7  , 16 , 5  , nil, nil, nil, nil, nil],
    [letterW , nil, nil, 2  , nil, 6  , nil, nil, nil],
    [letterO , nil, 9  , nil, nil, nil, 1  , nil, 2  ],
    [letterS , nil, nil, nil, nil, nil, 8  , 2  , nil],
    [letterL , nil, nil, nil, nil, nil, 5  , 11 , 1  ],
    [letterI , nil, nil, 10 , nil, nil, nil, 12 , nil],
    [letterB , nil, nil, 11 , nil, nil, nil, nil, 3  ],
    [letterR , nil, nil, 1  , nil, nil, nil, 3  , nil],
    [letterY , nil, nil, nil, nil, 15 , nil, 1  , nil],
    [letterV , 14 , nil, nil, nil, nil, nil, 5  , nil],
    [letterC , nil, nil, 3  , nil, 6  , nil, nil, nil]
  ]
;
cuckooMaze: MovieMaze
  roomList = [
    [letterO1, nil, nil, nil, nil, 13 , 2  , 6  , nil],
    [letterF , nil, 1  , nil, nil, 3  , nil, nil, nil],
    [letterL , 2  , nil, nil, nil, nil, nil, 4  , nil],
    [letterE , 7  , nil, 3  , 11 , 10 , 8  , nil, 5  ],
    [letterW , nil, 6  , nil, 4  , nil, nil, nil, nil],
    [letterO2, nil, nil, 1  , nil, 7  , 5  , 14 , nil],
    [letterV , 6  , nil, nil, nil, 4  , nil, nil, nil],
    [letterR , nil, 4  , nil, nil, nil, 9  , nil, nil],
    [letterT , 15 , 8  , 10 , nil, nil, nil, nil, nil],
    [letterH , 4  , nil, nil, nil, nil, nil, 9  , nil],
    [letterC , 13 , nil, nil, nil, nil, nil, 12 , 4  ],
    [letterU , nil, nil, 11 , nil, nil, nil, nil, nil],
    [letterK , 1  , nil, nil, nil, 11 , nil, nil, nil],
    [letterS1, nil, nil, 6  , nil, 15 , nil, nil, nil],
    [letterS2, 14 , nil, nil, nil, 9  , nil, nil, nil]
  ]
  xyzzyString = 'NE'
;
crouchingMaze: MovieMaze
  roomList = [
    [letterC , nil, nil, nil, nil, nil, 5  , 4  , 2  ],
    [letterR , nil, nil, 10 , 1  , 3  , 12 , 9  , nil],
    [letterO , 2  , nil, nil, 4  , 5  , 6  , nil, nil],
    [letterU , nil, nil, 1  , nil, nil, nil, nil, 3  ],
    [letterN , 3  , 1  , 10 , nil, nil, nil, 9  , 6  ],
    [letterG , 12 , 3  , nil, 5  , 7  , 8  , nil, 9  ],
    [letterT , 6  , nil, nil, nil, nil, nil, 8  , nil],
    [letterI , nil, 6  , 7  , nil, nil, nil, nil, nil],
    [letterE , 11 , nil, 2  , 6  , 5  , nil, nil, nil],
    [letterD1, 11 , nil, nil, nil, 5  , nil, 2  , nil],
    [letterD2, nil, nil, 10 , nil, nil, nil, 9  , nil],
    [letterA , nil, 2  , nil, nil, 6  , nil, nil, nil]
  ]
  xyzzyString = 'HI'
;

// -------------------------------------------------------------------
// ROOM MODIFICATIONS
// -------------------------------------------------------------------

modify BookMaze
  bmSpecificHint2 = "The book in question is by <<workAuthor>>."
;

// Modifications Part 1

modify tolstoyMaze
  solution = 'WARANDPEACE'
  workTitle = 'War and Peace'
  workAuthor = 'Leo Tolstoy'
  nextMaze = hawthorneMaze
;
modify hawthorneMaze
  solution = 'THESCARLETLETTER'
  workTitle = 'The Scarlet Letter'
  workAuthor = 'Nathaniel Hawthorne'
  nextMaze = dumasMaze
;
modify dumasMaze
  solution = 'THETHREEMUSKETEERS'
  workTitle = 'The Three Musketeers'
  workAuthor = 'Alexandre Dumas'
  nextMaze = dickensMaze
;
modify dickensMaze
  solution = 'ATALEOFTWOCITIES'
  workTitle = 'A Tale of Two Cities'
  workAuthor = 'Charles Dickens'
  nextMaze = defoeMaze
;
modify defoeMaze
  solution = 'ROBINSONCRUSOE'
  workTitle = 'Robinson Crusoe'
  workAuthor = 'Daniel Defoe'
  nextMaze = austenMaze
;
modify austenMaze
  solution = 'PRIDEANDPREJUDICE'
  workTitle = 'Pride and Prejudice'
  workAuthor = 'Jane Austen'
  nextMaze = carrollMaze
;
modify carrollMaze
  solution = 'ALICEINWONDERLAND'
  workTitle = 'Alice in Wonderland'
  workAuthor = 'Lewis Carroll'
  nextMaze = dostoevskyMaze
;
modify dostoevskyMaze
  solution = 'THEBROTHERSKARAMAZOV'
  workTitle = 'The Brothers Karamazov'
  workAuthor = 'Fyodor Dostoevsky'
  nextMaze = chaucerMaze
;
modify chaucerMaze
  solution = 'THECANTERBURYTALES'
  workTitle = 'The Canterbury Tales'
  workAuthor = 'Geoffrey Chaucer'
  nextMaze = proustMaze
;
modify proustMaze
  solution = 'REMEMBRANCEOFTHINGSPAST'
  workTitle = 'Remembrance of Things Past'
  workAuthor = 'Marcel Proust'
  nextMaze = twainMaze
;
modify twainMaze
  solution = 'THEADVENTURESOFTOMSAWYER'
  workTitle = 'The Adventures of Tom Sawyer'
  workAuthor = 'Mark Twain'
  nextMaze = nightsMaze
;
modify nightsMaze
  solution = 'THETHOUSANDANDONENIGHTS'
  workTitle = 'The Thousand and One Nights'
  workAuthor = nil
  nextMaze = marquezMaze
;
modify marquezMaze
  solution = 'ONEHUNDREDYEARSOFSOLITUDE'
  workTitle = 'One Hundred Years of Solitude'
  workAuthor = 'Gabriel Garc&iacute;a M&aacute;rquez'
  nextMaze = nil
;
modify starwarsMaze
  solution = 'STARWARS'
  workTitle = 'Star Wars'
  workAuthor = nil
  nextMaze = casablancaMaze
;
modify casablancaMaze
  solution = 'CASABLANCA'
  workTitle = 'Casablanca'
  workAuthor = nil
  nextMaze = planetMaze
;
modify planetMaze
  solution = 'PLANETOFTHEAPES'
  workTitle = 'Planet of the Apes'
  workAuthor = nil
  nextMaze = lawrenceMaze
;
modify lawrenceMaze
  solution = 'LAWRENCEOFARABIA'
  workTitle = 'Lawrence of Arabia'
  workAuthor = nil
  nextMaze = savingMaze
;
modify savingMaze
  solution = 'SAVINGPRIVATERYAN'
  workTitle = 'Saving Private Ryan'
  workAuthor = nil
  nextMaze = untouchMaze
;
modify untouchMaze
  solution = 'THEUNTOUCHABLES'
  workTitle = 'The Untouchables'
  workAuthor = nil
  nextMaze = silenceMaze
;
modify silenceMaze
  solution = 'THESILENCEOFTHELAMBS'
  workTitle = 'The Silence of the Lambs'
  workAuthor = nil
  nextMaze = bridgeMaze
;
modify bridgeMaze
  solution = 'THEBRIDGEONTHERIVERKWAI'
  workTitle = 'The Bridge on the River Kwai'
  workAuthor = nil
  nextMaze = manchurianMaze
;
modify manchurianMaze
  solution = 'THEMANCHURIANCANDIDATE'
  workTitle = 'The Manchurian Candidate'
  workAuthor = nil
  nextMaze = shawshankMaze
;
modify shawshankMaze
  solution = 'THESHAWSHANKREDEMPTION'
  workTitle = 'The Shawshank Redemption'
  workAuthor = nil
  nextMaze = valanceMaze
;
modify valanceMaze
  solution = 'THEMANWHOSHOTLIBERTYVALANCE'
  workTitle = 'The Man Who Shot Liberty Valance'
  workAuthor = nil
  nextMaze = cuckooMaze
;
modify cuckooMaze
  solution = 'ONEFLEWOVERTHECUCKOOSNEST'
  workTitle = 'One Flew over the Cuckoo<./s>s Nest'
  workAuthor = nil
  nextMaze = crouchingMaze
;
modify crouchingMaze
  solution = 'CROUCHINGTIGERHIDDENDRAGON'
  workTitle = 'Crouching Tiger, Hidden Dragon'
  workAuthor = nil
  nextMaze = nil
;

// Modifications Part 2

modify tolstoyMaze    bannerValue=tolstoy;
modify hawthorneMaze  bannerValue=hawthorne;
modify dumasMaze      bannerValue=dumas;
modify dickensMaze    bannerValue=dickens;
modify defoeMaze      bannerValue=defoe;
modify austenMaze     bannerValue=austen;
modify carrollMaze    bannerValue=carroll;
modify dostoevskyMaze bannerValue=dostoevsky;
modify chaucerMaze    bannerValue=chaucer;
modify proustMaze     bannerValue=proust;
modify twainMaze      bannerValue=twain;
modify nightsMaze     bannerValue=nights;
modify marquezMaze    bannerValue=marquez;
modify starwarsMaze   bannerValue=starwars;
modify casablancaMaze bannerValue=casablanca;
modify planetMaze     bannerValue=planet;
modify lawrenceMaze   bannerValue=lawrence;
modify savingMaze     bannerValue=saving;
modify untouchMaze    bannerValue=untouch;
modify silenceMaze    bannerValue=silence;
modify bridgeMaze     bannerValue=bridge;
modify manchurianMaze bannerValue=manchurian;
modify shawshankMaze  bannerValue=shawshank;
modify valanceMaze    bannerValue=valance;
modify cuckooMaze     bannerValue=cuckoo;
modify crouchingMaze  bannerValue=crouching;

// Modifications Part 3

//modify tolstoyMaze    specificHintProp = &tolstoyHintState   ;
//modify hawthorneMaze  specificHintProp = &hawthorneHintState ;
//modify dumasMaze      specificHintProp = &dumasHintState     ;
//modify dickensMaze    specificHintProp = &dickensHintState   ;
//modify defoeMaze      specificHintProp = &defoeHintState     ;
//modify austenMaze     specificHintProp = &austenHintState    ;
//modify carrollMaze    specificHintProp = &carrollHintState   ;
//modify dostoevskyMaze specificHintProp = &dostoevskyHintState;
//modify chaucerMaze    specificHintProp = &chaucerHintState   ;
//modify proustMaze     specificHintProp = &proustHintState    ;
//modify twainMaze      specificHintProp = &twainHintState     ;
//modify nightsMaze     specificHintProp = &nightsHintState    ;
//modify marquezMaze    specificHintProp = &marquezHintState   ;
//modify starwarsMaze   specificHintProp = &starwarsHintState  ;
//modify casablancaMaze specificHintProp = &casablancaHintState;
//modify planetMaze     specificHintProp = &planetHintState    ;
//modify lawrenceMaze   specificHintProp = &lawrenceHintState  ;
//modify savingMaze     specificHintProp = &savingHintState    ;
//modify untouchMaze    specificHintProp = &untouchHintState   ;
//modify silenceMaze    specificHintProp = &silenceHintState   ;
//modify bridgeMaze     specificHintProp = &bridgeHintState    ;
//modify manchurianMaze specificHintProp = &manchurianHintState;
//modify shawshankMaze  specificHintProp = &shawshankHintState ;
//modify valanceMaze    specificHintProp = &valanceHintState   ;
//modify cuckooMaze     specificHintProp = &cuckooHintState    ;
//modify crouchingMaze  specificHintProp = &crouchingHintState ;

// Modifications Part 4

modify tolstoyMaze
  bmSpecificHint1 = "a Russian novel"
  //bmSpecificHint2 = ""
;
modify hawthorneMaze
  bmSpecificHint1 = "an American novel"
  //bmSpecificHint2 = ""
;
modify dumasMaze
  bmSpecificHint1 = "a French novel"
  //bmSpecificHint2 = ""
;
modify dickensMaze
  bmSpecificHint1 = "an English novel"
  //bmSpecificHint2 = ""
;
modify defoeMaze
  bmSpecificHint1 = "an English novel"
  //bmSpecificHint2 = ""
;
modify austenMaze
  bmSpecificHint1 = "an English novel"
  //bmSpecificHint2 = ""
;
modify carrollMaze
  bmSpecificHint1 = "an English novel"
  //bmSpecificHint2 = ""
;
modify dostoevskyMaze
  bmSpecificHint1 = "a Russian novel"
  //bmSpecificHint2 = ""
;
modify chaucerMaze
  bmSpecificHint1 = "not a novel, but a collection of stories"
  //bmSpecificHint2 = ""
;
modify proustMaze
  bmSpecificHint1 = "a French novel"
  //bmSpecificHint2 = ""
;
modify twainMaze
  bmSpecificHint1 = "an American novel"
  //bmSpecificHint2 = ""
;
modify nightsMaze
  bmSpecificHint1 = "not a novel, but a collection of stories"
  bmSpecificHint2 = "The book in question is set in the Middle East."
;
modify marquezMaze
  bmSpecificHint1 = "a South American novel"
  //bmSpecificHint2 = ""
;
modify starwarsMaze
  bmSpecificHint1 = "The film in question is a science fiction movie."
  bmSpecificHint2 = "The film in question was the most popular movie of the year 1977."
;
modify casablancaMaze
  bmSpecificHint1 = "The film in question is a 1940s drama."
  bmSpecificHint2 = "The film in question stars Humphrey Bogart and Ingrid Bergman."
;
modify planetMaze
  bmSpecificHint1 = "The film in question is a science fiction movie."
  bmSpecificHint2 = "The film in question is a 1968 movie starring Charlton Heston."
;
modify lawrenceMaze
  bmSpecificHint1 = "The film in question is a drama, most of which takes place in a desert."
  bmSpecificHint2 = "The film in question was directed by David Lean, and stars Peter O<./s>Toole."
;
modify savingMaze
  bmSpecificHint1 = "The film in question stars Tom Hanks."
  bmSpecificHint2 = "The film in question is a 1998 movie directed by Steven Spielberg."
;
modify untouchMaze
  bmSpecificHint1 = "The film in question stars Kevin Costner, among others."
  bmSpecificHint2 = "The film in question is a 1987 crime drama set in Chicago."
;
modify silenceMaze
  bmSpecificHint1 = "The film in question is a crime thriller from the 1990s."
  bmSpecificHint2 = "The film in question stars Jodie Foster and Anthony Hopkins."
;
modify bridgeMaze
  bmSpecificHint1 = "The film in question is a 1957 movie starring Alec Guinness."
  bmSpecificHint2 = "The film in question was directed by David Lean. It<./s>s a war movie set in Asia."
;
modify manchurianMaze
  bmSpecificHint1 = "The film in question is a 1962 movie starring Frank Sinatra."
  bmSpecificHint2 = "The film in question was remade in 2004 as a new movie starring Denzel Washington."
;
modify shawshankMaze
  bmSpecificHint1 = "The film in question is from the 1990s, and is set in a prison."
  bmSpecificHint2 = "The film in question stars Tim Robbins and Morgan Freeman."
;
modify valanceMaze
  bmSpecificHint1 = "The film in question is a 1962 Western."
  bmSpecificHint2 = "The film in question stars John Wayne and Jimmy Stewart."
;
modify cuckooMaze
  bmSpecificHint1 = "The film in question stars Jack Nicholson."
  bmSpecificHint2 = "The film in question is a 1975 movie that takes place in a mental institution."
;
modify crouchingMaze
  bmSpecificHint1 = "The film in question is from the year 2000, and is set in Asia."
  bmSpecificHint2 = "The film in question was not in English, but Chinese, and featured a lot of martial arts action."
;

// -------------------------------------------------------------------
// ANCILLARY ROOM MODIFICATION STUFF
// -------------------------------------------------------------------

modify glob
  bookHintState = 0
  movieHintState = 0
  xyzzyBookHintState = 0
  xyzzyMovieHintState = 0
//  tolstoyHintState = 0
//  hawthorneHintState = 0
//  dumasHintState = 0
//  dickensHintState = 0
//  defoeHintState = 0
//  austenHintState = 0
//  carrollHintState = 0
//  dostoevskyHintState = 0
//  chaucerHintState = 0
//  proustHintState = 0
//  twainHintState = 0
//  nightsHintState = 0
//  marquezHintState = 0
//  starwarsHintState = 0
//  casablancaHintState = 0
//  planetHintState = 0
//  lawrenceHintState = 0
//  savingHintState = 0
//  untouchHintState = 0
//  silenceHintState = 0
//  bridgeHintState = 0
//  manchurianHintState = 0
//  shawshankHintState = 0
//  valanceHintState = 0
//  cuckooHintState = 0
//  crouchingHintState = 0
;

modify glob
  bookMovieCompassValue = true
;


// -------------------------------------------------------------------
// DEBUGGING STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

tolstoyFixture:   Fixture 'tolstoy'    'tolstoy'    @tolstoyMaze   ;
hawthorneFixture: Fixture 'hawthorne'  'hawthorne'  @hawthorneMaze ;
dumasFixture:     Fixture 'dumas'      'dumas'      @dumasMaze     ;
dickensFixture:   Fixture 'dickens'    'dickens'    @dickensMaze   ;
defoeFixture:     Fixture 'defoe'      'defoe'      @defoeMaze     ;
austenFixture:    Fixture 'austen'     'austen'     @austenMaze    ;
carrollFixture:   Fixture 'carroll'    'carroll'    @carrollMaze   ;
dostoevskyFixture:Fixture 'dostoevsky' 'dostoevsky' @dostoevskyMaze;
chaucerFixture:   Fixture 'chaucer'    'chaucer'    @chaucerMaze   ;
proustFixture:    Fixture 'proust'     'proust'     @proustMaze    ;
twainFixture:     Fixture 'twain'      'twain'      @twainMaze     ;
nightsFixture:    Fixture 'nights'     'nights'     @nightsMaze    ;
marquezFixture:   Fixture 'marquez'    'marquez'    @marquezMaze   ;
starwarsFixture:  Fixture 'starwars'   'starwars'   @starwarsMaze  ;
casablancaFixture:Fixture 'casablanca' 'casablanca' @casablancaMaze;
planetFixture:    Fixture 'planet'     'planet'     @planetMaze    ;
lawrenceFixture:  Fixture 'lawrence'   'lawrence'   @lawrenceMaze  ;
savingFixture:    Fixture 'saving'     'saving'     @savingMaze    ;
untouchFixture:   Fixture 'untouch'    'untouch'    @untouchMaze   ;
silenceFixture:   Fixture 'silence'    'silence'    @silenceMaze   ;
bridgeFixture:    Fixture 'bridge'     'bridge'     @bridgeMaze    ;
manchurianFixture:Fixture 'manchurian' 'manchurian' @manchurianMaze;
shawshankFixture: Fixture 'shawshank'  'shawshank'  @shawshankMaze ;
valanceFixture:   Fixture 'valance'    'valance'    @valanceMaze   ;
cuckooFixture:    Fixture 'cuckoo'     'cuckoo'     @cuckooMaze    ;
crouchingFixture: Fixture 'crouching'  'crouching'  @crouchingMaze ;

#endif // __DEBUG

// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "STAR WARS"
// -------------------------------------------------------------------
function starwarsMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + starwarsMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + starwarsMaze.connMapState(letterR,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + starwarsMaze.connMapState(letterR,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + starwarsMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + starwarsMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + starwarsMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + starwarsMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + starwarsMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + starwarsMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + starwarsMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + starwarsMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + starwarsMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + starwarsMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + starwarsMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + starwarsMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + starwarsMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + starwarsMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + starwarsMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + starwarsMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + starwarsMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + starwarsMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + starwarsMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + starwarsMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "CASABLANCA"
// -------------------------------------------------------------------
function casablancaMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + casablancaMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + casablancaMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + casablancaMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + casablancaMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + casablancaMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + casablancaMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + casablancaMaze.connMapState(letterB,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + casablancaMaze.connMapState(letterB,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + casablancaMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + casablancaMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + casablancaMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + casablancaMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + casablancaMaze.connMapState(letterB,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + casablancaMaze.connMapState(letterB,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + casablancaMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + casablancaMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + casablancaMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + casablancaMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + casablancaMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + casablancaMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + casablancaMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + casablancaMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + casablancaMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + casablancaMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + casablancaMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + casablancaMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + casablancaMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + casablancaMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + casablancaMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + casablancaMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + casablancaMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "PLANET OF THE APES"
// -------------------------------------------------------------------
function planetMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + planetMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + planetMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + planetMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + planetMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + planetMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + planetMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + planetMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + planetMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + planetMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + planetMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + planetMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + planetMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + planetMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + planetMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + planetMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + planetMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + planetMaze.connMapState(letterE,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + planetMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + planetMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + planetMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + planetMaze.connMapState(letterE,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + planetMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + planetMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + planetMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline179_19' + planetMaze.connMapState(letterA,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + planetMaze.connMapState(letterE,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + planetMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + planetMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + planetMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + planetMaze.connMapState(letterL,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + planetMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + planetMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "LAWRENCE OF ARABIA"
// -------------------------------------------------------------------
function lawrenceMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + lawrenceMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + lawrenceMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + lawrenceMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + lawrenceMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + lawrenceMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + lawrenceMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + lawrenceMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + lawrenceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + lawrenceMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + lawrenceMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + lawrenceMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + lawrenceMaze.connMapState(letterR,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + lawrenceMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + lawrenceMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + lawrenceMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + lawrenceMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + lawrenceMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + lawrenceMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + lawrenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + lawrenceMaze.connMapState(letterA,letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + lawrenceMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + lawrenceMaze.connMapState(letterA,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + lawrenceMaze.connMapState(letterB,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + lawrenceMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + lawrenceMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + lawrenceMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "SAVING PRIVATE RYAN"
// -------------------------------------------------------------------
function savingMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + savingMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + savingMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + savingMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + savingMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + savingMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + savingMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + savingMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + savingMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + savingMaze.connMapState(letterG,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterG,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + savingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent83' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_19' + savingMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterG,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + savingMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + savingMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + savingMaze.connMapState(letterI,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + savingMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + savingMaze.connMapState(letterG,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + savingMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + savingMaze.connMapState(letterA,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + savingMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + savingMaze.connMapState(letterG,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent67' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterY' + savingMaze.roomMapState(letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + savingMaze.connMapState(letterA,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + savingMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + savingMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + savingMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + savingMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterG' + savingMaze.roomMapState(letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline39_19' + savingMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + savingMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + savingMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes137.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + savingMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + savingMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE UNTOUCHABLES"
// -------------------------------------------------------------------
function untouchMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + untouchMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + untouchMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + untouchMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + untouchMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + untouchMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + untouchMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + untouchMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + untouchMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + untouchMaze.connMapState(letterN,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + untouchMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + untouchMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + untouchMaze.connMapState(letterC,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + untouchMaze.connMapState(letterE,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + untouchMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterE,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + untouchMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + untouchMaze.connMapState(letterC,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + untouchMaze.connMapState(letterE,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + untouchMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + untouchMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + untouchMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + untouchMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + untouchMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + untouchMaze.connMapState(letterA,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + untouchMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + untouchMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + untouchMaze.connMapState(letterA,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + untouchMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + untouchMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + untouchMaze.connMapState(letterA,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + untouchMaze.connMapState(letterB,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + untouchMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + untouchMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + untouchMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + untouchMaze.connMapState(letterA,letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + untouchMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE SILENCE OF THE LAMBS"
// -------------------------------------------------------------------
function silenceMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + silenceMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + silenceMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + silenceMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + silenceMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + silenceMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + silenceMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + silenceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + silenceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + silenceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + silenceMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + silenceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + silenceMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + silenceMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + silenceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + silenceMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + silenceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + silenceMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + silenceMaze.connMapState(letterI,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + silenceMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + silenceMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + silenceMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + silenceMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + silenceMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + silenceMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + silenceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + silenceMaze.connMapState(letterB,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + silenceMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + silenceMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline179_19' + silenceMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + silenceMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + silenceMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + silenceMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + silenceMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + silenceMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + silenceMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + silenceMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + silenceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + silenceMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + silenceMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE BRIDGE ON THE RIVER KWAI"
// -------------------------------------------------------------------
function bridgeMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + bridgeMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + bridgeMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + bridgeMaze.connMapState(letterD,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterG' + bridgeMaze.roomMapState(letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + bridgeMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + bridgeMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + bridgeMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + bridgeMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + bridgeMaze.connMapState(letterA,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + bridgeMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + bridgeMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + bridgeMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + bridgeMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + bridgeMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + bridgeMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + bridgeMaze.connMapState(letterI,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + bridgeMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + bridgeMaze.connMapState(letterE,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + bridgeMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + bridgeMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + bridgeMaze.connMapState(letterK,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + bridgeMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent29' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline13_37' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + bridgeMaze.connMapState(letterB,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + bridgeMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + bridgeMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + bridgeMaze.connMapState(letterK,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + bridgeMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + bridgeMaze.connMapState(letterB,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + bridgeMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + bridgeMaze.connMapState(letterK,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + bridgeMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + bridgeMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + bridgeMaze.connMapState(letterB,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterK' + bridgeMaze.roomMapState(letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + bridgeMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + bridgeMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + bridgeMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + bridgeMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + bridgeMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + bridgeMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE MANCHURIAN CANDIDATE"
// -------------------------------------------------------------------
function manchurianMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + manchurianMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + manchurianMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + manchurianMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + manchurianMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + manchurianMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + manchurianMaze.connMapState(letterA,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + manchurianMaze.connMapState(letterA,letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + manchurianMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + manchurianMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + manchurianMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + manchurianMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + manchurianMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + manchurianMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + manchurianMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + manchurianMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline179_19' + manchurianMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + manchurianMaze.connMapState(letterC,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + manchurianMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + manchurianMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + manchurianMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + manchurianMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + manchurianMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + manchurianMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + manchurianMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + manchurianMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + manchurianMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + manchurianMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + manchurianMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + manchurianMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + manchurianMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + manchurianMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + manchurianMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + manchurianMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + manchurianMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + manchurianMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + manchurianMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE SHAWSHANK REDEMPTION"
// -------------------------------------------------------------------
function shawshankMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterK' + shawshankMaze.roomMapState(letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + shawshankMaze.connMapState(letterK,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + shawshankMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + shawshankMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + shawshankMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + shawshankMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + shawshankMaze.connMapState(letterM,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + shawshankMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + shawshankMaze.connMapState(letterI,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + shawshankMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + shawshankMaze.connMapState(letterP,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline179_19' + shawshankMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + shawshankMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterI,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + shawshankMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + shawshankMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + shawshankMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + shawshankMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + shawshankMaze.connMapState(letterI,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + shawshankMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_37' + shawshankMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + shawshankMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + shawshankMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + shawshankMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + shawshankMaze.connMapState(letterH,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + shawshankMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + shawshankMaze.connMapState(letterK,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + shawshankMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + shawshankMaze.connMapState(letterA,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + shawshankMaze.connMapState(letterS,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + shawshankMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + shawshankMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + shawshankMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + shawshankMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + shawshankMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + shawshankMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + shawshankMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + shawshankMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE MAN WHO SHOT LIBERTY VALANCE"
// -------------------------------------------------------------------
function valanceMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + valanceMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + valanceMaze.connMapState(letterH,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + valanceMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterH,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterH,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + valanceMaze.connMapState(letterH,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + valanceMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + valanceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + valanceMaze.connMapState(letterH,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + valanceMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + valanceMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_37' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent81' + valanceMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + valanceMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + valanceMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + valanceMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + valanceMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + valanceMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + valanceMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + valanceMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + valanceMaze.connMapState(letterR,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + valanceMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + valanceMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterY' + valanceMaze.roomMapState(letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + valanceMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + valanceMaze.connMapState(letterB,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline179_19' + valanceMaze.connMapState(letterL,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + valanceMaze.connMapState(letterV,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + valanceMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + valanceMaze.connMapState(letterB,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + valanceMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + valanceMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + valanceMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterV,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + valanceMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + valanceMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + valanceMaze.connMapState(letterV,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line27' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + valanceMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + valanceMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + valanceMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterA,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + valanceMaze.connMapState(letterA,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + valanceMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + valanceMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + valanceMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + valanceMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line34' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + valanceMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "ONE FLEW OVER THE CUCKOO'S NEST"
// -------------------------------------------------------------------
function cuckooMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + cuckooMaze.roomMapState(letterS1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + cuckooMaze.connMapState(letterO2,letterS1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + cuckooMaze.connMapState(letterO2,letterS1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + cuckooMaze.connMapState(letterO2,letterS1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + cuckooMaze.roomMapState(letterO2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + cuckooMaze.connMapState(letterO1,letterO2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + cuckooMaze.connMapState(letterO1,letterO2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + cuckooMaze.connMapState(letterO1,letterO2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + cuckooMaze.roomMapState(letterO1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + cuckooMaze.connMapState(letterS1,letterS2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + cuckooMaze.connMapState(letterO2,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + cuckooMaze.connMapState(letterO2,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + cuckooMaze.connMapState(letterF,letterO1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + cuckooMaze.connMapState(letterK,letterO1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + cuckooMaze.connMapState(letterS1,letterS2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + cuckooMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + cuckooMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + cuckooMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + cuckooMaze.connMapState(letterK,letterO1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + cuckooMaze.connMapState(letterS1,letterS2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + cuckooMaze.connMapState(letterE,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + cuckooMaze.connMapState(letterE,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + cuckooMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + cuckooMaze.connMapState(letterK,letterO1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + cuckooMaze.roomMapState(letterS2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + cuckooMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + cuckooMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + cuckooMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterK' + cuckooMaze.roomMapState(letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + cuckooMaze.connMapState(letterS2,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + cuckooMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + cuckooMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline13_19' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent27' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + cuckooMaze.connMapState(letterC,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + cuckooMaze.connMapState(letterS2,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + cuckooMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + cuckooMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + cuckooMaze.connMapState(letterC,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + cuckooMaze.connMapState(letterS2,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + cuckooMaze.connMapState(letterR,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + cuckooMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent83' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_19' + cuckooMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + cuckooMaze.connMapState(letterC,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + cuckooMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + cuckooMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + cuckooMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + cuckooMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + cuckooMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + cuckooMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + cuckooMaze.connMapState(letterC,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + cuckooMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td colspan=\"11\" align=\"center\"><img src=\"bkmv/xyzzy' + (cuckooMaze.xyzzyIsKnown ? 'ne' : '') + '.png\" width=\"198\" height=\"20\" border=\"0\"></td>
  </tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "CROUCHING TIGER, HIDDEN DRAGON"
// -------------------------------------------------------------------
function crouchingMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/crouchline68' + crouchingMaze.connMapState(letterD2,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel746' + crouchingMaze.connMapState(letterD2,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD2,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD2,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + crouchingMaze.connMapState(letterD2,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + crouchingMaze.roomMapState(letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel946' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel846' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel746' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel946' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/crouchline48' + crouchingMaze.connMapState(letterD1,letterD2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + crouchingMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel346' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel246' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel146' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + crouchingMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + crouchingMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + crouchingMaze.connMapState(letterD1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + crouchingMaze.connMapState(letterD1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + crouchingMaze.roomMapState(letterD1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + crouchingMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline39_37' + crouchingMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + crouchingMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline17_19' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + crouchingMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent61' + crouchingMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + crouchingMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent43' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent67' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + crouchingMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent49' + crouchingMaze.connMapState(letterG,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + crouchingMaze.connMapState(letterG,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + crouchingMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + crouchingMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent83' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_19' + crouchingMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel728' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline39_19' + crouchingMaze.connMapState(letterE,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + crouchingMaze.connMapState(letterA,letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline17_37' + crouchingMaze.connMapState(letterG,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + crouchingMaze.connMapState(letterG,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + crouchingMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + crouchingMaze.connMapState(letterC,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + crouchingMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel428' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterG' + crouchingMaze.roomMapState(letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent29' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline13_37' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel128' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + crouchingMaze.connMapState(letterG,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + crouchingMaze.connMapState(letterG,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline17_19' + crouchingMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + crouchingMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + crouchingMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + crouchingMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + crouchingMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent43' + crouchingMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + crouchingMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + crouchingMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + crouchingMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line26' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel346' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel246' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/crouchparallel1346' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel246' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel146' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + crouchingMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + crouchingMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line24' + crouchingMaze.connMapState(letterD1,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td colspan=\"16\" align=\"center\"><img src=\"bkmv/xyzzy' + (crouchingMaze.xyzzyIsKnown ? 'hi' : '') + '.png\" width=\"198\" height=\"20\" border=\"0\"></td>
  </tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "WAR AND PEACE"
// -------------------------------------------------------------------
function tolstoyMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + tolstoyMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + tolstoyMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + tolstoyMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + tolstoyMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + tolstoyMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + tolstoyMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + tolstoyMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + tolstoyMaze.connMapState(letterE,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + tolstoyMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + tolstoyMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + tolstoyMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + tolstoyMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + tolstoyMaze.connMapState(letterE,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + tolstoyMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + tolstoyMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + tolstoyMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent91' + tolstoyMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + tolstoyMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + tolstoyMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + tolstoyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + tolstoyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + tolstoyMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + tolstoyMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + tolstoyMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + tolstoyMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + tolstoyMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + tolstoyMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + tolstoyMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + tolstoyMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + tolstoyMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + tolstoyMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + tolstoyMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + tolstoyMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + tolstoyMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + tolstoyMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE SCARLET LETTER"
// -------------------------------------------------------------------
function hawthorneMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + hawthorneMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterL,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterL,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + hawthorneMaze.roomMapState(letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterT1,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterT1,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + hawthorneMaze.roomMapState(letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + hawthorneMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + hawthorneMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + hawthorneMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + hawthorneMaze.connMapState(letterE,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent19' + hawthorneMaze.connMapState(letterE,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + hawthorneMaze.connMapState(letterE,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + hawthorneMaze.connMapState(letterH,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + hawthorneMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + hawthorneMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + hawthorneMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + hawthorneMaze.connMapState(letterE,letterT2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + hawthorneMaze.connMapState(letterE,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent91' + hawthorneMaze.connMapState(letterE,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + hawthorneMaze.connMapState(letterH,letterT1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + hawthorneMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + hawthorneMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + hawthorneMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + hawthorneMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + hawthorneMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + hawthorneMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + hawthorneMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + hawthorneMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + hawthorneMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + hawthorneMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + hawthorneMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + hawthorneMaze.connMapState(letterC,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + hawthorneMaze.connMapState(letterC,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + hawthorneMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE THREE MUSKETEERS"
// -------------------------------------------------------------------
function dumasMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + dumasMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dumasMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dumasMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + dumasMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dumasMaze.connMapState(letterK,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dumasMaze.connMapState(letterK,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterK' + dumasMaze.roomMapState(letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dumasMaze.connMapState(letterH,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + dumasMaze.connMapState(letterE1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent37' + dumasMaze.connMapState(letterE1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxcrosstan9' + dumasMaze.connMapState(letterS,letterU) + dumasMaze.connMapState(letterE1,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxcrosstan7' + dumasMaze.connMapState(letterS,letterU) + dumasMaze.connMapState(letterE1,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dumasMaze.connMapState(letterH,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + dumasMaze.connMapState(letterE1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + dumasMaze.connMapState(letterE1,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxcrosstan3' + dumasMaze.connMapState(letterS,letterU) + dumasMaze.connMapState(letterE1,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxcrosstan1' + dumasMaze.connMapState(letterS,letterU) + dumasMaze.connMapState(letterE1,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + dumasMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dumasMaze.connMapState(letterE1,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dumasMaze.connMapState(letterE1,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + dumasMaze.roomMapState(letterE1) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + dumasMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dumasMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent19' + dumasMaze.connMapState(letterE1,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + dumasMaze.connMapState(letterE1,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dumasMaze.connMapState(letterE1,letterE2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dumasMaze.connMapState(letterM,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dumasMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + dumasMaze.connMapState(letterE1,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent91' + dumasMaze.connMapState(letterE1,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dumasMaze.connMapState(letterE1,letterE2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dumasMaze.connMapState(letterM,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + dumasMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dumasMaze.connMapState(letterE2,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dumasMaze.connMapState(letterE2,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + dumasMaze.roomMapState(letterE2) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dumasMaze.connMapState(letterE2,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dumasMaze.connMapState(letterE2,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + dumasMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "A TALE OF TWO CITIES"
// -------------------------------------------------------------------
function dickensMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + dickensMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dickensMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dickensMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dickensMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + dickensMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + dickensMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dickensMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + dickensMaze.connMapState(letterO,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + dickensMaze.connMapState(letterC,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_19' + dickensMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + dickensMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + dickensMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + dickensMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + dickensMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + dickensMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dickensMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + dickensMaze.connMapState(letterT,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes139.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + dickensMaze.connMapState(letterC,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline137_37' + dickensMaze.connMapState(letterE,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dickensMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + dickensMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dickensMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dickensMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dickensMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + dickensMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + dickensMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + dickensMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dickensMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + dickensMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dickensMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dickensMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dickensMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dickensMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dickensMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + dickensMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "ROBINSON CRUSOE"
// -------------------------------------------------------------------
function defoeMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + defoeMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + defoeMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + defoeMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + defoeMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + defoeMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + defoeMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + defoeMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + defoeMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + defoeMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + defoeMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + defoeMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + defoeMaze.connMapState(letterB,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + defoeMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + defoeMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + defoeMaze.connMapState(letterS,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + defoeMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + defoeMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + defoeMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + defoeMaze.connMapState(letterC,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + defoeMaze.connMapState(letterN,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + defoeMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + defoeMaze.connMapState(letterB,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + defoeMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + defoeMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + defoeMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + defoeMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + defoeMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + defoeMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + defoeMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + defoeMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "PRIDE AND PREJUDICE"
// -------------------------------------------------------------------
function austenMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + austenMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + austenMaze.connMapState(letterP,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + austenMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + austenMaze.connMapState(letterI,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + austenMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + austenMaze.connMapState(letterC,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + austenMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + austenMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + austenMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + austenMaze.connMapState(letterD,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + austenMaze.connMapState(letterD,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + austenMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + austenMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + austenMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + austenMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + austenMaze.connMapState(letterE,letterJ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + austenMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + austenMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterJ' + austenMaze.roomMapState(letterJ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + austenMaze.connMapState(letterJ,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterJ,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + austenMaze.connMapState(letterJ,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + austenMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + austenMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + austenMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + austenMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + austenMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + austenMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + austenMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "ALICE IN WONDERLAND"
// -------------------------------------------------------------------
function carrollMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + carrollMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + carrollMaze.connMapState(letterL,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + carrollMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + carrollMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + carrollMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + carrollMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + carrollMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + carrollMaze.connMapState(letterE,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterE,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + carrollMaze.connMapState(letterE,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + carrollMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + carrollMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + carrollMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + carrollMaze.connMapState(letterC,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + carrollMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + carrollMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + carrollMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + carrollMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + carrollMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + carrollMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + carrollMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + carrollMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + carrollMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + carrollMaze.connMapState(letterN,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + carrollMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + carrollMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + carrollMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + carrollMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + carrollMaze.connMapState(letterO,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + carrollMaze.connMapState(letterO,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + carrollMaze.connMapState(letterO,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + carrollMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + carrollMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE BROTHERS KARAMAZOV"
// -------------------------------------------------------------------
function dostoevskyMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterZ' + dostoevskyMaze.roomMapState(letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterO,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dostoevskyMaze.connMapState(letterO,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dostoevskyMaze.connMapState(letterO,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dostoevskyMaze.connMapState(letterO,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterO,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + dostoevskyMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dostoevskyMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + dostoevskyMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + dostoevskyMaze.connMapState(letterA,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + dostoevskyMaze.connMapState(letterA,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dostoevskyMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + dostoevskyMaze.connMapState(letterO,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dostoevskyMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + dostoevskyMaze.connMapState(letterA,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + dostoevskyMaze.connMapState(letterA,letterZ) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + dostoevskyMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + dostoevskyMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/cboxes49.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dostoevskyMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + dostoevskyMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterA,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + dostoevskyMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + dostoevskyMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/cboxes617.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + dostoevskyMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent19' + dostoevskyMaze.connMapState(letterA,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + dostoevskyMaze.connMapState(letterA,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + dostoevskyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + dostoevskyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + dostoevskyMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + dostoevskyMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/cboxes43.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + dostoevskyMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + dostoevskyMaze.connMapState(letterA,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent91' + dostoevskyMaze.connMapState(letterA,letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent73' + dostoevskyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + dostoevskyMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dostoevskyMaze.connMapState(letterO,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + dostoevskyMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + dostoevskyMaze.connMapState(letterB,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + dostoevskyMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterK' + dostoevskyMaze.roomMapState(letterK) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterK,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterK,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + dostoevskyMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterR,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + dostoevskyMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + dostoevskyMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + dostoevskyMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + dostoevskyMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + dostoevskyMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE CANTERBURY TALES"
// -------------------------------------------------------------------
function chaucerMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + chaucerMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + chaucerMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + chaucerMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + chaucerMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + chaucerMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + chaucerMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + chaucerMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + chaucerMaze.connMapState(letterT,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterY' + chaucerMaze.roomMapState(letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + chaucerMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + chaucerMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + chaucerMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + chaucerMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + chaucerMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + chaucerMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + chaucerMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + chaucerMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + chaucerMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_37' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent81' + chaucerMaze.connMapState(letterA,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + chaucerMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + chaucerMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes19.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + chaucerMaze.connMapState(letterR,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + chaucerMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + chaucerMaze.connMapState(letterA,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + chaucerMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + chaucerMaze.connMapState(letterE,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + chaucerMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + chaucerMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + chaucerMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + chaucerMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + chaucerMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + chaucerMaze.connMapState(letterA,letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_37' + chaucerMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + chaucerMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + chaucerMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + chaucerMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + chaucerMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + chaucerMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + chaucerMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + chaucerMaze.connMapState(letterB,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + chaucerMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "REMEMBRANCE OF THINGS PAST"
// -------------------------------------------------------------------
function proustMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterP' + proustMaze.roomMapState(letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + proustMaze.connMapState(letterP,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + proustMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + proustMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + proustMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + proustMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterA,letterP) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline1379_37' + proustMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterG,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline379_37' + proustMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + proustMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterG' + proustMaze.roomMapState(letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + proustMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + proustMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + proustMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + proustMaze.connMapState(letterA,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterG,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterH,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes1379.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + proustMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + proustMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + proustMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + proustMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes46.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + proustMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + proustMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline139_19' + proustMaze.connMapState(letterC,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxes28.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes137.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + proustMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + proustMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterC' + proustMaze.roomMapState(letterC) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + proustMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + proustMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + proustMaze.connMapState(letterC,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + proustMaze.connMapState(letterE,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + proustMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + proustMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + proustMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + proustMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterB,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + proustMaze.connMapState(letterE,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes17.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterB' + proustMaze.roomMapState(letterB) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + proustMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + proustMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + proustMaze.connMapState(letterB,letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + proustMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE ADVENTURES OF TOM SAWYER"
// -------------------------------------------------------------------
function twainMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + twainMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterM' + twainMaze.roomMapState(letterM) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + twainMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + twainMaze.connMapState(letterF,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + twainMaze.connMapState(letterM,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + twainMaze.connMapState(letterM,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + twainMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + twainMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + twainMaze.connMapState(letterM,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + twainMaze.connMapState(letterF,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline37_37' + twainMaze.connMapState(letterO,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + twainMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + twainMaze.connMapState(letterM,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + twainMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + twainMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + twainMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + twainMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + twainMaze.connMapState(letterA,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + twainMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + twainMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + twainMaze.connMapState(letterN,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + twainMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + twainMaze.connMapState(letterA,letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + twainMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + twainMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + twainMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + twainMaze.connMapState(letterA,letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + twainMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + twainMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + twainMaze.connMapState(letterE,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline79_37' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent81' + twainMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + twainMaze.connMapState(letterA,letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + twainMaze.connMapState(letterA,letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + twainMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + twainMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + twainMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + twainMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + twainMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + twainMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + twainMaze.connMapState(letterE,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterV' + twainMaze.roomMapState(letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + twainMaze.connMapState(letterD,letterV) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + twainMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterW' + twainMaze.roomMapState(letterW) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline13_19' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent27' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + twainMaze.connMapState(letterR,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + twainMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + twainMaze.connMapState(letterW,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + twainMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterY' + twainMaze.roomMapState(letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "THE THOUSAND AND ONE NIGHTS"
// -------------------------------------------------------------------
function nightsMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + nightsMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + nightsMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + nightsMaze.connMapState(letterS,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterS' + nightsMaze.roomMapState(letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + nightsMaze.connMapState(letterS,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterS,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + nightsMaze.connMapState(letterS,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + nightsMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + nightsMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + nightsMaze.connMapState(letterH,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + nightsMaze.connMapState(letterO,letterS) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + nightsMaze.connMapState(letterO,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + nightsMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + nightsMaze.connMapState(letterH,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterH,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + nightsMaze.connMapState(letterH,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + nightsMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline39_37' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + nightsMaze.connMapState(letterG,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes179.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes37.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + nightsMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent61' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterG' + nightsMaze.roomMapState(letterG) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + nightsMaze.connMapState(letterG,letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + nightsMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + nightsMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + nightsMaze.connMapState(letterE,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + nightsMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline19_19' + nightsMaze.connMapState(letterI,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + nightsMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + nightsMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + nightsMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + nightsMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td colspan=\"11\" align=\"center\"><img src=\"bkmv/xyzzy' + (nightsMaze.xyzzyIsKnown ? 'and' : '') + '.png\" width=\"198\" height=\"20\" border=\"0\"></td>
  </tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
// -------------------------------------------------------------------
// BOOK/MOVIE MAZES: MAPS: "ONE HUNDRED YEARS OF SOLITUDE"
// -------------------------------------------------------------------
function marquezMapPrint() {
  return '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes79.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterT' + marquezMaze.roomMapState(letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline46' + marquezMaze.connMapState(letterT,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterU' + marquezMaze.roomMapState(letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterD,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterD' + marquezMaze.roomMapState(letterD) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterD,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterD,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterD,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterY' + marquezMaze.roomMapState(letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes13.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + marquezMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + marquezMaze.connMapState(letterN,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + marquezMaze.connMapState(letterN,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + marquezMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + marquezMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + marquezMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + marquezMaze.connMapState(letterN,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + marquezMaze.connMapState(letterN,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + marquezMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + marquezMaze.connMapState(letterD,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/doubletangent79' + marquezMaze.connMapState(letterD,letterR) + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterN' + marquezMaze.roomMapState(letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/doubletangent39' + marquezMaze.connMapState(letterD,letterR) + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/cross1937' + marquezMaze.connMapState(letterD,letterR) + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/doubletangent17' + marquezMaze.connMapState(letterD,letterR) + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxes39.png\" border=\"0\"></td>
    <td><img src=\"bkmv/aboxesline28' + marquezMaze.connMapState(letterN,letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/bboxesline17_19' + marquezMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + marquezMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line37' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/doubletangent13' + marquezMaze.connMapState(letterD,letterR) + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line19' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + marquezMaze.connMapState(letterH,letterU) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterO' + marquezMaze.roomMapState(letterO) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxtangent43' + marquezMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + marquezMaze.connMapState(letterE,letterN) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + marquezMaze.connMapState(letterD,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + marquezMaze.connMapState(letterE,letterY) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + marquezMaze.connMapState(letterD,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterH' + marquezMaze.roomMapState(letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel346' + marquezMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel246' + marquezMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel146' + marquezMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterE,letterH) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterE' + marquezMaze.roomMapState(letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterE,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterR' + marquezMaze.roomMapState(letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline1' + marquezMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent7' + marquezMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent9' + marquezMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline3' + marquezMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline2' + marquezMaze.connMapState(letterF,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent3' + marquezMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline9' + marquezMaze.connMapState(letterA,letterE) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline7' + marquezMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/tangent1' + marquezMaze.connMapState(letterA,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line28' + marquezMaze.connMapState(letterF,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + marquezMaze.connMapState(letterI,letterT) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box8.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterA' + marquezMaze.roomMapState(letterA) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box9.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline8' + marquezMaze.connMapState(letterF,letterR) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box7.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box6.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterI' + marquezMaze.roomMapState(letterI) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterI,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterL' + marquezMaze.roomMapState(letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline4' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/line46' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel346' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel246' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxparallel146' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/boxline6' + marquezMaze.connMapState(letterF,letterL) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/letterF' + marquezMaze.roomMapState(letterF) + '.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box4.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/nil.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box3.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box2.png\" border=\"0\"></td>
    <td><img src=\"bkmv/box1.png\" border=\"0\"></td>
  <tr>
  <tr>
    <td colspan=\"17\" align=\"center\"><img src=\"bkmv/xyzzy' + (marquezMaze.xyzzyIsKnown ? 'so' : '') + '.png\" width=\"198\" height=\"20\" border=\"0\"></td>
  </tr>
  </table>' + doCompass(glob.bookMovieCompassValue);
}
