/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

//
// Other stuff that goes in global
//
modify global

#ifdef	PLAYTESTING
	playtesting = true
#else
	playtesting = nil
#endif

	maxscore = 75

	hintbottoms = []	// hintnodes with no requirements
	hintsused = 0
	encrypt = nil		// encrypt hints?

	moverlist = []		// list of matter movers
	colorspace = ''
	system = ''
	planet = ''

	ingame = nil

	nondeterministic = true
	
	// print extra statusline stuff
	statusline = {
		if (global.ingame)
			return;

		"\ \ [";
		if (global.colorspace = '')
			"?";
		else
			say(global.colorspace);
		":\ ";
		if (global.system = '')
			"?";
		else
			say(global.system);
		",\ ";
		if (global.planet = '')
			"?";
		else
			say(global.planet);
		"]\ ";
	}
;

replace score_and_rank: function
{
	if (global.ingame) {
		"In "; say(global.turns);
		" turns, you have earned ";
		say(global.score); 
		if (global.score = 1)
			" point ";
		else
			" points ";
		"out of a possible 451.";

		" By my estimation, this means you're not very
		far along The Way.";
	}
	else {
		"In "; say(global.turns);
		" turns, you have earned ";
		say(global.score); 
		if (global.score = 1)
			" point ";
		else
			" points ";
		"out of a possible ";
		say(global.maxscore); 

#ifdef	DEMO
		" "; note(demoscorenote);
#endif
		".\n";

		"You have completed approximately ";
		say(hintnodes_satisfied() * 100 / hintnodes());
		" percent of the game.\n";

		if (global.hintsused = 0)
			"You haven't used any hints.";
		else if (global.hintsused = 1)
			"You've gotten one hint.";
		else
			"You have gotten <<global.hintsused>> hints.";
	}
}

#ifdef	DEMO
demoscorenote: object
	footnote = {
		"The maximum score refers to the complete version
		of the game, not the demo.";
	}
;
#endif

replace pardon: function
{
	if (global.ingame)
		"Silence is truly the way of Duhdha.";
	else
		"Couldn't have put it better myself.";
}

replace terminate: function
{
	if (global.score = global.maxscore)
		"\b";
	else
		"The Legend awaits your return.\b";
}

commandPrompt: function(n)
{
	"\b";

	if (global.ingame)
		">>";
	else
		">";
}

#ifdef DEMO
enddemo: function
{
	P();

	"You have reached the end of one of several paths through the
	demo. ";

	demoblurb();

	P();

	"Thank you for playing our demo!"; P();
			     
	end();
}

demoblurb: function
{
	"To find out how to get the complete game, read the \"readme\"
	file that came with the demo, or contact \(ADVENTIONS\) at the
	address mentioned in the game opening.";
}
#endif	/* DEMO */

modify Ground
	noun = 'floors'	// "...hardwood floors..."
;
