#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


connectorIntoTetris : TetrisRoomSet,OneWayRoomConnector
	-> tetrisByFence
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
		}
	}
;



class TetrisRoomSet : RoomInSet
	roomSetId = 'TetrisRoomSet'
	
	notifyBeforeArriving() {
//		"ENTERING <<roomSetId>>\n";
	}
	
	notifyBeforeLeaving() {
//		"LEAVING <<roomSetId>>\n";
	}
;

tetrisSoundSenseConnector : SenseConnector, Intangible
	transSensingThru(sense) {
		if(sense==sound)
			return distant;
		else
			return opaque;
	} 
	
	initialLocationClass = TetrisRoomSet
;



MultiLoc, Distant 'crane/arm' 'crane'
	"The crane is extremely tall and is likely very powerful. Presumably,
	it's used to move all this junk around. "
	locationList = [tetrisByFence]
;

MultiLoc, Heavy '(north) (south) (north-south) (east) (west) (east-west) tall rusty fence' 'rusty fence'
	"It's a tall rusty fence that reaches far into the sky. "
	initialLocationClass = TetrisRoomSet
//	locationList = [tetrisByFence,tetrisBuildingSE,tetrisBuildingSW,tetrisBuildingGap,tetrisCraneArea]
;

MultiLoc, Heavy '(tall) (front) (very) (poorly) (made) building/structure' 'building'
	"It looks like a building, but if it's supposed to be
	a building then had Frank Lloyd Wright been here he would have had
	an apoplectic attack. <q>Poorly done</q> is one phrase that comes
	to mind. <q>Please may I leave the area</q> is another. It looks very
	much like it could fall over at any moment. Beams are thrown together
	with very little support in some places and nothing but solid metal
	in others. The building looks to be perhaps 18 stories tall and the
	only part of the building that looks solid is the bottom 4 stories
	which are made of absolutely solid metal. Perhaps it's intended
	as a work of art instead of as a structure to be lived or worked in? "
	
	locationList = [tetrisBuildingSE,tetrisBuildingSW,tetrisBuildingGap,tetrisBuildingTopE,tetrisBuildingTopW]
;

    
/*
tetrisJunkyard : TetrisRoomSet,OutdoorRoom 'junkyard'
	"This is a junkyard. Large heaps of wreckage are piled up all over the
	place. A path through the wreckage leads south to where a large crane
	sits. Another path leads north. "
	north = tetrisByFence
	northeast = tetrisCraneArea
	
	vocabWords = 'junkyard'
;
*/

tetrisByFence : TetrisRoomSet,OutdoorRoom 'junkyard gate'
	"This is a large dirty junkyard with large heaps of wreckage piled up all over the place.
	A tall east-west fence stands here. There is a gate leading north
	through the fence. To the south a path leads to a crane that reaches
	high into the sky. "
	north = tetrisFenceGateOutside
    south = tetrisCraneArea
;
+ tetrisFenceGateOutside : Door 'rusty gate' 'gate'
	"This is a rusty gate in the fence. "
;	
+ Heavy 'large metal pileup/wreckage/junk/heap*heaps' 'wreckage'
	"They are made up of crushed cars, iron girders, and other less
	recognizable metal junk. "
;
++ Heavy '(large) crushed iron (metal) car/girder*cars*girders' 'wreckage'
	"It's all just junk. You don't need any of it. "
;

tetrisBuildingSE : TetrisRoomSet,OutdoorRoom 'structure southeast'
	"The fence was tall enough that it concealed the huge structure inside.
	There's a tall very poorly made building here. A north-south fence
	intersects the east-west fence here and continues running north
	next to the building. The only open paths are to the west in front
	of the building and back through the gate to the south.
	Next to the gate is a bench. Also, attached to the fence, is a ladder
	leading up to the top of the building. "
	west = tetrisBuildingSW
	south = tetrisFenceGateInside
	up = tetrisLadderUp
;
+ tetrisLadderUp : StairwayUp ->tetrisLadderDown 'steel ladder' 'ladder'
	"The steel ladder is attached to the fence and leads up to the top of the building. "
;
+ tetrisFenceGateInside : Door ->tetrisFenceGateOutside 'gate' 'gate'
	"This is a rusty gate in the fence. "
;	
+ tetrisBench : Bed,Heavy 'bench' 'bench'
	"This is a simple bench where, presumably, the construction workers sit during their
	lunch breaks. "
	isListedInRoomPart = true
;

tetrisBuildingSW : TetrisRoomSet,OutdoorRoom 'structure southwest'
	"There's a tall very poorly made building here. The fence turns a corner
	here and runs north next to the building. On this side there is room in
	between the fence and the building, so if you want to brave being in the
	shadow of this unsafe structure, you can continue along the fence to
	the north. "
	north = tetrisBuildingGap
	east = tetrisBuildingSE
;


tetrisBuildingGap : TetrisRoomSet,OutdoorRoom 'gap beside building'
	"This is a relatively thin gap on the west side of the building.
	The gap is bordered on the north and west by the fence and on the east
	by the building. You can leave the gap to the south.
	It actually seems rather strange that this gap is here. The building looks like it was
	built by dropping a bunch of oddly shaped blocks from the sky. It seems hard to believe
	that this gap would have been left here by accident. It seems as if the building had
	been built up while specifically leaving this gap here. "
	south = tetrisBuildingSW
;
+ Decoration 'thin gap' 'gap'
	"It's a relatively thin gap in between the fence and the building. "
;

tetrisBuildingTopE : TetrisRoomSet,OutdoorRoom 'building top east'
	"This is the east end of the top of the building. You can move along the top
	to the west. "
	down = tetrisLadderDown
	west = tetrisBuildingTopW
	
	vocabWords = 'top'
;
+ tetrisLadderDown : StairwayDown 'steel ladder' 'ladder'
	"The steel ladder is attached to the fence and leads down to the ground. "
;

tetrisBuildingTopW : TetrisRoomSet,OutdoorRoom 'building top west'
	"This is the west end of the top of the building. You can move back along the
	top to the east. "
	east = tetrisBuildingTopE
;

tetrisBuildingSkyW : TetrisRoomSet,OutdoorRoom 'sky west'
;

tetrisBuildingSkyE : TetrisRoomSet,OutdoorRoom 'sky east'
;




tetrisCraneArea : TetrisRoomSet,OutdoorRoom 'crane area'
	desc {
		if(!gPlayerChar.isIn(tetrisCrane)) {
			"The crane towers before you. You could enter the control room of the
			crane if you like. A path leads back to the north. ";
		}
	}
	north = tetrisByFence
	
	vocabWords = 'tcrane'
;
+ Decoration 'curving path' 'path'
	desc {tetrisCraneArea.desc;}
;
+ tetrisCrane : TetrisRoomSet,OutOfReach,Heavy,Booth 'crane arm control room' 'crane control room'
	"The crane is extremely tall and is likely very powerful. Presumably,
	it's used to move all this junk around. "
		
	useSpecialDesc = gPlayerChar.isIn(self)
	specialDesc = "The crane arm extends high into the air over the fenced
		in area of the junkyard. Considering that it's impossible to see
		what's inside that area from here, it's hard to understand how the
		crane could be used to reliably build anything. There's a control panel
		in front of you. "
	
	canObjReachSelf(obj) {return true;}
	canReachSelfFromInside(obj) {return true;}

	dobjFor(Enter) {
		action() {
			inherited;
			specialDesc;
		}
	}

;
++ tetrisCraneControlPanel : Component 'small video control tall thin camera/panel/display/LCD/screen/building' 'control panel'
	"The control panel consists of a display with a 10 digit LCD
	as well as a small video screen.
	<<completeDisplay>>
	There is also a minus button, a plus button,
	and a switch (<<tetrisDiscMagnetSwitch.isOn?'on':'off'>>) labelled magnetize. "
	
	armLoc = 3
	// I flipped the order of the lcd display around when I moved the crane to a different spot.
	// That's why it goes from 9 down to 0 instead of 0 to 9.
	display {
		for(local i=9; i>=armLoc+1; --i) {
			".";
		}
		
		if(craneMagnet.isHoldingBlock())
			"(";
		
		if(craneMagnet.isMagnetized())
			"+";
		else
			"-";

		if(craneMagnet.isHoldingBlock())
			")";

		for(local i=armLoc-1; i>=0; --i) {
			".";
		}
	}
	
	completeDisplay {
		if(gPlayerChar.canSee(tetrisCraneControlPanel)) {
			"The LCD now says <q><<display>></q>. ";
			craneMagnet.describeScreen();
		}
	}
	
	swingLeft() {
		if(armLoc>0) {
			--armLoc;
			"The crane rotates counterclockwise a little bit. ";
		} else {
			"Nothing noticeable happens. ";
		}
		craneMagnet.moveEast();
		craneMagnet.doUpdate();
		completeDisplay();
	}
	swingRight() {
		if(armLoc<9) {
			++armLoc;
			"The crane rotates clockwise a little bit. ";
		} else {
			"Nothing noticeable happens. ";
		}
		craneMagnet.moveWest();
		craneMagnet.doUpdate();
		completeDisplay();
	}
;
+++ Decoration,Hidden
	name = tetrisBlockBeam.name
	vocabWords = tetrisBlockBeam.vocabWords
	desc = tetrisBlockBeam.desc
	
	discovered {return craneMagnet.xPos==tetrisBlockBeam.xPos;}
;
+++ Button, Fixture 'minus button' 'minus button'
	"It's a button with a minus on it. "
	dobjFor(Push) {
		action() {
			tetrisCraneControlPanel.swingRight();
		}
	}
;
+++ Button, Fixture 'plus button' 'plus button'
	"It's a button with a plus on it. "
	dobjFor(Push) {
		action() {
			tetrisCraneControlPanel.swingLeft();
		}
	}
;
/*
+++ tetrisLever : Lever, Fixture 'lever' 'lever'
	"The lever has no distinguishing markings that would indicate what it does. "
	makePulled(pulled) {
		inherited(pulled);
		craneMagnet.doUpdate();
	}
;
*/
+++ tetrisDiscMagnetSwitch : Switch, Fixture 'magnetize switch' 'switch'
	"This is just a simple switch labelled <q>magnetize</q>. "
	makeOn(val) {
		inherited(val);
		craneMagnet.doUpdate();
		tetrisCraneControlPanel.completeDisplay;
	}
	
	dobjFor(Push) asDobjFor(Flip)
	dobjFor(Pull) asDobjFor(Flip)
	dobjFor(Attack) asDobjFor(Flip)
	dobjFor(Turn) asDobjFor(Flip)
;


craneMagnet : Heavy,Thing 'large circular disc' 'large circular disc'
	@tetrisBuildingTopE
	desc {
		if(isLowered) {
			"This is a large thick circular disc attached to a thick wire that is
			attached to the arm of the crane high overhead. ";
		} else {
			"This is a large thick circular disc attached to a thick wire that is
			attached to the arm of the crane high overhead. The disc is sitting on
			the ground here. ";
		}
	}
	
	specialDesc = "A large thick circular disc attached to a thick wire is here. "
	
	isLowered {
//		return tetrisLever.isPulled;
		return true;
	}
	xPos {return tetrisCraneControlPanel.armLoc;}
	isMagnetized {return tetrisDiscMagnetSwitch.isOn;}
	
	moveWest() {
		if(blockGrabbed!=nil)
			blockGrabbed.moveWest();
	}
	moveEast() {
		if(blockGrabbed!=nil)
			blockGrabbed.moveEast();
	}
	
	doUpdate() {
		// Move the magnet to wherever it's supposed to be.
		if(isLowered) {
			if(xPos<=4) {
				craneMagnet.moveIntoForTravel(tetrisBuildingTopE);
			} else {
				craneMagnet.moveIntoForTravel(tetrisBuildingTopW);
			}
		} else {
			if(xPos<=4) {
				craneMagnet.moveIntoForTravel(tetrisBuildingSkyE);
			} else {
				craneMagnet.moveIntoForTravel(tetrisBuildingSkyW);
			}
		}
		
		// grab or drop a block if possible
		if(!isMagnetized) {
			dropBlock();
		} else if(isLowered) {
			grabAnyBlock();
		}
	}
	
	
	grabAnyBlock() {
//		grabBlock(tetrisBlockCube);
		grabBlock(tetrisBlockBeam);
	}
	
	grabBlock(block) {	
		if(blockGrabbed==nil && isLowered) {
			if(xPos>=block.eastEnd && xPos<=block.westEnd) {
				blockGrabbed = block;
				block.moveIntoForTravel(self);
				block.doGrab();
			}
		}
	}
	
	dropBlock() {
		if(blockGrabbed != nil) {
			if(blockGrabbed.westEnd>=5) {
				blockGrabbed.moveIntoForTravel(tetrisBuildingTopW);
			} else {
				blockGrabbed.moveIntoForTravel(tetrisBuildingTopE);
			}
			
			local theBlockToDrop = blockGrabbed;
			blockGrabbed = nil;
			theBlockToDrop.doDrop();
		}
	}
	
	isHoldingBlock() {
		return blockGrabbed!=nil;
	}
	
	// If I just put the blocks in an array then this could be generalized to allow multiple
	// blocks to be used.
	describeScreen() {
		if(isHoldingBlock()) {
			"The screen is dark. It looks like something is in the way of the camera. ";
		} else {
			if(xPos==9)
				"The screen is displaying a picture of the gap between the tall thin building
				and the fence. ";
			else if(xPos==0)
				"The screen is displaying a picture of the edge of the tall thin building butting
				up against the fence. ";
			else
				"The screen is displaying a picture of the top of a tall thin building. ";
			
			if(xPos==tetrisBlockBeam.xPos)
				"There is a metal I-beam in the middle of the display on the top of the building. ";
		}
	}

	blockGrabbed = nil
;
+ Decoration 'arm/crane' 'arm of the crane'
	"The arm of the crane stretches far overhead. "
;
+ Decoration 'thick wire' 'wire'
	"This extremely thick wire runs from the disc up to the arm of the crane. "
;



class TetrisBlock : Heavy,Thing	

	specialDesc {
		if(isGrabbed()) {
			"It is attached to the metal disc. ";
		} else {
			if(westEnd==9) {
				"It is positioned at the west end of the building up against the fence. ";
			} else if(eastEnd==0) {
				"It is positioned at the east end of the building up against the fence. ";
			} else {
				"It is sitting on the top of the building. ";
			}
		}
	}

	xPos = nil
	width = nil
	
	westEnd {return xPos + width - 1;}
	eastEnd {return xPos;}
	
	moveWest() {
		if(westEnd<9)
			++xPos;
	}
	
	moveEast() {
		if(eastEnd>0)
			--xPos;
	}
	
	doGrab() {
	}
	doDrop() {
	}
	
	isGrabbed() {
		return craneMagnet.blockGrabbed==self;
	}
;
/*
tetrisBlockCube : TetrisBlock 'crushed metal cube' 'cube'
//	@tetrisBuildingTopW
	"This is a huge crushed cube of metal. It looks like it was probably a car in its
	previous life before it became a building block. "
	
	specialDesc {
		"A huge metal cube is here. ";
		inherited;
	}
	
	xPos = 8

	width = 2
	initDesc = "A huge cube of metal is positioned against the west wall. "
;
*/
tetrisBlockBeam : TetrisBlock 'dark red (large) (huge) (long) (thin) (metal) I beam/I-beam/Ibeam' 'I-beam'
	@tetrisBuildingTopE
	"The I-beam is a very large long and thin piece of metal. It is also, for some reason,
	colored dark red and is divided into four equally sized parts by thin black lines. "
	
	specialDesc {
		"A huge metal I-beam is here. ";
		inherited;
	}
	
	xPos = 0
	width = 1
//	initDesc = "A tall thin I-beam is standing here. "
	
	doDrop() {
		if(xPos==9) {
			"As the crane magnet is demagnetized, you hear a long shrill scraping,
			as if a humongous metal I-beam had been dropped into a metal shaft.
			The air is filled with shouting as construction workers yell at each other
			to get clear of the area.\b
			
			A KER-THUNK echoes out from the building area and then there is silence.
            Sighs of relief are replaced by urgent shouts to add supports to keep
			the building stable...\b
			
			But there isn't any time.\b
			
			It starts as a high pitched whine and turns into a great rending sound
			as metal supports tear loose, bolts rip from their sockets, and welds tear
			apart as if the building were made of nothing but glue and matchsticks.\b
			
			The crushing eventually comes to a halt and, judging from
			some of the things being said in there, it looks like the first four
			floors have been crushed flat. Good job! ";

			tetrisMachine.winGame();
						
			resetBlock();
			
			nestedAction(StopPlaying);
		}
	}
	
	resetBlock() {
		xPos = 0;
		tetrisBlockBeam.moveIntoForTravel(tetrisBuildingTopE);
	}
;
+ Decoration '(4) (four) equally sized thin black cubical lines/parts' 'parts'
	"The I-beam is divided by thin black lines into four equally sized cubical parts. "
;



/*
//: Add a "hammer" verb
hammer : Thing 'short rubber hammer' 'hammer'
	@tetrisBench
	"This is a short rubber hammer. It doesn't have a fork for pulling nails, it's just
	the kind of hammer that has a big lump of heavy rubber on the end that you can hit
	things with. "
	
	iobjFor(AttackWith) {
		verify() {}
		check() {}
		action() {}
	}
;
*/
