#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <verbs.h>


connectorIntoDuckHuntField : DuckHuntFieldRoomSet,OneWayRoomConnector
	-> duckHuntField
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = sitting;
		}
	}
;


class DuckHuntFieldRoomSet : RoomInSet
	roomSetId = 'DuckHuntFieldRoom'
	
	notifyBeforeArriving() {
	}
	
	notifyBeforeLeaving() {
		duck.disappear();
	}
;



duckHuntField :
	OutdoorRoom, DuckHuntFieldRoomSet 'field'
	"This is a pleasant bog. It smells like the less reputable parts of a cow, but
	there is something peaceful about it. In all directions you can see water with
	clumps of tall reeds and pussy willows growing out of it. You are situated behind a tall
	clump of reeds on a small section of land covered with pebbles. "

	receiveDrop(projectile, desc) {
		if(projectile.ofKind(Pebble)) {
//			"{The dobj/he} sails out a little ways then lands in the water and sinks out of sight. ";
//			obj.moveInto(nil);
		} else {
			"{The dobj/he} sails out a little ways then lands in the water and, lucky for you, floats to shore. ";
			projectile.moveInto(self);
		}
	}
;
+ bogSmell : SimpleOdor 'bog' 'smell'
	"It's probably not a good idea to inhale too deeply. "
;
+ theReeds : Distant 'tall pussy clump/reed/willow*clumps*reeds*willows' 'reeds'
	"Some of the clumps are moving a bit. It might just be the wind. "
	isPlural = true

/*
	canThrowViaPath(obj, dest, op) {
		if(gDobj.ofKind(Ball))	
			return checkStatusSuccess;
		else
			return new CheckStatusFailure('That\'s not really something that you should be throwing away. ');
	}
	checkThrowViaPath(obj, dest, op) {
		return canThrowViaPath(obj,dest,op);
	}
	
	getHitFallDestination(thrownObj, path) {
		return self;
	}
	
    receiveDrop(obj, desc) {
		if(obj.ofKind(Ball)) {
			mainReport('{The obj/it} flies out onto the water and lands well short of the reeds.
			In moments it floats away. ',obj);
			obj.moveInto(nil);
		}
    }	

//	throwTargetCatch (obj, path) {
//		if(obj.ofKind(Ball)) {
//			"The ball flies out onto the water and lands well short of the reeds.
//			In moments it floats away. ";
//			obj.moveInto(nil);
//		} else {
//			inherited;
//		}
//	}


	iobjFor(ThrowAt) {
		verify() {}
		check() {}
		
//		action() {
//			if(gDobj.ofKind(Ball)) {
//				"The ball flies out onto the water and lands well short of the reeds.
//				In moments it floats away. ";
//				gDobj.moveInto(nil);
//			} else {
//				inherited;
//			}
//		}

	}
*/	


	iobjFor(ThrowAt) {
		verify() {
			if(gDobj==nil || !gDobj.ofKind(Pebble))
				inherited;
		}
		check() {
			if(!gDobj.ofKind(Pebble))
				inherited;
		}
//		action() {
//			if(gDobj.ofKind(Pebble)) {
//				"It flies out and lands in the water. Lucky for you it floats back to shore. ";
//				gDobj.moveInto();
//			}
//		}
	}
	
;
+ duckhuntWater : Decoration 'water' 'water'
	"There are clumps of tall reeds sticking out of it. One of the clumps seems to rustle a bit
	every now and then, but it could just be the wind. "
;
+ Decoration 'wind/breeze' 'wind'
	"A very calm wind blows through the bog. "
;
+ Decoration 'small section land ground' 'land'
	"There are pebbles all over the ground. "
;



//pebbleDecoration : Decoration '*pebbles*rocks*stones' 'pebbles'
//	@duckHuntField
//	"The ground is covered with pebbles. "
//;

//pebbles : Dispenser,Fixture '*pebbles*rocks*stones' 'pebbles'
//I changed this to a meaningless name so that players won't ever see it.
pebbles : Dispenser,Fixture 'pebbleDispenser' 'pebbles'
	@duckHuntField
	"The ground is covered with pebbles. "
	
//	isPlural = true
	
	myItemClass = Pebble
	canReturnItem = true	

	notifyRemove(obj) {
		addNewPebbleIfNeeded();
	}
	dobjFor(LookIn) asDobjFor(Examine)
	
	
	// I don't think this works, but I put it in anyways.
    hideFromAll(action)
    {
        return true;
//		!(action.ofKind(ExamineAction)
    }
/*	
	dobjFor(Take) {
		verify() {
			illogical('You can\'t take the pebbles. ');
			logicalRank(80, 'take pebbles');
//			exit;
		}
		check() {
			// Silently hide any attempt to take the pebbles.
			exit;
		}
	}
*/	
	isListed = nil
	isListedInContents = nil
	
	addNewPebbleIfNeeded() {
		if(contents.length <= 1 /*&& pebblesCreated < maxPebblesToCreate*/) {
			addNewPebble();
		}		
	}
	addNewPebble() {
		local newPebble = new Pebble();
		newPebble.moveInto(self);
	}
;
pebble : Pebble
	location=pebbles
	;

pebbleGroup : CollectiveGroup 'pebble*pebbles' 'pebbles'
	desc {
		if(gPlayerChar.isIn(duckHuntField))
			"The ground is covered with pebbles. ";
		else
			"Each pebble is small and flat and suitable for skipping. ";
	}
;


class Pebble : Thing 'small flat rock/pebble/stone*rocks*pebbles*stones' 'pebble'
	"This is a small flat pebble suitable for skipping. "
	
//	beforeAction() {
//		if(isHeldBy(gActor))
//			logicalRank(120, 'held');
//	}
/*
	dobjFor(Default) {
		verify() {
			inherited;
			if(isHeldBy(gActor))
				logicalRank(120, 'held');
		}
	}
	iobjFor(Default) {
		verify() {
			inherited;
			if(isHeldBy(gActor))
				logicalRank(120, 'held');
		}
	}
*/	
	
	dobjFor(ThrowAt) {
		verify() {
			if(isHeldBy(gActor))
				logicalRank(120, 'held');
		}
		preCond = [objHeld]
		action() {
			if(gPlayerChar.isIn(duckHuntField)) {
				"The pebble goes <<gVerbName == 'skim' ? 'skimm' : 'skipp'>>ing off across the water. ";
				duck.appear();
				
				self.moveInto(nil);
			} else {
				inherited;
			}
		}
	}
	
	// This is a verbatim of dobjFor(ThrowAt), but I can't use asDobjFor(ThrowAt) because
	// that would throw an exception due to the lack of iobj. And, I can't do it in reverse
	// with "dobjFor(ThrowAt) asDobjFor(Throw) because that causes a weird message problem.
	// When the player does something like "throw pebble at car" then it responds
	// "What do you want to throw it at?".
	// So, I'm stuck just copying and pasting for this.
	dobjFor(Throw) {
		verify() {
			if(isHeldBy(gActor))
				logicalRank(120, 'held');
		}
		preCond = [objHeld]
		action() {
			if(gPlayerChar.isIn(duckHuntField)) {
				"The pebble goes <<gVerbName == 'skim' ? 'skimm' : 'skipp'>>ing off across the water. ";
				duck.appear();
				
				self.moveInto(nil);
			} else {
				inherited;
			}
		}
	}
	
	
	dobjFor(Drop) {
		action() {
			// inherited needs to be run first in either case so that the text output of "Dropped" is made
			// whether the pebble is going to be deleted or not.
			inherited;
			if(gPlayerChar.isIn(duckHuntField)) {
				self.moveInto(nil);
			}
		}
	}
	
	isEquivalent = true
	collectiveGroup = pebbleGroup
	
	isListed = (!isIn(pebbles))
	isListedInContents = (!isIn(pebbles))
;




duck : UntakeableActor 'evil (looking) mallard/duck*ducks' 'duck'
	"It's a typical mallard. Green head, brown body, and hideous evil red glowing eyes. "

	cannotTakeMsg = 'When you attempt to grab the duck it glares at you with such malevolence and
		hatred that you find yourself unable to force yourself to grab ahold of it. '
	cannotMoveMsg = (cannotTakeMsg)
	cannotPutMsg = (cannotTakeMsg)
	
	appear() {
		if(!isIn(duckHuntField))
			"An evil looking duck flaps out from behind a clump of reeds. ";
	
		moveIntoForTravel(duckHuntField);
		// This shoots the duck if possible.
		hunter.shootDuck();
	}
	getShot() {
		"With visible glee, the bird watcher sights along his gun, shoots, and succeeds in nailing it
		between its evil red eyes. He does a little jig and exclaims, <q>Woo hoo!</q> ";
		moveIntoForTravel(nil);
		
		duckHuntFieldMachine.winGame();
		nestedAction(StopPlaying);		
	}
	
	disappear() {
		moveIntoForTravel(nil);
	}
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"It would be too dangerous to agitate the duck further. It's crazy! ";
		}
	}
	
	iobjFor(ThrowAt) {
		check() {
			replaceAction(Attack, self);
		}
	}
	
	
	specialDesc = "An angry duck is here. "
	
	// This is here so that the player can ask about the duck before actually seeing the duck.
	isKnown=true
;
+ SimpleNoise 'duck noises' 'duck noises'
	"The duck seems to be quacking very angrily. He is certainly ill tempered. Why can't he be
	more like the robin or the pigeon? "
;
+ Decoration 'evil red glowing (duck) eyes' 'duck eyes'
	"Like all duck eyes, they glow with unadulterated evil. "
;
+ Decoration 'green (duck) head' 'green duck head'
	"The green head of a mallard is typically very pretty. However, the beauty of this mallard's head
	is overshadowed by it's malevolent evil red glowing eyes. Truly this is an evil bird. "
;
+ Decoration 'brown (duck) body' 'brown duck body'
	"There is nothing abnormal about the bird's body. "
;
+ duckAttack : AgendaItem
	initiallyActive = true
	isReady = (getActor.canSee(duck))
	invokeItem {
		attackPlayer();
	}
	
	attackPlayer() {
		if(gPlayerChar.isIn(duckHuntField)) {
			"<<attackMsgs.getNextValue>>";
		}
	}
	
	
	attackMsgs : ShuffledList {
		valueList = [
			'<q>QUACK!!!</Q> The duck lunges for your neck, but you manage to fight it off. '
			,'<q>QUACK!!!</Q> The duck bites the man\'s leg. He howls, <q>Ouch! Damn! I hate these things!</q> '
			,'<q>QUACK!!!</Q> The duck stops for a moment and stares at you with all the horrible malevolence that only a duck can bring to bear. '
		]
	}
	
; 

