Attribute VB_Name = "Registro"
Option Explicit

' RegOpenKeyEx, RegCreateKeyEx, RegSetValueEx, RegQueryValueEx, RegCloseKey
Public Const ERROR_SUCCESS = 0&

Public Const HKEY_CLASSES_ROOT = &H80000000
Public Const HKEY_CURRENT_CONFIG = &H80000005
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const HKEY_USERS = &H80000003

Public Const STANDARD_RIGHTS_ALL = &H1F0000
Public Const SYNCHRONIZE = &H100000
Public Const KEY_CREATE_LINK = &H20
Public Const KEY_CREATE_SUB_KEY = &H4
Public Const KEY_ENUMERATE_SUB_KEYS = &H8
Public Const KEY_EVENT = &H1
Public Const KEY_NOTIFY = &H10
Public Const KEY_QUERY_VALUE = &H1
Public Const KEY_SET_VALUE = &H2
Public Const KEY_ALL_ACCESS = ((STANDARD_RIGHTS_ALL Or KEY_QUERY_VALUE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY Or KEY_CREATE_LINK) And (Not SYNCHRONIZE))

Public Const REG_OPTION_VOLATILE = 1
Public Const REG_OPTION_NON_VOLATILE = 0
Public Const REG_OPTION_BACKUP_RESTORE = 4

Public Const REG_CREATED_NEW_KEY = &H1
Public Const REG_OPENED_EXISTING_KEY = &H2

Public Const REG_BINARY = 3
Public Const REG_DWORD = 4
Public Const REG_DWORD_BIG_ENDIAN = 5
Public Const REG_DWORD_LITTLE_ENDIAN = 4
Public Const REG_EXPAND_SZ = 2
Public Const REG_LINK = 6
Public Const REG_MULTI_SZ = 7
Public Const REG_NONE = 0
Public Const REG_RESOURCE_LIST = 8
Public Const REG_SZ = 1

Type SECURITY_ATTRIBUTES
        nLength As Long
        lpSecurityDescriptor As Long
        bInheritHandle As Long
End Type

Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, _
  ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, _
  phkResult As Long) As Long
Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, _
  ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, _
  ByVal dwOptions As Long, ByVal samDesired As Long, lpSecurityAttributes As SECURITY_ATTRIBUTES, _
  phkResult As Long, lpdwDisposition As Long) As Long
Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, _
  ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, _
  lpData As Any, ByVal cbData As Long) As Long
Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, _
  ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, _
  lpData As Any, lpcbData As Long) As Long
Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, _
  ByVal lpSubKey As String) As Long
  
' escribe una clave en el registro del sistema si la clave no existe la crea
' devuelve True si no hubo error o False si se produjo algn error
'   'lClaveRaiz', HKEY_CLASSES_ROOT, HKEY_LOCAL_MACHINE, ...
'   'sClave', clave de la forma 'Software\Compaa\Aplicacin\1.0'
'   'sVariable' nombre de subclave que se aadir bajo la clave anterior
'   'sValor' valor de la subclave
Public Function EscribeClaveRegistro(ByVal lClaveRaiz As Long, ByVal sClave As String, _
  ByVal sVariable As String, ByVal sValor As String) As Boolean
    Dim Segur As SECURITY_ATTRIBUTES
    Dim n As Long, hKey As Long, lModo As Long

    Segur.nLength = Len(Segur)
    Segur.lpSecurityDescriptor = 0
    Segur.bInheritHandle = True
    
    ' crea la clave si no existe, o la abre si existe
    n = RegCreateKeyEx(lClaveRaiz, sClave, 0, "", REG_OPTION_NON_VOLATILE, _
      KEY_ALL_ACCESS, Segur, hKey, lModo)
    If n <> ERROR_SUCCESS Then
        EscribeClaveRegistro = False
        Exit Function
    End If
    
    ' establece el valor de la clave
    ' siempre y cuando no sea una cadena vaca (ya que produce un error de proteccin general)
    If sValor <> "" Then
        n = RegSetValueEx(hKey, sVariable, 0, REG_SZ, ByVal sValor, LenB(StrConv(sValor, vbFromUnicode)) + 1)
        If n <> ERROR_SUCCESS Then
            EscribeClaveRegistro = False
            RegCloseKey hKey
            Exit Function
        End If
    End If
    
    RegCloseKey hKey
    EscribeClaveRegistro = True
    
End Function

' devuelve el valor de una clave del registro del sistema
' devuelve una cadena vaca si se produjo algn error
'   'lClaveRaiz', HKEY_CLASSES_ROOT, HKEY_LOCAL_MACHINE, ...
'   'sClave', clave de la forma 'Software\Compaa\Aplicacin\1.0'
'   'sVariable' nombre de subclave que se encuentra bajo la clave anterior
Public Function LeeClaveRegistro(ByVal lClaveRaiz As Long, ByVal sClave As String, _
  ByVal sVariable As String) As String
    Dim n As Long, hKey As Long, lTam As Long
    Dim s As String

    n = RegOpenKeyEx(lClaveRaiz, sClave, 0, KEY_ALL_ACCESS, hKey)
    If n <> ERROR_SUCCESS Then
        LeeClaveRegistro = ""
        Exit Function
    End If
    
    ' prepara buffer para leer dato
    lTam = 1024
    s = Space(lTam)
    
    n = RegQueryValueEx(hKey, sVariable, 0, REG_SZ, ByVal s, lTam)
    If n <> ERROR_SUCCESS Then
        LeeClaveRegistro = ""
        Exit Function
    End If
    
    RegCloseKey hKey
    
    ' devuelve la cadena, ajustando el tamao y eliminando el caracter final (chr(0))
    LeeClaveRegistro = Left(s, lTam - 1)

End Function

' borra una clave del registro del sistema
'   'lClaveRaiz', HKEY_CLASSES_ROOT, HKEY_LOCAL_MACHINE, ...
'   'sClave', clave de la forma 'Software\Compaa\Aplicacin\1.0'
' NOTA: para borrar completamente la clave es necesario llamar a esta funcin sucesivamente
'   de la siguiente forma:
'                   BorraClaveRegistro("Software\Compaa\Aplicacin\1.0")
'                   BorraClaveRegistro("Software\Compaa\Aplicacin")
'                   BorraClaveRegistro("Software\Compaa")
Public Function BorraClaveRegistro(ByVal lClaveRaiz As Long, ByVal sClave As String) As Boolean
    Dim n As Long, hKey As Long

    n = RegDeleteKey(lClaveRaiz, sClave)
    If n <> ERROR_SUCCESS Then
        BorraClaveRegistro = False
        Exit Function
    End If
    
    RegCloseKey hKey
    BorraClaveRegistro = True

End Function
