#!/usr/bin/tacl
#                                                                     BLACKJACL 
# -----------------------------------------------------------------------------
# Copyright (C) Stuart Allen 2001. All rights resevered.
# -----------------------------------------------------------------------------

variable INDEX
variable COUNTER
variable NODE1
variable NODE2
variable cardA
variable cardB
variable cardC

{+set_node1
set NODE1 = shoe
set COUNTER = random
set COUNTER + 4
repeat
   set NODE1 = NODE1(next)
   set COUNTER - 1;
until COUNTER = 0
}

{+set_node2
set NODE2 = end
set COUNTER = random
set COUNTER + 4
repeat
   set NODE2 = NODE2(previous)
   set COUNTER - 1;
until COUNTER = 0
}

# Optional rules
variable  SOFT_SEVENTEEN	false
variable  DAS			true

location casino : casino

{look
execute "+display_table"
}

constant value			1

constant type			2

	constant number		1
	constant jack		2
	constant queen		3
	constant king		4
	constant ace		5

constant suit			3

	constant hearts		1
	constant diamonds	2
	constant clubs		3
	constant spades		4

constant high-low		9
constant omega2			10
constant ko			11

object shoe	: shoe
  next		d1_two_diamonds

object d1_two_diamonds : two of diamonds
  value		2
  type		number
  suit		diamonds
  next		d1_three_diamonds
  previous	shoe
  high-low	1
  omega2	1
  ko		1

object d1_three_diamonds : three of diamonds
  value		3
  type		number
  suit		diamonds
  next		d1_four_diamonds 
  previous	d1_two_diamonds
  high-low	1
  omega2	1
  ko		1

object d1_four_diamonds : four of diamonds
  value		4
  type		number
  suit		diamonds
  next		d1_five_diamonds
  previous	d1_three_diamonds
  high-low	1
  omega2	2
  ko		1

object d1_five_diamonds : five of diamonds
  value		5
  type		number
  suit		diamonds
  next		d1_six_diamonds
  previous	d1_four_diamonds
  high-low	1
  omega2	2
  ko		1

object d1_six_diamonds : six of diamonds
  value		6
  type		number
  suit		diamonds
  next		d1_seven_diamonds
  previous	d1_five_diamonds
  high-low	1
  omega2	2
  ko		1

object d1_seven_diamonds : seven of diamonds
  value		7
  type		number
  suit		diamonds
  next		d1_eight_diamonds
  previous	d1_six_diamonds
  high-low	0
  omega2	1
  ko		1

object d1_eight_diamonds : eight of diamonds
  value		8
  type		number
  suit		diamonds
  next		d1_nine_diamonds
  previous	d1_seven_diamonds
  high-low	0
  omega2	0
  ko		0

object d1_nine_diamonds : nine of diamonds
  value		9
  type		number
  suit		diamonds
  next		d1_ten_diamonds
  previous	d1_eight_diamonds
  high-low	0
  omega2	-1
  ko		0

object d1_ten_diamonds : ten of diamonds
  value		10
  type		number
  suit		diamonds
  next		d1_jack_diamonds
  previous	d1_nine_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d1_jack_diamonds : jack of diamonds
  value		10
  type		jack
  suit		diamonds
  next		d1_queen_diamonds
  previous	d1_ten_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d1_queen_diamonds : queen of diamonds
  value		10
  type		queen
  suit		diamonds
  next		d1_king_diamonds
  previous	d1_jack_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d1_king_diamonds : king of diamonds
  value		10
  type		king
  suit		diamonds
  next		d1_ace_diamonds
  previous	d1_queen_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d1_ace_diamonds : ace of diamonds
  value		11
  type		ace
  suit		diamonds
  next		d1_two_hearts
  previous	d1_king_diamonds
  high-low	-1
  omega2	-0
  ko		-1

object d1_two_hearts : two of hearts
  value		2
  type		number
  suit		hearts
  next		d1_three_hearts
  previous	d1_ace_diamonds
  high-low	1
  omega2	1
  ko		1

object d1_three_hearts : three of hearts
  value		3
  type		number
  suit		hearts
  next		d1_four_hearts
  previous	d1_two_hearts
  high-low	1
  omega2	1
  ko		1

object d1_four_hearts : four of hearts
  value		4
  type		number
  suit		hearts
  next		d1_five_hearts
  previous	d1_three_hearts
  high-low	1
  omega2	2
  ko		1

object d1_five_hearts : five of hearts
  value		5
  type		number
  suit		hearts
  next		d1_six_hearts
  previous	d1_four_hearts
  high-low	1
  omega2	2
  ko		1

object d1_six_hearts : six of hearts
  value		6
  type		number
  suit		hearts
  next		d1_seven_hearts
  previous	d1_five_hearts
  high-low	1
  omega2	2
  ko		1

object d1_seven_hearts : seven of hearts
  value		7
  type		number
  suit		hearts
  next		d1_eight_hearts
  previous	d1_six_hearts
  high-low	0
  omega2	1
  ko		1

object d1_eight_hearts : eight of hearts
  value		8
  type		number
  suit		hearts
  next		d1_nine_hearts
  previous	d1_seven_hearts
  high-low	0
  omega2	0
  ko		0

object d1_nine_hearts : nine of hearts
  value		9
  type		number
  suit		hearts
  next		d1_ten_hearts
  previous	d1_eight_hearts
  high-low	0
  omega2	-1
  ko		0

object d1_ten_hearts : ten of hearts
  value		10
  type		number
  suit		hearts
  next		d1_jack_hearts
  previous	d1_nine_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d1_jack_hearts : jack of hearts
  value		10
  type		jack
  suit		hearts
  next		d1_queen_hearts
  previous	d1_ten_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d1_queen_hearts : queen of hearts
  value		10
  type		queen
  suit		hearts
  next		d1_king_hearts
  previous	d1_jack_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d1_king_hearts : king of hearts
  value		10
  type		king
  suit		hearts
  next		d1_ace_hearts
  previous	d1_queen_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d1_ace_hearts : ace of hearts
  value		11
  type		ace
  suit		hearts
  next		d1_two_clubs
  previous	d1_king_hearts
  high-low	-1
  omega2	0
  ko		-1

object d1_two_clubs : two of clubs
  value		2
  type		number
  suit		clubs
  next		d1_three_clubs
  previous	d1_ace_hearts
  high-low	1
  omega2	1
  ko		1

object d1_three_clubs : three of clubs
  value		3
  type		number
  suit		clubs
  next		d1_four_clubs
  previous	d1_two_clubs
  high-low	1
  omega2	1
  ko		1

object d1_four_clubs : four of clubs
  value		4
  type		number
  suit		clubs
  next		d1_five_clubs
  previous	d1_three_clubs
  high-low	1
  omega2	2
  ko		1

object d1_five_clubs : five of clubs
  value		5
  type		number
  suit		clubs
  next		d1_six_clubs
  previous	d1_four_clubs
  high-low	1
  omega2	2
  ko		1

object d1_six_clubs : six of clubs
  value		6
  type		number
  suit		clubs
  next		d1_seven_clubs
  previous	d1_five_clubs
  high-low	1
  omega2	2
  ko		1

object d1_seven_clubs : seven of clubs
  value		7
  type		number
  suit		clubs
  next		d1_eight_clubs
  previous	d1_six_clubs
  high-low	0
  omega2	1
  ko		1

object d1_eight_clubs : eight of clubs
  value		8
  type		number
  suit		clubs
  next		d1_nine_clubs
  previous	d1_seven_clubs
  high-low	0
  omega2	0
  ko		0

object d1_nine_clubs : nine of clubs
  value		9
  type		number
  suit		clubs
  next		d1_ten_clubs
  previous	d1_eight_clubs
  high-low	0
  omega2	-1
  ko		0

object d1_ten_clubs : ten of clubs
  value		10
  type		number
  suit		clubs
  next		d1_jack_clubs
  previous	d1_nine_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d1_jack_clubs : jack of clubs
  value		10
  type		jack
  suit		clubs
  next		d1_queen_clubs
  previous	d1_ten_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d1_queen_clubs : queen of clubs
  value		10
  type		queen
  suit		clubs
  next		d1_king_clubs
  previous	d1_jack_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d1_king_clubs : king of clubs
  value		10
  type		king
  suit		clubs
  next		d1_ace_clubs
  previous	d1_queen_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d1_ace_clubs : ace of clubs
  value		11
  type		ace
  suit		clubs
  next		d1_two_spades
  previous	d1_king_clubs
  high-low	-1
  omega2	-0
  ko		-1

object d1_two_spades : two of spades
  value		2
  type		number
  suit		spades
  next		d1_three_spades
  previous	d1_ace_clubs
  high-low	1
  omega2	1
  ko		1

object d1_three_spades : three of spades
  value		3
  type		number
  suit		spades
  next		d1_four_spades
  previous	d1_two_spades
  high-low	1
  omega2	1
  ko		1

object d1_four_spades : four of spades
  value		4
  type		number
  suit		spades
  next		d1_five_spades
  previous	d1_three_spades
  high-low	1
  omega2	2
  ko		1

object d1_five_spades : five of spades
  value		5
  type		number
  suit		spades
  next		d1_six_spades
  previous	d1_four_spades
  high-low	1
  omega2	2
  ko		1

object d1_six_spades : six of spades
  value		6
  type		number
  suit		spades
  next		d1_seven_spades
  previous	d1_five_spades
  high-low	1
  omega2	2
  ko		1

object d1_seven_spades : seven of spades
  value		7
  type		number
  suit		spades
  next		d1_eight_spades
  previous	d1_six_spades
  high-low	0
  omega2	1
  ko		1

object d1_eight_spades : eight of spades
  value		8
  type		number
  suit		spades
  next		d1_nine_spades
  previous	d1_seven_spades
  high-low	0
  omega2	0
  ko		0

object d1_nine_spades : nine of spades
  value		9
  type		number
  suit		spades
  next		d1_ten_spades
  previous	d1_eight_spades
  high-low	0
  omega2	-1
  ko		0

object d1_ten_spades : ten of spades
  value		10
  type		number
  suit		spades
  next		d1_jack_spades
  previous	d1_nine_spades
  high-low	-1
  omega2	-2
  ko		-1

object d1_jack_spades : jack of spades
  value		10
  type		jack
  suit		spades
  next		d1_queen_spades
  previous	d1_ten_spades
  high-low	-1
  omega2	-2
  ko		-1

object d1_queen_spades : queen of spades
  value		10
  type		queen
  suit		spades
  next		d1_king_spades
  previous	d1_jack_spades
  high-low	-1
  omega2	-2
  ko		-1

object d1_king_spades : king of spades
  value		10
  type		king
  suit		spades
  next		d1_ace_spades
  previous	d1_queen_spades
  high-low	-1
  omega2	-2
  ko		-1

object d1_ace_spades : ace of spades
  value		11
  type		ace
  suit		spades
  next		d2_two_diamonds
  previous	d1_king_spades
  high-low	-1
  omega2	0
  ko		-1

object d2_two_diamonds : two of diamonds
  value		2
  type		number
  suit		diamonds
  next		d2_three_diamonds
  previous	d1_ace_spades
  high-low	1
  omega2	1
  ko		1

object d2_three_diamonds : three of diamonds
  value		3
  type		number
  suit		diamonds
  next		d2_four_diamonds 
  previous	d2_two_diamonds
  high-low	1
  omega2	1
  ko		1

object d2_four_diamonds : four of diamonds
  value		4
  type		number
  suit		diamonds
  next		d2_five_diamonds
  previous	d2_three_diamonds
  high-low	1
  omega2	2
  ko		1

object d2_five_diamonds : five of diamonds
  value		5
  type		number
  suit		diamonds
  next		d2_six_diamonds
  previous	d2_four_diamonds
  high-low	1
  omega2	2
  ko		1

object d2_six_diamonds : six of diamonds
  value		6
  type		number
  suit		diamonds
  next		d2_seven_diamonds
  previous	d2_five_diamonds
  high-low	1
  omega2	2
  ko		1

object d2_seven_diamonds : seven of diamonds
  value		7
  type		number
  suit		diamonds
  next		d2_eight_diamonds
  previous	d2_six_diamonds
  high-low	0
  omega2	1
  ko		1

object d2_eight_diamonds : eight of diamonds
  value		8
  type		number
  suit		diamonds
  next		d2_nine_diamonds
  previous	d2_seven_diamonds
  high-low	0
  omega2	0
  ko		0

object d2_nine_diamonds : nine of diamonds
  value		9
  type		number
  suit		diamonds
  next		d2_ten_diamonds
  previous	d2_eight_diamonds
  high-low	0
  omega2	-1
  ko		0

object d2_ten_diamonds : ten of diamonds
  value		10
  type		number
  suit		diamonds
  next		d2_jack_diamonds
  previous	d2_nine_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d2_jack_diamonds : jack of diamonds
  value		10
  type		jack
  suit		diamonds
  next		d2_queen_diamonds
  previous	d2_ten_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d2_queen_diamonds : queen of diamonds
  value		10
  type		queen
  suit		diamonds
  next		d2_king_diamonds
  previous	d2_jack_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d2_king_diamonds : king of diamonds
  value		10
  type		king
  suit		diamonds
  next		d2_ace_diamonds
  previous	d2_queen_diamonds
  high-low	-1
  omega2	-2
  ko		-1

object d2_ace_diamonds : ace of diamonds
  value		11
  type		ace
  suit		diamonds
  next		d2_two_hearts
  previous	d2_king_diamonds
  high-low	-1
  omega2	0
  ko		-1

object d2_two_hearts : two of hearts
  value		2
  type		number
  suit		hearts
  next		d2_three_hearts
  previous	d2_ace_diamonds
  high-low	1
  omega2	1
  ko		1

object d2_three_hearts : three of hearts
  value		3
  type		number
  suit		hearts
  next		d2_four_hearts
  previous	d2_two_hearts
  high-low	1
  omega2	1
  ko		1

object d2_four_hearts : four of hearts
  value		4
  type		number
  suit		hearts
  next		d2_five_hearts
  previous	d2_three_hearts
  high-low	1
  omega2	2
  ko		1

object d2_five_hearts : five of hearts
  value		5
  type		number
  suit		hearts
  next		d2_six_hearts
  previous	d2_four_hearts
  high-low	1
  omega2	2
  ko		1

object d2_six_hearts : six of hearts
  value		6
  type		number
  suit		hearts
  next		d2_seven_hearts
  previous	d2_five_hearts
  high-low	1
  omega2	2
  ko		1

object d2_seven_hearts : seven of hearts
  value		7
  type		number
  suit		hearts
  next		d2_eight_hearts
  previous	d2_six_hearts
  high-low	0
  omega2	1
  ko		1

object d2_eight_hearts : eight of hearts
  value		8
  type		number
  suit		hearts
  next		d2_nine_hearts
  previous	d2_seven_hearts
  high-low	0
  omega2	0
  ko		0

object d2_nine_hearts : nine of hearts
  value		9
  type		number
  suit		hearts
  next		d2_ten_hearts
  previous	d2_eight_hearts
  high-low	0
  omega2	-1
  ko		0

object d2_ten_hearts : ten of hearts
  value		10
  type		number
  suit		hearts
  next		d2_jack_hearts
  previous	d2_nine_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d2_jack_hearts : jack of hearts
  value		10
  type		jack
  suit		hearts
  next		d2_queen_hearts
  previous	d2_ten_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d2_queen_hearts : queen of hearts
  value		10
  type		queen
  suit		hearts
  next		d2_king_hearts
  previous	d2_jack_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d2_king_hearts : king of hearts
  value		10
  type		king
  suit		hearts
  next		d2_ace_hearts
  previous	d2_queen_hearts
  high-low	-1
  omega2	-2
  ko		-1

object d2_ace_hearts : ace of hearts
  value		11
  type		ace
  suit		hearts
  next		d2_two_clubs
  previous	d2_king_hearts
  high-low	-1
  omega2	0
  ko		-1

object d2_two_clubs : two of clubs
  value		2
  type		number
  suit		clubs
  next		d2_three_clubs
  previous	d2_ace_hearts
  high-low	1
  omega2	1
  ko		1

object d2_three_clubs : three of clubs
  value		3
  type		number
  suit		clubs
  next		d2_four_clubs
  previous	d2_two_clubs
  high-low	1
  omega2	1
  ko		1

object d2_four_clubs : four of clubs
  value		4
  type		number
  suit		clubs
  next		d2_five_clubs
  previous	d2_three_clubs
  high-low	1
  omega2	2
  ko		1

object d2_five_clubs : five of clubs
  value		5
  type		number
  suit		clubs
  next		d2_six_clubs
  previous	d2_four_clubs
  high-low	1
  omega2	2
  ko		1

object d2_six_clubs : six of clubs
  value		6
  type		number
  suit		clubs
  next		d2_seven_clubs
  previous	d2_five_clubs
  high-low	1
  omega2	2
  ko		1

object d2_seven_clubs : seven of clubs
  value		7
  type		number
  suit		clubs
  next		d2_eight_clubs
  previous	d2_six_clubs
  high-low	0
  omega2	1
  ko		1

object d2_eight_clubs : eight of clubs
  value		8
  type		number
  suit		clubs
  next		d2_nine_clubs
  previous	d2_seven_clubs
  high-low	0
  omega2	0
  ko		0

object d2_nine_clubs : nine of clubs
  value		9
  type		number
  suit		clubs
  next		d2_ten_clubs
  previous	d2_eight_clubs
  high-low	0
  omega2	-1
  ko		0

object d2_ten_clubs : ten of clubs
  value		10
  type		number
  suit		clubs
  next		d2_jack_clubs
  previous	d2_nine_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d2_jack_clubs : jack of clubs
  value		10
  type		jack
  suit		clubs
  next		d2_queen_clubs
  previous	d2_ten_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d2_queen_clubs : queen of clubs
  value		10
  type		queen
  suit		clubs
  next		d2_king_clubs
  previous	d2_jack_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d2_king_clubs : king of clubs
  value		10
  type		king
  suit		clubs
  next		d2_ace_clubs
  previous	d2_queen_clubs
  high-low	-1
  omega2	-2
  ko		-1

object d2_ace_clubs : ace of clubs
  value		11
  type		ace
  suit		clubs
  next		d2_two_spades
  previous	d2_king_clubs
  high-low	-1
  omega2	0
  ko		-1

object d2_two_spades : two of spades
  value		2
  type		number
  suit		spades
  next		d2_three_spades
  previous	d2_ace_clubs
  high-low	1
  omega2	1
  ko		1

object d2_three_spades : three of spades
  value		3
  type		number
  suit		spades
  next		d2_four_spades
  previous	d2_two_spades
  high-low	1
  omega2	1
  ko		1

object d2_four_spades : four of spades
  value		4
  type		number
  suit		spades
  next		d2_five_spades
  previous	d2_three_spades
  high-low	1
  omega2	2
  ko		1

object d2_five_spades : five of spades
  value		5
  type		number
  suit		spades
  next		d2_six_spades
  previous	d2_four_spades
  high-low	1
  omega2	2
  ko		1

object d2_six_spades : six of spades
  value		6
  type		number
  suit		spades
  next		d2_seven_spades
  previous	d2_five_spades
  high-low	1
  omega2	2
  ko		1

object d2_seven_spades : seven of spades
  value		7
  type		number
  suit		spades
  next		d2_eight_spades
  previous	d2_six_spades
  high-low	0
  omega2	1
  ko		1

object d2_eight_spades : eight of spades
  value		8
  type		number
  suit		spades
  next		d2_nine_spades
  previous	d2_seven_spades
  high-low	0
  omega2	0
  ko		0

object d2_nine_spades : nine of spades
  value		9
  type		number
  suit		spades
  next		d2_ten_spades
  previous	d2_eight_spades
  high-low	0
  omega2	-1
  ko		0

object d2_ten_spades : ten of spades
  value		10
  type		number
  suit		spades
  next		d2_jack_spades
  previous	d2_nine_spades
  high-low	-1
  omega2	-2
  ko		-1

object d2_jack_spades : jack of spades
  value		10
  type		jack
  suit		spades
  next		d2_queen_spades
  previous	d2_ten_spades
  high-low	-1
  omega2	-2
  ko		-1

object d2_queen_spades : queen of spades
  value		10
  type		queen
  suit		spades
  next		d2_king_spades
  previous	d2_jack_spades
  high-low	-1
  omega2	-2
  ko		-1

object d2_king_spades : king of spades
  value		10
  type		king
  suit		spades
  next		d2_ace_spades
  previous	d2_queen_spades
  high-low	-1
  omega2	-2
  ko		-1

object d2_ace_spades : ace of spades
  value		11
  type		ace
  suit		spades
  next		end
  previous	d2_king_spades
  high-low	-1
  omega2	-0
  ko		-1

object end : end
  previous	d2_ace_spades

variable current_hand

	constant bet			1
    constant result			2
	constant total			3
	constant aces			4
	constant aces_as_one	5
	constant cards			6

variable current_player

	constant money			1
	constant hands			2
	constant insurance		3

variable GAME_PHASE

	constant place_bet		1
	constant players_turn	2
	constant dealers_turn	3

grammar blankjacl	>view_table
grammar view		>view_table	
grammar look		>view_table	

{+view_table
execute "+display_table"
}

grammar options >options

{+options
}

grammar help		>help
grammar instructions	>help

{+help
write "The aim of Blackjack is to have a hand with a total value closer"
write "to 21 than the dealer without going over 21. Ten, Jack, Queen and King"
write "all worth 10, an Ace is worth 11 or 1, and all other cards are worth"
write "their face value. An Ace is treated as 11 unless it would put your "
write "hand over 21, in which case it is treated as 1.^"
write "There are two phases to the game of Blackjack. Firstly your must place "
write "your bet, then you must playout the hand you are dealt. To place a "
write "bet and received you cards you must type the command 'bet' followed "
write "by an amount between $25 and $1000. When typing the amount, do not use "
write "the dollar sign. For example:^^"
write "bet 25^"
write "bet 150 etc...^^"
write "When you are playing your hand, the commands available to you will be "
write "displayed based on the current game situation. Unless you hand has "
write "bust (gone over a total value of 21), you will always be able to 'hit' "
write "(receive another card) or 'stay', (finish playing that hand).^^"
write "If the dealers first card is an ace, you will be given the option to "
write "take insurance against the dealer getting blackjack by typing the "
write "command 'insurance'. This must be done before any other action "
write "regarding your hand is taken.^^"
write "If you two cards are of equal value, you will also be given the "
write "the opportunity to split you hand. This takes you two initial cards "
write "and makes two one-card hands from them. This is done using the 'split' "
write "command. These two hands are then played out one at a time as normal. "
write "Be sure to pay attention to the indicator at the bottom of the screen "
write "telling you which card you are currently playing.^^"
write "If the first two card of any hand total 9, 10 or 11, you will be "
write "given the opportunity to 'double'. In this case you initial bet will "
write "be doubled and you will receive one more card only.^^"
write "Below is a list of commands that you can use at any time during the "
write "game:^"
write "restart			loads the game again from scratch.^"
write "quit			exits the game.^"
write "highlow			displays the current high-low card count.^"
write "omega2			displays the current OmegaII card count.^"
write "ko			displays the current KO card count.^"
}

grammar about >about

{+about
centre "BlackJACL"
centre "Copyright (c) 2001 Stuart Allen"
centre "Written using the JACL Adventure Creation Language"
write "^^This program is free software; you can redistribute it and/or"
write "modify it under the terms of the GNU General Public License"
write "as published by the Free Software Foundation; either version 2"
write "of the License, or (at your option) any later version."
write "^^This program is distributed in the hope that it will be useful,"
write "but WITHOUT ANY WARRANTY; without even the implied warranty of"
write "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
write "GNU General Public License for more details."
write "^^You should have received a copy of the GNU General Public License"
write "along with this program; if not, write to the Free Software"
write "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA."
}

{+after
if GAME_PHASE = players_turn
   if current_player(hands) = 2
      write "Now playing " current_hand{the} "^"
   endif
endif
write "^Bankroll: $" current_player(money) " -- "
if GAME_PHASE = place_bet
   write "COMMANDS: bet (25 - 1000).^"
endif
if GAME_PHASE = players_turn
   write "COMMANDS: "
   if current_hand(cards) = 2
      if current_player(hands) = 1
         if dealers_hand(cards) = 1
            if dealers_hand(total) = 11
               if current_player(insurance) = 0
		  write "insurance, "
	       endif
            endif
         endif
      endif
   endif
   if current_hand(cards) = 2
      if current_player(hands) = 1
         execute "+is_pair" 
         if FIRST = SECOND
	    write "split, "
         endif
      endif
   endif
   if current_hand(total) = 9 : current_hand(total) = 10 : current_hand(total) = 11
      if current_player(hands) = 2
         if current_hand(cards) = 1
	    if DAS = 1 
	       write "double, "
	    endif
         endif
      else
         if current_hand(cards) = 2
	    write "double, "
         endif
      endif
   endif
   write "hit or stay.^"
endif
write "Type help for other possible commands.^"
}

grammar insurance	>insurance
grammar i		>insurance

{+insurance
if GAME_PHASE = place_bet
   write "You must first place a bet to begin the hand. To do this, type "
   write "'bet <amount>'.^"
   break
endif
set INDEX = current_hand(bet)
set INDEX / 2
set current_player(insurance) = INDEX
set current_player(money) - INDEX
execute "+display_table"
}

grammar double	>double
grammar d	>double

{+double
if GAME_PHASE = place_bet
   write "You must first place a bet to begin the hand. To do this, type "
   write "'bet <amount>'.^"
   break
endif
set current_player(money) - current_hand(bet)
set current_hand(bet) * 2
execute "+deal_card" current_hand
if current_player(hands) = 1 
   execute "+play_out_dealer"
   break
endif
if current_hand = hand_one
   set current_hand = hand_two
   execute "+display_table"
else
   execute "+play_out_dealer"
endif
}

grammar hit	>hit
grammar h	>hit

{+hit
if GAME_PHASE = place_bet
   write "You must first place a bet to begin the hand. To do this, type "
   write "'bet <amount>'.^"
   break
endif
execute "+deal_card" current_hand
if current_hand(total) > 20
   if current_player(hands) = 1 
      execute "+play_out_dealer"
      break
   endif
   if current_hand = hand_one
      set current_hand = hand_two
   else
      execute "+play_out_dealer"
      break
   endif
endif
execute "+display_table"
}

grammar stay	>stay
grammar s	>stay

{+stay
if GAME_PHASE = place_bet
   write "You must first place a bet to begin the hand. To do this, type "
   write "'bet <amount>'.^"
   break
endif
if current_player(hands) = 1 
   execute "+play_out_dealer"
   break
endif
if current_hand = hand_one
   set current_hand = hand_two
   execute "+display_table"
else
   execute "+play_out_dealer"
endif
}

grammar split	>split
grammar sp	>split

{+split
if GAME_PHASE = place_bet
   write "You must first place a bet to begin the hand. To do this, type "
   write "'bet <amount>'.^"
   break
endif
set hand_two(bet) = hand_one(bet)
set current_player(money) - hand_two(bet)
set current_player(hands) = 2
set hand_one(aces_as_one) = 0
set hand_one(cards) = 1
set hand_two(aces_as_one) = 0
set hand_two(cards) = 1
set FIRST = false
set INDEX = FIRST_CARD
repeat
   if INDEX(parent) = current_hand
      if FIRST = false
         set FIRST = INDEX
      else
         set SECOND = INDEX
      endif
   endif
   set INDEX = INDEX(next)
until INDEX = PAST_LAST
set SECOND(parent) = hand_two
if SECOND(value) = 11
   set hand_two(aces) = 1
   set hand_one(aces) - 1
   if FIRST(value) = 11
	  # Splitting aces...
      set hand_one(total) = 11
      set hand_two(total) = 11
	  execute "+deal_card" hand_one
	  execute "+deal_card" hand_two
	  set current_hand = hand_two
	  execute "+play_out_dealer"
	  break
   endif
endif
set hand_one(total) - SECOND(value)
set hand_two(total) + SECOND(value)
execute "+display_table"
}

variable FIRST_CARD			;The first card of this hand
variable PAST_LAST			;The last card of this hand
variable NEAR_END			;The card twenty five cards from the end
variable PASSED_NEAR_END	;The twenty fifth card from the end been reached

{+shuffle_decks
# Shuffle INDEX number of times
set HIGH-LOW-COUNT = 0
set KO-COUNT = 0
set OMEGA2-COUNT = 0
set INDEX = 150
repeat
	execute "+set_node1"
	execute "+set_node2"
	set cardA = shoe(next)
	set cardB = NODE1(previous)
	set cardC = NODE2(next)
	set shoe(next) = NODE1
	set NODE1(previous) = shoe
	set cardB(next) = cardC
	set cardC(previous) = cardB
	set cardA(previous) = NODE2
	set NODE2(next) = cardA
	set INDEX - 1
until INDEX = 0
set CURRENT_CARD = shoe
execute "+set_near_end"
set PASSED_NEAR_END = false
}

{+set_near_end
set NEAR_END = end
set INDEX = 0
repeat
   set NEAR_END = NEAR_END(previous)
   set INDEX + 1
until INDEX = 25
}

{+display_card
if noun4(type) = number
   if noun4(value) = 10
      print " | T |"
   else
      print " | " noun4(value) " |"
   endif
else
   if noun4(type) = jack
	  print " | J |"
   endif
   if noun4(type) = queen
	  print " | Q |"
   endif
   if noun4(type) = king
	  print " | K |"
   endif
   if noun4(type) = ace
	  print " | A |"
   endif
endif
}

variable CURRENT_CARD

variable HIGH-LOW-COUNT
variable KO-COUNT
variable OMEGA2-COUNT

{+deal_card
set CURRENT_CARD = CURRENT_CARD(next)
set PAST_LAST = CURRENT_CARD(next)
set CURRENT_CARD(parent) = noun4
execute "+increase_total"
set HIGH-LOW-COUNT + CURRENT_CARD(high-low)
set KO-COUNT + CURRENT_CARD(ko)
set OMEGA2-COUNT + CURRENT_CARD(omega2)
if CURRENT_CARD = NEAR_END
   set PASSED_NEAR_END = true
endif
}

{+increase_total
set noun4(total) + CURRENT_CARD(value)
set noun4(cards) + 1
if CURRENT_CARD(value) = 11
   set noun4(aces) + 1
endif
if noun4(total) < 22
   break
endif
if noun4(aces) > noun4(aces_as_one)
   set noun4(total) - 10
   set noun4(aces_as_one) + 1
endif
}

variable FIRST
variable SECOND

{+is_pair
set FIRST = 0
set INDEX = FIRST_CARD
repeat
   if INDEX(parent) = current_hand
      if FIRST = 0
         set FIRST = INDEX(value)
      else
         set SECOND = INDEX(value)
      endif
   endif
   set INDEX = INDEX(next)
until INDEX = PAST_LAST
}

{+intro
set MAX_RAND = end
set MAX_RAND - d1_two_diamonds
set MAX_RAND / 2
set MAX_RAND - 8
clear
write "Shuffling decks, please wait...^"
execute "+shuffle_decks"
clear
set current_player = kryten
set GAME_PHASE = place_bet

# Set the number of hands for the player back to one (dealer can only have one)
set current_player(hands) = 1
set current_hand = hand_one
centre "Blackjack pays 3:2"
centre "Dealer must draw to 16 and stay on all 17s."
centre "Double allowed after split, two decks in shoe."
centre "Insurance pays 2 to 1"
centre "Select your initial bet to start playing."
}

{+play_out_dealer
if SOFT_SEVENTEEN = true
   execute "+soft"
else
   execute "+hard"
endif
execute "+determine_winner" hand_one
if current_player(hands) = 2
   execute "+determine_winner" hand_two
endif
execute "+display_final"
if PASSED_NEAR_END = true
   write "^"
   centre "---[ ALL CARDS ARE ABOUT TO BE SHUFFLED AND RETURNED TO THE SHOE ]---"
endif
set GAME_PHASE = place_bet
}

{+soft
if dealers_hand(total) < 18
   if dealers_hand(total) = 17
      if dealers_hand(aces) = dealers_hand(aces_as_one)
         break
      endif
   endif
   execute "+deal_card" dealers_hand
   execute "+soft"
endif
}

{+hard
if dealers_hand(total) < 17
   repeat
      execute "+deal_card" dealers_hand
   until dealers_hand(total) > 16
endif
}

variable RESULT

{+determine_winner
# Player bust...
if noun4(total) > 21 
   set noun4(result) = 1
   break
endif

# Player got Blackjack...
if noun4(total) = 21
   if noun4(cards) = 2
      if dealers_hand(total) = 21
         if dealers_hand(cards) = 2
            # ...and so did the dealer...
			set current_player(money) + noun4(bet)
			# Pay two to one on insurance
			set current_player(money) + current_player(insurance)
			set current_player(money) + current_player(insurance)
            set noun4(result) = 2
            break
         endif
      endif
      set INDEX = noun4(bet)
      set INDEX / 2
      set COUNTER = noun4(bet)
      set COUNTER * 2
      set COUNTER + INDEX
      set current_player(money) + COUNTER
	  set noun4(result) = 3
      break
   endif
endif

# The dealer got Blackjack
if dealers_hand(total) = 21
   if dealers_hand(cards) = 2
      set noun4(result) = 4
 	  # Pay two to one on insurance
	  set current_player(money) + current_player(insurance)
      set current_player(money) + current_player(insurance)
      break
   endif
endif

# Player equal with dealer...
if noun4(total) = dealers_hand(total)
   set current_player(money) + noun4(bet)
   set noun4(result) = 2
   break
endif

# Dealer bust...
if dealers_hand(total) > 21
   set current_player(money) + noun4(bet)
   set current_player(money) + noun4(bet)
   set noun4(result) = 5
   break
endif

# Player higher than delear...
if noun4(total) > dealers_hand(total)
   set current_player(money) + noun4(bet)
   set current_player(money) + noun4(bet)
   set noun4(result) = 6
   break
endif

# Player not bust, dealer not bust, player lower than dealer...
set noun4(result) = 7
}

{+display_result
if noun4(result) = 1
   write " -- You bust."
   break
endif
if noun4(result) = 2
   write " -- Push"
   break
endif
if noun4(result) = 3
   write " -- Blackjack!"
   break
endif
if noun4(result) = 4
   write " -- Dealer got Blackjack."
   break
endif
if noun4(result) = 5
   write " -- Dealer bust."
   break
endif
if noun4(result) = 6
   write " -- You won."
   break
endif
if noun4(result) = 7
   write " -- Dealer won."
   break
endif
}

{+deal_initial
# Set the number of hands for the player back to one (dealer can only have one)
set current_player(hands) = 1
set current_player(insurance) = 0
set	current_hand = hand_one

# Reset the player's stats
set dealers_hand(aces) = 0
set dealers_hand(aces_as_one) = 0
set dealers_hand(total) = 0
set dealers_hand(cards) = 0

set hand_one(aces) = 0
set hand_one(aces_as_one) = 0
set hand_one(total) = 0
set hand_one(cards) = 0

set hand_two(aces) = 0
set hand_two(aces_as_one) = 0
set hand_two(total) = 0
set hand_two(cards) = 0

#set INDEX = FIRST_CARD
#repeat
#   set INDEX(parent) = 0
#   set INDEX = INDEX(next)
#until INDEX = PAST_LAST

if PASSED_NEAR_END = true
   execute "+shuffle_decks"
endif

# Deal the initial cards out in the correct order
execute "+deal_card" current_hand
set FIRST_CARD = CURRENT_CARD
execute "+deal_card" dealers_hand
execute "+deal_card" current_hand

if current_hand(total) = 21
   execute "+play_out_dealer"
else
   execute "+display_table"
endif
}

{+display_table
clear
# Display the dealer's cards
if dealers_hand(cards) = 1
   write "Dealer's card"
else
   write "Dealer's cards"
endif

execute "+display_hand" dealers_hand

# Display the player's first hand
if current_player(hands) = 1
   write "Your cards -- Total: " hand_one(total)
else
   write "First hand -- Total: " hand_one(total)
endif
write " -- Bet: $" hand_one(bet) 

execute "+display_hand" hand_one

if current_player(hands) = 2
   # Display the player's second hand
   write "Second hand -- Total: " hand_two(total)
   write " -- Bet: $" hand_two(bet) 
   
   execute "+display_hand" hand_two 
endif
}

variable THIS_HAND

{+display_hand
write "^"

set THIS_HAND = noun4
set INDEX = THIS_HAND(cards)
repeat
   print " +---+"
   set INDEX - 1
until INDEX = 0

write "^"

set INDEX = THIS_HAND(cards)
repeat
   print " |   |"
   set INDEX - 1
until INDEX = 0

write "^"

set INDEX = FIRST_CARD
set INDEX = FIRST_CARD
repeat
   if INDEX(parent) = THIS_HAND
      execute "+display_card" INDEX
   endif
   set INDEX = INDEX(next)
until INDEX = PAST_LAST

write "^"

set INDEX = THIS_HAND(cards)
repeat
   print " |   |"
   set INDEX - 1
until INDEX = 0

write "^"

set INDEX = THIS_HAND(cards)
repeat
   print " +---+"
   set INDEX - 1
until INDEX = 0

write "^"
}

{+display_final
clear
# Display the dealer's cards
write "Dealer's cards -- Total: " dealers_hand(total)

execute "+display_hand" dealers_hand

# Display the player's first hand
set current_hand = hand_one
if current_player(hands) = 1
   write "Your cards -- Total: " hand_one(total)
else
   write "First hand --- Total: " hand_one(total)
endif
write " -- Bet: $" hand_one(bet)
execute "+display_result" hand_one
execute "+display_hand" hand_one

if current_player(hands) = 2
   # Display the player's second hand
   write "Second hand -- Total: " hand_two(total)
   write " -- Bet: $" hand_two(bet)
   execute "+display_result" hand_two
   execute "+display_hand" hand_two
   
endif
}

grammar omega2	>omega2
grammar o	>omega2

{+omega2
write "The current Omega-II count is "
execute "+display_count" OMEGA2-COUNT
write ".^"
}

grammar highlow	>highlow
grammar h	>highlow

{+highlow
write "The current HIGH-LOW count is "
execute "+display_count" HIGH-LOW-COUNT
write ".^"
}

grammar ko	>ko
grammar k	>ko

{+ko
write "The current KO count is "
execute "+display_count" KO-COUNT
write ".^"
}

{+display_count
set ARGUMENT = noun4
if ARGUMENT < 1
   write ARGUMENT
else
   write "+" ARGUMENT
endif
}

grammar bet $integer	>bet
grammar b $integer	>bet

{+bet
if GAME_PHASE = players_turn
   write "You can't place a bet until the start of the next hand.^"
   break
endif
if $integer < 25 : $integer > 1000
   write "This table has a minimum bet of $25 and a maxium bet of $1000.^"
   break
endif
set GAME_PHASE = players_turn
set current_player(money) - $integer
set current_hand(bet) = $integer
execute "+deal_initial"
}

object dealer : dealer
  static
  short			name "dealer"

object dealers_hand : dealer_hand
 
object kryten: myself self me james bond
  has			ANIMATE
  short			name "player one"
  quantity		42
  money			2000
  parent		casino
  player

object hand_one : hand one
  short			name "first hand"

object hand_two : hand two
  short			name "second hand"

variable TEMP
variable BACKUP
