/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __list_h
#define __list_h
                          
/*  This list class will allow us to have some sort of reasonable 
	storage for lists of things without using much memory and
	without much hassle in the other parts of the code.  */                          
typedef struct _list list;

#define LGLK_NULL_INDEX ((unsigned)-1)
   
/*  Create a new list.  Items will all be item_size  */
list *lglk_list_create(unsigned item_size);
/*  Delete the list and associated memory  */
void lglk_list_delete(list *l);

/*  Get a new index in the list for an item  */
unsigned lglk_list_add(list *l);

/*  Get a pointer to the item at the given index.  
	If the item isn't there, return NULL  */
void *lglk_list_index(list *l, unsigned ix);

/*  Remove the item at the given index.  The list isn't packed.  */
void lglk_list_remove(list *l, unsigned ix);

/*  Return the index one greater than the last item  */
unsigned lglk_list_size(list *l);
                             
/*  Pack all of the items in the list so that there aren't any empty slots  */                             
void lglk_list_pack(list *l);

#endif
