/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// WinAceView.h : interface of the CWinAceView class
//
/////////////////////////////////////////////////////////////////////////////
//{{AFX_INCLUDES()
#include "webbrowser2.h"
#include "FlagsDialog.h"	// Added by ClassView
//}}AFX_INCLUDES

#if !defined(AFX_WINACEVIEW_H__0F4C77DD_4028_47E4_9A17_D032800AB072__INCLUDED_)
#define AFX_WINACEVIEW_H__0F4C77DD_4028_47E4_9A17_D032800AB072__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FlagTable.h"
#include "ObjectDialog.h"
class CWinAceDoc;
class COutputStream;

class CWinAceView : public CFormView
{
protected: // create from serialization only
	CWinAceView();
	DECLARE_DYNCREATE(CWinAceView)

public:
	//{{AFX_DATA(CWinAceView)
	enum { IDD = IDD_WINACE_FORM };
	CButton	m_Button;
	CEdit	m_prompt;
	CEdit	m_commandControl;
	CWebBrowser2	m_browser2;
	//}}AFX_DATA

// Attributes
public:
	CWinAceDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinAceView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	bool debugging;
	void updateFlags();
	void OnProperties();
	void ClearHTML();
	void AddHTML( CString  html );
	virtual ~CWinAceView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	bool b_initalUpdate;
	COutputStream *OutputStream;
	//{{AFX_MSG(CWinAceView)
	afx_msg void OnButtonClicked();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChangeEdit1();
	afx_msg void OnKillfocusEdit1();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDebugFlags();
	afx_msg void OnDebugParser();
	afx_msg void OnDebugSinglestep();
	afx_msg void OnOptions();
	afx_msg void OnDebugObjects();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	UINT h_timer;
	CObjectDialog * p_objDlg;
	CFlagsDialog *p_flagsDialog;
	bool wantKeyPress;
	bool is_quitting;
};

#ifndef _DEBUG  // debug version in WinAceView.cpp
inline CWinAceDoc* CWinAceView::GetDocument()
   { return (CWinAceDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINACEVIEW_H__0F4C77DD_4028_47E4_9A17_D032800AB072__INCLUDED_)
