/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// ProcessTable.h: interface for the CProcessTable class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROCESSTABLE_H__94E53304_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_PROCESSTABLE_H__94E53304_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ccondact.hpp"

class Condition : public CObject
{
public:
	int Verb;
	int Noun;
	int CondAct;
	
};

class CProcessTable  : public CObject
{
	DECLARE_SERIAL( CProcessTable )
public:
	void dump();
	CProcessTable();
	virtual ~CProcessTable();
	CArray< CCondAct*, CCondAct* > Processes; //The array of condacts
	CArray< Condition*, Condition* > Conditions; // Maps verb,noun combos to position in array
	int ConditionPtr, ProcessPtr;
	int GetProcess( int Verb, int Noun);
	CCondAct* GetCondact( int CondAct );
	void Reset( void ){ ConditionPtr=0; ProcessPtr=0; };
	virtual void Serialize( CArchive &ar );

	int ConditionCount, ProcessCount;
};

#endif // !defined(AFX_PROCESSTABLE_H__94E53304_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
