/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// ObjectList.h: interface for the CObjectList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OBJECTLIST_H__94E53305_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_OBJECTLIST_H__94E53305_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_


#include "CParser.hpp"
#include "ObjectDef.h"	// Added by ClassView
#include "MessageList.h"
#include "FlagTable.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CMessageList;

class CObjectList : public CObject  
{
	DECLARE_SERIAL ( CObjectList )

public:

	int GetObjectCount();
	void BodgeRoom255( int location );
	int ObjectsCarried();
	bool validate( int ObjectNum );

	int GetObject( int Noun, int Adjective,int start=0 );
	CString GetObjectDesc( int ObjNo );
	CString GetObjectDescShort( int ObjNo );
	void SetObject(int ObjNo, CObjectDef *ObjDef );
	CObjectDef *GetObject( int ObjectNo );
	CObjectList( CParser *parser = NULL);	
	void SetObjectDesc( int, CString ); 
	virtual ~CObjectList();
	virtual void Serialize( CArchive &ar );
	int Get( int Obj );
	int Drop( int Obj );
	int Wear( int Obj );
	int Remove( int Obj);
	int TakeOut( int Obj, int Loc );
	int PutIn( int Obj, int Loc );
	void Reset( void );
	void ListCarried();
	void ListAt( int LocNo );
	void SetCurrentObject( void );
	void SetCurrentObject( int ObjNo );
	CMessageList * SysMsgs;

	int MaxObjects;
	CFlagTable *Flags; // Used for Get Drop Etc...

	void GameSerialize( CArchive &ar );

private:
	CArray< CObjectDef *, CObjectDef *> ObjectList;
	CArray< CString, CString > ShortDescription;
	CArray< CString, CString > Descriptions;

	int LastObject;

	CParser *parser;

	

};

#endif // !defined(AFX_OBJECTLIST_H__94E53305_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
