/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// ObjectDef.h: interface for the CObjectDef class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OBJECTDEF_H__94E53308_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_OBJECTDEF_H__94E53308_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "afx.h"

#ifndef __OBJ_STATES
#define __OBJ_STATES

#define OBJ_NOT_CREATED	252
#define OBJ_WORN		253
#define OBJ_CARRIED		254
#define OBJ_HERE		255

#endif

class CObjectDef  : public CObject
{
	DECLARE_SERIAL( CObjectDef )
public:
	bool Absent( int CurrentLocation );
	int ObjWeight;
	int Adjective;
	int Noun;
	int ContainedBy;
	int StartLocation;
	bool Worn;
	bool Wearable;
	bool Container;
	int Location;
	void SetLocation( int NewLocation );
	int GetLocation();
	int GetWeight();
	void SetWeight( int Weight );
	CObjectDef();
	
	virtual ~CObjectDef();
	virtual void Serialize ( CArchive &ar );
	void GameSerialize( CArchive &ar );

};

#endif // !defined(AFX_OBJECTDEF_H__94E53308_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
