/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.swingui.LineEditor;
import org.zmpp.vm.StoryFileHeader;

public class LineEditorImpl
implements LineEditor,
KeyListener,
MouseListener {
    private boolean inputmode;
    private List<Short> editbuffer;
    private StoryFileHeader fileheader;
    private ZsciiEncoding encoding;

    public LineEditorImpl(StoryFileHeader storyFileHeader, ZsciiEncoding zsciiEncoding) {
        this.fileheader = storyFileHeader;
        this.encoding = zsciiEncoding;
        this.editbuffer = new LinkedList<Short>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMode(boolean bl) {
        List<Short> list = this.editbuffer;
        synchronized (list) {
            this.inputmode = bl;
            this.editbuffer.clear();
            this.editbuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelInput() {
        List<Short> list = this.editbuffer;
        synchronized (list) {
            this.editbuffer.add((short)0);
            this.inputmode = false;
            this.editbuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short nextZsciiChar() {
        short s = 0;
        List<Short> list = this.editbuffer;
        synchronized (list) {
            while (this.editbuffer.size() == 0) {
                try {
                    this.editbuffer.wait();
                }
                catch (Exception exception) {}
            }
            s = this.editbuffer.remove(0);
            this.editbuffer.notifyAll();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputMode() {
        List<Short> list = this.editbuffer;
        synchronized (list) {
            return this.inputmode;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 127: {
                this.addToBuffer((short)8);
                break;
            }
            case 32: {
                this.addToBuffer((short)32);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.encoding.isConvertableToZscii(c) && !this.handledInKeyPressed(c)) {
            this.addToBuffer(this.encoding.getZsciiChar(c));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.addToBuffer((short)129);
                break;
            }
            case 40: {
                this.addToBuffer((short)130);
                break;
            }
            case 37: {
                this.addToBuffer((short)131);
                break;
            }
            case 39: {
                this.addToBuffer((short)132);
                break;
            }
            case 27: {
                this.addToBuffer((short)27);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBuffer(short s) {
        if (this.isInputMode()) {
            List<Short> list = this.editbuffer;
            synchronized (list) {
                this.editbuffer.add(s);
                this.editbuffer.notifyAll();
            }
        }
    }

    private boolean handledInKeyPressed(char c) {
        return c == ' ' || c == '\b' || c == '\u007f';
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fileheader.isEnabled(StoryFileHeader.Attribute.USE_MOUSE)) {
            this.fileheader.setMouseCoordinates(mouseEvent.getX(), mouseEvent.getY());
            this.addToBuffer(mouseEvent.getClickCount() == 1 ? (short)254 : 253);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

