\ scoring.f for advtr.f  Leo Wong 11 June 02003 fyj +
((
Exit code.  Will eventually include scoring.  For now, however, ...

The present scoring algorithm is as follows:
  objective:            points:    present total possible:
  getting will into cave    25               25
  each treasure < chest     12               60
  treasure chest itself     14               14
  each treasure > chest     16              144
  surviving            (max-num)*10          30
  not quitting               4                4
  reaching "closng"         25
  "closed": quit/killed     10
            klutzed         25
            wrong way       30 
            success         45               45
  came to Witt's End         1                1
  round out the total        2                2
                                    TOTAL:  350
  (points can also be deducted for using hints)
))

:NONAME  \ 20000
   0 TO score  0 TO mxscor
   \ First tally up the treasures.  Must be in building and not broken.
   \ Give the poor guy 2 points just for finding each treasure.
   maxtrs 1+ 50 DO
     I ptext @ IF
        I chest > IF 16 ELSE
        I chest = IF 14 ELSE
                     12 THEN THEN
        I prop @ 0< 0= IF score 2 + TO score THEN
        I place @ 3 = I prop @ 0= AND IF DUP score + 2 - TO score THEN
        mxscor + TO mxscor
     THEN
   LOOP

   \ Now look at how he finished and how far he got.  Maxdie and numdie
   \ tell us how well he survived.  Gaveup says whether he exited via
   \ quit.  dflag will tell us if he ever got suitably deep into the
   \ cave.  closng still indicates whether he reched the endgame.  And
   \ if he got as far as "caved closed" (indicated by "closed"), then
   \ bonus is zero for mundane exits or 133, 134, 135 if he blew it
   \ (so to speak).
   score maxdie numdie - 10 * + TO score
   mxscor maxdie 10 * + TO mxscor
   scorng gaveup OR 0= IF score 4 + TO score THEN
   mxscor 4 + TO mxscor
   dflag IF score 25 + TO score THEN
   mxscor 25 + TO mxscor
   closng IF score 25 + TO score THEN
   mxscor 25 + TO mxscor
   closed IF
     CASE bonus
        0 OF 10 ENDOF
      135 OF 25 ENDOF
      134 OF 30 ENDOF
      133 OF 45 ENDOF
             0
     ENDCASE score + TO score 
   THEN
   mxscor 45 + TO mxscor

   \ Did he come to Witt's End as he should?
   magzin place @ 108 = IF score 1+ TO score THEN
   mxscor 1+ TO mxscor

   \ round it off.
   score 2 + TO score
   mxscor 2 + TO mxscor

   \ Deduct point for hints.  Hints < 4 are special.  See database
   \ description
   hntmax 1+ 1 DO I hinted @ IF score I 2 hints @ - TO score THEN LOOP

   \ Return to score command if that's where he came from.
   scorng 0= IF   
   \ That should be good enough.  Let's tell him all about it.
    CR CR CR ." You scored " score .
             ." out of a possible " mxscor 0 .R
             ." , using " turns . ." turns."
    
     clsses 1+ 1 DO I CVAL @ score < 0= IF I LEAVE THEN LOOP
     DUP CVAL @ score < ABORT" You just went off my scale! "
     DUP ctext speak
     CR ." To achieve the next higher rating, "
     DUP clsses 1- <
     IF ." you need "
        CVAL @ 1+ score - DUP . ." more point"
        1 > IF [CHAR] s EMIT THEN [CHAR] . EMIT
     ELSE DROP
        ." would be a neat trick!"  CR CR ." Congratulations!!" CR
     THEN
     QUIT
   ELSE "score8241" THEN ; IS ?score
  