import "story/gargoyle"
import "story/stables"
import "story/waterway"

function archway()
	if not archwayVisited then
		gargoyleName = "gargoyle"
		archwayVisited = true
		text "You hitch up your skirts to descend the steps from the cell. You can still hear Leofric and Leofwine disputing one another's precedents."
	end

	clearText()

	image("archways", "cover")

	text [[You emerge into a grand hallway. Columns caked in crumbling stucco breathe dust into the air as you pass them. The place has not been well kept, and despite its size, it has an airless quiet.]]

	if not metGargoyle then
		text [[At one end of the hall is an elaborate corbel arch, framing an austere door. Mounted just beside the rightmost window is a large gargoyle.]]
	else
		text [[The $(gargoyleName) remains on guard at the austere door, his quartz eyes monitoring you as you walk.]]
	end

	if metHobson then
		text [[The sound of Hobson's lute practice wafts out of the stable door, accompanied by the smell of warm straw.]]
	else
		text [[In the shadowed side of the hall, you can make out a faint light coming from under an oversized but rustic wooden door. From beyond it, you can hear the sound of someone plucking the same few notes on a lute, over and over, occasionally breaking off to curse.]]
	end

	if visitedWaterway then
		text [[The slick bars of the waterway gate still present no barrier for someone as small as you.]]
	else
		text [[A rusted wrought iron gate, many times bigger than you are, is set into the wall of the lighter side of the hall. The stone passageway beyond it is wet with mist, and you can hear the sound of running water.]]
	end

	jump "archway_hub"
end

function archway_hub()
	choiceOnce("Check if the birds have stopped fighting.", "archway_checkVultures")
	if gargoyleDoorOpen then
		choice("Go to the Queen's Shrine.", "gargoyle")
	elseif metGargoyle then
		choice("Negotiate with the $(gargoyleName).", "gargoyle")
	else
		choice("Approach the door with the $(gargoyleName).", "gargoyle")
	end

	if metHobson then
		choice("Visit Hobson's stable.", "stables")
	else
		choice("Investigate the source of the music.", "stables")
	end

	if visitedWaterway then
		choice("Slip through the iron gate into the waterway.", "waterway")
	else
		choice("Try and squeeze between the bars of the iron gate.", "waterway")
	end
end

function archway_checkVultures()
    text [[You ascend the steps and listen:]]
    vultureNonsense()
	jump "archway_hub"
end