! This is the C run-time start-off routine.  It's job is to take the
! arguments as put on the stack by EXEC, and to parse them and set them up the
! way _main expects them.

! public labels
	.define	__start
	.define	_environ
#ifdef ACK
	.define	EXIT
	.define	.trpim
	.define	.trppc
#endif ACK
#ifdef _MCRTSO
	.define	_monstartup
	.define	_moncontrol
	.define	__mcleanup
#endif
#ifdef ACK
	.sect	.text
	.sect	.rom
	.sect	.data
	.sect	.bss
#endif ACK
! external references
	.extern	_main
	.extern	_exit
	.extern	_etext
	.extern	_edata
	.extern	_end

	.sect	.text
__start:
#ifdef	_MCRTSO
	pea	_etext		! start profile monitor
	pea	__start
	jsr	_monstartup
	add	#8,sp
#endif
	move.l	sp,a0
	move.l	(a0)+,d0	! long due to lib/exec.c and mm/exec.c
	move.l	d0,d1
	add.l	#1,d1
	asl.l	#2,d1		! pointers are four bytes on 68000
	move.l	a0,a1
	add.l	d1,a1
	move.l	a1,_environ	! save envp in environ
	move.l	a1,-(sp)	! push environ
	move.l	a0,-(sp)	! push argv
	move.w	d0,-(sp)	! push argc
	jsr	_main
	add.l	#10,sp
#ifdef	_MCRTSO			! This should normally be in __exit ??
	clr.l	-(sp)		! stop profile monitor
	jsr	_moncontrol
	add	#4,sp
	jsr	__mcleanup	! write mon.out file
#endif
#ifdef ACK
EXIT:
#endif ACK
	move.w	d0,-(sp)	! push exit status
	jsr	_exit
L0:	bra	L0

#ifdef _MCRTSO
	.extern _mcount
#ifdef ACK
	.define	_procentry
	.define	_procexit

_procentry:
	move.l	4(a6),a1	! callers address
	move.l	(sp),a0		! callees address
	move.l	4(sp),-(sp)
	move.l	a0,-(sp)
	move.l	a1,-(sp)
	jsr	_mcount		! mcount(from_pc, to_pc, arc_ptr)
	add	#12,sp
_procexit:
	rts
#else
	.define	mcount

mcount:	move.l	(sp),a1
	move.l	a0,-(sp)	! UNIX has arc_ptr in a0 (at least for GNU C)
	move.l	a1,-(sp)	! callees address
	move.l	4(a6),-(sp)	! callers address
	jsr	_mcount		! mcount(from_pc, to_pc, arc_ptr)
	add	#12,sp
	rts
#endif
#endif

	.sect	.data
_environ:
	.data4	0
#ifdef ACK
.trpim:	.data2	0
.trppc:	.data4	0
#endif ACK
