| lib88.s

| exported functions

	.define	_codeseg
	.define	_dataseg
	.define	_get_processor
	.define	_inportb
	.define	_oportb
	.define	_peek8
	.define	_peekb
	.define	_peek16
	.define	_peekw
	.define	_peek32
	.define	_poke8
	.define	_pokeb
	.define	_poke16
	.define	_pokew
	.define	_poke32
	.define	_scrclose
	.define	_scrin
	.define	_scrioctl
	.define	_scropen
	.define	_scrout
	.define _symswap
	.define	_ttyclose
	.define	_ttyioctl
	.define	_ttyin
	.define	_ttyopen
	.define	_ttyout

| imported functions

	.extern	_get_con_state
	.extern	_reset_con_state

BACKSPACE	=	8
BIOS_DATA_SEG	=	0x40
  ACTIVE_PAGE	=	0x62	| byte
  ADDR_6845	=	0x63	| word
    CURSOR	=	14	| indexes
    CUR_SIZE	=	10
      CURSOFF	=	0x1000	| no scan lines in range
      CURSON	=	0x0F	| scan lines 0 to 15
    VID_ORG	=	12
  CRT_COLS	=	0x4A	| byte
| CRT_LEN	=	0x4C	| word
  CRT_MODE_SET	=	0x49	| byte
    MONO_MODE	=	7
| CRT_PALETTE	=	0x66	| byte
  CRT_START	=	0x4E	| word
  CURSOR_MODE	=	0x60	| word
  CURSOR_POSN	=	0x50	| word[8]
COM1		=	0x3F8	| COM1 serial port (see data for one used)
COM2		=	0x2F8	| COM2 serial port (see data)
CR		=	13
EOF		=	-1
LF		=	10
SCR_ATTRIB	=	0x3	| cyan text on black background
SCR_CSEGMENT	=	0xB800	| color screen segment
SCR_LENGTH	=	4000
  HSCR_LENGTH	=	SCR_LENGTH/2
SCR_MSEGMENT	=	0xB000	| mono screen segment
SCR_START	=	0
  HSCR_START	=	SCR_START/2
SCR_TOP		=	SCR_START+SCR_LENGTH
SCR_WIDTH	=	160
  HSCR_WIDTH	=	SCR_WIDTH/2
TAB		=	9
TRUE		=	1

| phys_clicks codeseg()

_codeseg:
	mov	ax,cs
	ret

| phys_clicks dataseg()

_dataseg:
	mov	ax,ds
	ret

| get some parameters from documented BIOS work area
| MINIX must update these parameters when db is entered

get_crtc_port:
	mov	cx,ds
	mov	ax,#BIOS_DATA_SEG
	mov	ds,ax
	mov	ax,ADDR_6845
	mov	ds,cx
	ret

get_cstype:
	mov	cx,ds
	mov	ax,#BIOS_DATA_SEG
	mov	ds,ax
	mov	ax,CURSOR_MODE
	mov	ds,cx
	ret

get_cursor_ptr:
	mov	cx,ds
	mov	ax,#BIOS_DATA_SEG
	mov	ds,ax
	movb	bl,ACTIVE_PAGE
	movb	bh,#0
	shl	bx,#1
	mov	ax,CURSOR_POSN(bx)	| row, column in ah, al
	movb	bl,al			| but offset is required
	movb	al,ah			| row, column stored in inferior order
	mulb	CRT_COLS		| slow in the BIOS too
	add	ax,bx
	shl	ax,#1
	add	ax,CRT_START
	mov	ds,cx
	ret

getscr_segment:
	mov	cx,ds
	mov	ax,#BIOS_DATA_SEG
	mov	ds,ax
	movb	al,CRT_MODE_SET
	cmpb	al,#MONO_MODE
	mov	ax,#SCR_MSEGMENT
	je	got_scr_segment
	mov	ax,#SCR_CSEGMENT
got_scr_segment:
	mov	ds,cx
	ret
	
getscr_org:
	mov	cx,ds
	mov	ax,#BIOS_DATA_SEG
	mov	ds,ax
	mov	ax,CRT_START
	mov	ds,cx
	ret

| PUBLIC unsigned get_processor()
| decide processor type among 8088=8086, 80188=80186, 80286, 80386
| return 86, 186, 286 or 386
| 8088=8086 and 80188=80186 push sp as new sp, 80286 and 80386 as old sp
| all but 8088=8086 do shifts mod 32 or 16
| 386 stores 0 for the upper 8 bits of the GDT pointer in 16 bit mode,
| while 286 stores 0xFF
| Preserves all registers except the flags and the return register ax

_get_processor:
	push	sp
	pop	ax
	cmp	ax,sp
	jz	new_processor
	push	cx
	mov	cx,#0x0120
	shlb	ch,cl		| zero tells if 86
	pop	cx
	mov	ax,#86
	jz	got_processor
	mov	ax,#186
	ret

new_processor:
	push	bp
	mov	bp,sp
	sub	sp,#6		| space for GDT ptr
|	sgdt	-6(bp)		| save 3 word GDT ptr
	.byte	0x0F,0x01,0x46,0xFA
	add	sp,#4		| discard 2 words of GDT ptr
	pop	ax		| top word of GDT ptr
	pop	bp
	cmpb	ah,#0		| zero only for 386
	mov	ax,#286
	jnz	got_processor
	mov	ax,#386
got_processor:
	ret

| PUBLIC unsigned inportb( port_t port );
| reads an (unsigned) byte from the i/o port  port  and returns it

_inportb:
	pop	bx
	pop	dx
	dec	sp
	dec	sp
	in
	subb	ah,ah
|	jmp	bx
	push	bx
	ret

| void oportb( port_t port, u8_pt value );
| writes the byte  value  to  the i/o port  port
| this would be outportb except for feeble linkers

_oportb:
	pop	bx
	pop	dx
	pop	ax
	sub	sp,#4
	out
|	jmp	bx
	push	bx
	ret

| PUBLIC u8_pt peek8( struct adr *adr );
| returns then (unsigned) byte at the address  adr

_peek8:
	mov	cx,es
	pop	dx
	pop	bx
	push	bx
	mov	es,4(bx)	| les can no longer be used
	mov	bx,(bx)		| since space is reserved for 32 bit offset
	seg	es
	movb	al,(bx)
	xorb	ah,ah
	mov	es,cx
|	jmp	dx		| asld does this non-portably
	push	dx
	ret

| PUBLIC u8_pt peekb( segment_t segment, u8_t *offset );
| returns the (unsigned) byte at the far pointer  segment:offset

_peekb:
	mov	cx,ds
	pop	dx
	pop	ds
	pop	bx
	sub	sp,#4
	movb	al,(bx)
	subb	ah,ah
	mov	ds,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC u16_t peek16( struct adr *adr );

_peek16:
	mov	cx,es
	pop	dx
	pop	bx
	push	bx
	mov	es,4(bx)
	mov	bx,(bx)
	seg	es
	mov	ax,(bx)
	mov	es,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC u16_t peekw( segment_t segment, u16_t *offset );
| returns the word at the far pointer  segment:offset

_peekw:
	mov	cx,ds
	pop	dx
	pop	ds
	pop	bx
	sub	sp,#4
	mov	ax,(bx)
	mov	ds,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC u32_t peek32( struct adr *adr );

_peek32:
	pop	cx
	pop	bx
	push	bx
	push	es
	mov	es,4(bx)
	mov	bx,(bx)
	seg	es
	mov	ax,(bx)
	seg	es
	mov	dx,2(bx)
	pop	es
|	jmp	cx
	push	cx
	ret

| PUBLIC void poke8( struct adr *adr, u8_pt value );

_poke8:
	mov	cx,es
	pop	dx
	pop	bx
	pop	ax
	push	ax
	push	bx
	mov	es,4(bx)
	mov	bx,(bx)
	seg	es
	movb	(bx),al
	mov	es,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC void pokeb( segment_t segment, u8_t *offset, u8_pt value );
| writes the byte  value  at the far pointer  segment:offset

_pokeb:
	mov	cx,ds
	pop	dx
	pop	ds
	pop	bx
	pop	ax
	sub	sp,#6
	movb	(bx),al
	mov	ds,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC void poke16( struct adr *adr, u16_t value );

_poke16:
	mov	cx,es
	pop	dx
	pop	bx
	pop	ax
	push	ax
	push	bx
	mov	es,4(bx)
	mov	bx,(bx)
	seg	es
	mov	(bx),ax
	mov	es,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC void pokew( segment_t segment, u16_t *offset, u16_t value );
| writes the word value  at the far pointer  segment:offset

_pokew:
	mov	cx,ds
	pop	dx
	pop	ds
	pop	bx
	pop	ax
	sub	sp,#6
	mov	(bx),ax
	mov	ds,cx
|	jmp	dx
	push	dx
	ret

| PUBLIC void poke32( struct adr *adr, u32_t value );

_poke32:
	pop	cx
	pop	bx
	pop	ax
	pop	dx
	push	dx
	push	ax
	push	bx
	push	es
	mov	es,4(bx)
	mov	bx,(bx)
	seg	es
	mov	(bx),ax
	seg	es
	mov	2(bx),dx
	pop	es
|	jmp	cx
	push	cx
	ret

| PUBLIC void scrclose();
| reverse everything done by scropen()

_scrclose:
	push	di
	push	si
	push	es
	mov	bx,u_cstype
	call	set_cstype
	mov	bx,u_cursor_ptr
	call	set_cursor_ptr
	mov	bx,u_scr_org
	call	set_scr_org

	push	ds
	pop	es
	lds	si,scr_ptr	| just to get screen segment
	mov	si,#SCR_START
	mov	di,#db_screen
	mov	cx,#HSCR_LENGTH
	rep
	movw
	push	es
	push	ds
	pop	es
	pop	ds
	mov	si,#u_screen
	mov	di,#SCR_START
	mov	cx,#HSCR_LENGTH
	rep
	movw

	call	_reset_con_state  | just for keyboard
	pop	es
	pop	si
	pop	di
	ret

| PUBLIC char_pt scrin();

_scrin:
	ret

| PUBLIC void scrioctl( int command );
| turn cursor on or off

_scrioctl:
	pop	dx
	pop	ax
	push	ax
	push	dx
	or	ax,ax
	mov	bx,#CURSOFF
	je	set_cstype	| off, don't bother locating
	mov	bx,scr_ptr
	dec	ax
	jne	scrio_ret
	call	set_cursor_ptr
	mov	bx,#CURSON

| set cursor type to bx { ax, bx, dx }

set_cstype:
	mov	ax,#CUR_SIZE * 256 + CUR_SIZE + 1	| pair of indexes

| set crtc register pair al:ah to bl:bh { ax, bx, dx }

set_crtc:
	mov	dx,crtc_port
	xchgb	ah,bl		| get low data in ah, high index in bl
	outw			| write index:data ports in succession
				| don't know if this works with 16 bit bus
	xchg	ax,bx		| get high index in al, high data in ah
	outw
scrio_ret:
	ret

| set hardware cursor to offset bx { ax, bx, dx }

set_cursor_ptr:
	shr	bx,#1
	mov	ax,#CURSOR * 256 + CURSOR + 1
	j	set_crtc

| set screen origin to offset bx { ax, bx, dx }

set_scr_org:
	shr	bx,#1
	mov	ax,#VID_ORG * 256 + VID_ORG + 1
	j	set_crtc

| PUBLIC void scropen();
| set up independent db screen
| save underlying piece of user screen
| with Minix, there are many gotchas
| Minix scrolls by moving the screen origin and there is a glitch when we
| replace it. But it is too much work to use Minix coordinates
| stupid CRTC regs are read-only so we must call O/S to get their state
| the cursor position and size must also be saved
| and all this assumes that the screen mode does not need switching!

_scropen:
	push	di
	push	si
	push	es
	call	_get_con_state
	call	get_crtc_port
	mov	crtc_port,ax
	call	get_cstype
	mov	u_cstype,ax
	call	get_cursor_ptr
	mov	u_cursor_ptr,ax
	call	getscr_org
	mov	u_scr_org,ax

	call	getscr_segment
	mov	scr_ptr + 2,ax
	push	ds
	pop	es
	mov	ds,ax
	mov	si,#SCR_START
	mov	di,#u_screen
	mov	cx,#HSCR_LENGTH
	rep
	movw
	seg	es
	cmpb	scr_garbage,cl	| cl is 0
	je	over_setup_screen
	mov	di,#db_screen
	mov	ax,#SCR_ATTRIB * 256 + ' '
	mov	cx,#HSCR_LENGTH
	rep
	stow
	seg	es
	movb	scr_garbage,cl	| cl is 0
over_setup_screen:
	push	es
	push	ds
	pop	es
	pop	ds
	mov	si,#db_screen
	mov	di,#SCR_START
	mov	cx,#HSCR_LENGTH
	rep
	movw

	mov	bx,#CURSOFF	| don't bother locating while off
	call	set_cstype
	mov	bx,#HSCR_START
	call	set_scr_org
	pop	es
	pop	si
	pop	di
	ret

| PUBLIC void scrout( char_pt c );

_scrout:
	pop	cx
	pop	ax
	dec	sp
	dec	sp
	push	es
	movb	ah,scr_attrib
	les	bx,scr_ptr
	cmpb	al,#' '
	jb	scro_control
scro_normal:
	seg	es		| avoiding stow here, would have to push di
	mov	(bx),ax
	inc	bx
	inc	bx
scro_checktop:
	cmp	bx,#SCR_TOP
	jae	scro_scroll
scro_exit:
	mov	scr_ptr,bx
	pop	es
|	jmp	cx
	push	cx
	ret

scro_control:
	cmpb	al,#CR
	je	scro_cr
	cmpb	al,#LF
	je	scro_lf
	cmpb	al,#TAB
	je	scro_tab
	cmpb	al,#BACKSPACE
	jne	scro_normal
	cmp	bx,#0
	je	scro_exit
	dec	bx
	j	scro_exit

scro_tab:
	movb	al,#' '
scro_totab:
	seg	es
	mov	(bx),ax
	inc	bx
	inc	bx
	test	bx,#0xF		| make bx multiple of 16 to get tabs every 8
	jne	scro_totab
	j	scro_checktop

scro_cr:
	xchg	ax,bx
	mov	bx,#SCR_WIDTH
	xor	dx,dx
	div	bx
	mul	bx
	xchg	bx,ax
	j	scro_exit

scro_lf:
	add	bx,#SCR_WIDTH
	cmp	bx,#SCR_TOP
	jb	scro_exit
scro_scroll:
	sub	bx,#SCR_WIDTH
	mov	scr_ptr,bx
	push	cx
	push	ds
	push	di
	push	si
	push	es
	pop	ds
	mov	di,#SCR_START
	mov	si,#SCR_START+SCR_WIDTH
	mov	cx,#HSCR_LENGTH-HSCR_WIDTH
	rep
	movw
	mov	di,#SCR_TOP-SCR_WIDTH
	movb	al,#' '
	mov	cx,#SCR_WIDTH/2
	rep
	stow
	pop	si
	pop	di
	pop	ds
	pop	cx
	pop	es
|	jmp	cx
	push	cx
	ret

| PUBLIC void symswap( left, right, tableseg, length )
| struct nlist *left;
| struct nlist *right;
| segment_t tableseg;
| unsigned length;		/* must be even */

_symswap:
	push	bp
	mov	bp,sp
	push	di
	push	si
	push	es
	push	ds
	mov	di,4(bp)
	mov	si,6(bp)
	mov	ax,8(bp)
	mov	es,ax
	mov	ds,ax
	mov	cx,10(bp)
	shr	cx,#1
ssloop:
	mov	ax,(di)
	movw
	mov	-2(si),ax
	loop	ssloop
	pop	ds
	pop	es
	pop	si
	pop	di
	pop	bp
	ret

| PUBLIC void ttyclose();

_ttyclose:
	mov	dx,serial_port

| attempt to restore state

	addb	dl,#3		| line control
	movb	al,#0x80	| divisor latch
	out
	addb	dl,#-3		| divisor low
	mov	ax,baud_divisor
	out
	inc	dx		| divisor high
	movb	al,ah
	out
	addb	dl,#2		| line control
	movb	al,u_line_control
	out
	inc	dx		| modem control
	movb	al,u_modem_control
	out
	addb	dl,#-3		| irq enable
	movb	al,u_irq_enable
	out
	ret

| PUBLIC char_pt ttyin();
| input char from tty, return EOF if none

_ttyin:
	mov	dx,serial_port
	addb	dl,#5
	in
	testb	al,#1
	jne	got_ttyin
	mov	ax,#EOF
	ret

got_ttyin:
	addb	dl,#-5
	in
	xorb	ah,ah
	ret

| PUBLIC void ttyioctl( int command );
| copy the user's tty state 

_ttyioctl:
	pop	dx
	pop	ax
	push	ax
	push	dx
	cmp	ax,#2
	jne	ttyio_ret	
	mov	ax,u_baud_divisor
	mov	baud_divisor,ax
	movb	al,u_line_control
	movb	line_control,al
	movb	al,u_modem_control
	movb	modem_control,al
	call	_ttyclose
				| fall into _ttyopen

| PUBLIC void ttyopen();

_ttyopen:
	mov	dx,serial_port

| attempt to save state in combination with setting baud rate,

	addb	dl,#3		| line control
	in
	movb	u_line_control,al
	movb	al,#0x80	| divisor latch
	out
	addb	dl,#-2		| divisor high
	in
	movb	ah,al
	dec	dx		| divisor low
	in
	mov	u_baud_divisor,ax
	mov	ax,baud_divisor
	out
	inc	dx
	movb	al,ah
	out
	addb	dl,#2		| line control
	movb	al,line_control
	out
	inc	dx		| modem control
	in
	movb	u_modem_control,al
	movb	al,modem_control
	out
	addb	dl,#-3		| irq enable
	in
	movb	u_irq_enable,al
	movb	al,#0		| no irqs
	out
ttyio_ret:
	ret

| PUBLIC void ttyout( char_pt c );

_ttyout:
	mov	dx,serial_port
	addb	dl,#5
ttyoloop:
	in
	testb	al,#0x20
	je	ttyoloop
	pop	bx
	pop	ax
	push	ax
	addb	dl,#-5
	out
|	jmp	bx
	push	bx
	ret

	.data
	.even
baud_divisor:
	.word	12		| 115200/9600 for 9600 baud
cursor_ptr:
	.word	HSCR_START
line_control:
	.byte	3		| no div latch, 1 stop bit, no parity, 8 bits
modem_control:
	.byte	3		| no master irq, yes dtr and rts
scr_attrib:
	.byte	SCR_ATTRIB
scr_garbage:
	.byte	TRUE
scr_ptr:
	.word	SCR_START,SCR_CSEGMENT
serial_port:
	.word	COM1

	.bss
	.even
crtc_port:
	.zerow	1
db_screen:
	.space	SCR_LENGTH
kbd_shift:
	.zerow	1
u_cstype:
	.zerow	1
u_cursor_ptr:
	.zerow	1
u_baud_divisor:
	.zerow	1
u_irq_enable:
	.space	1
u_line_control:
	.space	1
u_modem_control:
	.space	1
	.even
u_screen:
	.space	SCR_LENGTH
u_scr_org:
	.zerow	1
