/* The <signal.h> header defines all the ANSI and POSIX signals.
 * MINIX supports all the signals required by POSIX.  They are defined below.
 * Some additional signals are also supported.
 */

#ifndef _SIGNAL_H
#define _SIGNAL_H

#define _NSIG             15	/* number of signals used */

#define SIGHUP	           1	/* hangup */
#define SIGINT             2	/* interrupt (DEL) */
#define SIGQUIT            3	/* quit (ASCII FS) */
#define SIGILL             4	/* illegal instruction */
#define SIGTRAP            5	/* trace trap (not reset when caught) */
#define SIGABRT            6	/* IOT instruction */
#define SIGUNUSED          7	/* spare code */
#define SIGFPE             8	/* floating point exception */
#define SIGKILL            9	/* kill (cannot be caught or ignored) */
#define SIGUSR1           10	/* user defined signal # 1 */
#define SIGSEGV           11	/* segmentation violation */
#define SIGUSR2           12	/* user defined signal # 2 */
#define SIGPIPE           13	/* write on a pipe with no one to read it */
#define SIGALRM           14	/* alarm clock */
#define SIGTERM           15	/* software termination signal from kill */

#define SIGSTKFLT         16	/* used by kernel to indicate stack fault */

/* POSIX requires the following signals to be defined, even if they are
 * not supported.  Here are the definitions, but they are not supported.
 */
#define SIGCHLD           17	/* child process terminated or stopped */
#define SIGCONT           18	/* continue if stopped */
#define SIGSTOP           19	/* stop signal */
#define SIGTSTP           20	/* interactive stop signal */
#define SIGTTIN           21	/* background process wants to read */
#define SIGTTOU           22	/* background process wants to write */

#ifdef _POSIX_SOURCE
#define SA_NOCLDSTOP       1	/* signal parent if child stops */

/* Here are types that are closely associated with signal handling. */
typedef int		sig_atomic_t;
typedef unsigned short	sigset_t;

struct sigaction {		/* parameter to sigaction() call */
  void (*sa_handler);		/* pointer to signal handler */
  sigset_t sa_mask;		/* signals to be blocked during handler */
  int sa_flags;			/* special flags to affect behavior of sig */
}
#endif /* _POSIX_SOURCE */

/* POSIX requires these values for use on system calls involving signals. */
#define SIG_BLOCK          0	/* for blocking signals */
#define SIG_UNBLOCK        1	/* for unblocking signals */
#define SIG_SETMASK        2	/* for setting the signal mask */

/* Macros used as function pointers. */
#define SIG_DFL		((void (*)(int))0)
#define SIG_IGN		((void (*)(int))1)
#define SIG_ERR		((void (*)(int))-1)

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
int kill(pid_t __pid, int __sig);
void (*signal(int __sig, void (*__func)(int)))(int);
int sigemptyset(sigset_t *__set);
int sigfillset(sigset_t *__set);
int sigaddset(sigset_t *__set);
int sigdelset(sigset_t *__set);
int sigismember(sigset_t *__set, int __signo);
int sigaction(int __sig, struct sigaction *__act, struct sigaction *__oact);
int sigprocmask(int __how, sigset_t *__set, sigset_t *__oset);
int sigsuspend(sigset_t *__sigmask);
int raise(int __sig);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
void (*signal())();
#endif

#endif /* _SIGNAL_H */
