static char rcsid[] = "$Author: djh $ $Date: 1991/11/17 13:44:43 $";
static char rcsident[] = "$Header: /mac/src/cap60/applications/lwsrv/RCS/procset.c,v 2.5 1991/11/17 13:44:43 djh Rel djh $";
static char revision[] = "$Revision: 2.5 $";

/*
 * procset - UNIX AppleTalk spooling program: act as a laserwriter
 *   handles simple procset list - assumes procsets in a directory
 *
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University in the
 * City of New York.
 *
 * Edit History:
 *  Created Sept 5, 1987 by cck from lwsrv.
 *
 *
 */

/* PATCH: procset.c.looping, djh@munnari.OZ.AU, 12/11/90 */
/* PATCH: XENIX/file.3, djh@munnari.OZ.AU, 20/11/90 */

#include <stdio.h>
#include <sys/param.h>
#ifndef _TYPES
# include <sys/types.h>		/* assume included by param.h */
#endif
#include <sys/file.h>
#ifdef xenix5
#include <sys/ndir.h>
#else xenix5
#include <sys/dir.h>
#endif xenix5
#include <sys/stat.h>
#include <netat/appletalk.h>
#include <netat/sysvcompat.h>
#include <netat/compat.h>
#ifdef USESTRINGDOTH
# include <string.h>
#else USESTRINGDOTH
# include <strings.h>
#endif USESTRINGDOTH
#ifdef USEDIRENT
# include <sys/dirent.h>
#endif USEDIRENT
#ifdef xenix5
# include <unistd.h>
#endif xenix5
#include "procset.h"
#include "spmisc.h"

extern int verbose;

DictList *dicthead = (DictList *) NULL;	/* dictionary list header */

void
newdictionary(dl)
DictList *dl;
{
  dl->ad_next = dicthead;		/* link it into the list */
  dicthead = dl;
}

DictList *
GetProcSet(psn)
char *psn;
{
  DictList *dl;

  for (dl = dicthead; dl != (DictList *) NULL; dl = dl->ad_next)
    if (strcmp(psn,dl->ad_ver) == 0)
      return(dl);
  return(NULL);
}

void ClearProcSetsSent()
{
  DictList *dl;

  for (dl = dicthead; dl != (DictList *) NULL; dl = dl->ad_next) {
    dl->ad_sent = FALSE;
  }
}

/*
 * checks if the file is there and should be readable
 *
*/
private boolean
checkfile(fn)
char *fn;
{
  struct stat stb;
  if (stat(fn, &stb) < 0)
    return(FALSE);
#ifdef USEDIRENT
  /* sysv follows xpg standards */
  if (S_ISREG(&stb) == 0)		/* make sure regular file */
#else  USEDIRENT
  if (S_ISREG(stb.st_mode) == 0)		/* make sure regular file */
#endif USEDIRENT
    return(FALSE);
  if (access(fn, R_OK) < 0)
    return(FALSE);
  return(TRUE);
}

private boolean
dictselect(d)
#ifdef USEDIRENT
struct dirent *d;
#else  USEDIRENT
struct direct *d;
#endif USEDIRENT
{
  return(checkfile(d->d_name));
}

/*
 * scan dict dir for valid proc sets
 *
*/
void
scandicts(dfn)
char *dfn;
{
  DictList *dl;
#ifdef USEDIRENT
  struct dirent **namelist;
  register struct dirent *dp;
#else  USEDIRENT
  struct direct **namelist;
  register struct direct *dp;
#endif USEDIRENT
  struct stat stb;
  int i, j,nlst;
  char path[MAXPATHLEN];
  char line[1024];			/* reasonable size */
  char *psn;
  static time_t lastried = 0;
  FILE *fp;

  if (stat(dfn, &stb) >= 0) {
    if (lastried == stb.st_mtime) /* directory modified? */
      return;			/* no, nothing to do */
    lastried = stb.st_mtime;
  }
  fprintf(stderr, "lwsrv: (re)Scanning for Procsets\n");
#ifdef USEGETCWD
  if (getcwd(path,sizeof(path)-1) == 0) {
    fprintf(stderr, "lwsrv: Can't get working directory: %s\n", path);
    return;
  }
#else
  if (getwd(path) == 0) {
    fprintf(stderr, "lwsrv: Can't get working directory: %s\n", path);
    return;
  }
#endif
  if (chdir(dfn) < 0) {
    perror("chdir");
    fprintf(stderr, "on path %s\n",dfn);
    (void)chdir(path);			/* try to go back in case... */
    return;
  }
  if ((nlst = scandir(".", &namelist, dictselect, NULL)) < 0) {
    perror(dfn);
    fprintf(stderr, "Can't find dictionary files!\n");
    return;
  }
  for (i = 0, dp = namelist[0]; i < nlst ; i++, dp = namelist[i]) {
    if ((fp = fopen(dp->d_name, "r")) == NULL) 
      goto baddict;
    if (fgets(line, sizeof(line)-1, fp) == NULL) {
      fclose(fp);
      goto baddict;
    }
    if (strncmp(line, "%%BeginProcSet: ",sizeof("%%BeginProcSet: ")-1) != 0) {
      fclose(fp);
      goto baddict;
    }
    fclose(fp);
    for (j = 0; line[j] != '\0'; j++)	/* treat '\r' as eol */
      if (line[j] == '\r' || line[j] == '\n') {
	line[j] = '\0';
	break;
      }
    psn = line+sizeof("%%BeginProcSet:");
    stripspaces(psn);
    if (*psn == '\0')
      goto baddict;
    if ((dl=GetProcSet(psn)) != NULL) {
      if (checkfile(dl->ad_fn))
	goto baddict;
      free(dl->ad_fn);		/* reuse old dl, but drop fn space */
      free(dl->ad_ver);		/* drop ver space */
      dl->ad_fn = NULL;
    } else {
      if ((dl = (DictList *)malloc(sizeof(DictList))) == NULL)
	goto baddict;
      newdictionary(dl);		/* link it into the list */
    }
    dl->ad_ver = strdup(psn);		/* remember proc set name */
    dl->ad_fn = strdup(dp->d_name);	/* remember file name */
    dl->ad_sent = FALSE;
baddict:
    free(dp);
  }
  free(namelist);

  (void)chdir(path);

  if (verbose) {
    for (dl = dicthead; dl != (DictList *) NULL; dl = dl->ad_next)
      fprintf(stderr,"lwsrv: ProcSet '%s' file is '%s/%s'\n",
	    dl->ad_ver,dfn,dl->ad_fn);
  }
}


#define ADBUFZ MAXPATHLEN

private int domultijob = FALSE;

void
setflag_encrypted_instream(flg)
int flg;
{
  domultijob = flg;
}

void
ListProcSet(fn, dictdir, outfile, patchprocset)
char *fn;
char *dictdir;
FILE *outfile;
int patchprocset;
{
  char adbuf[ADBUFZ+1];
  FILE *fd;
  int cnt;

  sprintf(adbuf, "%s/%s",dictdir,fn);
  if ((fd = fopen(adbuf,"r")) != NULL) {
    if (patchprocset && domultijob) {
      fprintf(stderr, "lwsrv: Running in eexec mode\n");
      fprintf(outfile, "%%The following fixes problems where the prep file\n");
      fprintf(outfile, "%%assumes that it is permanently downloaded and an\n");
      fprintf(outfile, "%%eof occurs at the end of the prep (e.g. eexec)\n");
      fprintf(outfile, "2 {(%%stdin) (r) file cvx exec } repeat\n");
    }
    while ((cnt = fread(adbuf,sizeof(char),ADBUFZ,fd)) > 0)
      fwrite(adbuf,sizeof(char),cnt,outfile);
    if (patchprocset && domultijob)
      fprintf(outfile, "%%%%EOF\n");
    fclose(fd);
  } else {
    fprintf(stderr,"lwsrv: ListProcSet: file not found %s\n",adbuf);
    fprintf(outfile,"%% ** ProcSet file %s not found **\n",adbuf);
  }
}


