/*
 * java.h --
 *
 *	Declarations of structures and functions used to implement
 *	the native Java support in Tcl.
 *
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) java.h 1.24 98/02/10 20:03:42
 */

#ifndef _JAVA
#define _JAVA

#include <tcl.h>
#include <jni.h>

#if (TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION == 0) 

/*
 * The following structure is new to 8.1 so we include it here for now.
 */

typedef struct Tcl_SavedResult {
    char *result;
    Tcl_FreeProc *freeProc;
    Tcl_Obj *objResultPtr;
    char *appendResult;
    int appendAvl;
    int appendUsed;
    char resultSpace[TCL_RESULT_SIZE+1];
} Tcl_SavedResult;

#endif

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif


/*
 * The following structure contains cached class information.
 */

typedef struct JavaInfo {
    jclass Object;
    jmethodID toString;
    jclass Interp;
    jmethodID callCommand;
    jmethodID dispose;
    jmethodID interpC;
    jfieldID interpPtr;
    jclass Command;
    jmethodID cmdProc;
    jclass TclObject;
    jmethodID preserve;
    jmethodID release;
    jmethodID getInternalRep;
    jclass TclException;
    jclass CommandWithDispose;
    jmethodID disposeCmd;
    jclass CObject;
    jmethodID newCObjectInstance;
    jfieldID objPtr;
    jclass Extension;
    jmethodID init;
    jclass BlendExtension;
    jmethodID blendC;
    jclass VarTrace;
    jmethodID traceProc;
    jclass Void;		/* java.lang.Void */
    jclass voidTYPE;		/* java.lang.Void.TYPE */
    jclass Notifier;
    jmethodID serviceEvent;
    jmethodID hasEvents;
    jclass NativeLock;
    jclass IdleHandler;
    jmethodID invokeIdle;
    jclass TimerHandler;
    jmethodID invokeTimer;
} JavaInfo;

extern JavaInfo java;

/*
 * The following macros are used to enter and leave the global
 * monitor around native code and to set up the VM environment
 * pointer.
 */

#define JAVA_LOCK()	\
{ \
    (*env)->MonitorEnter(env, java.NativeLock); \
    oldEnv = JavaSetEnv(env); \
}

#define JAVA_UNLOCK()	\
{ \
    JavaSetEnv(oldEnv); \
    (*env)->MonitorExit(env, java.NativeLock); \
}

/*
 * Declarations for functions shared across files.
 */

EXTERN void		JavaAlertNotifier();
EXTERN void		JavaDisposeNotifier();
EXTERN JNIEnv *		JavaGetEnv(Tcl_Interp *interp);
EXTERN Tcl_Interp *	JavaGetInterp(JNIEnv *env, jobject interpObj);
EXTERN char *		JavaGetString(JNIEnv *env, jstring str,
			    int *lengthPtr);
EXTERN Tcl_Obj *	JavaGetTclObj(JNIEnv *env, jobject object);
EXTERN jobject		JavaGetTclObject(JNIEnv *env, Tcl_Obj *objPtr,
			    int *isLocal);
EXTERN int		JavaSetupJava(JNIEnv *env, Tcl_Interp *interp);
EXTERN int		JavaInitBlend(JNIEnv *env, Tcl_Interp *interp,
			    jobject interpObj);
EXTERN void		JavaInitNotifier();
EXTERN void		JavaInterpDeleted(ClientData clientData,
			    Tcl_Interp *interp);
EXTERN void		JavaObjInit();
EXTERN JNIEnv *		JavaSetEnv(JNIEnv *env);
EXTERN void		JavaThrowTclException(JNIEnv *env, Tcl_Interp *interp,
			    int result);

/*
 * Declarations for exported functions.
 */

EXTERN EXPORT(int,Tclblend_Init) _ANSI_ARGS_((Tcl_Interp *interp));


#endif /* _JAVA */
