/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class JavaInfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"class", "baseclass", "dimensions", "events", "fields", "methods", "constructors", "properties", "superclass"};
    private static final int CLASS = 0;
    private static final int BASECLASS = 1;
    private static final int DIMENSIONS = 2;
    private static final int EVENTS = 3;
    private static final int FIELDS = 4;
    private static final int METHODS = 5;
    private static final int CONSTRUCTORS = 6;
    private static final int PROPERTIES = 7;
    private static final int SUPERCLASS = 8;
    private static final String[] propOpts = new String[]{"-type"};
    private static final String[] methOpts = new String[]{"-type", "-static"};
    static final int TYPE_OPT = 0;
    static final int STATIC_OPT = 1;

    /*
     * Unable to fully structure code
     */
    public void cmdProc(Interp var1_1, TclObject[] var2_2) throws TclException {
        var3_3 = var2_2.length - 1;
        var4_4 = false;
        var5_5 = false;
        if (var2_2.length < 2) {
            throw new TclNumArgsException(var1_1, 1, var2_2, "option ?arg arg ...?");
        }
        var8_6 = TclIndex.get(var1_1, var2_2[1], JavaInfoCmd.validCmds, "option", 0);
        switch (var8_6) {
            case 1: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_7 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_7 != null) {
                    var9_16 = var7_7;
                    while (var9_16.isArray()) {
                        var9_16 = var9_16.getComponentType();
                    }
                    var1_1.setResult(var9_16.getName());
                }
                return;
            }
            case 0: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var7_8 = ReflectObject.getClass(var1_1, var2_2[2]);
                if (var7_8 != null) {
                    var1_1.setResult(JavaInfoCmd.getNameFromClass(var7_8));
                }
                return;
            }
            case 2: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_9 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_9 == null) {
                    var1_1.setResult(0);
                    return;
                }
                var1_1.setResult(JavaInfoCmd.getNumDimsFromClass(var7_9));
                return;
            }
            case 3: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var7_10 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                if (var7_10 == null) {
                    var1_1.resetResult();
                    return;
                }
                try {
                    var9_17 = Introspector.getBeanInfo(var7_10);
                }
                catch (IntrospectionException v0) {
                    ** GOTO lbl57
                }
                var10_20 = var9_17.getEventSetDescriptors();
                if (var10_20 != null) {
                    var11_21 = TclList.newInstance();
                    var12_22 = 0;
                    while (var12_22 < var10_20.length) {
                        TclList.append((Interp)var1_1, (TclObject)var11_21, (TclObject)TclString.newInstance(var10_20[var12_22].getListenerType().getName()));
                        ++var12_22;
                    }
                    var1_1.setResult(var11_21);
                    return;
                }
lbl57:
                // 3 sources

                var1_1.resetResult();
                return;
            }
            case 4: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                var9_18 = 2;
                while (var9_18 < var3_3) {
                    var8_6 = TclIndex.get(var1_1, var2_2[var9_18], JavaInfoCmd.methOpts, "option", 0);
                    switch (var8_6) {
                        case 1: {
                            var4_4 = true;
                            break;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                    ++var9_18;
                }
                var7_11 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_11 != null) {
                    var6_23 = JavaInfoCmd.getFieldInfoList(var1_1, var7_11, var4_4, var5_5);
                    var1_1.setResult(var6_23);
                }
                return;
            }
            case 5: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                var9_19 = 2;
                while (var9_19 < var3_3) {
                    var8_6 = TclIndex.get(var1_1, var2_2[var9_19], JavaInfoCmd.methOpts, "option", 0);
                    switch (var8_6) {
                        case 1: {
                            var4_4 = true;
                            break;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                    ++var9_19;
                }
                var7_12 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_12 != null) {
                    var6_24 = JavaInfoCmd.getMethodInfoList(var1_1, var7_12, var4_4, var5_5);
                    var1_1.setResult(var6_24);
                }
                return;
            }
            case 6: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_13 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                if (var7_13 != null) {
                    var6_25 = JavaInfoCmd.getConstructorInfoList(var1_1, var7_13);
                    var1_1.setResult(var6_25);
                }
                return;
            }
            case 7: {
                if (var3_3 < 2 || var3_3 > 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? objOrClass");
                }
                if (var3_3 == 3) {
                    var8_6 = TclIndex.get(var1_1, var2_2[2], JavaInfoCmd.propOpts, "option", 0);
                    var5_5 = true;
                }
                if ((var7_14 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3])) != null) {
                    var6_26 = JavaInfoCmd.getPropInfoList(var1_1, var7_14, var5_5);
                    var1_1.setResult(var6_26);
                }
                return;
            }
            case 8: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_15 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                var1_1.resetResult();
                if (var7_15 != null && (var7_15 = var7_15.getSuperclass()) != null) {
                    var1_1.setResult(JavaInfoCmd.getNameFromClass(var7_15));
                }
                return;
            }
        }
    }

    private static Class getClassFromObj(Interp interp, TclObject tclObject) throws TclException {
        Class clazz;
        try {
            clazz = ReflectObject.getClass(interp, tclObject);
        }
        catch (TclException tclException) {
            try {
                clazz = ClassRep.get(interp, tclObject);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "unknown java class or object \"" + tclObject + "\"");
            }
        }
        return clazz;
    }

    private static TclObject getPropInfoList(Interp interp, Class clazz, boolean bl) throws TclException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new TclException(interp, introspectionException.toString());
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            TclObject tclObject2;
            TclObject tclObject3 = TclList.newInstance();
            if (bl && (tclObject2 = TclString.newInstance(propertyDescriptorArray[n].getPropertyType().getName())) != null) {
                TclList.append((Interp)interp, (TclObject)tclObject3, (TclObject)tclObject2);
            }
            tclObject2 = TclString.newInstance(propertyDescriptorArray[n].getName());
            TclList.append((Interp)interp, (TclObject)tclObject3, (TclObject)tclObject2);
            TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject3);
            ++n;
        }
        return tclObject;
    }

    private static TclObject getFieldInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Field[] fieldArray;
        try {
            fieldArray = clazz.getFields();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < fieldArray.length) {
            boolean bl3;
            boolean bl4 = bl3 = (fieldArray[n].getModifiers() & 8) > 0;
            if (bl3 == bl) {
                TclObject tclObject2 = TclList.newInstance();
                String string = fieldArray[n].getName();
                TclObject tclObject3 = TclString.newInstance(string);
                TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
                Class<?> clazz2 = fieldArray[n].getDeclaringClass();
                if (!clazz2.equals(clazz)) {
                    int n2 = 0;
                    while (n2 < fieldArray.length) {
                        Class<?> clazz3;
                        if (n2 != n && string.equals(fieldArray[n2].getName()) && clazz2.isAssignableFrom(clazz3 = fieldArray[n2].getDeclaringClass())) {
                            tclObject3 = TclString.newInstance(clazz2.getName());
                            TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl2) {
                    TclObject tclObject4 = TclList.newInstance();
                    tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(fieldArray[n].getType()));
                    TclList.append((Interp)interp, (TclObject)tclObject4, (TclObject)tclObject3);
                    TclList.append((Interp)interp, (TclObject)tclObject4, (TclObject)tclObject2);
                    TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject4);
                } else {
                    TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject2);
                }
            }
            ++n;
        }
        return tclObject;
    }

    private static TclObject getMethodInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Method[] methodArray;
        try {
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < methodArray.length) {
            boolean bl3;
            boolean bl4 = bl3 = (methodArray[n].getModifiers() & 8) > 0;
            if (bl3 == bl) {
                TclObject tclObject2 = TclList.newInstance();
                TclObject tclObject3 = TclString.newInstance(methodArray[n].getName());
                TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
                Class<?>[] classArray = methodArray[n].getParameterTypes();
                int n2 = 0;
                while (n2 < classArray.length) {
                    tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(classArray[n2]));
                    TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
                    ++n2;
                }
                if (bl2) {
                    TclObject tclObject4 = TclList.newInstance();
                    TclObject tclObject5 = TclList.newInstance();
                    Class<?>[] classArray2 = methodArray[n].getExceptionTypes();
                    int n3 = 0;
                    while (n3 < classArray2.length) {
                        TclList.append((Interp)interp, (TclObject)tclObject5, (TclObject)TclString.newInstance(classArray2[n3].getName()));
                        ++n3;
                    }
                    TclList.append((Interp)interp, (TclObject)tclObject4, (TclObject)TclString.newInstance(JavaInfoCmd.getNameFromClass(methodArray[n].getReturnType())));
                    TclList.append((Interp)interp, (TclObject)tclObject4, (TclObject)tclObject2);
                    TclList.append((Interp)interp, (TclObject)tclObject4, (TclObject)tclObject5);
                    TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject4);
                } else {
                    TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject2);
                }
            }
            ++n;
        }
        return tclObject;
    }

    private static TclObject getConstructorInfoList(Interp interp, Class clazz) throws TclException {
        Constructor<?>[] constructorArray;
        try {
            constructorArray = clazz.getConstructors();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < constructorArray.length) {
            TclObject tclObject2 = TclList.newInstance();
            TclObject tclObject3 = TclString.newInstance(constructorArray[n].getName());
            TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            int n2 = 0;
            while (n2 < classArray.length) {
                tclObject3 = TclString.newInstance(JavaInfoCmd.getNameFromClass(classArray[n2]));
                TclList.append((Interp)interp, (TclObject)tclObject2, (TclObject)tclObject3);
                ++n2;
            }
            TclList.append((Interp)interp, (TclObject)tclObject, (TclObject)tclObject2);
            ++n;
        }
        return tclObject;
    }

    static int getNumDimsFromClass(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        return n;
    }

    static String getNameFromClass(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append("[]");
            clazz = clazz.getComponentType();
        }
        stringBuffer.insert(0, clazz.getName());
        return stringBuffer.toString();
    }

    private static String getBaseNameFromClass(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.getName();
    }

    JavaInfoCmd() {
    }
}

