
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

/***********************************************************************/
/* Piped compiler: (Quintus only) */
:- dynamic(save_clause/1).
save_clause(none).

main :-
	save(comp,1),
	init_compile,
	compileall,
	halt.
main.

init_compile :-
	set(dummy_counter,0),
	read_one(Clause),
	set(save_clauses,[Clause]).

compileall :-
	read_proc(NameAr, Proc),
        gc(compileproc(NameAr, Proc, Code-[])),
        write_plm(NameAr, Code),
	compileall.
compileall.

read_proc(NameAr, NewProc) :-
	access(save_clauses,Saved),
	read_proc(Saved, NameAr, NewProc).

read_proc([end_of_file], _, _) :- !, fail.
read_proc(Saved, NameAr, NewProc) :-
	read_proc(Saved, Proc, NameAr, NextCls),
	eliminate_disjunctions(Proc,NewProc,NewClauses,Link),
	Link = NextCls,
	set(save_clauses,NewClauses).

% first arg: list of clauses read the time before
% second arg: result
% third argument: Name/Arity of result
% fourth arg: list of clauses read in advance
read_proc([C|Cs], [C|NewCs], NameAr, NextCs) :-
	getname(C, NameAr), !,
	read_proc(Cs, NewCs, NameAr, NextCs).
read_proc([C|Cs], [], _, [C|Cs]).
read_proc([], NewCs, NameAr, NextCs) :-
	read_one(NewC),
	(getname(NewC, NameAr) ->
	    NewCs = [NewC|Rest], read_proc([],Rest,NameAr,NextCs);
	    NewCs = [], NextCs = [NewC]).

read_one(Clause) :-
        read(Cl),
        (Cl=(:-(Directive)) ->
                handle_directive(Directive),
                read_one(Clause);
	Clause = Cl), !.

handle_directive(option(OptList)) :- piped_options(OptList), !.
handle_directive(X) :- X.

% Add options to data base:
piped_options(Opt) :-
	\+((Opt==[]; nonvar(Opt),Opt=[_|_])), !, piped_options([Opt]).
piped_options(OptionList) :-
	set(2, []),
        full_list(OptionList), add_options(OptionList), !.
piped_options(_) :-
        write('/***** ERROR IN OPTION FORMAT *****/'),nl,        
        halt, !.

/***********************************************************************/
