
functor TopdecLrVals(
	   structure Token: TOKEN
	   structure LexBasics: LEX_BASICS
	   structure GrammarUtils: GRAMMAR_UTILS
	     sharing type GrammarUtils.pos = LexBasics.pos
	 )
	 = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Grammar for top-level declarations.			NICK, August 1990. *)

(* We have some divergences from the grammar described in the definition
   document. This is because the correct parsing of SML sometimes requires
   left context to be carried a rather horrific distance into the parse.
   In these cases, we parse a slightly more general syntactic form which
   conforms to LR(1), and then knock out the illegal forms in the reduction
   semantic rules.

	(i)	The parser doesn't know about infix status at all. I had a
		bash at doing a preprocessor which attached the correct infix
		status to identifiers, but it was a bit of a nightmare, and
		dealing with "*" and "=" as well became a *lot* of a nightmare.
		So, all application expressions, patterns and so on are
		parsed just as chains of atomic exp's/pat's. Any infixed
		identifiers are resolved later. This means we have to hang
		onto the "op" attached to identifiers, to be aware of the
		difference between

			f + g

		and

			f op+ g

	(ii)	This grammar parses `<Pat> as <Pat>', and eliminates illegal
		forms (`<Pat> as ...' where <Pat> is not an <OpId> or
		<OpId> : <Ty>) in the reduction rules. This is because a
		correct parse of

			fun F(X : ty as ...)

		requires infinite lookahead to determine whether the `X' can
		be reduced to an <AtPat>, or whether there's an `as'-clause
		following the type expression. This could conceivably be
		fixed in the grammar (much like the disambiguating of LOCAL)
		but would add considerable complexity.

	(iii)	<FValBind> function bindings are a nightmare. The expression

			fun (A infix1 B) infix2 C = ...

		is ambiguous because `A <infix1> B' should be read as two
		infix-separated <AtPat>'s *unless* there's an infix following
		the closing bracket, in which case `A <infix1> B' is part of
		a bracketted <Pat>.

		Because we're resolving infix in a post-pass anyway, this gets
		deferred. The functor Infixing() does all the work - look to
		that for more details.

	(iv)	The grammar actually accepts `op =' in a pattern. This is
		because we want to define equality in terms of the bool type
		declared in the prelude, which precludes us from building `='
		into the initial environment. We reject subsequent declarations
		of `=' during semantic analysis.

		I hate this language.

	(v)	Hey, guess what, I've found another one. Which of the
		following is legal?

			val rec f = fn x => x: int
			val rec f = (fn x => x)
			val rec f = (fn x => x): int -> int

		The Definition is rather political about this (i.e. it
		contradicts itself and doesn't make a commitment one way
		or the other). I've decided to allow the first and third
		alternatives (i.e. `fn match' or `(fn match) : ty') which
		seem to be sort-of in the spirit of the definition. I'm
		making the second form illegal to stop programmers getting
		cocky.

		[MEMO: a couple of remaining bugs. Firstly, nested LOCAL
		 declarations are not handled correctly (see the bug list).
		 Secondly, we aren't lexing the correct tokens for numeric
		 record labels.
		]

	(vi)	Whoops, just found something else. Semicolon dec/strdec/spec
		separators are difficult to do as per the Definition, since
		they are optional everywhere and they separate optional (i.e.
		possibly empty) phrases. We deal with this by giving ";"
		the same status as the phrase class it serves to separate.
		The `compose' functions from GrammarUtils are to swallow
		empty absyn phrases which can result from this treatment.
		Needless to say, this all means that we can't reconstitute
		semicolons in the source (that would require an abstract
		syntax class for them at least). Tough. Real SML programmers
		don't use semicolons.
 *)

open GrammarUtils GrammarUtils.M GrammarUtils.C LexBasics
type arg = unit


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\005\000\013\001\059\000\023\000\064\000\018\000\000\000\
\\001\000\007\000\067\001\009\000\048\000\010\000\047\000\028\000\066\001\
\\059\000\023\000\064\000\018\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\015\000\045\000\021\000\042\000\
\\024\000\040\000\028\000\037\000\032\000\034\000\035\000\032\000\
\\042\000\029\000\043\000\028\000\044\000\072\000\045\000\027\000\
\\047\000\026\000\057\000\025\000\058\000\024\000\059\000\023\000\
\\060\000\022\000\061\000\021\000\062\000\020\000\063\000\019\000\
\\064\000\018\000\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\015\000\045\000\021\000\042\000\
\\024\000\040\000\028\000\037\000\032\000\034\000\035\000\032\000\
\\042\000\029\000\043\000\028\000\045\000\027\000\047\000\026\000\
\\057\000\025\000\058\000\024\000\059\000\023\000\060\000\022\000\
\\061\000\021\000\062\000\020\000\063\000\019\000\064\000\018\000\
\\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\032\000\034\000\058\000\024\000\
\\059\000\023\000\064\000\018\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\032\000\085\000\036\000\084\000\
\\043\000\083\000\045\000\082\000\047\000\081\000\053\000\080\000\
\\059\000\023\000\060\000\022\000\061\000\021\000\062\000\020\000\
\\063\000\019\000\064\000\018\000\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\032\000\085\000\036\000\177\000\
\\043\000\083\000\045\000\082\000\047\000\081\000\053\000\080\000\
\\059\000\023\000\060\000\022\000\061\000\021\000\062\000\020\000\
\\063\000\019\000\064\000\018\000\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\032\000\085\000\043\000\083\000\
\\044\000\174\000\045\000\082\000\047\000\081\000\053\000\080\000\
\\059\000\023\000\060\000\022\000\061\000\021\000\062\000\020\000\
\\063\000\019\000\064\000\018\000\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\032\000\085\000\043\000\083\000\
\\045\000\082\000\047\000\081\000\053\000\080\000\059\000\023\000\
\\060\000\022\000\061\000\021\000\062\000\020\000\063\000\019\000\
\\064\000\018\000\066\000\017\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\038\000\089\001\059\000\023\000\
\\064\000\018\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\058\000\094\000\059\000\023\000\
\\064\000\018\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\058\000\178\000\059\000\023\000\
\\064\000\018\000\000\000\
\\001\000\009\000\048\000\010\000\047\000\059\000\023\000\064\000\018\000\000\000\
\\001\000\009\000\146\000\043\000\145\000\047\000\144\000\064\000\143\000\
\\065\000\142\000\000\000\
\\001\000\009\000\146\000\064\000\143\000\000\000\
\\001\000\013\000\056\000\016\000\159\000\023\000\055\000\034\000\054\000\
\\050\000\053\000\000\000\
\\001\000\013\000\056\000\018\000\055\001\023\000\055\000\034\000\054\000\
\\050\000\053\000\000\000\
\\001\000\013\000\056\000\019\000\053\001\023\000\055\000\034\000\054\000\
\\050\000\053\000\051\000\156\000\000\000\
\\001\000\013\000\056\000\023\000\055\000\031\000\206\000\034\000\054\000\
\\050\000\053\000\000\000\
\\001\000\013\000\056\000\023\000\055\000\034\000\054\000\037\000\191\000\
\\050\000\053\000\000\000\
\\001\000\013\000\056\000\023\000\055\000\034\000\054\000\044\000\158\000\
\\049\000\157\000\050\000\053\000\051\000\156\000\000\000\
\\001\000\014\000\158\002\048\000\158\002\049\000\158\002\050\000\193\000\
\\058\000\232\001\000\000\
\\001\000\014\000\163\000\044\000\241\000\049\000\240\000\050\000\162\000\000\000\
\\001\000\014\000\163\000\050\000\162\000\055\000\199\000\000\000\
\\001\000\014\000\163\000\050\000\162\000\058\000\161\000\000\000\
\\001\000\014\000\163\000\050\000\162\000\058\000\242\000\000\000\
\\001\000\019\000\051\001\000\000\
\\001\000\019\000\052\001\000\000\
\\001\000\019\000\062\001\000\000\
\\001\000\019\000\107\001\000\000\
\\001\000\019\000\120\001\000\000\
\\001\000\019\000\146\001\000\000\
\\001\000\019\000\151\001\000\000\
\\001\000\019\000\178\001\000\000\
\\001\000\019\000\188\001\000\000\
\\001\000\021\000\048\001\043\000\047\001\000\000\
\\001\000\021\000\103\001\000\000\
\\001\000\025\000\185\000\000\000\
\\001\000\025\000\187\000\000\000\
\\001\000\025\000\250\000\000\000\
\\001\000\025\000\126\001\000\000\
\\001\000\025\000\150\001\000\000\
\\001\000\032\000\125\000\059\000\023\000\064\000\018\000\000\000\
\\001\000\040\000\208\000\041\000\207\000\000\000\
\\001\000\040\000\061\001\000\000\
\\001\000\043\000\214\000\000\000\
\\001\000\044\000\154\000\000\000\
\\001\000\044\000\155\000\000\000\
\\001\000\044\000\239\000\000\000\
\\001\000\044\000\245\000\000\000\
\\001\000\044\000\035\001\000\000\
\\001\000\044\000\037\001\049\000\036\001\000\000\
\\001\000\044\000\073\001\000\000\
\\001\000\044\000\152\001\000\000\
\\001\000\044\000\167\001\000\000\
\\001\000\044\000\170\001\000\000\
\\001\000\044\000\171\001\000\000\
\\001\000\046\000\152\000\000\000\
\\001\000\046\000\237\000\000\000\
\\001\000\048\000\151\000\000\000\
\\001\000\048\000\236\000\000\000\
\\001\000\048\000\034\001\000\000\
\\001\000\050\000\033\001\000\000\
\\001\000\050\000\071\001\000\000\
\\001\000\050\000\124\001\000\000\
\\001\000\050\000\129\001\000\000\
\\001\000\050\000\187\001\000\000\
\\001\000\051\000\000\000\067\000\000\000\000\000\
\\001\000\052\000\168\000\059\000\023\000\060\000\062\000\064\000\018\000\
\\066\000\061\000\000\000\
\\001\000\058\000\098\000\059\000\023\000\064\000\018\000\000\000\
\\001\000\058\000\150\000\000\000\
\\001\000\058\000\211\000\000\000\
\\001\000\058\000\234\000\000\000\
\\001\000\058\000\244\000\000\000\
\\001\000\058\000\252\000\000\000\
\\001\000\058\000\006\001\000\000\
\\001\000\058\000\010\001\000\000\
\\001\000\058\000\130\001\000\000\
\\001\000\058\000\153\001\000\000\
\\001\000\058\000\160\001\000\000\
\\001\000\058\000\165\001\000\000\
\\001\000\058\000\189\001\000\000\
\\001\000\059\000\023\000\060\000\062\000\064\000\018\000\066\000\061\000\000\000\
\\001\000\059\000\023\000\064\000\018\000\000\000\
\\001\000\064\000\143\000\000\000\
\\001\000\065\000\181\000\000\000\
\\208\001\000\000\
\\209\001\000\000\
\\210\001\000\000\
\\211\001\000\000\
\\212\001\000\000\
\\213\001\000\000\
\\214\001\000\000\
\\215\001\000\000\
\\216\001\000\000\
\\217\001\000\000\
\\217\001\043\000\115\001\000\000\
\\218\001\000\000\
\\219\001\000\000\
\\220\001\000\000\
\\221\001\000\000\
\\222\001\000\000\
\\223\001\000\000\
\\224\001\000\000\
\\225\001\000\000\
\\226\001\066\000\112\000\000\000\
\\227\001\000\000\
\\228\001\000\000\
\\229\001\000\000\
\\230\001\000\000\
\\231\001\000\000\
\\232\001\000\000\
\\233\001\000\000\
\\234\001\000\000\
\\235\001\059\000\023\000\064\000\018\000\000\000\
\\236\001\000\000\
\\237\001\058\000\098\000\059\000\023\000\064\000\018\000\000\000\
\\238\001\000\000\
\\239\001\009\000\048\000\010\000\047\000\059\000\023\000\064\000\018\000\000\000\
\\240\001\000\000\
\\241\001\058\000\130\001\000\000\
\\242\001\000\000\
\\243\001\058\000\165\001\000\000\
\\244\001\000\000\
\\245\001\000\000\
\\246\001\000\000\
\\247\001\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\000\000\
\\248\001\000\000\
\\249\001\000\000\
\\250\001\000\000\
\\251\001\050\000\210\000\000\000\
\\252\001\000\000\
\\253\001\012\000\191\001\000\000\
\\254\001\000\000\
\\255\001\000\000\
\\000\002\002\000\051\000\000\000\
\\001\002\000\000\
\\002\002\000\000\
\\003\002\012\000\131\001\000\000\
\\004\002\000\000\
\\005\002\000\000\
\\006\002\012\000\183\001\000\000\
\\007\002\000\000\
\\008\002\000\000\
\\009\002\012\000\159\001\000\000\
\\010\002\000\000\
\\011\002\000\000\
\\012\002\054\000\202\001\000\000\
\\013\002\000\000\
\\014\002\000\000\
\\015\002\012\000\195\001\000\000\
\\016\002\000\000\
\\017\002\000\000\
\\018\002\012\000\156\001\000\000\
\\019\002\000\000\
\\020\002\000\000\
\\021\002\012\000\176\001\000\000\
\\022\002\000\000\
\\023\002\000\000\
\\024\002\001\000\030\001\003\000\029\001\004\000\028\001\008\000\027\001\
\\017\000\026\001\020\000\025\001\029\000\024\001\033\000\023\001\
\\038\000\022\001\039\000\021\001\051\000\020\001\000\000\
\\025\002\001\000\030\001\003\000\029\001\004\000\028\001\008\000\027\001\
\\017\000\026\001\020\000\025\001\029\000\024\001\033\000\023\001\
\\038\000\022\001\039\000\021\001\051\000\020\001\000\000\
\\025\002\001\000\030\001\003\000\029\001\004\000\028\001\008\000\027\001\
\\017\000\026\001\020\000\025\001\029\000\024\001\033\000\023\001\
\\038\000\022\001\039\000\021\001\051\000\020\001\059\000\023\000\
\\064\000\018\000\000\000\
\\026\002\000\000\
\\027\002\000\000\
\\028\002\000\000\
\\029\002\000\000\
\\030\002\000\000\
\\031\002\000\000\
\\032\002\000\000\
\\033\002\000\000\
\\034\002\012\000\131\001\000\000\
\\035\002\000\000\
\\036\002\000\000\
\\037\002\000\000\
\\038\002\000\000\
\\039\002\000\000\
\\040\002\000\000\
\\041\002\000\000\
\\042\002\000\000\
\\043\002\000\000\
\\044\002\002\000\051\000\006\000\050\000\008\000\049\000\009\000\048\000\
\\010\000\047\000\011\000\046\000\015\000\045\000\017\000\044\000\
\\020\000\043\000\021\000\042\000\022\000\041\000\024\000\040\000\
\\026\000\039\000\027\000\038\000\028\000\037\000\029\000\036\000\
\\030\000\035\000\032\000\034\000\033\000\033\000\035\000\032\000\
\\038\000\031\000\039\000\030\000\042\000\029\000\043\000\028\000\
\\045\000\027\000\047\000\026\000\057\000\025\000\058\000\024\000\
\\059\000\023\000\060\000\022\000\061\000\021\000\062\000\020\000\
\\063\000\019\000\064\000\018\000\066\000\017\000\000\000\
\\044\002\008\000\049\000\011\000\046\000\017\000\044\000\020\000\043\000\
\\022\000\041\000\026\000\039\000\027\000\038\000\029\000\036\000\
\\030\000\035\000\033\000\033\000\038\000\031\000\039\000\030\000\000\000\
\\045\002\000\000\
\\046\002\000\000\
\\047\002\008\000\049\000\011\000\046\000\017\000\044\000\020\000\043\000\
\\022\000\041\000\026\000\039\000\027\000\038\000\029\000\036\000\
\\030\000\035\000\033\000\033\000\038\000\031\000\039\000\030\000\
\\051\000\103\000\000\000\
\\048\002\007\000\067\001\008\000\049\000\009\000\048\000\010\000\047\000\
\\011\000\046\000\017\000\044\000\020\000\043\000\022\000\041\000\
\\026\000\039\000\027\000\038\000\028\000\066\001\029\000\036\000\
\\030\000\035\000\033\000\033\000\038\000\031\000\039\000\030\000\
\\051\000\103\000\059\000\023\000\064\000\018\000\000\000\
\\048\002\008\000\049\000\011\000\046\000\017\000\044\000\020\000\043\000\
\\022\000\041\000\026\000\039\000\027\000\038\000\029\000\036\000\
\\030\000\035\000\033\000\033\000\038\000\031\000\039\000\030\000\
\\051\000\103\000\000\000\
\\049\002\000\000\
\\050\002\000\000\
\\051\002\000\000\
\\052\002\000\000\
\\053\002\000\000\
\\054\002\000\000\
\\055\002\000\000\
\\056\002\012\000\117\001\000\000\
\\057\002\000\000\
\\058\002\000\000\
\\059\002\000\000\
\\060\002\000\000\
\\061\002\006\000\050\000\000\000\
\\062\002\000\000\
\\063\002\000\000\
\\064\002\012\000\070\001\000\000\
\\065\002\000\000\
\\066\002\000\000\
\\067\002\000\000\
\\068\002\000\000\
\\069\002\000\000\
\\070\002\000\000\
\\071\002\000\000\
\\072\002\000\000\
\\073\002\000\000\
\\074\002\000\000\
\\075\002\000\000\
\\076\002\000\000\
\\077\002\009\000\048\000\010\000\047\000\028\000\037\000\032\000\034\000\
\\043\000\028\000\045\000\027\000\047\000\026\000\057\000\025\000\
\\058\000\024\000\059\000\023\000\060\000\022\000\061\000\021\000\
\\062\000\020\000\063\000\019\000\064\000\018\000\066\000\017\000\000\000\
\\078\002\000\000\
\\079\002\000\000\
\\080\002\059\000\023\000\060\000\062\000\064\000\018\000\066\000\061\000\000\000\
\\081\002\000\000\
\\082\002\013\000\056\000\023\000\055\000\034\000\054\000\049\000\039\001\
\\050\000\053\000\000\000\
\\083\002\000\000\
\\084\002\009\000\048\000\010\000\047\000\015\000\045\000\021\000\042\000\
\\024\000\040\000\028\000\037\000\032\000\034\000\035\000\032\000\
\\042\000\029\000\043\000\028\000\045\000\027\000\047\000\026\000\
\\057\000\025\000\058\000\024\000\059\000\023\000\060\000\022\000\
\\061\000\021\000\062\000\020\000\063\000\019\000\064\000\018\000\
\\066\000\017\000\000\000\
\\085\002\000\000\
\\086\002\013\000\056\000\023\000\055\000\034\000\054\000\049\000\153\000\
\\050\000\053\000\000\000\
\\087\002\000\000\
\\088\002\000\000\
\\089\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\
\\051\000\156\000\000\000\
\\090\002\000\000\
\\091\002\000\000\
\\092\002\000\000\
\\093\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\000\000\
\\094\002\000\000\
\\095\002\000\000\
\\096\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\000\000\
\\097\002\013\000\056\000\034\000\054\000\050\000\053\000\000\000\
\\098\002\013\000\056\000\050\000\053\000\000\000\
\\099\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\000\000\
\\100\002\000\000\
\\101\002\000\000\
\\102\002\054\000\198\000\000\000\
\\103\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\000\000\
\\104\002\000\000\
\\105\002\000\000\
\\106\002\041\000\204\000\000\000\
\\107\002\000\000\
\\108\002\000\000\
\\109\002\000\000\
\\110\002\000\000\
\\111\002\000\000\
\\112\002\000\000\
\\113\002\000\000\
\\114\002\000\000\
\\115\002\000\000\
\\116\002\000\000\
\\117\002\000\000\
\\118\002\000\000\
\\119\002\000\000\
\\120\002\000\000\
\\121\002\000\000\
\\122\002\011\000\046\000\017\000\044\000\020\000\043\000\022\000\041\000\
\\026\000\039\000\027\000\038\000\029\000\110\000\030\000\035\000\
\\033\000\033\000\038\000\031\000\039\000\030\000\051\000\109\000\000\000\
\\123\002\011\000\046\000\017\000\044\000\020\000\043\000\022\000\041\000\
\\026\000\039\000\027\000\038\000\029\000\110\000\030\000\035\000\
\\033\000\033\000\038\000\031\000\039\000\030\000\051\000\109\000\000\000\
\\124\002\000\000\
\\125\002\000\000\
\\126\002\000\000\
\\127\002\012\000\041\001\013\000\056\000\023\000\055\000\034\000\054\000\
\\050\000\053\000\000\000\
\\128\002\000\000\
\\129\002\000\000\
\\130\002\000\000\
\\131\002\000\000\
\\132\002\050\000\187\001\000\000\
\\133\002\000\000\
\\134\002\012\000\140\001\000\000\
\\135\002\000\000\
\\136\002\000\000\
\\137\002\012\000\106\001\000\000\
\\138\002\000\000\
\\139\002\000\000\
\\140\002\012\000\113\001\000\000\
\\141\002\000\000\
\\142\002\000\000\
\\143\002\054\000\144\001\000\000\
\\144\002\000\000\
\\145\002\000\000\
\\146\002\000\000\
\\147\002\012\000\002\001\000\000\
\\148\002\000\000\
\\149\002\000\000\
\\150\002\012\000\195\000\000\000\
\\151\002\000\000\
\\152\002\000\000\
\\153\002\013\000\056\000\023\000\055\000\034\000\054\000\050\000\053\000\
\\054\000\110\001\000\000\
\\154\002\000\000\
\\155\002\000\000\
\\156\002\009\000\048\000\010\000\047\000\032\000\085\000\043\000\083\000\
\\045\000\082\000\047\000\081\000\053\000\080\000\059\000\023\000\
\\060\000\022\000\061\000\021\000\062\000\020\000\063\000\019\000\
\\064\000\018\000\066\000\017\000\000\000\
\\157\002\000\000\
\\158\002\050\000\193\000\000\000\
\\159\002\000\000\
\\160\002\031\000\202\000\000\000\
\\160\002\031\000\202\000\058\000\201\000\000\000\
\\161\002\000\000\
\\162\002\000\000\
\\163\002\000\000\
\\164\002\000\000\
\\165\002\000\000\
\\166\002\000\000\
\\167\002\000\000\
\\168\002\000\000\
\\169\002\000\000\
\\170\002\000\000\
\\171\002\052\000\168\000\059\000\023\000\060\000\062\000\064\000\018\000\
\\066\000\061\000\000\000\
\\172\002\000\000\
\\173\002\000\000\
\\174\002\000\000\
\\175\002\014\000\163\000\050\000\162\000\000\000\
\\176\002\014\000\044\001\000\000\
\\177\002\000\000\
\\178\002\014\000\163\000\049\000\100\001\050\000\162\000\000\000\
\\178\002\049\000\100\001\000\000\
\\179\002\000\000\
\\180\002\009\000\048\000\010\000\047\000\032\000\085\000\043\000\083\000\
\\045\000\082\000\047\000\081\000\053\000\080\000\059\000\023\000\
\\060\000\022\000\061\000\021\000\062\000\020\000\063\000\019\000\
\\064\000\018\000\066\000\017\000\000\000\
\\181\002\000\000\
\\182\002\014\000\163\000\049\000\238\000\050\000\162\000\000\000\
\\183\002\000\000\
\\184\002\009\000\048\000\010\000\047\000\032\000\085\000\043\000\083\000\
\\045\000\082\000\047\000\081\000\053\000\080\000\059\000\023\000\
\\060\000\022\000\061\000\021\000\062\000\020\000\063\000\019\000\
\\064\000\018\000\066\000\017\000\000\000\
\\185\002\000\000\
\\186\002\000\000\
\\187\002\014\000\163\000\050\000\162\000\000\000\
\\188\002\000\000\
\\189\002\056\000\219\000\000\000\
\\190\002\009\000\146\000\059\000\218\000\064\000\143\000\000\000\
\\191\002\000\000\
\\192\002\000\000\
\\193\002\000\000\
\\194\002\000\000\
\\195\002\000\000\
\\196\002\049\000\036\001\000\000\
\\197\002\000\000\
\\198\002\000\000\
\\199\002\000\000\
\\200\002\000\000\
\\201\002\000\000\
\\202\002\059\000\023\000\060\000\062\000\064\000\018\000\066\000\061\000\000\000\
\\203\002\000\000\
\\204\002\000\000\
\\205\002\049\000\136\001\000\000\
\\206\002\000\000\
\\207\002\000\000\
\\208\002\000\000\
\\209\002\000\000\
\\210\002\000\000\
\\211\002\043\000\089\000\065\000\088\000\000\000\
\\212\002\000\000\
\\213\002\049\000\246\000\000\000\
\"
val actionRowNumbers =
"\180\000\090\001\204\000\101\000\
\\099\000\095\000\189\000\228\000\
\\215\000\126\000\203\000\181\000\
\\125\000\123\000\124\000\108\000\
\\086\000\091\001\092\001\107\000\
\\106\000\087\000\102\000\082\000\
\\218\000\222\000\002\000\003\000\
\\005\000\095\001\003\000\012\000\
\\010\000\069\000\186\000\005\001\
\\105\000\105\000\003\000\008\000\
\\008\000\042\000\095\001\003\000\
\\095\001\098\000\097\000\083\000\
\\083\000\083\000\214\000\013\000\
\\003\000\008\000\003\000\179\000\
\\112\000\210\000\111\000\110\000\
\\109\000\070\000\059\000\217\000\
\\221\000\057\000\224\000\046\000\
\\047\000\020\000\208\000\015\000\
\\046\001\069\001\242\000\068\001\
\\024\000\045\001\044\001\054\001\
\\064\001\007\000\006\000\011\000\
\\243\000\084\000\093\001\085\000\
\\231\000\118\000\247\000\100\000\
\\103\000\116\000\090\000\250\000\
\\091\000\184\000\183\000\037\000\
\\187\000\188\000\255\000\000\001\
\\004\001\003\001\038\000\001\001\
\\005\001\069\000\104\000\069\000\
\\019\000\040\001\032\001\253\000\
\\038\001\232\000\240\000\023\000\
\\043\001\088\000\246\000\083\000\
\\244\000\084\000\018\000\043\000\
\\130\000\190\000\071\000\199\000\
\\045\000\135\000\081\001\093\000\
\\078\001\074\001\073\001\229\000\
\\082\001\092\000\086\001\013\000\
\\094\000\235\000\230\000\236\000\
\\003\000\205\000\213\000\003\000\
\\211\000\209\000\003\000\003\000\
\\207\000\003\000\036\001\003\000\
\\013\000\008\000\072\000\021\000\
\\060\000\053\001\055\001\063\001\
\\058\000\066\001\048\000\022\000\
\\050\001\007\001\025\000\006\000\
\\047\001\073\000\049\000\097\001\
\\117\000\115\000\182\000\186\000\
\\002\001\003\000\039\000\249\000\
\\248\000\003\000\074\000\013\000\
\\030\001\008\000\037\001\238\000\
\\008\000\003\000\029\001\004\000\
\\013\000\089\000\095\001\075\000\
\\008\000\095\001\005\001\076\000\
\\000\000\000\000\197\000\198\000\
\\161\000\133\000\134\000\077\001\
\\013\000\013\000\062\000\061\000\
\\085\001\050\000\051\000\220\000\
\\223\000\226\000\227\000\225\000\
\\237\000\009\001\070\001\071\001\
\\008\000\059\001\048\001\052\001\
\\008\000\051\001\008\000\049\001\
\\035\000\012\001\013\000\094\001\
\\085\000\026\000\027\000\017\000\
\\005\001\016\000\003\000\039\001\
\\031\001\239\000\241\000\026\001\
\\042\000\029\001\041\001\251\000\
\\042\000\233\000\044\000\028\000\
\\001\000\196\000\129\000\160\000\
\\202\000\063\000\159\000\158\000\
\\162\000\052\000\163\000\069\000\
\\095\001\012\000\160\000\083\000\
\\095\001\083\000\009\000\083\000\
\\095\001\075\001\072\001\013\000\
\\083\001\014\000\013\000\084\001\
\\216\000\082\000\006\001\005\000\
\\061\001\062\001\008\000\065\001\
\\067\001\036\000\008\000\019\001\
\\096\001\191\000\212\000\206\000\
\\029\000\003\000\035\001\028\001\
\\027\001\042\001\022\001\005\001\
\\245\000\175\000\096\000\194\000\
\\186\000\186\000\030\000\200\000\
\\083\000\000\000\157\000\130\000\
\\064\000\164\000\084\000\165\000\
\\172\000\040\000\042\001\168\000\
\\084\000\167\000\065\000\169\000\
\\077\000\136\000\170\000\014\000\
\\114\000\173\000\166\000\089\001\
\\076\001\079\001\080\001\219\000\
\\008\001\056\001\068\000\057\001\
\\058\001\008\000\016\001\017\001\
\\095\001\254\000\234\000\033\001\
\\008\000\025\001\020\001\095\001\
\\031\000\185\000\192\000\083\000\
\\041\000\032\000\195\000\201\000\
\\053\000\078\000\013\000\153\000\
\\160\000\144\000\079\000\000\000\
\\012\000\009\000\080\000\137\000\
\\113\000\087\001\082\000\060\001\
\\054\000\010\001\006\000\018\001\
\\034\001\023\001\042\000\021\001\
\\252\000\055\000\056\000\193\000\
\\001\000\174\000\130\000\001\000\
\\156\000\151\000\095\001\033\000\
\\142\000\083\000\042\000\141\000\
\\120\000\119\000\138\000\014\000\
\\088\001\066\000\015\001\024\001\
\\176\000\178\000\034\000\081\000\
\\132\000\154\000\069\000\152\000\
\\171\000\143\000\042\001\150\000\
\\139\000\083\000\122\000\121\000\
\\016\001\013\000\177\000\001\000\
\\128\000\083\000\155\000\147\000\
\\148\000\095\001\140\000\011\001\
\\014\001\132\000\131\000\145\000\
\\042\000\149\000\013\001\127\000\
\\146\000\067\000"
val gotoT =
"\
\\001\000\205\001\002\000\014\000\003\000\013\000\004\000\012\000\
\\005\000\011\000\043\000\010\000\056\000\009\000\059\000\008\000\
\\086\000\007\000\101\000\006\000\102\000\005\000\107\000\004\000\
\\108\000\003\000\109\000\002\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\059\000\008\000\086\000\050\000\102\000\005\000\
\\107\000\004\000\108\000\003\000\109\000\002\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\003\000\055\000\005\000\011\000\101\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\102\000\058\000\110\000\057\000\111\000\056\000\000\000\
\\058\000\063\000\071\000\062\000\102\000\058\000\110\000\061\000\
\\111\000\056\000\000\000\
\\043\000\010\000\056\000\066\000\059\000\008\000\080\000\065\000\
\\081\000\064\000\086\000\007\000\102\000\005\000\107\000\004\000\
\\108\000\003\000\109\000\002\000\112\000\001\000\000\000\
\\043\000\010\000\056\000\069\000\059\000\008\000\082\000\068\000\
\\086\000\007\000\089\000\067\000\102\000\005\000\107\000\004\000\
\\108\000\003\000\109\000\002\000\112\000\001\000\000\000\
\\043\000\010\000\056\000\071\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\043\000\077\000\044\000\076\000\046\000\075\000\051\000\074\000\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\042\000\085\000\050\000\084\000\000\000\
\\043\000\010\000\056\000\088\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\096\000\090\000\102\000\005\000\107\000\089\000\000\000\
\\102\000\005\000\107\000\091\000\000\000\
\\095\000\095\000\102\000\094\000\104\000\093\000\000\000\
\\005\000\100\000\019\000\099\000\035\000\098\000\036\000\097\000\
\\101\000\006\000\000\000\
\\054\000\106\000\092\000\105\000\093\000\104\000\100\000\103\000\
\\101\000\102\000\000\000\
\\099\000\109\000\000\000\
\\099\000\111\000\000\000\
\\043\000\010\000\056\000\112\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\043\000\077\000\046\000\116\000\053\000\115\000\060\000\114\000\
\\088\000\113\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\117\000\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\047\000\122\000\102\000\121\000\103\000\120\000\000\000\
\\042\000\125\000\049\000\124\000\000\000\
\\043\000\010\000\056\000\126\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\042\000\125\000\049\000\127\000\000\000\
\\000\000\
\\000\000\
\\018\000\129\000\102\000\128\000\000\000\
\\016\000\131\000\102\000\130\000\000\000\
\\006\000\133\000\102\000\132\000\000\000\
\\000\000\
\\038\000\139\000\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\043\000\010\000\056\000\145\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\146\000\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\043\000\010\000\056\000\147\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\046\000\116\000\088\000\158\000\102\000\005\000\
\\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\165\000\072\000\164\000\102\000\163\000\110\000\162\000\
\\111\000\056\000\000\000\
\\043\000\077\000\044\000\169\000\046\000\075\000\083\000\168\000\
\\084\000\167\000\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\043\000\077\000\044\000\171\000\046\000\075\000\085\000\170\000\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\043\000\077\000\044\000\174\000\046\000\075\000\052\000\173\000\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\102\000\005\000\107\000\091\000\000\000\
\\000\000\
\\105\000\177\000\000\000\
\\000\000\
\\090\000\178\000\000\000\
\\000\000\
\\096\000\180\000\102\000\005\000\107\000\089\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\095\000\181\000\102\000\094\000\104\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\100\000\035\000\182\000\101\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\092\000\184\000\100\000\103\000\101\000\102\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\054\000\186\000\092\000\105\000\093\000\104\000\100\000\103\000\
\\101\000\102\000\000\000\
\\095\000\187\000\102\000\094\000\104\000\093\000\000\000\
\\000\000\
\\095\000\188\000\102\000\094\000\104\000\093\000\000\000\
\\000\000\
\\075\000\190\000\000\000\
\\064\000\192\000\000\000\
\\000\000\
\\043\000\077\000\046\000\116\000\088\000\194\000\102\000\005\000\
\\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\000\000\
\\069\000\195\000\000\000\
\\000\000\
\\079\000\198\000\000\000\
\\000\000\
\\000\000\
\\102\000\201\000\000\000\
\\000\000\
\\105\000\203\000\000\000\
\\000\000\
\\000\000\
\\023\000\207\000\000\000\
\\000\000\
\\000\000\
\\002\000\211\000\021\000\210\000\000\000\
\\000\000\
\\004\000\214\000\022\000\213\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\105\000\135\000\106\000\215\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\037\000\220\000\077\000\219\000\102\000\058\000\110\000\218\000\
\\111\000\056\000\000\000\
\\038\000\222\000\039\000\138\000\040\000\137\000\041\000\136\000\
\\091\000\221\000\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\056\000\223\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\056\000\066\000\059\000\008\000\081\000\224\000\
\\086\000\007\000\102\000\005\000\107\000\004\000\108\000\003\000\
\\109\000\002\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\056\000\226\000\059\000\008\000\086\000\007\000\
\\089\000\225\000\102\000\005\000\107\000\004\000\108\000\003\000\
\\109\000\002\000\112\000\001\000\000\000\
\\043\000\010\000\056\000\066\000\059\000\008\000\081\000\227\000\
\\086\000\007\000\102\000\005\000\107\000\004\000\108\000\003\000\
\\109\000\002\000\112\000\001\000\000\000\
\\000\000\
\\043\000\010\000\056\000\228\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\000\000\
\\043\000\010\000\056\000\229\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\038\000\230\000\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\043\000\077\000\044\000\231\000\046\000\075\000\087\000\073\000\
\\102\000\005\000\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\000\000\
\\075\000\233\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\174\000\046\000\075\000\052\000\241\000\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\100\000\019\000\245\000\035\000\098\000\036\000\097\000\
\\101\000\006\000\000\000\
\\000\000\
\\043\000\010\000\056\000\247\000\059\000\008\000\086\000\007\000\
\\089\000\246\000\102\000\005\000\107\000\004\000\108\000\003\000\
\\109\000\002\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\056\000\249\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\000\000\
\\038\000\251\000\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\043\000\077\000\046\000\116\000\053\000\252\000\060\000\114\000\
\\088\000\113\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\253\000\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\043\000\010\000\056\000\254\000\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\070\000\255\000\000\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\001\001\000\000\
\\038\000\002\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\042\000\085\000\050\000\003\001\000\000\
\\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\005\001\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\042\000\085\000\050\000\006\001\000\000\
\\054\000\007\001\092\000\105\000\093\000\104\000\100\000\103\000\
\\101\000\102\000\000\000\
\\000\000\
\\017\000\010\001\102\000\009\001\000\000\
\\017\000\012\001\102\000\009\001\000\000\
\\000\000\
\\000\000\
\\014\000\017\001\015\000\016\001\033\000\015\001\034\000\014\001\
\\102\000\013\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\039\000\029\001\040\000\137\000\041\000\136\000\105\000\135\000\
\\106\000\134\000\000\000\
\\038\000\030\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\036\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\038\001\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\040\001\046\000\075\000\087\000\073\000\
\\102\000\005\000\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\073\000\041\001\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\169\000\046\000\075\000\084\000\043\001\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\000\000\
\\043\000\077\000\044\000\169\000\046\000\075\000\084\000\044\001\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\038\000\047\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\090\000\048\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\054\000\052\001\092\000\105\000\093\000\104\000\100\000\103\000\
\\101\000\102\000\000\000\
\\000\000\
\\043\000\010\000\056\000\054\001\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\047\000\055\001\102\000\121\000\103\000\120\000\000\000\
\\070\000\056\001\000\000\
\\000\000\
\\000\000\
\\048\000\058\001\102\000\121\000\103\000\057\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\063\001\102\000\062\001\107\000\061\001\000\000\
\\000\000\
\\000\000\
\\014\000\066\001\015\000\016\001\033\000\015\001\034\000\014\001\000\000\
\\026\000\067\001\000\000\
\\000\000\
\\015\000\016\001\033\000\070\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\073\001\102\000\094\000\104\000\072\001\000\000\
\\012\000\075\001\042\000\074\001\000\000\
\\096\000\076\001\102\000\005\000\107\000\089\000\000\000\
\\014\000\077\001\015\000\016\001\033\000\015\001\034\000\014\001\000\000\
\\009\000\079\001\102\000\078\001\000\000\
\\011\000\081\001\042\000\080\001\000\000\
\\008\000\083\001\102\000\082\001\000\000\
\\007\000\086\001\097\000\085\001\102\000\005\000\107\000\084\001\000\000\
\\094\000\089\001\102\000\088\001\000\000\
\\012\000\090\001\042\000\074\001\000\000\
\\000\000\
\\000\000\
\\038\000\091\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\105\000\135\000\106\000\092\001\000\000\
\\038\000\094\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\091\000\093\001\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\000\000\
\\058\000\095\001\102\000\058\000\110\000\061\000\111\000\056\000\000\000\
\\000\000\
\\043\000\077\000\044\000\076\000\046\000\075\000\051\000\096\001\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\074\000\097\001\000\000\
\\074\000\099\001\000\000\
\\043\000\077\000\044\000\100\001\046\000\075\000\087\000\073\000\
\\102\000\005\000\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\102\001\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\066\000\103\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\010\000\056\000\106\001\059\000\008\000\086\000\007\000\
\\102\000\005\000\107\000\004\000\108\000\003\000\109\000\002\000\
\\112\000\001\000\000\000\
\\065\000\107\001\000\000\
\\000\000\
\\000\000\
\\079\000\109\001\000\000\
\\067\000\110\001\000\000\
\\054\000\112\001\092\000\105\000\093\000\104\000\100\000\103\000\
\\101\000\102\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\025\000\114\001\000\000\
\\005\000\100\000\019\000\116\001\035\000\098\000\036\000\097\000\
\\101\000\006\000\000\000\
\\005\000\100\000\019\000\117\001\035\000\098\000\036\000\097\000\
\\101\000\006\000\000\000\
\\000\000\
\\000\000\
\\016\000\119\001\102\000\130\000\000\000\
\\017\000\120\001\102\000\009\001\000\000\
\\000\000\
\\023\000\121\001\000\000\
\\000\000\
\\000\000\
\\105\000\123\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\079\000\125\001\000\000\
\\000\000\
\\105\000\126\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\098\000\131\001\105\000\135\000\106\000\130\001\000\000\
\\094\000\132\001\102\000\088\001\000\000\
\\000\000\
\\000\000\
\\078\000\133\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\135\001\102\000\163\000\110\000\162\000\111\000\056\000\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\119\000\046\000\075\000\055\000\118\000\
\\057\000\136\001\087\000\073\000\102\000\005\000\107\000\004\000\
\\108\000\072\000\112\000\001\000\000\000\
\\063\000\137\001\000\000\
\\000\000\
\\042\000\085\000\050\000\139\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\046\000\116\000\060\000\140\001\088\000\113\000\
\\102\000\005\000\107\000\004\000\108\000\072\000\112\000\001\000\000\000\
\\068\000\141\001\000\000\
\\000\000\
\\042\000\125\000\049\000\143\001\000\000\
\\000\000\
\\005\000\100\000\019\000\146\001\020\000\145\001\035\000\098\000\
\\036\000\097\000\101\000\006\000\102\000\062\001\107\000\061\001\000\000\
\\000\000\
\\018\000\147\001\102\000\128\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\038\000\152\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\031\000\153\001\000\000\
\\014\000\155\001\015\000\016\001\033\000\015\001\034\000\014\001\000\000\
\\028\000\156\001\000\000\
\\000\000\
\\017\000\159\001\102\000\009\001\000\000\
\\097\000\161\001\102\000\005\000\107\000\160\001\000\000\
\\007\000\162\001\097\000\085\001\102\000\005\000\107\000\084\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\037\000\164\001\102\000\058\000\110\000\218\000\111\000\056\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\043\000\077\000\044\000\174\000\046\000\075\000\052\000\166\001\
\\087\000\073\000\102\000\005\000\107\000\004\000\108\000\072\000\
\\112\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\048\000\167\001\102\000\121\000\103\000\057\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\170\001\102\000\062\001\107\000\061\001\000\000\
\\000\000\
\\023\000\171\001\000\000\
\\020\000\172\001\102\000\062\001\107\000\061\001\000\000\
\\032\000\173\001\000\000\
\\000\000\
\\012\000\175\001\042\000\074\001\000\000\
\\000\000\
\\000\000\
\\009\000\177\001\102\000\078\001\000\000\
\\010\000\179\001\102\000\121\000\103\000\178\001\000\000\
\\027\000\180\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\098\000\183\001\105\000\135\000\106\000\182\001\000\000\
\\000\000\
\\076\000\184\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\024\000\188\001\000\000\
\\000\000\
\\013\000\190\001\102\000\094\000\104\000\072\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\079\000\191\001\000\000\
\\030\000\192\001\000\000\
\\000\000\
\\008\000\194\001\102\000\082\001\000\000\
\\000\000\
\\000\000\
\\063\000\195\001\000\000\
\\038\000\196\001\039\000\138\000\040\000\137\000\041\000\136\000\
\\105\000\135\000\106\000\134\000\000\000\
\\000\000\
\\020\000\197\001\102\000\062\001\107\000\061\001\000\000\
\\000\000\
\\006\000\198\001\102\000\132\000\000\000\
\\000\000\
\\029\000\199\001\000\000\
\\000\000\
\\011\000\201\001\042\000\080\001\000\000\
\\000\000\
\\000\000\
\\076\000\202\001\000\000\
\\024\000\203\001\000\000\
\\000\000\
\\000\000\
\\010\000\204\001\102\000\121\000\103\000\178\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 462
val numrules = 262
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2;
String.ord(String.nth i (!s)) + String.ord(String.nth (i+1) (!s)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.create (numstates+numrules) ERROR
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Array.Update _ => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = LexBasics.pos
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit
 | DIGIT of unit ->  (int) | TYVAR of unit ->  (string)
 | ID of unit ->  (string) | STRING of unit ->  (string)
 | REAL of unit ->  (real) | NEGINT of unit ->  (int)
 | POSINT2 of unit ->  (int) | QUAL_STAR of unit ->  (string list)
 | QUAL_ID of unit ->  (string list) | Integer of unit ->  (int)
 | PosInt of unit ->  (int) | Label of unit ->  (lab)
 | LongOpEqIdent of unit ->  (string list op_opt)
 | LongOpIdent of unit ->  (string list op_opt)
 | LongIdent of unit ->  (string list)
 | LongTypeIdent of unit ->  (string list)
 | TypeIdent of unit ->  (string) | EqIdent of unit ->  (string)
 | OpIdent of unit ->  (string op_opt) | Ident of unit ->  (string)
 | OneDec_sans_LOCAL of unit ->  (dec) | OneDec of unit ->  (dec)
 | DIGIT_opt of unit ->  (int Option)
 | LongTypeIdentEq_seq2 of unit ->  (string list WithInfo list)
 | LongIdentEq_seq2 of unit ->  (string list WithInfo list)
 | LongIdent_seq1 of unit ->  (string list WithInfo list)
 | EqIdent_seq1 of unit ->  (string list)
 | Ident_seq1 of unit ->  (string WithInfo list)
 | NonEmptyDec of unit ->  (dec)
 | OneDec_or_SEMICOLON of unit ->  (dec Option)
 | TyComma_seq2 of unit ->  (ty list)
 | TyVarComma_seq1 of unit ->  (tyvar list)
 | ExpSemicolon_seq2 of unit ->  (exp list)
 | AtPat_seq1 of unit ->  (atpat list)
 | AtPat_seq2 of unit ->  (atpat list)
 | AtExp_seq1 of unit ->  (atexp list)
 | PatComma_seq2 of unit ->  (pat list)
 | PatComma_seq1 of unit ->  (pat list)
 | PatComma_seq0 of unit ->  (pat list)
 | ExpComma_seq2 of unit ->  (exp list)
 | ExpComma_seq1 of unit ->  (exp list)
 | ExpComma_seq0 of unit ->  (exp list)
 | OfTy_opt of unit ->  (ty Option)
 | CommaTyRow_opt of unit ->  (tyrow Option)
 | TyRow_opt of unit ->  (tyrow Option)
 | ColonTy_seq1 of unit ->  ( ( ty * pos )  list)
 | ColonTy_opt of unit ->  (ty Option)
 | CommaPatRow_opt of unit ->  (patrow Option)
 | AsPat_opt of unit ->  (pat Option)
 | PatRow_opt of unit ->  (patrow Option)
 | ExpRow_opt of unit ->  (exprow Option)
 | AndExBind_opt of unit ->  (exbind Option)
 | BarMatch_opt of unit ->  (match Option)
 | BarConBind_opt of unit ->  (conbind Option)
 | AndDatBind_opt of unit ->  (datbind Option)
 | AndTypBind_opt of unit ->  (typbind Option)
 | BarFClause_opt of unit ->  (FClause Option)
 | AndFValBind_opt of unit ->  (FValBind Option)
 | AndFnValBind_opt of unit ->  (valbind Option)
 | AndValBind_opt of unit ->  (valbind Option)
 | CommaExpRow_opt of unit ->  (exprow Option)
 | FClause of unit ->  (FClause) | AtExp of unit ->  (atexp)
 | ExpRow of unit ->  (exprow) | Match_ of unit ->  (match)
 | Exp_ of unit ->  (exp) | MRule of unit ->  (mrule)
 | Dec of unit ->  (dec) | FValBind of unit ->  (FValBind)
 | FnValBind of unit ->  (valbind) | ValBind of unit ->  (valbind)
 | TypBind of unit ->  (typbind) | DatBind of unit ->  (datbind)
 | ConBind of unit ->  (conbind) | ExBind of unit ->  (exbind)
 | AtPat of unit ->  (atpat) | PatRow of unit ->  (patrow)
 | Pat of unit ->  (pat) | SCon of unit ->  (scon)
 | TyVarSeq of unit ->  (tyvar list) | AtomicTy of unit ->  (ty)
 | Ty_sans_STAR of unit ->  (ty) | TupleTy of unit ->  (ty list)
 | Ty of unit ->  (ty) | TyRow of unit ->  (tyrow)
 | NonEmptyStrDec of unit ->  (strdec)
 | OneStrDec_or_SEMICOLON of unit ->  (strdec Option)
 | NonEmptySpec of unit ->  (spec)
 | OneSpec_or_SEMICOLON of unit ->  (spec Option)
 | AndValDesc_opt of unit ->  (valdesc Option)
 | AndTypDesc_opt of unit ->  (typdesc Option)
 | AndDatDesc_opt of unit ->  (datdesc Option)
 | BarConDesc_opt of unit ->  (condesc Option)
 | AndExDesc_opt of unit ->  (exdesc Option)
 | AndStrDesc_opt of unit ->  (strdesc Option)
 | AndSigBind_opt of unit ->  (sigbind Option)
 | AndStrBind_opt of unit ->  (strbind Option)
 | AndFunBind_opt of unit ->  (funbind Option)
 | ColonSigExp_opt of unit ->  (sigexp Option)
 | FunDec_sans_SC_opt of unit ->  (fundec Option)
 | SigDec_sans_SC_opt of unit ->  (sigdec Option)
 | StrExp of unit ->  (strexp) | StrDec of unit ->  (strdec)
 | StrBind of unit ->  (strbind) | SigExp of unit ->  (sigexp)
 | SigBind of unit ->  (sigbind) | OneSpec of unit ->  (spec)
 | Spec of unit ->  (spec) | ValDesc of unit ->  (valdesc)
 | TypDesc of unit ->  (typdesc) | DatDesc of unit ->  (datdesc)
 | ConDesc of unit ->  (condesc) | ExDesc of unit ->  (exdesc)
 | StrDesc of unit ->  (strdesc) | SharEq of unit ->  (shareq)
 | FunBind of unit ->  (funbind) | OneStrDec of unit ->  (strdec)
 | FunDec_sans_SEMICOLON of unit ->  (fundec)
 | StrDec_sans_SEMICOLON of unit ->  (strdec)
 | SigDec_sans_SEMICOLON of unit ->  (sigdec)
 | TopDec of unit ->  (topdec)
end
type svalue = MlyValue.svalue
type result = topdec
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 41) => true | (T 40) => true | (T 39) => true | (T 38) => true
 | (T 37) => true | (T 36) => true | (T 35) => true | (T 34) => true
 | (T 33) => true | (T 32) => true | (T 31) => true | (T 30) => true
 | (T 29) => true | (T 28) => true | (T 27) => true | (T 26) => true
 | (T 25) => true | (T 24) => true | (T 23) => true | (T 22) => true
 | (T 21) => true | (T 20) => true | (T 19) => true | (T 18) => true
 | (T 17) => true | (T 16) => true | (T 15) => true | (T 14) => true
 | (T 13) => true | (T 12) => true | (T 11) => true | (T 10) => true
 | (T 7) => true | (T 6) => true | (T 5) => true | (T 4) => true | (T 
3) => true | (T 2) => true | (T 1) => true | (T 0) => true | _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 66) => true | _ => false
val showTerminal =
fn (T 0) => "EQTYPE"
  | (T 1) => "FUNCTOR"
  | (T 2) => "INCLUDE"
  | (T 3) => "SHARING"
  | (T 4) => "SIG"
  | (T 5) => "SIGNATURE"
  | (T 6) => "STRUCT"
  | (T 7) => "STRUCTURE"
  | (T 8) => "QUAL_ID"
  | (T 9) => "QUAL_STAR"
  | (T 10) => "ABSTYPE"
  | (T 11) => "AND"
  | (T 12) => "ANDALSO"
  | (T 13) => "AS"
  | (T 14) => "CASE"
  | (T 15) => "DO"
  | (T 16) => "DATATYPE"
  | (T 17) => "ELSE"
  | (T 18) => "END"
  | (T 19) => "EXCEPTION"
  | (T 20) => "FN"
  | (T 21) => "FUN"
  | (T 22) => "HANDLE"
  | (T 23) => "IF"
  | (T 24) => "IN"
  | (T 25) => "INFIX"
  | (T 26) => "INFIXR"
  | (T 27) => "LET"
  | (T 28) => "LOCAL"
  | (T 29) => "NONFIX"
  | (T 30) => "OF"
  | (T 31) => "OP"
  | (T 32) => "OPEN"
  | (T 33) => "ORELSE"
  | (T 34) => "RAISE"
  | (T 35) => "REC"
  | (T 36) => "THEN"
  | (T 37) => "TYPE"
  | (T 38) => "VAL"
  | (T 39) => "WITH"
  | (T 40) => "WITHTYPE"
  | (T 41) => "WHILE"
  | (T 42) => "LPAREN"
  | (T 43) => "RPAREN"
  | (T 44) => "LBRACKET"
  | (T 45) => "RBRACKET"
  | (T 46) => "LBRACE"
  | (T 47) => "RBRACE"
  | (T 48) => "COMMA"
  | (T 49) => "COLON"
  | (T 50) => "SEMICOLON"
  | (T 51) => "DOTDOTDOT"
  | (T 52) => "UNDERBAR"
  | (T 53) => "BAR"
  | (T 54) => "DARROW"
  | (T 55) => "ARROW"
  | (T 56) => "HASH"
  | (T 57) => "EQUALS"
  | (T 58) => "STAR"
  | (T 59) => "POSINT2"
  | (T 60) => "NEGINT"
  | (T 61) => "REAL"
  | (T 62) => "STRING"
  | (T 63) => "ID"
  | (T 64) => "TYVAR"
  | (T 65) => "DIGIT"
  | (T 66) => "EOF"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 8) => MlyValue.QUAL_ID(fn () => (["bogus"])) | 
(T 9) => MlyValue.QUAL_STAR(fn () => (["bogus"])) | 
(T 59) => MlyValue.POSINT2(fn () => (0)) | 
(T 60) => MlyValue.NEGINT(fn () => (0)) | 
(T 61) => MlyValue.REAL(fn () => (0.0)) | 
(T 62) => MlyValue.STRING(fn () => ("")) | 
(T 63) => MlyValue.ID(fn () => ("bogus")) | 
(T 64) => MlyValue.TYVAR(fn () => ("'bogus")) | 
(T 65) => MlyValue.DIGIT(fn () => (0)) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 6
) :: (T 7) :: (T 10) :: (T 11) :: (T 12) :: (T 13) :: (T 14) :: (T 15)
 :: (T 16) :: (T 17) :: (T 18) :: (T 19) :: (T 20) :: (T 21) :: (T 22)
 :: (T 23) :: (T 24) :: (T 25) :: (T 26) :: (T 27) :: (T 28) :: (T 29)
 :: (T 30) :: (T 31) :: (T 32) :: (T 33) :: (T 34) :: (T 35) :: (T 36)
 :: (T 37) :: (T 38) :: (T 39) :: (T 40) :: (T 41) :: (T 42) :: (T 43)
 :: (T 44) :: (T 45) :: (T 46) :: (T 47) :: (T 48) :: (T 49) :: (T 50)
 :: (T 51) :: (T 52) :: (T 53) :: (T 54) :: (T 55) :: (T 56) :: (T 57)
 :: (T 58) :: (T 66) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.Ident(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 101,(result,ID1left,ID1right),rest671) end
| (1,(_,(_,STAR1left,STAR1right))::rest671) => let val result=
MlyValue.Ident(fn _ => ( "*" ))
 in (LrTable.NT 101,(result,STAR1left,STAR1right),rest671) end
| (2,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.OpIdent(fn _ => let val Ident as Ident1=Ident1
 ()
 in ( OP_OPT(Ident, false) ) end
)
 in (LrTable.NT 102,(result,Ident1left,Ident1right),rest671) end
| (3,(_,(MlyValue.Ident Ident1,_,Ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.OpIdent(fn _ => let val Ident as 
Ident1=Ident1 ()
 in ( OP_OPT(Ident, true) ) end
)
 in (LrTable.NT 102,(result,OP1left,Ident1right),rest671) end
| (4,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.EqIdent(fn _ => let val Ident as Ident1=Ident1
 ()
 in ( Ident ) end
)
 in (LrTable.NT 103,(result,Ident1left,Ident1right),rest671) end
| (5,(_,(_,EQUALS1left,EQUALS1right))::rest671) => let val result=
MlyValue.EqIdent(fn _ => ( "=" ))
 in (LrTable.NT 103,(result,EQUALS1left,EQUALS1right),rest671) end
| (6,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.TypeIdent(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 104,(result,ID1left,ID1right),rest671) end
| (7,(_,(MlyValue.TypeIdent TypeIdent1,TypeIdent1left,TypeIdent1right)
)::rest671) => let val result=MlyValue.LongTypeIdent(fn _ => let val 
TypeIdent as TypeIdent1=TypeIdent1 ()
 in ( [TypeIdent] ) end
)
 in (LrTable.NT 105,(result,TypeIdent1left,TypeIdent1right),rest671)
 end
| (8,(_,(MlyValue.QUAL_ID QUAL_ID1,QUAL_ID1left,QUAL_ID1right))::
rest671) => let val result=MlyValue.LongTypeIdent(fn _ => let val 
QUAL_ID as QUAL_ID1=QUAL_ID1 ()
 in ( QUAL_ID ) end
)
 in (LrTable.NT 105,(result,QUAL_ID1left,QUAL_ID1right),rest671) end
| (9,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.LongIdent(fn _ => let val Ident as Ident1=
Ident1 ()
 in ( [Ident] ) end
)
 in (LrTable.NT 106,(result,Ident1left,Ident1right),rest671) end
| (10,(_,(MlyValue.QUAL_ID QUAL_ID1,QUAL_ID1left,QUAL_ID1right))::
rest671) => let val result=MlyValue.LongIdent(fn _ => let val QUAL_ID
 as QUAL_ID1=QUAL_ID1 ()
 in ( QUAL_ID ) end
)
 in (LrTable.NT 106,(result,QUAL_ID1left,QUAL_ID1right),rest671) end
| (11,(_,(MlyValue.QUAL_STAR QUAL_STAR1,QUAL_STAR1left,QUAL_STAR1right
))::rest671) => let val result=MlyValue.LongIdent(fn _ => let val 
QUAL_STAR as QUAL_STAR1=QUAL_STAR1 ()
 in ( QUAL_STAR ) end
)
 in (LrTable.NT 106,(result,QUAL_STAR1left,QUAL_STAR1right),rest671)
 end
| (12,(_,(MlyValue.LongIdent LongIdent1,LongIdent1left,LongIdent1right
))::rest671) => let val result=MlyValue.LongOpIdent(fn _ => let val 
LongIdent as LongIdent1=LongIdent1 ()
 in ( OP_OPT(LongIdent, false) ) end
)
 in (LrTable.NT 107,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (13,(_,(MlyValue.LongIdent LongIdent1,_,LongIdent1right))::(_,(_,
OP1left,_))::rest671) => let val result=MlyValue.LongOpIdent(fn _ => 
let val LongIdent as LongIdent1=LongIdent1 ()
 in ( OP_OPT(LongIdent, true) ) end
)
 in (LrTable.NT 107,(result,OP1left,LongIdent1right),rest671) end
| (14,(_,(MlyValue.LongOpIdent LongOpIdent1,LongOpIdent1left,
LongOpIdent1right))::rest671) => let val result=MlyValue.LongOpEqIdent
(fn _ => let val LongOpIdent as LongOpIdent1=LongOpIdent1 ()
 in ( LongOpIdent ) end
)
 in (LrTable.NT 108,(result,LongOpIdent1left,LongOpIdent1right),
rest671) end
| (15,(_,(_,EQUALS1left,EQUALS1right))::rest671) => let val result=
MlyValue.LongOpEqIdent(fn _ => ( OP_OPT(["="], false) ))
 in (LrTable.NT 108,(result,EQUALS1left,EQUALS1right),rest671) end
| (16,(_,(_,_,EQUALS1right))::(_,(_,OP1left,_))::rest671) => let val 
result=MlyValue.LongOpEqIdent(fn _ => ( OP_OPT(["="], true) ))
 in (LrTable.NT 108,(result,OP1left,EQUALS1right),rest671) end
| (17,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.DIGIT_opt(fn _ => let val DIGIT as DIGIT1=
DIGIT1 ()
 in ( Some DIGIT ) end
)
 in (LrTable.NT 98,(result,DIGIT1left,DIGIT1right),rest671) end
| (18,rest671) => let val result=MlyValue.DIGIT_opt(fn _ => ( None ))
 in (LrTable.NT 98,(result,defaultPos,defaultPos),rest671) end
| (19,(_,(MlyValue.POSINT2 POSINT21,POSINT21left,POSINT21right))::
rest671) => let val result=MlyValue.Integer(fn _ => let val POSINT2
 as POSINT21=POSINT21 ()
 in ( POSINT2 ) end
)
 in (LrTable.NT 111,(result,POSINT21left,POSINT21right),rest671) end
| (20,(_,(MlyValue.NEGINT NEGINT1,NEGINT1left,NEGINT1right))::rest671)
 => let val result=MlyValue.Integer(fn _ => let val NEGINT as NEGINT1=
NEGINT1 ()
 in ( NEGINT ) end
)
 in (LrTable.NT 111,(result,NEGINT1left,NEGINT1right),rest671) end
| (21,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.Integer(fn _ => let val DIGIT as DIGIT1=DIGIT1
 ()
 in ( DIGIT ) end
)
 in (LrTable.NT 111,(result,DIGIT1left,DIGIT1right),rest671) end
| (22,(_,(MlyValue.POSINT2 POSINT21,POSINT21left,POSINT21right))::
rest671) => let val result=MlyValue.PosInt(fn _ => let val POSINT2 as 
POSINT21=POSINT21 ()
 in ( POSINT2 ) end
)
 in (LrTable.NT 110,(result,POSINT21left,POSINT21right),rest671) end
| (23,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.PosInt(fn _ => let val DIGIT as DIGIT1=DIGIT1 
()
 in ( DIGIT ) end
)
 in (LrTable.NT 110,(result,DIGIT1left,DIGIT1right),rest671) end
| (24,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.Label(fn _ => let val Ident as Ident1=Ident1 
()
 in ( mk_IdentLab Ident ) end
)
 in (LrTable.NT 109,(result,Ident1left,Ident1right),rest671) end
| (25,(_,(MlyValue.PosInt PosInt1,PosInt1left,PosInt1right))::rest671)
 => let val result=MlyValue.Label(fn _ => let val PosInt as PosInt1=
PosInt1 ()
 in ( mk_IntegerLab PosInt ) end
)
 in (LrTable.NT 109,(result,PosInt1left,PosInt1right),rest671) end
| (26,(_,(MlyValue.Ident_seq1 Ident_seq11,_,Ident_seq11right))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,Identright))::rest671)
 => let val result=MlyValue.Ident_seq1(fn _ => let val Ident as Ident1
=Ident1 ()
val Ident_seq1 as Ident_seq11=Ident_seq11 ()
 in ( WITH_INFO(PP Identleft Identright, Ident)
			  :: Ident_seq1
			
) end
)
 in (LrTable.NT 93,(result,Ident1left,Ident_seq11right),rest671) end
| (27,(_,(MlyValue.Ident Ident1,Identleft as Ident1left,Identright as 
Ident1right))::rest671) => let val result=MlyValue.Ident_seq1(fn _ => 
let val Ident as Ident1=Ident1 ()
 in ( [WITH_INFO(PP Identleft Identright, Ident)] ) end
)
 in (LrTable.NT 93,(result,Ident1left,Ident1right),rest671) end
| (28,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq11right))::
(_,(MlyValue.EqIdent EqIdent1,EqIdent1left,_))::rest671) => let val 
result=MlyValue.EqIdent_seq1(fn _ => let val EqIdent as EqIdent1=
EqIdent1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in ( EqIdent :: EqIdent_seq1 ) end
)
 in (LrTable.NT 94,(result,EqIdent1left,EqIdent_seq11right),rest671)
 end
| (29,(_,(MlyValue.EqIdent EqIdent1,EqIdent1left,EqIdent1right))::
rest671) => let val result=MlyValue.EqIdent_seq1(fn _ => let val 
EqIdent as EqIdent1=EqIdent1 ()
 in ( [EqIdent] ) end
)
 in (LrTable.NT 94,(result,EqIdent1left,EqIdent1right),rest671) end
| (30,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq11right))::(_,(MlyValue.LongIdent LongIdent1,
LongIdentleft as LongIdent1left,LongIdentright))::rest671) => let val 
result=MlyValue.LongIdent_seq1(fn _ => let val LongIdent as LongIdent1
=LongIdent1 ()
val LongIdent_seq1 as LongIdent_seq11=LongIdent_seq11 ()
 in (
 WITH_INFO(PP LongIdentleft LongIdentright,
				    LongIdent
				   ) :: LongIdent_seq1
			
) end
)
 in (LrTable.NT 95,(result,LongIdent1left,LongIdent_seq11right),
rest671) end
| (31,(_,(MlyValue.LongIdent LongIdent1,LongIdentleft as 
LongIdent1left,LongIdentright as LongIdent1right))::rest671) => let 
val result=MlyValue.LongIdent_seq1(fn _ => let val LongIdent as 
LongIdent1=LongIdent1 ()
 in (
 [WITH_INFO(PP LongIdentleft LongIdentright,
				     LongIdent
				    )
			  ]
			
) end
)
 in (LrTable.NT 95,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (32,(_,(MlyValue.LongIdentEq_seq2 LongIdentEq_seq21,_,
LongIdentEq_seq21right))::_::(_,(MlyValue.LongIdent LongIdent1,
LongIdentleft as LongIdent1left,LongIdentright))::rest671) => let val 
result=MlyValue.LongIdentEq_seq2(fn _ => let val LongIdent as 
LongIdent1=LongIdent1 ()
val LongIdentEq_seq2 as LongIdentEq_seq21=LongIdentEq_seq21 ()
 in (
 WITH_INFO(PP LongIdentleft LongIdentright, LongIdent)
			  :: LongIdentEq_seq2
			
) end
)
 in (LrTable.NT 96,(result,LongIdent1left,LongIdentEq_seq21right),
rest671) end
| (33,(_,(MlyValue.LongIdent LongIdent2,LongIdent2left,LongIdent2right
))::_::(_,(MlyValue.LongIdent LongIdent1,LongIdent1left,
LongIdent1right))::rest671) => let val result=
MlyValue.LongIdentEq_seq2(fn _ => let val LongIdent1=LongIdent1 ()
val LongIdent2=LongIdent2 ()
 in (
 [WITH_INFO(PP LongIdent1left LongIdent1right,
				     LongIdent1
				    ),
			   WITH_INFO(PP LongIdent2left LongIdent2right,
				     LongIdent2
				    )
			  ]
			
) end
)
 in (LrTable.NT 96,(result,LongIdent1left,LongIdent2right),rest671)
 end
| (34,(_,(MlyValue.LongTypeIdentEq_seq2 LongTypeIdentEq_seq21,_,
LongTypeIdentEq_seq21right))::_::(_,(MlyValue.LongTypeIdent 
LongTypeIdent1,LongTypeIdentleft as LongTypeIdent1left,
LongTypeIdentright))::rest671) => let val result=
MlyValue.LongTypeIdentEq_seq2(fn _ => let val LongTypeIdent as 
LongTypeIdent1=LongTypeIdent1 ()
val LongTypeIdentEq_seq2 as LongTypeIdentEq_seq21=
LongTypeIdentEq_seq21 ()
 in (
 WITH_INFO(PP LongTypeIdentleft LongTypeIdentright,
				    LongTypeIdent
				   )
			  :: LongTypeIdentEq_seq2
			
) end
)
 in (LrTable.NT 97,(result,LongTypeIdent1left,
LongTypeIdentEq_seq21right),rest671) end
| (35,(_,(MlyValue.LongTypeIdent LongTypeIdent2,LongTypeIdent2left,
LongTypeIdent2right))::_::(_,(MlyValue.LongTypeIdent LongTypeIdent1,
LongTypeIdent1left,LongTypeIdent1right))::rest671) => let val result=
MlyValue.LongTypeIdentEq_seq2(fn _ => let val LongTypeIdent1=
LongTypeIdent1 ()
val LongTypeIdent2=LongTypeIdent2 ()
 in (
 [WITH_INFO(PP LongTypeIdent1left LongTypeIdent1right,
				     LongTypeIdent1
				    ),
			   WITH_INFO(PP LongTypeIdent2left LongTypeIdent2right,
				     LongTypeIdent2
				    )
			  ]
			
) end
)
 in (LrTable.NT 97,(result,LongTypeIdent1left,LongTypeIdent2right),
rest671) end
| (36,(_,(MlyValue.StrDec_sans_SEMICOLON StrDec_sans_SEMICOLON1,
StrDec_sans_SEMICOLONleft as StrDec_sans_SEMICOLON1left,
StrDec_sans_SEMICOLONright as StrDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
StrDec_sans_SEMICOLON as StrDec_sans_SEMICOLON1=StrDec_sans_SEMICOLON1
 ()
 in (
 STRtopdec(PP StrDec_sans_SEMICOLONleft
				       StrDec_sans_SEMICOLONright,
				    StrDec_sans_SEMICOLON
				   )
			
) end
)
 in (LrTable.NT 0,(result,StrDec_sans_SEMICOLON1left,
StrDec_sans_SEMICOLON1right),rest671) end
| (37,(_,(MlyValue.SigDec_sans_SEMICOLON SigDec_sans_SEMICOLON1,
SigDec_sans_SEMICOLONleft as SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLONright as SigDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
SigDec_sans_SEMICOLON as SigDec_sans_SEMICOLON1=SigDec_sans_SEMICOLON1
 ()
 in (
 SIGtopdec(PP SigDec_sans_SEMICOLONleft
				       SigDec_sans_SEMICOLONright,
				    SigDec_sans_SEMICOLON
				   )
			
) end
)
 in (LrTable.NT 0,(result,SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLON1right),rest671) end
| (38,(_,(MlyValue.FunDec_sans_SEMICOLON FunDec_sans_SEMICOLON1,
FunDec_sans_SEMICOLONleft as FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLONright as FunDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
FunDec_sans_SEMICOLON as FunDec_sans_SEMICOLON1=FunDec_sans_SEMICOLON1
 ()
 in (
 FUNtopdec(PP FunDec_sans_SEMICOLONleft
				       FunDec_sans_SEMICOLONright,
				    FunDec_sans_SEMICOLON
				   )
			
) end
)
 in (LrTable.NT 0,(result,FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLON1right),rest671) end
| (39,(_,(MlyValue.Exp_ Exp_1,Exp_1left,Exp_1right))::rest671) => let 
val result=MlyValue.TopDec(fn _ => let val Exp_ as Exp_1=Exp_1 ()
 in ( topdecOfExp Exp_ ) end
)
 in (LrTable.NT 0,(result,Exp_1left,Exp_1right),rest671) end
| (40,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.ColonSigExp_opt ColonSigExp_opt1,_,_))
::_::(_,(MlyValue.SigExp SigExp1,_,_))::_::(_,(MlyValue.Ident Ident2,_
,_))::_::(_,(MlyValue.Ident Ident1,Ident1left,_))::rest671) => let 
val result=MlyValue.FunBind(fn _ => let val Ident1=Ident1 ()
val Ident2=Ident2 ()
val SigExp as SigExp1=SigExp1 ()
val ColonSigExp_opt as ColonSigExp_opt1=ColonSigExp_opt1 ()
val StrExp as StrExp1=StrExp1 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 FUNBIND(PP Ident1left AndFunBind_optright,
				  mk_FunId Ident1, mk_StrId Ident2, SigExp,
				  ColonSigExp_opt, StrExp, AndFunBind_opt
				 )
			
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (41,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.ColonSigExp_opt ColonSigExp_opt1,_,_))
::_::(_,(MlyValue.Spec Spec1,Specleft,Specright))::_::(_,(
MlyValue.Ident Ident1,Ident1left,_))::rest671) => let val result=
MlyValue.FunBind(fn _ => let val Ident as Ident1=Ident1 ()
val Spec as Spec1=Spec1 ()
val ColonSigExp_opt as ColonSigExp_opt1=ColonSigExp_opt1 ()
val StrExp as StrExp1=StrExp1 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
			    val newStrId = inventStrId()
			  in
			    FUNBIND(PP Ident1left AndFunBind_optright,
				    mk_FunId Ident, newStrId,
				    SIGsigexp(PP Specleft Specright, Spec),
				    case ColonSigExp_opt
				      of None => None
				       | Some e =>
					   Some(functSigExp(e, newStrId)),
				    convertFunctorBody(newStrId, StrExp),
				    AndFunBind_opt
				   )
			  end
			
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (42,(_,(MlyValue.SigExp SigExp1,_,SigExp1right))::(_,(_,COLON1left,_
))::rest671) => let val result=MlyValue.ColonSigExp_opt(fn _ => let 
val SigExp as SigExp1=SigExp1 ()
 in ( Some SigExp ) end
)
 in (LrTable.NT 22,(result,COLON1left,SigExp1right),rest671) end
| (43,rest671) => let val result=MlyValue.ColonSigExp_opt(fn _ => (
 None ))
 in (LrTable.NT 22,(result,defaultPos,defaultPos),rest671) end
| (44,(_,(MlyValue.FunBind FunBind1,_,FunBind1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndFunBind_opt(fn _ => let 
val FunBind as FunBind1=FunBind1 ()
 in ( Some FunBind ) end
)
 in (LrTable.NT 23,(result,AND1left,FunBind1right),rest671) end
| (45,rest671) => let val result=MlyValue.AndFunBind_opt(fn _ => (
 None ))
 in (LrTable.NT 23,(result,defaultPos,defaultPos),rest671) end
| (46,(_,(MlyValue.FunDec_sans_SC_opt FunDec_sans_SC_opt1,_,
FunDec_sans_SC_optright as FunDec_sans_SC_opt1right))::(_,(
MlyValue.FunBind FunBind1,_,_))::(_,(_,FUNCTORleft as FUNCTOR1left,_))
::rest671) => let val result=MlyValue.FunDec_sans_SEMICOLON(fn _ => 
let val FunBind as FunBind1=FunBind1 ()
val FunDec_sans_SC_opt as FunDec_sans_SC_opt1=FunDec_sans_SC_opt1 ()
 in (
 let
			    val i = PP FUNCTORleft FunDec_sans_SC_optright
			    val fundec1 = FUNCTORfundec(i, FunBind)
			  in
			    case FunDec_sans_SC_opt
			      of Some fd => SEQfundec(i, fundec1, fd)
			       | None => fundec1
			  end
			
) end
)
 in (LrTable.NT 3,(result,FUNCTOR1left,FunDec_sans_SC_opt1right),
rest671) end
| (47,(_,(MlyValue.FunDec_sans_SEMICOLON FunDec_sans_SEMICOLON1,
FunDec_sans_SEMICOLON1left,FunDec_sans_SEMICOLON1right))::rest671) => 
let val result=MlyValue.FunDec_sans_SC_opt(fn _ => let val 
FunDec_sans_SEMICOLON as FunDec_sans_SEMICOLON1=FunDec_sans_SEMICOLON1
 ()
 in ( Some FunDec_sans_SEMICOLON ) end
)
 in (LrTable.NT 21,(result,FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLON1right),rest671) end
| (48,rest671) => let val result=MlyValue.FunDec_sans_SC_opt(fn _ => (
 None ))
 in (LrTable.NT 21,(result,defaultPos,defaultPos),rest671) end
| (49,(_,(MlyValue.LongIdentEq_seq2 LongIdentEq_seq21,
LongIdentEq_seq2left as LongIdentEq_seq21left,LongIdentEq_seq2right
 as LongIdentEq_seq21right))::rest671) => let val result=
MlyValue.SharEq(fn _ => let val LongIdentEq_seq2 as LongIdentEq_seq21=
LongIdentEq_seq21 ()
 in (
 STRUCTUREshareq(PP LongIdentEq_seq2left
					     LongIdentEq_seq2right,
					  wi_Convert mk_LongStrId
						     LongIdentEq_seq2
					 )
			
) end
)
 in (LrTable.NT 6,(result,LongIdentEq_seq21left,LongIdentEq_seq21right
),rest671) end
| (50,(_,(MlyValue.LongTypeIdentEq_seq2 LongTypeIdentEq_seq21,_,
LongTypeIdentEq_seq2right as LongTypeIdentEq_seq21right))::(_,(_,
TYPEleft as TYPE1left,_))::rest671) => let val result=MlyValue.SharEq(
fn _ => let val LongTypeIdentEq_seq2 as LongTypeIdentEq_seq21=
LongTypeIdentEq_seq21 ()
 in (
 TYPEshareq(PP TYPEleft LongTypeIdentEq_seq2right,
				     wi_Convert mk_LongTyCon
						LongTypeIdentEq_seq2
				    )
			
) end
)
 in (LrTable.NT 6,(result,TYPE1left,LongTypeIdentEq_seq21right),
rest671) end
| (51,(_,(MlyValue.SharEq SharEq2,_,SharEq2right))::_::(_,(
MlyValue.SharEq SharEq1,SharEq1left,_))::rest671) => let val result=
MlyValue.SharEq(fn _ => let val SharEq1=SharEq1 ()
val SharEq2=SharEq2 ()
 in (
 ANDshareq(PP SharEq1left SharEq2right,
				    SharEq1, SharEq2
				   )
			
) end
)
 in (LrTable.NT 6,(result,SharEq1left,SharEq2right),rest671) end
| (52,(_,(MlyValue.AndStrDesc_opt AndStrDesc_opt1,_,
AndStrDesc_optright as AndStrDesc_opt1right))::(_,(MlyValue.SigExp 
SigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.StrDesc(fn _ => let val Ident
 as Ident1=Ident1 ()
val SigExp as SigExp1=SigExp1 ()
val AndStrDesc_opt as AndStrDesc_opt1=AndStrDesc_opt1 ()
 in (
 STRDESC(PP Identleft AndStrDesc_optright,
				  mk_StrId Ident, SigExp, AndStrDesc_opt
				 )
			
) end
)
 in (LrTable.NT 7,(result,Ident1left,AndStrDesc_opt1right),rest671)
 end
| (53,(_,(MlyValue.StrDesc StrDesc1,_,StrDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndStrDesc_opt(fn _ => let 
val StrDesc as StrDesc1=StrDesc1 ()
 in ( Some StrDesc ) end
)
 in (LrTable.NT 26,(result,AND1left,StrDesc1right),rest671) end
| (54,rest671) => let val result=MlyValue.AndStrDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 26,(result,defaultPos,defaultPos),rest671) end
| (55,(_,(MlyValue.AndExDesc_opt AndExDesc_opt1,_,AndExDesc_optright
 as AndExDesc_opt1right))::(_,(MlyValue.OfTy_opt OfTy_opt1,_,_))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,_))::rest671) => let 
val result=MlyValue.ExDesc(fn _ => let val Ident as Ident1=Ident1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val AndExDesc_opt as AndExDesc_opt1=AndExDesc_opt1 ()
 in (
 EXDESC(PP Identleft AndExDesc_optright,
				 mk_ExCon Ident, OfTy_opt, AndExDesc_opt
				)
			
) end
)
 in (LrTable.NT 8,(result,Ident1left,AndExDesc_opt1right),rest671) end
| (56,(_,(MlyValue.ExDesc ExDesc1,_,ExDesc1right))::(_,(_,AND1left,_))
::rest671) => let val result=MlyValue.AndExDesc_opt(fn _ => let val 
ExDesc as ExDesc1=ExDesc1 ()
 in ( Some ExDesc ) end
)
 in (LrTable.NT 27,(result,AND1left,ExDesc1right),rest671) end
| (57,rest671) => let val result=MlyValue.AndExDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 27,(result,defaultPos,defaultPos),rest671) end
| (58,(_,(MlyValue.BarConDesc_opt BarConDesc_opt1,_,
BarConDesc_optright as BarConDesc_opt1right))::(_,(MlyValue.OfTy_opt 
OfTy_opt1,_,_))::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as 
OpIdent1left,_))::rest671) => let val result=MlyValue.ConDesc(fn _ => 
let val OpIdent as OpIdent1=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val BarConDesc_opt as BarConDesc_opt1=BarConDesc_opt1 ()
 in (
 let
			    val OP_OPT(id, _) = OpIdent
			  in
			    CONDESC(PP OpIdentleft BarConDesc_optright,
				    mk_Con id, OfTy_opt, BarConDesc_opt
				   )
			  end
			
) end
)
 in (LrTable.NT 9,(result,OpIdent1left,BarConDesc_opt1right),rest671)
 end
| (59,(_,(MlyValue.ConDesc ConDesc1,_,ConDesc1right))::(_,(_,BAR1left,
_))::rest671) => let val result=MlyValue.BarConDesc_opt(fn _ => let 
val ConDesc as ConDesc1=ConDesc1 ()
 in ( Some ConDesc ) end
)
 in (LrTable.NT 28,(result,BAR1left,ConDesc1right),rest671) end
| (60,rest671) => let val result=MlyValue.BarConDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 28,(result,defaultPos,defaultPos),rest671) end
| (61,(_,(MlyValue.AndDatDesc_opt AndDatDesc_opt1,_,
AndDatDesc_optright as AndDatDesc_opt1right))::(_,(MlyValue.ConDesc 
ConDesc1,_,_))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,(
MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::rest671
) => let val result=MlyValue.DatDesc(fn _ => let val TyVarSeq as 
TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val ConDesc as ConDesc1=ConDesc1 ()
val AndDatDesc_opt as AndDatDesc_opt1=AndDatDesc_opt1 ()
 in (
 DATDESC(PP TyVarSeqleft AndDatDesc_optright,
				  TyVarSeq, mk_TyCon TypeIdent,
				  ConDesc, AndDatDesc_opt
				 )
			
) end
)
 in (LrTable.NT 10,(result,TyVarSeq1left,AndDatDesc_opt1right),rest671
) end
| (62,(_,(MlyValue.DatDesc DatDesc1,_,DatDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndDatDesc_opt(fn _ => let 
val DatDesc as DatDesc1=DatDesc1 ()
 in ( Some DatDesc ) end
)
 in (LrTable.NT 29,(result,AND1left,DatDesc1right),rest671) end
| (63,rest671) => let val result=MlyValue.AndDatDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 29,(result,defaultPos,defaultPos),rest671) end
| (64,(_,(MlyValue.AndTypDesc_opt AndTypDesc_opt1,_,
AndTypDesc_optright as AndTypDesc_opt1right))::(_,(MlyValue.TypeIdent 
TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as 
TyVarSeq1left,_))::rest671) => let val result=MlyValue.TypDesc(fn _
 => let val TyVarSeq as TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val AndTypDesc_opt as AndTypDesc_opt1=AndTypDesc_opt1 ()
 in (
 TYPDESC(PP TyVarSeqleft AndTypDesc_optright,
				  TyVarSeq, mk_TyCon TypeIdent,
				  AndTypDesc_opt
				 )
			
) end
)
 in (LrTable.NT 11,(result,TyVarSeq1left,AndTypDesc_opt1right),rest671
) end
| (65,(_,(MlyValue.TypDesc TypDesc1,_,TypDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndTypDesc_opt(fn _ => let 
val TypDesc as TypDesc1=TypDesc1 ()
 in ( Some TypDesc ) end
)
 in (LrTable.NT 30,(result,AND1left,TypDesc1right),rest671) end
| (66,rest671) => let val result=MlyValue.AndTypDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 30,(result,defaultPos,defaultPos),rest671) end
| (67,(_,(MlyValue.AndValDesc_opt AndValDesc_opt1,_,
AndValDesc_optright as AndValDesc_opt1right))::(_,(MlyValue.Ty Ty1,_,_
))::_::(_,(MlyValue.EqIdent EqIdent1,EqIdentleft as EqIdent1left,_))::
rest671) => let val result=MlyValue.ValDesc(fn _ => let val EqIdent
 as EqIdent1=EqIdent1 ()
val Ty as Ty1=Ty1 ()
val AndValDesc_opt as AndValDesc_opt1=AndValDesc_opt1 ()
 in (
 VALDESC(PP EqIdentleft AndValDesc_optright,
				  mk_Id EqIdent, Ty, AndValDesc_opt
				 )
			
) end
)
 in (LrTable.NT 12,(result,EqIdent1left,AndValDesc_opt1right),rest671)
 end
| (68,(_,(MlyValue.ValDesc ValDesc1,_,ValDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndValDesc_opt(fn _ => let 
val ValDesc as ValDesc1=ValDesc1 ()
 in ( Some ValDesc ) end
)
 in (LrTable.NT 31,(result,AND1left,ValDesc1right),rest671) end
| (69,rest671) => let val result=MlyValue.AndValDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 31,(result,defaultPos,defaultPos),rest671) end
| (70,(_,(MlyValue.OneSpec_or_SEMICOLON OneSpec_or_SEMICOLON1,_,
OneSpec_or_SEMICOLONright as OneSpec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptySpec NonEmptySpec1,NonEmptySpecleft as 
NonEmptySpec1left,_))::rest671) => let val result=
MlyValue.NonEmptySpec(fn _ => let val NonEmptySpec as NonEmptySpec1=
NonEmptySpec1 ()
val OneSpec_or_SEMICOLON as OneSpec_or_SEMICOLON1=
OneSpec_or_SEMICOLON1 ()
 in (
 case OneSpec_or_SEMICOLON
			    of Some spec =>
			 	 composeSpec(PP NonEmptySpecleft
					        OneSpec_or_SEMICOLONright,
				  	     NonEmptySpec, spec
					    )
			     | None => NonEmptySpec
			
) end
)
 in (LrTable.NT 33,(result,NonEmptySpec1left,
OneSpec_or_SEMICOLON1right),rest671) end
| (71,(_,(MlyValue.OneSpec_or_SEMICOLON OneSpec_or_SEMICOLON1,
OneSpec_or_SEMICOLON1left,OneSpec_or_SEMICOLON1right))::rest671) => 
let val result=MlyValue.NonEmptySpec(fn _ => let val 
OneSpec_or_SEMICOLON as OneSpec_or_SEMICOLON1=OneSpec_or_SEMICOLON1 ()
 in (
 case OneSpec_or_SEMICOLON
			    of Some spec => spec
			     | None => EMPTYspec(PP defaultPos defaultPos)
			
) end
)
 in (LrTable.NT 33,(result,OneSpec_or_SEMICOLON1left,
OneSpec_or_SEMICOLON1right),rest671) end
| (72,(_,(MlyValue.NonEmptySpec NonEmptySpec1,NonEmptySpec1left,
NonEmptySpec1right))::rest671) => let val result=MlyValue.Spec(fn _
 => let val NonEmptySpec as NonEmptySpec1=NonEmptySpec1 ()
 in ( NonEmptySpec ) end
)
 in (LrTable.NT 13,(result,NonEmptySpec1left,NonEmptySpec1right),
rest671) end
| (73,rest671) => let val result=MlyValue.Spec(fn _ => (
 EMPTYspec(PP defaultPos defaultPos) ))
 in (LrTable.NT 13,(result,defaultPos,defaultPos),rest671) end
| (74,(_,(MlyValue.OneSpec OneSpec1,OneSpec1left,OneSpec1right))::
rest671) => let val result=MlyValue.OneSpec_or_SEMICOLON(fn _ => let 
val OneSpec as OneSpec1=OneSpec1 ()
 in ( Some OneSpec ) end
)
 in (LrTable.NT 32,(result,OneSpec1left,OneSpec1right),rest671) end
| (75,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneSpec_or_SEMICOLON(fn _ => ( None ))
 in (LrTable.NT 32,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (76,(_,(MlyValue.ValDesc ValDesc1,_,ValDescright as ValDesc1right))
::(_,(_,VALleft as VAL1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val ValDesc as ValDesc1=ValDesc1 ()
 in ( VALspec(PP VALleft ValDescright, ValDesc) ) end
)
 in (LrTable.NT 14,(result,VAL1left,ValDesc1right),rest671) end
| (77,(_,(MlyValue.TypDesc TypDesc1,_,TypDescright as TypDesc1right))
::(_,(_,TYPEleft as TYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val TypDesc as TypDesc1=TypDesc1 ()
 in ( TYPEspec(PP TYPEleft TypDescright, TypDesc) ) end
)
 in (LrTable.NT 14,(result,TYPE1left,TypDesc1right),rest671) end
| (78,(_,(MlyValue.TypDesc TypDesc1,_,TypDescright as TypDesc1right))
::(_,(_,EQTYPEleft as EQTYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val TypDesc as TypDesc1=TypDesc1 ()
 in ( EQTYPEspec(PP EQTYPEleft TypDescright, TypDesc) ) end
)
 in (LrTable.NT 14,(result,EQTYPE1left,TypDesc1right),rest671) end
| (79,(_,(MlyValue.DatDesc DatDesc1,_,DatDescright as DatDesc1right))
::(_,(_,DATATYPEleft as DATATYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val DatDesc as DatDesc1=DatDesc1 ()
 in ( DATATYPEspec(PP DATATYPEleft DatDescright, DatDesc) ) end
)
 in (LrTable.NT 14,(result,DATATYPE1left,DatDesc1right),rest671) end
| (80,(_,(MlyValue.ExDesc ExDesc1,_,ExDescright as ExDesc1right))::(_,
(_,EXCEPTIONleft as EXCEPTION1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val ExDesc as ExDesc1=ExDesc1 ()
 in ( EXCEPTIONspec(PP EXCEPTIONleft ExDescright, ExDesc) ) end
)
 in (LrTable.NT 14,(result,EXCEPTION1left,ExDesc1right),rest671) end
| (81,(_,(MlyValue.StrDesc StrDesc1,_,StrDescright as StrDesc1right))
::(_,(_,STRUCTUREleft as STRUCTURE1left,_))::rest671) => let val 
result=MlyValue.OneSpec(fn _ => let val StrDesc as StrDesc1=StrDesc1 
()
 in ( STRUCTUREspec(PP STRUCTUREleft StrDescright, StrDesc)
			) end
)
 in (LrTable.NT 14,(result,STRUCTURE1left,StrDesc1right),rest671) end
| (82,(_,(MlyValue.SharEq SharEq1,_,SharEqright as SharEq1right))::(_,
(_,SHARINGleft as SHARING1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val SharEq as SharEq1=SharEq1 ()
 in ( SHARINGspec(PP SHARINGleft SharEqright, SharEq) ) end
)
 in (LrTable.NT 14,(result,SHARING1left,SharEq1right),rest671) end
| (83,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Spec Spec2,_,_))::
_::(_,(MlyValue.Spec Spec1,_,_))::(_,(_,LOCALleft as LOCAL1left,_))::
rest671) => let val result=MlyValue.OneSpec(fn _ => let val Spec1=
Spec1 ()
val Spec2=Spec2 ()
 in ( LOCALspec(PP LOCALleft ENDright, Spec1, Spec2) ) end
)
 in (LrTable.NT 14,(result,LOCAL1left,END1right),rest671) end
| (84,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq1right as LongIdent_seq11right))::(_,(_,OPENleft as 
OPEN1left,_))::rest671) => let val result=MlyValue.OneSpec(fn _ => 
let val LongIdent_seq1 as LongIdent_seq11=LongIdent_seq11 ()
 in (
 OPENspec(PP OPENleft LongIdent_seq1right,
				   wi_Convert mk_LongStrId LongIdent_seq1
				  )
			
) end
)
 in (LrTable.NT 14,(result,OPEN1left,LongIdent_seq11right),rest671)
 end
| (85,(_,(MlyValue.Ident_seq1 Ident_seq11,_,Ident_seq1right as 
Ident_seq11right))::(_,(_,INCLUDEleft as INCLUDE1left,_))::rest671)
 => let val result=MlyValue.OneSpec(fn _ => let val Ident_seq1 as 
Ident_seq11=Ident_seq11 ()
 in (
 INCLUDEspec(PP INCLUDEleft Ident_seq1right,
				      wi_Convert mk_SigId Ident_seq1
				     )
			
) end
)
 in (LrTable.NT 14,(result,INCLUDE1left,Ident_seq11right),rest671) end
| (86,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec StrDec1,_,_
))::(_,(_,STRUCTleft as STRUCT1left,_))::rest671) => let val result=
MlyValue.StrExp(fn _ => let val StrDec as StrDec1=StrDec1 ()
 in ( STRUCTstrexp(PP STRUCTleft ENDright, StrDec) ) end
)
 in (LrTable.NT 19,(result,STRUCT1left,END1right),rest671) end
| (87,(_,(MlyValue.LongIdent LongIdent1,LongIdentleft as 
LongIdent1left,LongIdentright as LongIdent1right))::rest671) => let 
val result=MlyValue.StrExp(fn _ => let val LongIdent as LongIdent1=
LongIdent1 ()
 in (
 LONGSTRIDstrexp(PP LongIdentleft LongIdentright,
					  mk_LongStrId LongIdent
					 )
			
) end
)
 in (LrTable.NT 19,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (88,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.StrExp(fn _ => let val Ident
 as Ident1=Ident1 ()
val StrExp as StrExp1=StrExp1 ()
 in (
 APPstrexp(PP Identleft RPARENright,
				    mk_FunId Ident, StrExp
				   )
			
) end
)
 in (LrTable.NT 19,(result,Ident1left,RPAREN1right),rest671) end
| (89,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrExp StrExp1,_,_
))::_::(_,(MlyValue.StrDec StrDec1,_,_))::(_,(_,LETleft as LET1left,_)
)::rest671) => let val result=MlyValue.StrExp(fn _ => let val StrDec
 as StrDec1=StrDec1 ()
val StrExp as StrExp1=StrExp1 ()
 in ( LETstrexp(PP LETleft ENDright, StrDec, StrExp) ) end
)
 in (LrTable.NT 19,(result,LET1left,END1right),rest671) end
| (90,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrDec 
StrDec1,StrDecleft,StrDecright))::_::(_,(MlyValue.Ident Ident1,
Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.StrExp(fn _ => let val Ident as Ident1=Ident1 ()
val StrDec as StrDec1=StrDec1 ()
 in (
 APPstrexp(PP Identleft RPARENright, mk_FunId Ident,
				    STRUCTstrexp(PP StrDecleft StrDecright,
						 StrDec
						)
				   )
			
) end
)
 in (LrTable.NT 19,(result,Ident1left,RPAREN1right),rest671) end
| (91,(_,(MlyValue.StrDec_sans_SEMICOLON StrDec_sans_SEMICOLON1,_,
StrDec_sans_SEMICOLONright as StrDec_sans_SEMICOLON1right))::(_,(
MlyValue.OneStrDec OneStrDec1,OneStrDecleft as OneStrDec1left,_))::
rest671) => let val result=MlyValue.StrDec_sans_SEMICOLON(fn _ => let 
val OneStrDec as OneStrDec1=OneStrDec1 ()
val StrDec_sans_SEMICOLON as StrDec_sans_SEMICOLON1=
StrDec_sans_SEMICOLON1 ()
 in (
 composeStrDec(PP OneStrDecleft
					   StrDec_sans_SEMICOLONright,
					OneStrDec, StrDec_sans_SEMICOLON
				       )
			
) end
)
 in (LrTable.NT 2,(result,OneStrDec1left,StrDec_sans_SEMICOLON1right),
rest671) end
| (92,rest671) => let val result=MlyValue.StrDec_sans_SEMICOLON(fn _
 => ( EMPTYstrdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 2,(result,defaultPos,defaultPos),rest671) end
| (93,(_,(MlyValue.OneStrDec_or_SEMICOLON OneStrDec_or_SEMICOLON1,_,
OneStrDec_or_SEMICOLONright as OneStrDec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptyStrDec NonEmptyStrDec1,NonEmptyStrDecleft as 
NonEmptyStrDec1left,_))::rest671) => let val result=
MlyValue.NonEmptyStrDec(fn _ => let val NonEmptyStrDec as 
NonEmptyStrDec1=NonEmptyStrDec1 ()
val OneStrDec_or_SEMICOLON as OneStrDec_or_SEMICOLON1=
OneStrDec_or_SEMICOLON1 ()
 in (
 case OneStrDec_or_SEMICOLON
			    of Some strdec =>
				 composeStrDec(PP NonEmptyStrDecleft
					          OneStrDec_or_SEMICOLONright,
					       NonEmptyStrDec, strdec
					      )
			     | None =>
				 NonEmptyStrDec
			
) end
)
 in (LrTable.NT 35,(result,NonEmptyStrDec1left,
OneStrDec_or_SEMICOLON1right),rest671) end
| (94,(_,(MlyValue.OneStrDec_or_SEMICOLON OneStrDec_or_SEMICOLON1,
OneStrDec_or_SEMICOLON1left,OneStrDec_or_SEMICOLON1right))::rest671)
 => let val result=MlyValue.NonEmptyStrDec(fn _ => let val 
OneStrDec_or_SEMICOLON as OneStrDec_or_SEMICOLON1=
OneStrDec_or_SEMICOLON1 ()
 in (
 case OneStrDec_or_SEMICOLON
			    of Some strdec => strdec
			     | None => EMPTYstrdec(PP defaultPos defaultPos)
			
) end
)
 in (LrTable.NT 35,(result,OneStrDec_or_SEMICOLON1left,
OneStrDec_or_SEMICOLON1right),rest671) end
| (95,(_,(MlyValue.NonEmptyStrDec NonEmptyStrDec1,NonEmptyStrDec1left,
NonEmptyStrDec1right))::rest671) => let val result=MlyValue.StrDec(fn 
_ => let val NonEmptyStrDec as NonEmptyStrDec1=NonEmptyStrDec1 ()
 in ( NonEmptyStrDec ) end
)
 in (LrTable.NT 18,(result,NonEmptyStrDec1left,NonEmptyStrDec1right),
rest671) end
| (96,rest671) => let val result=MlyValue.StrDec(fn _ => (
 EMPTYstrdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 18,(result,defaultPos,defaultPos),rest671) end
| (97,(_,(MlyValue.OneStrDec OneStrDec1,OneStrDec1left,OneStrDec1right
))::rest671) => let val result=MlyValue.OneStrDec_or_SEMICOLON(fn _
 => let val OneStrDec as OneStrDec1=OneStrDec1 ()
 in ( Some OneStrDec ) end
)
 in (LrTable.NT 34,(result,OneStrDec1left,OneStrDec1right),rest671)
 end
| (98,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneStrDec_or_SEMICOLON(fn _ => ( None ))
 in (LrTable.NT 34,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (99,(_,(MlyValue.OneDec_sans_LOCAL OneDec_sans_LOCAL1,
OneDec_sans_LOCALleft as OneDec_sans_LOCAL1left,OneDec_sans_LOCALright
 as OneDec_sans_LOCAL1right))::rest671) => let val result=
MlyValue.OneStrDec(fn _ => let val OneDec_sans_LOCAL as 
OneDec_sans_LOCAL1=OneDec_sans_LOCAL1 ()
 in (
 DECstrdec(PP OneDec_sans_LOCALleft
				       OneDec_sans_LOCALright,
				    OneDec_sans_LOCAL
				   )
			
) end
)
 in (LrTable.NT 4,(result,OneDec_sans_LOCAL1left,
OneDec_sans_LOCAL1right),rest671) end
| (100,(_,(MlyValue.StrBind StrBind1,_,StrBindright as StrBind1right))
::(_,(_,STRUCTUREleft as STRUCTURE1left,_))::rest671) => let val 
result=MlyValue.OneStrDec(fn _ => let val StrBind as StrBind1=StrBind1
 ()
 in (
 STRUCTUREstrdec(PP STRUCTUREleft StrBindright,
					  StrBind
					 )
			
) end
)
 in (LrTable.NT 4,(result,STRUCTURE1left,StrBind1right),rest671) end
| (101,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec StrDec2,_,
_))::_::(_,(MlyValue.StrDec StrDec1,_,_))::(_,(_,LOCALleft as 
LOCAL1left,_))::rest671) => let val result=MlyValue.OneStrDec(fn _ => 
let val StrDec1=StrDec1 ()
val StrDec2=StrDec2 ()
 in (
 LOCALstrdec(PP LOCALleft ENDright,
				      StrDec1, StrDec2
				     )
			
) end
)
 in (LrTable.NT 4,(result,LOCAL1left,END1right),rest671) end
| (102,(_,(MlyValue.AndStrBind_opt AndStrBind_opt1,_,
AndStrBind_optright as AndStrBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.ColonSigExp_opt ColonSigExp_opt1,_,_))
::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_))::rest671) => 
let val result=MlyValue.StrBind(fn _ => let val Ident as Ident1=Ident1
 ()
val ColonSigExp_opt as ColonSigExp_opt1=ColonSigExp_opt1 ()
val StrExp as StrExp1=StrExp1 ()
val AndStrBind_opt as AndStrBind_opt1=AndStrBind_opt1 ()
 in (
 STRBIND(PP Identleft AndStrBind_optright,
				  mk_StrId Ident, ColonSigExp_opt,
				  StrExp, AndStrBind_opt
				 )
			
) end
)
 in (LrTable.NT 17,(result,Ident1left,AndStrBind_opt1right),rest671)
 end
| (103,(_,(MlyValue.StrBind StrBind1,_,StrBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndStrBind_opt(fn _ => let 
val StrBind as StrBind1=StrBind1 ()
 in ( Some StrBind ) end
)
 in (LrTable.NT 24,(result,AND1left,StrBind1right),rest671) end
| (104,rest671) => let val result=MlyValue.AndStrBind_opt(fn _ => (
 None ))
 in (LrTable.NT 24,(result,defaultPos,defaultPos),rest671) end
| (105,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Spec Spec1,_,_))
::(_,(_,SIGleft as SIG1left,_))::rest671) => let val result=
MlyValue.SigExp(fn _ => let val Spec as Spec1=Spec1 ()
 in ( SIGsigexp(PP SIGleft ENDright, Spec) ) end
)
 in (LrTable.NT 16,(result,SIG1left,END1right),rest671) end
| (106,(_,(MlyValue.Ident Ident1,Identleft as Ident1left,Identright
 as Ident1right))::rest671) => let val result=MlyValue.SigExp(fn _ => 
let val Ident as Ident1=Ident1 ()
 in ( SIGIDsigexp(PP Identleft Identright, mk_SigId Ident) ) end
)
 in (LrTable.NT 16,(result,Ident1left,Ident1right),rest671) end
| (107,(_,(MlyValue.SigDec_sans_SC_opt SigDec_sans_SC_opt1,_,
SigDec_sans_SC_optright as SigDec_sans_SC_opt1right))::(_,(
MlyValue.SigBind SigBind1,_,_))::(_,(_,SIGNATUREleft as SIGNATURE1left
,_))::rest671) => let val result=MlyValue.SigDec_sans_SEMICOLON(fn _
 => let val SigBind as SigBind1=SigBind1 ()
val SigDec_sans_SC_opt as SigDec_sans_SC_opt1=SigDec_sans_SC_opt1 ()
 in (
 let
			    val i = PP SIGNATUREleft SigDec_sans_SC_optright
			    val sigdec1 = SIGNATUREsigdec(i, SigBind)
			  in
			    case SigDec_sans_SC_opt
			      of Some sd => SEQsigdec(i, sigdec1, sd)
			       | None => sigdec1
			  end
			
) end
)
 in (LrTable.NT 1,(result,SIGNATURE1left,SigDec_sans_SC_opt1right),
rest671) end
| (108,(_,(MlyValue.SigDec_sans_SEMICOLON SigDec_sans_SEMICOLON1,
SigDec_sans_SEMICOLON1left,SigDec_sans_SEMICOLON1right))::rest671) => 
let val result=MlyValue.SigDec_sans_SC_opt(fn _ => let val 
SigDec_sans_SEMICOLON as SigDec_sans_SEMICOLON1=SigDec_sans_SEMICOLON1
 ()
 in ( Some SigDec_sans_SEMICOLON ) end
)
 in (LrTable.NT 20,(result,SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLON1right),rest671) end
| (109,rest671) => let val result=MlyValue.SigDec_sans_SC_opt(fn _ => 
( None ))
 in (LrTable.NT 20,(result,defaultPos,defaultPos),rest671) end
| (110,(_,(MlyValue.AndSigBind_opt AndSigBind_opt1,_,
AndSigBind_optright as AndSigBind_opt1right))::(_,(MlyValue.SigExp 
SigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.SigBind(fn _ => let val Ident
 as Ident1=Ident1 ()
val SigExp as SigExp1=SigExp1 ()
val AndSigBind_opt as AndSigBind_opt1=AndSigBind_opt1 ()
 in (
 SIGBIND(PP Identleft AndSigBind_optright,
				  mk_SigId Ident, SigExp, AndSigBind_opt
				 )
			
) end
)
 in (LrTable.NT 15,(result,Ident1left,AndSigBind_opt1right),rest671)
 end
| (111,(_,(MlyValue.SigBind SigBind1,_,SigBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndSigBind_opt(fn _ => let 
val SigBind as SigBind1=SigBind1 ()
 in ( Some SigBind ) end
)
 in (LrTable.NT 25,(result,AND1left,SigBind1right),rest671) end
| (112,rest671) => let val result=MlyValue.AndSigBind_opt(fn _ => (
 None ))
 in (LrTable.NT 25,(result,defaultPos,defaultPos),rest671) end
| (113,(_,(MlyValue.SCon SCon1,SConleft as SCon1left,SConright as 
SCon1right))::rest671) => let val result=MlyValue.AtExp(fn _ => let 
val SCon as SCon1=SCon1 ()
 in ( SCONatexp(PP SConleft SConright, SCon) ) end
)
 in (LrTable.NT 58,(result,SCon1left,SCon1right),rest671) end
| (114,(_,(MlyValue.LongOpEqIdent LongOpEqIdent1,LongOpEqIdentleft as 
LongOpEqIdent1left,LongOpEqIdentright as LongOpEqIdent1right))::
rest671) => let val result=MlyValue.AtExp(fn _ => let val 
LongOpEqIdent as LongOpEqIdent1=LongOpEqIdent1 ()
 in (
 let
			    val OP_OPT(id, withOp) = LongOpEqIdent
			  in
			    IDENTatexp(PP LongOpEqIdentleft LongOpEqIdentright,
				       OP_OPT(mk_LongId id, withOp)
				      )
			  end
			
) end
)
 in (LrTable.NT 58,(result,LongOpEqIdent1left,LongOpEqIdent1right),
rest671) end
| (115,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.ExpRow_opt 
ExpRow_opt1,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => 
let val result=MlyValue.AtExp(fn _ => let val ExpRow_opt as 
ExpRow_opt1=ExpRow_opt1 ()
 in ( RECORDatexp(PP LBRACEleft RBRACEright, ExpRow_opt) ) end
)
 in (LrTable.NT 58,(result,LBRACE1left,RBRACE1right),rest671) end
| (116,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Exp_ Exp_1,_,_))
::_::(_,(MlyValue.Dec Dec1,_,_))::(_,(_,LETleft as LET1left,_))::
rest671) => let val result=MlyValue.AtExp(fn _ => let val Dec as Dec1=
Dec1 ()
val Exp_ as Exp_1=Exp_1 ()
 in ( LETatexp(PP LETleft ENDright, Dec, Exp_) ) end
)
 in (LrTable.NT 58,(result,LET1left,END1right),rest671) end
| (117,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Exp_ Exp_1,
_,_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result
=MlyValue.AtExp(fn _ => let val Exp_ as Exp_1=Exp_1 ()
 in ( PARatexp(PP LPARENleft RPARENright, Exp_) ) end
)
 in (LrTable.NT 58,(result,LPAREN1left,RPAREN1right),rest671) end
| (118,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.AtExp(fn _ => (
 RECORDatexp(PP LPARENleft RPARENright, None) ))
 in (LrTable.NT 58,(result,LPAREN1left,RPAREN1right),rest671) end
| (119,(_,(_,_,RPAREN1right))::(_,(MlyValue.ExpComma_seq2 
ExpComma_seq21,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.AtExp(fn _ => let val ExpComma_seq2 as ExpComma_seq21=
ExpComma_seq21 ()
 in ( tupleAtExp ExpComma_seq2 ) end
)
 in (LrTable.NT 58,(result,LPAREN1left,RPAREN1right),rest671) end
| (120,(_,(MlyValue.Label Label1,_,Label1right))::(_,(_,HASH1left,_))
::rest671) => let val result=MlyValue.AtExp(fn _ => let val Label as 
Label1=Label1 ()
 in ( hash Label ) end
)
 in (LrTable.NT 58,(result,HASH1left,Label1right),rest671) end
| (121,(_,(_,_,RPARENright as RPAREN1right))::(_,(
MlyValue.ExpSemicolon_seq2 ExpSemicolon_seq21,_,_))::(_,(_,LPARENleft
 as LPAREN1left,_))::rest671) => let val result=MlyValue.AtExp(fn _
 => let val ExpSemicolon_seq2 as ExpSemicolon_seq21=ExpSemicolon_seq21
 ()
 in (
 PARatexp(PP LPARENleft RPARENright,
				   sequenceExp ExpSemicolon_seq2
				  )
			
) end
)
 in (LrTable.NT 58,(result,LPAREN1left,RPAREN1right),rest671) end
| (122,(_,(_,_,ENDright as END1right))::(_,(MlyValue.ExpSemicolon_seq2
 ExpSemicolon_seq21,_,_))::_::(_,(MlyValue.Dec Dec1,_,_))::(_,(_,
LETleft as LET1left,_))::rest671) => let val result=MlyValue.AtExp(fn 
_ => let val Dec as Dec1=Dec1 ()
val ExpSemicolon_seq2 as ExpSemicolon_seq21=ExpSemicolon_seq21 ()
 in (
 LETatexp(PP LETleft ENDright,
				   Dec, sequenceExp ExpSemicolon_seq2
				  )
			
) end
)
 in (LrTable.NT 58,(result,LET1left,END1right),rest671) end
| (123,(_,(_,_,RBRACKET1right))::(_,(MlyValue.ExpComma_seq0 
ExpComma_seq01,_,_))::(_,(_,LBRACKET1left,_))::rest671) => let val 
result=MlyValue.AtExp(fn _ => let val ExpComma_seq0 as ExpComma_seq01=
ExpComma_seq01 ()
 in ( listAtExp ExpComma_seq0 ) end
)
 in (LrTable.NT 58,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (124,(_,(MlyValue.AtExp_seq1 AtExp_seq11,_,AtExp_seq11right))::(_,(
MlyValue.AtExp AtExp1,AtExp1left,_))::rest671) => let val result=
MlyValue.AtExp_seq1(fn _ => let val AtExp as AtExp1=AtExp1 ()
val AtExp_seq1 as AtExp_seq11=AtExp_seq11 ()
 in ( AtExp :: AtExp_seq1 ) end
)
 in (LrTable.NT 85,(result,AtExp1left,AtExp_seq11right),rest671) end
| (125,(_,(MlyValue.AtExp AtExp1,AtExp1left,AtExp1right))::rest671)
 => let val result=MlyValue.AtExp_seq1(fn _ => let val AtExp as AtExp1
=AtExp1 ()
 in ( [AtExp] ) end
)
 in (LrTable.NT 85,(result,AtExp1left,AtExp1right),rest671) end
| (126,(_,(MlyValue.CommaExpRow_opt CommaExpRow_opt1,_,
CommaExpRow_optright as CommaExpRow_opt1right))::(_,(MlyValue.Exp_ 
Exp_1,_,_))::_::(_,(MlyValue.Label Label1,Labelleft as Label1left,_))
::rest671) => let val result=MlyValue.ExpRow(fn _ => let val Label as 
Label1=Label1 ()
val Exp_ as Exp_1=Exp_1 ()
val CommaExpRow_opt as CommaExpRow_opt1=CommaExpRow_opt1 ()
 in (
 EXPROW(PP Labelleft CommaExpRow_optright,
				 Label, Exp_, CommaExpRow_opt
				)
			
) end
)
 in (LrTable.NT 57,(result,Label1left,CommaExpRow_opt1right),rest671)
 end
| (127,(_,(MlyValue.ExpRow ExpRow1,ExpRow1left,ExpRow1right))::rest671
) => let val result=MlyValue.ExpRow_opt(fn _ => let val ExpRow as 
ExpRow1=ExpRow1 ()
 in ( Some ExpRow ) end
)
 in (LrTable.NT 70,(result,ExpRow1left,ExpRow1right),rest671) end
| (128,rest671) => let val result=MlyValue.ExpRow_opt(fn _ => ( None )
)
 in (LrTable.NT 70,(result,defaultPos,defaultPos),rest671) end
| (129,(_,(MlyValue.ExpRow ExpRow1,_,ExpRow1right))::(_,(_,COMMA1left,
_))::rest671) => let val result=MlyValue.CommaExpRow_opt(fn _ => let 
val ExpRow as ExpRow1=ExpRow1 ()
 in ( Some ExpRow ) end
)
 in (LrTable.NT 60,(result,COMMA1left,ExpRow1right),rest671) end
| (130,rest671) => let val result=MlyValue.CommaExpRow_opt(fn _ => (
 None ))
 in (LrTable.NT 60,(result,defaultPos,defaultPos),rest671) end
| (131,(_,(MlyValue.ExpComma_seq1 ExpComma_seq11,ExpComma_seq11left,
ExpComma_seq11right))::rest671) => let val result=
MlyValue.ExpComma_seq0(fn _ => let val ExpComma_seq1 as ExpComma_seq11
=ExpComma_seq11 ()
 in ( ExpComma_seq1 ) end
)
 in (LrTable.NT 79,(result,ExpComma_seq11left,ExpComma_seq11right),
rest671) end
| (132,rest671) => let val result=MlyValue.ExpComma_seq0(fn _ => (
 nil ))
 in (LrTable.NT 79,(result,defaultPos,defaultPos),rest671) end
| (133,(_,(MlyValue.ExpComma_seq1 ExpComma_seq11,_,ExpComma_seq11right
))::_::(_,(MlyValue.Exp_ Exp_1,Exp_1left,_))::rest671) => let val 
result=MlyValue.ExpComma_seq1(fn _ => let val Exp_ as Exp_1=Exp_1 ()
val ExpComma_seq1 as ExpComma_seq11=ExpComma_seq11 ()
 in ( Exp_ :: ExpComma_seq1 ) end
)
 in (LrTable.NT 80,(result,Exp_1left,ExpComma_seq11right),rest671) end
| (134,(_,(MlyValue.Exp_ Exp_1,Exp_1left,Exp_1right))::rest671) => 
let val result=MlyValue.ExpComma_seq1(fn _ => let val Exp_ as Exp_1=
Exp_1 ()
 in ( [Exp_] ) end
)
 in (LrTable.NT 80,(result,Exp_1left,Exp_1right),rest671) end
| (135,(_,(MlyValue.ExpComma_seq1 ExpComma_seq11,_,ExpComma_seq11right
))::_::(_,(MlyValue.Exp_ Exp_1,Exp_1left,_))::rest671) => let val 
result=MlyValue.ExpComma_seq2(fn _ => let val Exp_ as Exp_1=Exp_1 ()
val ExpComma_seq1 as ExpComma_seq11=ExpComma_seq11 ()
 in ( Exp_ :: ExpComma_seq1 ) end
)
 in (LrTable.NT 81,(result,Exp_1left,ExpComma_seq11right),rest671) end
| (136,(_,(MlyValue.ExpSemicolon_seq2 ExpSemicolon_seq21,_,
ExpSemicolon_seq21right))::_::(_,(MlyValue.Exp_ Exp_1,Exp_1left,_))::
rest671) => let val result=MlyValue.ExpSemicolon_seq2(fn _ => let val 
Exp_ as Exp_1=Exp_1 ()
val ExpSemicolon_seq2 as ExpSemicolon_seq21=ExpSemicolon_seq21 ()
 in ( Exp_ :: ExpSemicolon_seq2) end
)
 in (LrTable.NT 88,(result,Exp_1left,ExpSemicolon_seq21right),rest671)
 end
| (137,(_,(MlyValue.Exp_ Exp_2,_,Exp_2right))::_::(_,(MlyValue.Exp_ 
Exp_1,Exp_1left,_))::rest671) => let val result=
MlyValue.ExpSemicolon_seq2(fn _ => let val Exp_1=Exp_1 ()
val Exp_2=Exp_2 ()
 in ( [Exp_1, Exp_2] ) end
)
 in (LrTable.NT 88,(result,Exp_1left,Exp_2right),rest671) end
| (138,(_,(MlyValue.AtExp_seq1 AtExp_seq11,AtExp_seq11left,
AtExp_seq11right))::rest671) => let val result=MlyValue.Exp_(fn _ => 
let val AtExp_seq1 as AtExp_seq11=AtExp_seq11 ()
 in ( UNRES_INFIXexp(i, AtExp_seq1) ) end
)
 in (LrTable.NT 55,(result,AtExp_seq11left,AtExp_seq11right),rest671)
 end
| (139,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.Exp_ Exp_1,Exp_left as Exp_1left,_))::rest671) => let val 
result=MlyValue.Exp_(fn _ => let val Exp_ as Exp_1=Exp_1 ()
val Ty as Ty1=Ty1 ()
 in ( TYPEDexp(PP Exp_left Tyright, Exp_, Ty) ) end
)
 in (LrTable.NT 55,(result,Exp_1left,Ty1right),rest671) end
| (140,(_,(MlyValue.Match_ Match_1,_,Match_right as Match_1right))::_
::(_,(MlyValue.Exp_ Exp_1,Exp_left as Exp_1left,_))::rest671) => let 
val result=MlyValue.Exp_(fn _ => let val Exp_ as Exp_1=Exp_1 ()
val Match_ as Match_1=Match_1 ()
 in ( HANDLEexp(PP Exp_left Match_right, Exp_, Match_) ) end
)
 in (LrTable.NT 55,(result,Exp_1left,Match_1right),rest671) end
| (141,(_,(MlyValue.Exp_ Exp_1,_,Exp_right as Exp_1right))::(_,(_,
RAISEleft as RAISE1left,_))::rest671) => let val result=MlyValue.Exp_(
fn _ => let val Exp_ as Exp_1=Exp_1 ()
 in ( RAISEexp(PP RAISEleft Exp_right, Exp_) ) end
)
 in (LrTable.NT 55,(result,RAISE1left,Exp_1right),rest671) end
| (142,(_,(MlyValue.Match_ Match_1,_,Match_right as Match_1right))::(_
,(_,FNleft as FN1left,_))::rest671) => let val result=MlyValue.Exp_(
fn _ => let val Match_ as Match_1=Match_1 ()
 in ( FNexp(PP FNleft Match_right, Match_) ) end
)
 in (LrTable.NT 55,(result,FN1left,Match_1right),rest671) end
| (143,(_,(MlyValue.Match_ Match_1,_,Match_1right))::_::(_,(
MlyValue.Exp_ Exp_1,_,_))::(_,(_,CASE1left,_))::rest671) => let val 
result=MlyValue.Exp_(fn _ => let val Exp_ as Exp_1=Exp_1 ()
val Match_ as Match_1=Match_1 ()
 in ( caseExp(Exp_, Match_) ) end
)
 in (LrTable.NT 55,(result,CASE1left,Match_1right),rest671) end
| (144,(_,(MlyValue.Exp_ Exp_3,_,Exp_3right))::_::(_,(MlyValue.Exp_ 
Exp_2,_,_))::_::(_,(MlyValue.Exp_ Exp_1,_,_))::(_,(_,IF1left,_))::
rest671) => let val result=MlyValue.Exp_(fn _ => let val Exp_1=Exp_1 
()
val Exp_2=Exp_2 ()
val Exp_3=Exp_3 ()
 in ( ifThenElse(Exp_1, Exp_2, Exp_3) ) end
)
 in (LrTable.NT 55,(result,IF1left,Exp_3right),rest671) end
| (145,(_,(MlyValue.Exp_ Exp_2,_,Exp_2right))::_::(_,(MlyValue.Exp_ 
Exp_1,Exp_1left,_))::rest671) => let val result=MlyValue.Exp_(fn _ => 
let val Exp_1=Exp_1 ()
val Exp_2=Exp_2 ()
 in ( ifThenElse(Exp_1, trueExp, Exp_2) ) end
)
 in (LrTable.NT 55,(result,Exp_1left,Exp_2right),rest671) end
| (146,(_,(MlyValue.Exp_ Exp_2,_,Exp_2right))::_::(_,(MlyValue.Exp_ 
Exp_1,Exp_1left,_))::rest671) => let val result=MlyValue.Exp_(fn _ => 
let val Exp_1=Exp_1 ()
val Exp_2=Exp_2 ()
 in ( ifThenElse(Exp_1, Exp_2, falseExp) ) end
)
 in (LrTable.NT 55,(result,Exp_1left,Exp_2right),rest671) end
| (147,(_,(MlyValue.Exp_ Exp_2,_,Exp_2right))::_::(_,(MlyValue.Exp_ 
Exp_1,_,_))::(_,(_,WHILE1left,_))::rest671) => let val result=
MlyValue.Exp_(fn _ => let val Exp_1=Exp_1 ()
val Exp_2=Exp_2 ()
 in ( whileExp(Exp_1, Exp_2) ) end
)
 in (LrTable.NT 55,(result,WHILE1left,Exp_2right),rest671) end
| (148,(_,(MlyValue.BarMatch_opt BarMatch_opt1,_,BarMatch_optright as 
BarMatch_opt1right))::(_,(MlyValue.MRule MRule1,MRuleleft as 
MRule1left,_))::rest671) => let val result=MlyValue.Match_(fn _ => 
let val MRule as MRule1=MRule1 ()
val BarMatch_opt as BarMatch_opt1=BarMatch_opt1 ()
 in (
 MATCH(PP MRuleleft BarMatch_optright,
				MRule, BarMatch_opt
			       )
			
) end
)
 in (LrTable.NT 56,(result,MRule1left,BarMatch_opt1right),rest671) end
| (149,(_,(MlyValue.Match_ Match_1,_,Match_1right))::(_,(_,BAR1left,_)
)::rest671) => let val result=MlyValue.BarMatch_opt(fn _ => let val 
Match_ as Match_1=Match_1 ()
 in ( Some Match_ ) end
)
 in (LrTable.NT 68,(result,BAR1left,Match_1right),rest671) end
| (150,rest671) => let val result=MlyValue.BarMatch_opt(fn _ => (
 None ))
 in (LrTable.NT 68,(result,defaultPos,defaultPos),rest671) end
| (151,(_,(MlyValue.Exp_ Exp_1,_,Exp_right as Exp_1right))::_::(_,(
MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.MRule(fn _ => let val Pat as Pat1=Pat1 ()
val Exp_ as Exp_1=Exp_1 ()
 in ( MRULE(PP Patleft Exp_right, Pat, Exp_) ) end
)
 in (LrTable.NT 54,(result,Pat1left,Exp_1right),rest671) end
| (152,(_,(MlyValue.ValBind ValBind1,_,ValBindright as ValBind1right))
::(_,(_,VALleft as VAL1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val ValBind as ValBind1=
ValBind1 ()
 in ( VALdec(PP VALleft ValBindright, ValBind) ) end
)
 in (LrTable.NT 100,(result,VAL1left,ValBind1right),rest671) end
| (153,(_,(MlyValue.TypBind TypBind1,_,TypBindright as TypBind1right))
::(_,(_,TYPEleft as TYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val TypBind as TypBind1=
TypBind1 ()
 in ( TYPEdec(PP TYPEleft TypBindright, TypBind) ) end
)
 in (LrTable.NT 100,(result,TYPE1left,TypBind1right),rest671) end
| (154,(_,(MlyValue.DatBind DatBind1,_,DatBindright as DatBind1right))
::(_,(_,DATATYPEleft as DATATYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val DatBind as DatBind1=
DatBind1 ()
 in ( DATATYPEdec(PP DATATYPEleft DatBindright, DatBind) ) end
)
 in (LrTable.NT 100,(result,DATATYPE1left,DatBind1right),rest671) end
| (155,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Dec Dec1,_,_))::_
::(_,(MlyValue.DatBind DatBind1,_,_))::(_,(_,ABSTYPEleft as 
ABSTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val DatBind as DatBind1=
DatBind1 ()
val Dec as Dec1=Dec1 ()
 in ( ABSTYPEdec(PP ABSTYPEleft ENDright, DatBind, Dec) ) end
)
 in (LrTable.NT 100,(result,ABSTYPE1left,END1right),rest671) end
| (156,(_,(MlyValue.ExBind ExBind1,_,ExBindright as ExBind1right))::(_
,(_,EXCEPTIONleft as EXCEPTION1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val ExBind as ExBind1=ExBind1 
()
 in ( EXCEPTIONdec(PP EXCEPTIONleft ExBindright, ExBind) ) end
)
 in (LrTable.NT 100,(result,EXCEPTION1left,ExBind1right),rest671) end
| (157,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq1right as LongIdent_seq11right))::(_,(_,OPENleft as 
OPEN1left,_))::rest671) => let val result=MlyValue.OneDec_sans_LOCAL(
fn _ => let val LongIdent_seq1 as LongIdent_seq11=LongIdent_seq11 ()
 in (
 OPENdec(PP OPENleft LongIdent_seq1right,
				  wi_Convert mk_LongStrId LongIdent_seq1
				 )
			
) end
)
 in (LrTable.NT 100,(result,OPEN1left,LongIdent_seq11right),rest671)
 end
| (158,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(MlyValue.DIGIT_opt DIGIT_opt1,_,_))::(_,(_,
INFIXleft as INFIX1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val DIGIT_opt as DIGIT_opt1=
DIGIT_opt1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 INFIXdec(PP INFIXleft EqIdent_seq1right,
				   DIGIT_opt, map mk_Id EqIdent_seq1
				  )
			
) end
)
 in (LrTable.NT 100,(result,INFIX1left,EqIdent_seq11right),rest671)
 end
| (159,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(MlyValue.DIGIT_opt DIGIT_opt1,_,_))::(_,(_,
INFIXRleft as INFIXR1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val DIGIT_opt as DIGIT_opt1=
DIGIT_opt1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 INFIXRdec(PP INFIXRleft EqIdent_seq1right,
				    DIGIT_opt, map mk_Id EqIdent_seq1
				   )
			
) end
)
 in (LrTable.NT 100,(result,INFIXR1left,EqIdent_seq11right),rest671)
 end
| (160,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(_,NONFIXleft as NONFIX1left,_))::rest671)
 => let val result=MlyValue.OneDec_sans_LOCAL(fn _ => let val 
EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 NONFIXdec(PP NONFIXleft EqIdent_seq1right,
				    map mk_Id EqIdent_seq1
				   )
			
) end
)
 in (LrTable.NT 100,(result,NONFIX1left,EqIdent_seq11right),rest671)
 end
| (161,(_,(MlyValue.TypBind TypBind1,TypBindleft,TypBindright as 
TypBind1right))::_::(_,(MlyValue.DatBind DatBind1,DatBindleft,
DatBindright))::(_,(_,DATATYPEleft as DATATYPE1left,_))::rest671) => 
let val result=MlyValue.OneDec_sans_LOCAL(fn _ => let val DatBind as 
DatBind1=DatBind1 ()
val TypBind as TypBind1=TypBind1 ()
 in (
 let
			    val db = rewriteDatBind(DatBind, TypBind)
			  in
			    SEQdec(PP DATATYPEleft TypBindright,
				   DATATYPEdec(PP DatBindleft DatBindright, db),
				   TYPEdec(PP TypBindleft TypBindright, TypBind)
				  )
			  end
			
) end
)
 in (LrTable.NT 100,(result,DATATYPE1left,TypBind1right),rest671) end
| (162,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Dec Dec1,_,
Decright))::_::(_,(MlyValue.TypBind TypBind1,TypBindleft,TypBindright)
)::_::(_,(MlyValue.DatBind DatBind1,_,_))::(_,(_,ABSTYPEleft as 
ABSTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val DatBind as DatBind1=
DatBind1 ()
val TypBind as TypBind1=TypBind1 ()
val Dec as Dec1=Dec1 ()
 in (
 let
			    val db = rewriteDatBind(DatBind, TypBind)
			  in
			    ABSTYPEdec(PP ABSTYPEleft ENDright, db,
				       SEQdec(PP TypBindleft Decright,
					      TYPEdec(PP TypBindleft
						         TypBindright,
						      TypBind
						     ),
					      Dec
					     )
				      )
			  end
			
) end
)
 in (LrTable.NT 100,(result,ABSTYPE1left,END1right),rest671) end
| (163,(_,(MlyValue.FValBind FValBind1,_,FValBindright as 
FValBind1right))::(_,(_,FUNleft as FUN1left,_))::rest671) => let val 
result=MlyValue.OneDec_sans_LOCAL(fn _ => let val FValBind as 
FValBind1=FValBind1 ()
 in ( UNRES_FUNdec(PP FUNleft FValBindright, FValBind) ) end
)
 in (LrTable.NT 100,(result,FUN1left,FValBind1right),rest671) end
| (164,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Dec Dec2,_,_))::_
::(_,(MlyValue.Dec Dec1,_,_))::(_,(_,LOCALleft as LOCAL1left,_))::
rest671) => let val result=MlyValue.OneDec(fn _ => let val Dec1=Dec1 
()
val Dec2=Dec2 ()
 in ( LOCALdec(PP LOCALleft ENDright, Dec1, Dec2) ) end
)
 in (LrTable.NT 99,(result,LOCAL1left,END1right),rest671) end
| (165,(_,(MlyValue.OneDec_sans_LOCAL OneDec_sans_LOCAL1,
OneDec_sans_LOCAL1left,OneDec_sans_LOCAL1right))::rest671) => let val 
result=MlyValue.OneDec(fn _ => let val OneDec_sans_LOCAL as 
OneDec_sans_LOCAL1=OneDec_sans_LOCAL1 ()
 in ( OneDec_sans_LOCAL ) end
)
 in (LrTable.NT 99,(result,OneDec_sans_LOCAL1left,
OneDec_sans_LOCAL1right),rest671) end
| (166,(_,(MlyValue.OneDec OneDec1,OneDec1left,OneDec1right))::rest671
) => let val result=MlyValue.OneDec_or_SEMICOLON(fn _ => let val 
OneDec as OneDec1=OneDec1 ()
 in ( Some OneDec ) end
)
 in (LrTable.NT 91,(result,OneDec1left,OneDec1right),rest671) end
| (167,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneDec_or_SEMICOLON(fn _ => ( None ))
 in (LrTable.NT 91,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (168,(_,(MlyValue.OneDec_or_SEMICOLON OneDec_or_SEMICOLON1,_,
OneDec_or_SEMICOLONright as OneDec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptyDec NonEmptyDec1,NonEmptyDecleft as NonEmptyDec1left,
_))::rest671) => let val result=MlyValue.NonEmptyDec(fn _ => let val 
NonEmptyDec as NonEmptyDec1=NonEmptyDec1 ()
val OneDec_or_SEMICOLON as OneDec_or_SEMICOLON1=OneDec_or_SEMICOLON1 
()
 in (
 case OneDec_or_SEMICOLON
			    of Some dec =>
			         composeDec(PP NonEmptyDecleft
					       OneDec_or_SEMICOLONright,
					    NonEmptyDec, dec
				           )

			     | None =>
				 NonEmptyDec
			
) end
)
 in (LrTable.NT 92,(result,NonEmptyDec1left,OneDec_or_SEMICOLON1right)
,rest671) end
| (169,(_,(MlyValue.OneDec_or_SEMICOLON OneDec_or_SEMICOLON1,
OneDec_or_SEMICOLON1left,OneDec_or_SEMICOLON1right))::rest671) => let 
val result=MlyValue.NonEmptyDec(fn _ => let val OneDec_or_SEMICOLON
 as OneDec_or_SEMICOLON1=OneDec_or_SEMICOLON1 ()
 in (
 case OneDec_or_SEMICOLON
			    of Some dec => dec
			     | None => EMPTYdec(PP defaultPos defaultPos)
			
) end
)
 in (LrTable.NT 92,(result,OneDec_or_SEMICOLON1left,
OneDec_or_SEMICOLON1right),rest671) end
| (170,(_,(MlyValue.NonEmptyDec NonEmptyDec1,NonEmptyDec1left,
NonEmptyDec1right))::rest671) => let val result=MlyValue.Dec(fn _ => 
let val NonEmptyDec as NonEmptyDec1=NonEmptyDec1 ()
 in ( NonEmptyDec ) end
)
 in (LrTable.NT 53,(result,NonEmptyDec1left,NonEmptyDec1right),rest671
) end
| (171,rest671) => let val result=MlyValue.Dec(fn _ => (
 EMPTYdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 53,(result,defaultPos,defaultPos),rest671) end
| (172,(_,(MlyValue.AndValBind_opt AndValBind_opt1,_,
AndValBind_optright as AndValBind_opt1right))::(_,(MlyValue.Exp_ Exp_1
,_,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => 
let val result=MlyValue.ValBind(fn _ => let val Pat as Pat1=Pat1 ()
val Exp_ as Exp_1=Exp_1 ()
val AndValBind_opt as AndValBind_opt1=AndValBind_opt1 ()
 in (
 PLAINvalbind(PP Patleft AndValBind_optright,
				       Pat, Exp_, AndValBind_opt
				      )
			
) end
)
 in (LrTable.NT 50,(result,Pat1left,AndValBind_opt1right),rest671) end
| (173,(_,(MlyValue.FnValBind FnValBind1,_,FnValBindright as 
FnValBind1right))::(_,(_,RECleft as REC1left,_))::rest671) => let val 
result=MlyValue.ValBind(fn _ => let val FnValBind as FnValBind1=
FnValBind1 ()
 in ( RECvalbind(PP RECleft FnValBindright, FnValBind) ) end
)
 in (LrTable.NT 50,(result,REC1left,FnValBind1right),rest671) end
| (174,(_,(MlyValue.ValBind ValBind1,_,ValBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndValBind_opt(fn _ => let 
val ValBind as ValBind1=ValBind1 ()
 in ( Some ValBind ) end
)
 in (LrTable.NT 61,(result,AND1left,ValBind1right),rest671) end
| (175,rest671) => let val result=MlyValue.AndValBind_opt(fn _ => (
 None ))
 in (LrTable.NT 61,(result,defaultPos,defaultPos),rest671) end
| (176,(_,(MlyValue.AndFnValBind_opt AndFnValBind_opt1,_,
AndFnValBind_optright as AndFnValBind_opt1right))::(_,(MlyValue.Match_
 Match_1,_,Match_right))::(_,(_,FNleft,_))::_::(_,(MlyValue.Pat Pat1,
Patleft as Pat1left,_))::rest671) => let val result=MlyValue.FnValBind
(fn _ => let val Pat as Pat1=Pat1 ()
val Match_ as Match_1=Match_1 ()
val AndFnValBind_opt as AndFnValBind_opt1=AndFnValBind_opt1 ()
 in (
 PLAINvalbind(PP Patleft AndFnValBind_optright,
				       Pat,
				       FNexp(PP FNleft Match_right, Match_),
				       AndFnValBind_opt
				      )
			
) end
)
 in (LrTable.NT 51,(result,Pat1left,AndFnValBind_opt1right),rest671)
 end
| (177,(_,(MlyValue.AndFnValBind_opt AndFnValBind_opt1,_,
AndFnValBind_optright as AndFnValBind_opt1right))::(_,(
MlyValue.ColonTy_seq1 ColonTy_seq11,_,_))::(_,(_,_,RPARENright))::(_,(
MlyValue.Match_ Match_1,_,Match_right))::(_,(_,FNleft,_))::(_,(_,
LPARENleft,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::
rest671) => let val result=MlyValue.FnValBind(fn _ => let val Pat as 
Pat1=Pat1 ()
val Match_ as Match_1=Match_1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
val AndFnValBind_opt as AndFnValBind_opt1=AndFnValBind_opt1 ()
 in (
 let
			    val fnExp = FNexp(PP FNleft Match_right, Match_)

			    val parAtexp =
			      PARatexp(PP LPARENleft RPARENright, fnExp)

			    val atexpExp =
			      ATEXPexp(PP LPARENleft RPARENright, parAtexp)

			    fun attachTypes(e, nil) = e
			      | attachTypes(e, (ty, p) :: rest) =
				  attachTypes(TYPEDexp(PP FNleft p, e, ty),
					      rest
					     )
			  in
			    PLAINvalbind(PP Patleft AndFnValBind_optright,
					 Pat,
					 attachTypes(atexpExp, ColonTy_seq1),
					 AndFnValBind_opt
					)
			  end
			
) end
)
 in (LrTable.NT 51,(result,Pat1left,AndFnValBind_opt1right),rest671)
 end
| (178,(_,(MlyValue.FnValBind FnValBind1,_,FnValBindright as 
FnValBind1right))::(_,(_,RECleft as REC1left,_))::rest671) => let val 
result=MlyValue.FnValBind(fn _ => let val FnValBind as FnValBind1=
FnValBind1 ()
 in ( RECvalbind(PP RECleft FnValBindright, FnValBind) ) end
)
 in (LrTable.NT 51,(result,REC1left,FnValBind1right),rest671) end
| (179,(_,(MlyValue.ColonTy_seq1 ColonTy_seq11,_,ColonTy_seq11right))
::(_,(MlyValue.Ty Ty1,_,Tyright))::(_,(_,COLON1left,_))::rest671) => 
let val result=MlyValue.ColonTy_seq1(fn _ => let val Ty as Ty1=Ty1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
 in ( (Ty, Tyright) :: ColonTy_seq1 ) end
)
 in (LrTable.NT 75,(result,COLON1left,ColonTy_seq11right),rest671) end
| (180,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::(_,(_,COLON1left,_
))::rest671) => let val result=MlyValue.ColonTy_seq1(fn _ => let val 
Ty as Ty1=Ty1 ()
 in ( [(Ty, Tyright)] ) end
)
 in (LrTable.NT 75,(result,COLON1left,Ty1right),rest671) end
| (181,(_,(MlyValue.FnValBind FnValBind1,_,FnValBind1right))::(_,(_,
AND1left,_))::rest671) => let val result=MlyValue.AndFnValBind_opt(fn 
_ => let val FnValBind as FnValBind1=FnValBind1 ()
 in ( Some FnValBind ) end
)
 in (LrTable.NT 62,(result,AND1left,FnValBind1right),rest671) end
| (182,rest671) => let val result=MlyValue.AndFnValBind_opt(fn _ => (
 None ))
 in (LrTable.NT 62,(result,defaultPos,defaultPos),rest671) end
| (183,(_,(MlyValue.AndTypBind_opt AndTypBind_opt1,_,
AndTypBind_optright as AndTypBind_opt1right))::(_,(MlyValue.Ty Ty1,_,_
))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq 
TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::rest671) => let val 
result=MlyValue.TypBind(fn _ => let val TyVarSeq as TyVarSeq1=
TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val Ty as Ty1=Ty1 ()
val AndTypBind_opt as AndTypBind_opt1=AndTypBind_opt1 ()
 in (
 TYPBIND(PP TyVarSeqleft AndTypBind_optright,
				  TyVarSeq, mk_TyCon TypeIdent,
				  Ty, AndTypBind_opt
				 )
			
) end
)
 in (LrTable.NT 49,(result,TyVarSeq1left,AndTypBind_opt1right),rest671
) end
| (184,(_,(MlyValue.TypBind TypBind1,_,TypBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndTypBind_opt(fn _ => let 
val TypBind as TypBind1=TypBind1 ()
 in ( Some TypBind ) end
)
 in (LrTable.NT 65,(result,AND1left,TypBind1right),rest671) end
| (185,rest671) => let val result=MlyValue.AndTypBind_opt(fn _ => (
 None ))
 in (LrTable.NT 65,(result,defaultPos,defaultPos),rest671) end
| (186,(_,(MlyValue.AndDatBind_opt AndDatBind_opt1,_,
AndDatBind_optright as AndDatBind_opt1right))::(_,(MlyValue.ConBind 
ConBind1,_,_))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,(
MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::rest671
) => let val result=MlyValue.DatBind(fn _ => let val TyVarSeq as 
TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val ConBind as ConBind1=ConBind1 ()
val AndDatBind_opt as AndDatBind_opt1=AndDatBind_opt1 ()
 in (
 DATBIND(PP TyVarSeqleft AndDatBind_optright,
				  TyVarSeq, mk_TyCon TypeIdent,
				  ConBind, AndDatBind_opt
				 )
			
) end
)
 in (LrTable.NT 48,(result,TyVarSeq1left,AndDatBind_opt1right),rest671
) end
| (187,(_,(MlyValue.DatBind DatBind1,_,DatBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndDatBind_opt(fn _ => let 
val DatBind as DatBind1=DatBind1 ()
 in ( Some DatBind ) end
)
 in (LrTable.NT 66,(result,AND1left,DatBind1right),rest671) end
| (188,rest671) => let val result=MlyValue.AndDatBind_opt(fn _ => (
 None ))
 in (LrTable.NT 66,(result,defaultPos,defaultPos),rest671) end
| (189,(_,(MlyValue.BarConBind_opt BarConBind_opt1,_,
BarConBind_optright as BarConBind_opt1right))::(_,(MlyValue.OfTy_opt 
OfTy_opt1,_,_))::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as 
OpIdent1left,_))::rest671) => let val result=MlyValue.ConBind(fn _ => 
let val OpIdent as OpIdent1=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val BarConBind_opt as BarConBind_opt1=BarConBind_opt1 ()
 in (
 let
			    val OP_OPT(id, withOp) = OpIdent
			  in
			    CONBIND(PP OpIdentleft BarConBind_optright,
				    OP_OPT(mk_Con id, withOp),
				    OfTy_opt, BarConBind_opt
				   )
			  end
			
) end
)
 in (LrTable.NT 47,(result,OpIdent1left,BarConBind_opt1right),rest671)
 end
| (190,(_,(MlyValue.ConBind ConBind1,_,ConBind1right))::(_,(_,BAR1left
,_))::rest671) => let val result=MlyValue.BarConBind_opt(fn _ => let 
val ConBind as ConBind1=ConBind1 ()
 in ( Some ConBind ) end
)
 in (LrTable.NT 67,(result,BAR1left,ConBind1right),rest671) end
| (191,rest671) => let val result=MlyValue.BarConBind_opt(fn _ => (
 None ))
 in (LrTable.NT 67,(result,defaultPos,defaultPos),rest671) end
| (192,(_,(MlyValue.AndExBind_opt AndExBind_opt1,_,AndExBind_optright
 as AndExBind_opt1right))::(_,(MlyValue.OfTy_opt OfTy_opt1,_,_))::(_,(
MlyValue.OpIdent OpIdent1,OpIdentleft as OpIdent1left,_))::rest671)
 => let val result=MlyValue.ExBind(fn _ => let val OpIdent as OpIdent1
=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val AndExBind_opt as AndExBind_opt1=AndExBind_opt1 ()
 in (
 let
			    val OP_OPT(id, withOp) = OpIdent
			  in
			    EXBIND(PP OpIdentleft AndExBind_optright,
				   OP_OPT(mk_ExCon id, withOp),
				   OfTy_opt, AndExBind_opt
				  )
			  end
			
) end
)
 in (LrTable.NT 46,(result,OpIdent1left,AndExBind_opt1right),rest671)
 end
| (193,(_,(MlyValue.AndExBind_opt AndExBind_opt1,_,AndExBind_optright
 as AndExBind_opt1right))::(_,(MlyValue.LongOpEqIdent LongOpEqIdent1,_
,_))::_::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as OpIdent1left,_))
::rest671) => let val result=MlyValue.ExBind(fn _ => let val OpIdent
 as OpIdent1=OpIdent1 ()
val LongOpEqIdent as LongOpEqIdent1=LongOpEqIdent1 ()
val AndExBind_opt as AndExBind_opt1=AndExBind_opt1 ()
 in (
 let
			    val OP_OPT(id1, withOp1) = OpIdent
			    val OP_OPT(id2, withOp2) = LongOpEqIdent
			  in
			    EXEQUAL(PP OpIdentleft AndExBind_optright,
				    OP_OPT(mk_ExCon id1, withOp1),
				    OP_OPT(mk_LongId id2, withOp2),
				    AndExBind_opt
				   )
			  end
			
) end
)
 in (LrTable.NT 46,(result,OpIdent1left,AndExBind_opt1right),rest671)
 end
| (194,(_,(MlyValue.ExBind ExBind1,_,ExBind1right))::(_,(_,AND1left,_)
)::rest671) => let val result=MlyValue.AndExBind_opt(fn _ => let val 
ExBind as ExBind1=ExBind1 ()
 in ( Some ExBind ) end
)
 in (LrTable.NT 69,(result,AND1left,ExBind1right),rest671) end
| (195,rest671) => let val result=MlyValue.AndExBind_opt(fn _ => (
 None ))
 in (LrTable.NT 69,(result,defaultPos,defaultPos),rest671) end
| (196,(_,(MlyValue.AndFValBind_opt AndFValBind_opt1,_,
AndFValBind_optright as AndFValBind_opt1right))::(_,(MlyValue.FClause 
FClause1,FClauseleft as FClause1left,_))::rest671) => let val result=
MlyValue.FValBind(fn _ => let val FClause as FClause1=FClause1 ()
val AndFValBind_opt as AndFValBind_opt1=AndFValBind_opt1 ()
 in (
 FVALBIND(PP FClauseleft AndFValBind_optright,
				   FClause, AndFValBind_opt
				  )
			
) end
)
 in (LrTable.NT 52,(result,FClause1left,AndFValBind_opt1right),rest671
) end
| (197,(_,(MlyValue.FValBind FValBind1,_,FValBind1right))::(_,(_,
AND1left,_))::rest671) => let val result=MlyValue.AndFValBind_opt(fn _
 => let val FValBind as FValBind1=FValBind1 ()
 in ( Some FValBind ) end
)
 in (LrTable.NT 63,(result,AND1left,FValBind1right),rest671) end
| (198,rest671) => let val result=MlyValue.AndFValBind_opt(fn _ => (
 None ))
 in (LrTable.NT 63,(result,defaultPos,defaultPos),rest671) end
| (199,(_,(MlyValue.BarFClause_opt BarFClause_opt1,_,
BarFClause_optright as BarFClause_opt1right))::(_,(MlyValue.Exp_ Exp_1
,_,_))::_::(_,(MlyValue.ColonTy_opt ColonTy_opt1,_,_))::(_,(
MlyValue.AtPat_seq1 AtPat_seq11,AtPat_seq1left as AtPat_seq11left,_))
::rest671) => let val result=MlyValue.FClause(fn _ => let val 
AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val Exp_ as Exp_1=Exp_1 ()
val BarFClause_opt as BarFClause_opt1=BarFClause_opt1 ()
 in (
 FCLAUSE(PP AtPat_seq1left BarFClause_optright,
				  AtPat_seq1, ColonTy_opt,
				  Exp_, BarFClause_opt
				 )
			
) end
)
 in (LrTable.NT 59,(result,AtPat_seq11left,BarFClause_opt1right),
rest671) end
| (200,(_,(MlyValue.FClause FClause1,_,FClause1right))::(_,(_,BAR1left
,_))::rest671) => let val result=MlyValue.BarFClause_opt(fn _ => let 
val FClause as FClause1=FClause1 ()
 in ( Some FClause ) end
)
 in (LrTable.NT 64,(result,BAR1left,FClause1right),rest671) end
| (201,rest671) => let val result=MlyValue.BarFClause_opt(fn _ => (
 None ))
 in (LrTable.NT 64,(result,defaultPos,defaultPos),rest671) end
| (202,(_,(MlyValue.AtPat_seq1 AtPat_seq11,_,AtPat_seq11right))::(_,(
MlyValue.AtPat AtPat1,AtPat1left,_))::rest671) => let val result=
MlyValue.AtPat_seq2(fn _ => let val AtPat as AtPat1=AtPat1 ()
val AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
 in ( AtPat :: AtPat_seq1 ) end
)
 in (LrTable.NT 86,(result,AtPat1left,AtPat_seq11right),rest671) end
| (203,(_,(MlyValue.AtPat_seq1 AtPat_seq11,_,AtPat_seq11right))::(_,(
MlyValue.AtPat AtPat1,AtPat1left,_))::rest671) => let val result=
MlyValue.AtPat_seq1(fn _ => let val AtPat as AtPat1=AtPat1 ()
val AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
 in ( AtPat :: AtPat_seq1 ) end
)
 in (LrTable.NT 87,(result,AtPat1left,AtPat_seq11right),rest671) end
| (204,(_,(MlyValue.AtPat AtPat1,AtPat1left,AtPat1right))::rest671)
 => let val result=MlyValue.AtPat_seq1(fn _ => let val AtPat as AtPat1
=AtPat1 ()
 in ( [AtPat] ) end
)
 in (LrTable.NT 87,(result,AtPat1left,AtPat1right),rest671) end
| (205,(_,(MlyValue.Ty Ty1,_,Ty1right))::(_,(_,COLON1left,_))::rest671
) => let val result=MlyValue.ColonTy_opt(fn _ => let val Ty as Ty1=Ty1
 ()
 in ( Some Ty ) end
)
 in (LrTable.NT 74,(result,COLON1left,Ty1right),rest671) end
| (206,rest671) => let val result=MlyValue.ColonTy_opt(fn _ => ( None 
))
 in (LrTable.NT 74,(result,defaultPos,defaultPos),rest671) end
| (207,(_,(MlyValue.Ty Ty1,_,Ty1right))::(_,(_,OF1left,_))::rest671)
 => let val result=MlyValue.OfTy_opt(fn _ => let val Ty as Ty1=Ty1 ()
 in ( Some Ty ) end
)
 in (LrTable.NT 78,(result,OF1left,Ty1right),rest671) end
| (208,rest671) => let val result=MlyValue.OfTy_opt(fn _ => ( None ))
 in (LrTable.NT 78,(result,defaultPos,defaultPos),rest671) end
| (209,(_,(_,UNDERBARleft as UNDERBAR1left,UNDERBARright as 
UNDERBAR1right))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 WILDCARDatpat(PP UNDERBARleft UNDERBARright) ))
 in (LrTable.NT 45,(result,UNDERBAR1left,UNDERBAR1right),rest671) end
| (210,(_,(MlyValue.SCon SCon1,SConleft as SCon1left,SConright as 
SCon1right))::rest671) => let val result=MlyValue.AtPat(fn _ => let 
val SCon as SCon1=SCon1 ()
 in ( SCONatpat(PP SConleft SConright, SCon) ) end
)
 in (LrTable.NT 45,(result,SCon1left,SCon1right),rest671) end
| (211,(_,(MlyValue.LongOpIdent LongOpIdent1,LongOpIdentleft as 
LongOpIdent1left,LongOpIdentright as LongOpIdent1right))::rest671) => 
let val result=MlyValue.AtPat(fn _ => let val LongOpIdent as 
LongOpIdent1=LongOpIdent1 ()
 in (
 let
			    val OP_OPT(id, withOp) = LongOpIdent
			  in
			    LONGIDatpat(PP LongOpIdentleft LongOpIdentright,
					OP_OPT(mk_LongId id, withOp)
				       )
			  end
			
) end
)
 in (LrTable.NT 45,(result,LongOpIdent1left,LongOpIdent1right),rest671
) end
| (212,(_,(_,_,EQUALSright as EQUALS1right))::(_,(_,OPleft as OP1left,
_))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 LONGIDatpat(PP OPleft EQUALSright,
				      OP_OPT(mk_LongId ["="], true)
				     )
			
))
 in (LrTable.NT 45,(result,OP1left,EQUALS1right),rest671) end
| (213,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.PatRow_opt 
PatRow_opt1,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => 
let val result=MlyValue.AtPat(fn _ => let val PatRow_opt as 
PatRow_opt1=PatRow_opt1 ()
 in ( RECORDatpat(PP LBRACEleft RBRACEright, PatRow_opt) ) end
)
 in (LrTable.NT 45,(result,LBRACE1left,RBRACE1right),rest671) end
| (214,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Pat Pat1,_,
_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtPat(fn _ => let val Pat as Pat1=Pat1 ()
 in ( PARatpat(PP LPARENleft RPARENright, Pat) ) end
)
 in (LrTable.NT 45,(result,LPAREN1left,RPAREN1right),rest671) end
| (215,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 RECORDatpat(PP LPARENleft RPARENright, None) ))
 in (LrTable.NT 45,(result,LPAREN1left,RPAREN1right),rest671) end
| (216,(_,(_,_,RPAREN1right))::(_,(MlyValue.PatComma_seq2 
PatComma_seq21,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.AtPat(fn _ => let val PatComma_seq2 as PatComma_seq21=
PatComma_seq21 ()
 in ( tupleAtPat PatComma_seq2 ) end
)
 in (LrTable.NT 45,(result,LPAREN1left,RPAREN1right),rest671) end
| (217,(_,(_,_,RBRACKET1right))::(_,(MlyValue.PatComma_seq0 
PatComma_seq01,_,_))::(_,(_,LBRACKET1left,_))::rest671) => let val 
result=MlyValue.AtPat(fn _ => let val PatComma_seq0 as PatComma_seq01=
PatComma_seq01 ()
 in ( listAtPat PatComma_seq0 ) end
)
 in (LrTable.NT 45,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (218,(_,(MlyValue.PatRow PatRow1,PatRow1left,PatRow1right))::rest671
) => let val result=MlyValue.PatRow_opt(fn _ => let val PatRow as 
PatRow1=PatRow1 ()
 in ( Some PatRow ) end
)
 in (LrTable.NT 71,(result,PatRow1left,PatRow1right),rest671) end
| (219,rest671) => let val result=MlyValue.PatRow_opt(fn _ => ( None )
)
 in (LrTable.NT 71,(result,defaultPos,defaultPos),rest671) end
| (220,(_,(_,DOTDOTDOTleft as DOTDOTDOT1left,DOTDOTDOTright as 
DOTDOTDOT1right))::rest671) => let val result=MlyValue.PatRow(fn _ => 
( C.DOTDOTDOT(PP DOTDOTDOTleft DOTDOTDOTright) ))
 in (LrTable.NT 44,(result,DOTDOTDOT1left,DOTDOTDOT1right),rest671)
 end
| (221,(_,(MlyValue.CommaPatRow_opt CommaPatRow_opt1,_,
CommaPatRow_optright as CommaPatRow_opt1right))::(_,(MlyValue.Pat Pat1
,_,_))::_::(_,(MlyValue.Label Label1,Labelleft as Label1left,_))::
rest671) => let val result=MlyValue.PatRow(fn _ => let val Label as 
Label1=Label1 ()
val Pat as Pat1=Pat1 ()
val CommaPatRow_opt as CommaPatRow_opt1=CommaPatRow_opt1 ()
 in (
 PATROW(PP Labelleft CommaPatRow_optright,
				 Label, Pat, CommaPatRow_opt
				)
			
) end
)
 in (LrTable.NT 44,(result,Label1left,CommaPatRow_opt1right),rest671)
 end
| (222,(_,(MlyValue.CommaPatRow_opt CommaPatRow_opt1,_,
CommaPatRow_optright as CommaPatRow_opt1right))::(_,(
MlyValue.AsPat_opt AsPat_opt1,_,AsPat_optright))::(_,(
MlyValue.ColonTy_opt ColonTy_opt1,_,ColonTy_optright))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,Identright))::rest671)
 => let val result=MlyValue.PatRow(fn _ => let val Ident as Ident1=
Ident1 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val AsPat_opt as AsPat_opt1=AsPat_opt1 ()
val CommaPatRow_opt as CommaPatRow_opt1=CommaPatRow_opt1 ()
 in (
 PATROW(
			    PP Identleft CommaPatRow_optright,
			    mk_IdentLab Ident,
			    let
			      val i = PP Identleft Identright
			      val idPat =
				ATPATpat(
				  i,
				  LONGIDatpat(i,
					      OP_OPT(mk_LongId [Ident], false)
					     )
				)
			    in
			      case (ColonTy_opt, AsPat_opt)
				of (_, Some pat) =>
				     LAYEREDpat(PP Identleft AsPat_optright,
						OP_OPT(mk_Id Ident, false),
						ColonTy_opt, pat
					       )

				 | (Some ty, None) =>
				     TYPEDpat(PP Identleft ColonTy_optright,
					      idPat, ty
					     )

				 | (None, None) => idPat
			    end,
			    CommaPatRow_opt
			   )
			
) end
)
 in (LrTable.NT 44,(result,Ident1left,CommaPatRow_opt1right),rest671)
 end
| (223,(_,(MlyValue.Pat Pat1,_,Pat1right))::(_,(_,AS1left,_))::rest671
) => let val result=MlyValue.AsPat_opt(fn _ => let val Pat as Pat1=
Pat1 ()
 in ( Some Pat ) end
)
 in (LrTable.NT 72,(result,AS1left,Pat1right),rest671) end
| (224,rest671) => let val result=MlyValue.AsPat_opt(fn _ => ( None ))
 in (LrTable.NT 72,(result,defaultPos,defaultPos),rest671) end
| (225,(_,(MlyValue.PatRow PatRow1,_,PatRow1right))::(_,(_,COMMA1left,
_))::rest671) => let val result=MlyValue.CommaPatRow_opt(fn _ => let 
val PatRow as PatRow1=PatRow1 ()
 in ( Some PatRow ) end
)
 in (LrTable.NT 73,(result,COMMA1left,PatRow1right),rest671) end
| (226,rest671) => let val result=MlyValue.CommaPatRow_opt(fn _ => (
 None ))
 in (LrTable.NT 73,(result,defaultPos,defaultPos),rest671) end
| (227,(_,(MlyValue.PatComma_seq1 PatComma_seq11,PatComma_seq11left,
PatComma_seq11right))::rest671) => let val result=
MlyValue.PatComma_seq0(fn _ => let val PatComma_seq1 as PatComma_seq11
=PatComma_seq11 ()
 in ( PatComma_seq1 ) end
)
 in (LrTable.NT 82,(result,PatComma_seq11left,PatComma_seq11right),
rest671) end
| (228,rest671) => let val result=MlyValue.PatComma_seq0(fn _ => (
 nil ))
 in (LrTable.NT 82,(result,defaultPos,defaultPos),rest671) end
| (229,(_,(MlyValue.PatComma_seq1 PatComma_seq11,_,PatComma_seq11right
))::_::(_,(MlyValue.Pat Pat1,Pat1left,_))::rest671) => let val result=
MlyValue.PatComma_seq1(fn _ => let val Pat as Pat1=Pat1 ()
val PatComma_seq1 as PatComma_seq11=PatComma_seq11 ()
 in ( Pat :: PatComma_seq1 ) end
)
 in (LrTable.NT 83,(result,Pat1left,PatComma_seq11right),rest671) end
| (230,(_,(MlyValue.Pat Pat1,Pat1left,Pat1right))::rest671) => let 
val result=MlyValue.PatComma_seq1(fn _ => let val Pat as Pat1=Pat1 ()
 in ( [Pat] ) end
)
 in (LrTable.NT 83,(result,Pat1left,Pat1right),rest671) end
| (231,(_,(MlyValue.PatComma_seq1 PatComma_seq11,_,PatComma_seq11right
))::_::(_,(MlyValue.Pat Pat1,Pat1left,_))::rest671) => let val result=
MlyValue.PatComma_seq2(fn _ => let val Pat as Pat1=Pat1 ()
val PatComma_seq1 as PatComma_seq11=PatComma_seq11 ()
 in ( Pat :: PatComma_seq1 ) end
)
 in (LrTable.NT 84,(result,Pat1left,PatComma_seq11right),rest671) end
| (232,(_,(MlyValue.AtPat AtPat1,AtPatleft as AtPat1left,AtPatright
 as AtPat1right))::rest671) => let val result=MlyValue.Pat(fn _ => 
let val AtPat as AtPat1=AtPat1 ()
 in ( ATPATpat(PP AtPatleft AtPatright, AtPat) ) end
)
 in (LrTable.NT 43,(result,AtPat1left,AtPat1right),rest671) end
| (233,(_,(MlyValue.AtPat_seq2 AtPat_seq21,AtPat_seq2left as 
AtPat_seq21left,AtPat_seq2right as AtPat_seq21right))::rest671) => 
let val result=MlyValue.Pat(fn _ => let val AtPat_seq2 as AtPat_seq21=
AtPat_seq21 ()
 in (
 UNRES_INFIXpat(PP AtPat_seq2left AtPat_seq2right,
					 AtPat_seq2
					)
			
) end
)
 in (LrTable.NT 43,(result,AtPat_seq21left,AtPat_seq21right),rest671)
 end
| (234,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.Pat(fn _ => let val Pat as Pat1=Pat1 ()
val Ty as Ty1=Ty1 ()
 in ( TYPEDpat(PP Patleft Tyright, Pat, Ty) ) end
)
 in (LrTable.NT 43,(result,Pat1left,Ty1right),rest671) end
| (235,(_,(MlyValue.Pat Pat2,_,Pat2right))::_::(_,(MlyValue.Pat Pat1,
Pat1left,_))::rest671) => let val result=MlyValue.Pat(fn _ => let val 
Pat1=Pat1 ()
val Pat2=Pat2 ()
 in ( layeredPat(PP Pat1left Pat2right, Pat1, Pat2) ) end
)
 in (LrTable.NT 43,(result,Pat1left,Pat2right),rest671) end
| (236,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.TupleTy TupleTy1,TupleTyleft as TupleTy1left,_))::rest671)
 => let val result=MlyValue.Ty(fn _ => let val TupleTy as TupleTy1=
TupleTy1 ()
val Ty as Ty1=Ty1 ()
 in (
 FNty(PP TupleTyleft Tyright,
			       case TupleTy
				 of [t] => t
			          | ts => tupleType ts,
			       Ty
			      )
			
) end
)
 in (LrTable.NT 37,(result,TupleTy1left,Ty1right),rest671) end
| (237,(_,(MlyValue.TupleTy TupleTy1,TupleTy1left,TupleTy1right))::
rest671) => let val result=MlyValue.Ty(fn _ => let val TupleTy as 
TupleTy1=TupleTy1 ()
 in ( case TupleTy
			    of [t] => t
			     | ts => tupleType ts
			
) end
)
 in (LrTable.NT 37,(result,TupleTy1left,TupleTy1right),rest671) end
| (238,(_,(MlyValue.Ty_sans_STAR Ty_sans_STAR1,Ty_sans_STAR1left,
Ty_sans_STAR1right))::rest671) => let val result=MlyValue.TupleTy(fn _
 => let val Ty_sans_STAR as Ty_sans_STAR1=Ty_sans_STAR1 ()
 in ( [Ty_sans_STAR] ) end
)
 in (LrTable.NT 38,(result,Ty_sans_STAR1left,Ty_sans_STAR1right),
rest671) end
| (239,(_,(MlyValue.TupleTy TupleTy1,_,TupleTy1right))::_::(_,(
MlyValue.Ty_sans_STAR Ty_sans_STAR1,Ty_sans_STAR1left,_))::rest671)
 => let val result=MlyValue.TupleTy(fn _ => let val Ty_sans_STAR as 
Ty_sans_STAR1=Ty_sans_STAR1 ()
val TupleTy as TupleTy1=TupleTy1 ()
 in ( Ty_sans_STAR :: TupleTy ) end
)
 in (LrTable.NT 38,(result,Ty_sans_STAR1left,TupleTy1right),rest671)
 end
| (240,(_,(MlyValue.LongTypeIdent LongTypeIdent1,_,LongTypeIdentright
 as LongTypeIdent1right))::_::(_,(MlyValue.TyComma_seq2 TyComma_seq21,
_,_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result
=MlyValue.Ty_sans_STAR(fn _ => let val TyComma_seq2 as TyComma_seq21=
TyComma_seq21 ()
val LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP LPARENleft LongTypeIdentright,
				TyComma_seq2, mk_LongTyCon LongTypeIdent
			       )
			
) end
)
 in (LrTable.NT 39,(result,LPAREN1left,LongTypeIdent1right),rest671)
 end
| (241,(_,(MlyValue.LongTypeIdent LongTypeIdent1,_,LongTypeIdentright
 as LongTypeIdent1right))::(_,(MlyValue.Ty_sans_STAR Ty_sans_STAR1,
Ty_sans_STARleft as Ty_sans_STAR1left,_))::rest671) => let val result=
MlyValue.Ty_sans_STAR(fn _ => let val Ty_sans_STAR as Ty_sans_STAR1=
Ty_sans_STAR1 ()
val LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP Ty_sans_STARleft LongTypeIdentright,
				[Ty_sans_STAR], mk_LongTyCon LongTypeIdent
			       )
			
) end
)
 in (LrTable.NT 39,(result,Ty_sans_STAR1left,LongTypeIdent1right),
rest671) end
| (242,(_,(MlyValue.AtomicTy AtomicTy1,AtomicTy1left,AtomicTy1right))
::rest671) => let val result=MlyValue.Ty_sans_STAR(fn _ => let val 
AtomicTy as AtomicTy1=AtomicTy1 ()
 in ( AtomicTy ) end
)
 in (LrTable.NT 39,(result,AtomicTy1left,AtomicTy1right),rest671) end
| (243,(_,(MlyValue.TyComma_seq2 TyComma_seq21,_,TyComma_seq21right))
::_::(_,(MlyValue.Ty Ty1,Ty1left,_))::rest671) => let val result=
MlyValue.TyComma_seq2(fn _ => let val Ty as Ty1=Ty1 ()
val TyComma_seq2 as TyComma_seq21=TyComma_seq21 ()
 in ( Ty :: TyComma_seq2 ) end
)
 in (LrTable.NT 90,(result,Ty1left,TyComma_seq21right),rest671) end
| (244,(_,(MlyValue.Ty Ty2,_,Ty2right))::_::(_,(MlyValue.Ty Ty1,
Ty1left,_))::rest671) => let val result=MlyValue.TyComma_seq2(fn _ => 
let val Ty1=Ty1 ()
val Ty2=Ty2 ()
 in ( [Ty1, Ty2] ) end
)
 in (LrTable.NT 90,(result,Ty1left,Ty2right),rest671) end
| (245,(_,(MlyValue.LongTypeIdent LongTypeIdent1,LongTypeIdentleft as 
LongTypeIdent1left,LongTypeIdentright as LongTypeIdent1right))::
rest671) => let val result=MlyValue.AtomicTy(fn _ => let val 
LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP LongTypeIdentleft LongTypeIdentright,
				nil, mk_LongTyCon LongTypeIdent
			       )
			
) end
)
 in (LrTable.NT 40,(result,LongTypeIdent1left,LongTypeIdent1right),
rest671) end
| (246,(_,(MlyValue.TYVAR TYVAR1,TYVARleft as TYVAR1left,TYVARright
 as TYVAR1right))::rest671) => let val result=MlyValue.AtomicTy(fn _
 => let val TYVAR as TYVAR1=TYVAR1 ()
 in ( TYVARty(PP TYVARleft TYVARright, mk_TyVar TYVAR) ) end
)
 in (LrTable.NT 40,(result,TYVAR1left,TYVAR1right),rest671) end
| (247,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.TyRow_opt 
TyRow_opt1,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => 
let val result=MlyValue.AtomicTy(fn _ => let val TyRow_opt as 
TyRow_opt1=TyRow_opt1 ()
 in ( RECORDty(PP LBRACEleft RBRACEright, TyRow_opt) ) end
)
 in (LrTable.NT 40,(result,LBRACE1left,RBRACE1right),rest671) end
| (248,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Ty Ty1,_,_)
)::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtomicTy(fn _ => let val Ty as Ty1=Ty1 ()
 in ( PARty(PP LPARENleft RPARENright, Ty) ) end
)
 in (LrTable.NT 40,(result,LPAREN1left,RPAREN1right),rest671) end
| (249,(_,(MlyValue.TyRow TyRow1,TyRow1left,TyRow1right))::rest671)
 => let val result=MlyValue.TyRow_opt(fn _ => let val TyRow as TyRow1=
TyRow1 ()
 in ( Some TyRow ) end
)
 in (LrTable.NT 76,(result,TyRow1left,TyRow1right),rest671) end
| (250,rest671) => let val result=MlyValue.TyRow_opt(fn _ => ( None ))
 in (LrTable.NT 76,(result,defaultPos,defaultPos),rest671) end
| (251,(_,(MlyValue.CommaTyRow_opt CommaTyRow_opt1,_,
CommaTyRow_optright as CommaTyRow_opt1right))::(_,(MlyValue.Ty Ty1,_,_
))::_::(_,(MlyValue.Label Label1,Labelleft as Label1left,_))::rest671)
 => let val result=MlyValue.TyRow(fn _ => let val Label as Label1=
Label1 ()
val Ty as Ty1=Ty1 ()
val CommaTyRow_opt as CommaTyRow_opt1=CommaTyRow_opt1 ()
 in (
 TYROW(PP Labelleft CommaTyRow_optright,
				Label, Ty, CommaTyRow_opt
			       )
			
) end
)
 in (LrTable.NT 36,(result,Label1left,CommaTyRow_opt1right),rest671)
 end
| (252,(_,(MlyValue.TyRow TyRow1,_,TyRow1right))::(_,(_,COMMA1left,_))
::rest671) => let val result=MlyValue.CommaTyRow_opt(fn _ => let val 
TyRow as TyRow1=TyRow1 ()
 in ( Some TyRow ) end
)
 in (LrTable.NT 77,(result,COMMA1left,TyRow1right),rest671) end
| (253,rest671) => let val result=MlyValue.CommaTyRow_opt(fn _ => (
 None ))
 in (LrTable.NT 77,(result,defaultPos,defaultPos),rest671) end
| (254,(_,(MlyValue.Integer Integer1,Integer1left,Integer1right))::
rest671) => let val result=MlyValue.SCon(fn _ => let val Integer as 
Integer1=Integer1 ()
 in ( mk_IntSCon Integer ) end
)
 in (LrTable.NT 42,(result,Integer1left,Integer1right),rest671) end
| (255,(_,(MlyValue.STRING STRING1,STRING1left,STRING1right))::rest671
) => let val result=MlyValue.SCon(fn _ => let val STRING as STRING1=
STRING1 ()
 in ( mk_StringSCon STRING ) end
)
 in (LrTable.NT 42,(result,STRING1left,STRING1right),rest671) end
| (256,(_,(MlyValue.REAL REAL1,REAL1left,REAL1right))::rest671) => 
let val result=MlyValue.SCon(fn _ => let val REAL as REAL1=REAL1 ()
 in ( mk_RealSCon REAL ) end
)
 in (LrTable.NT 42,(result,REAL1left,REAL1right),rest671) end
| (257,(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,TYVAR1right))::rest671)
 => let val result=MlyValue.TyVarSeq(fn _ => let val TYVAR as TYVAR1=
TYVAR1 ()
 in ( [mk_TyVar TYVAR] ) end
)
 in (LrTable.NT 41,(result,TYVAR1left,TYVAR1right),rest671) end
| (258,(_,(_,_,RPAREN1right))::(_,(MlyValue.TyVarComma_seq1 
TyVarComma_seq11,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.TyVarSeq(fn _ => let val TyVarComma_seq1 as 
TyVarComma_seq11=TyVarComma_seq11 ()
 in ( TyVarComma_seq1 ) end
)
 in (LrTable.NT 41,(result,LPAREN1left,RPAREN1right),rest671) end
| (259,rest671) => let val result=MlyValue.TyVarSeq(fn _ => ( nil ))
 in (LrTable.NT 41,(result,defaultPos,defaultPos),rest671) end
| (260,(_,(MlyValue.TyVarComma_seq1 TyVarComma_seq11,_,
TyVarComma_seq11right))::_::(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,_))::
rest671) => let val result=MlyValue.TyVarComma_seq1(fn _ => let val 
TYVAR as TYVAR1=TYVAR1 ()
val TyVarComma_seq1 as TyVarComma_seq11=TyVarComma_seq11 ()
 in ( mk_TyVar TYVAR :: TyVarComma_seq1 ) end
)
 in (LrTable.NT 89,(result,TYVAR1left,TyVarComma_seq11right),rest671)
 end
| (261,(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,TYVAR1right))::rest671)
 => let val result=MlyValue.TyVarComma_seq1(fn _ => let val TYVAR as 
TYVAR1=TYVAR1 ()
 in ( [mk_TyVar TYVAR] ) end
)
 in (LrTable.NT 89,(result,TYVAR1left,TYVAR1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.TopDec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : Topdec_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun QUAL_ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.QUAL_ID (fn () => i),p1,p2))
fun QUAL_STAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.QUAL_STAR (fn () => i),p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun UNDERBAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun STAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun POSINT2 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.POSINT2 (fn () => i),p1,p2))
fun NEGINT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.NEGINT (fn () => i),p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.REAL (fn () => i),p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.STRING (fn () => i),p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.ID (fn () => i),p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.TYVAR (fn () => i),p1,p2))
fun DIGIT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.DIGIT (fn () => i),p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
end
end
