(*
$File: Compiler/DECISION_TREE.sml $
$Date: 1992/09/17 14:17:50 $
$Revision: 1.1 $
$Locker:  $
*)

(*$DECTREE_DT*)
(* Just the bare datatype for decision trees. *)

signature DECTREE_DT =
  sig
    type lab
    type lvar
    type var
    type con
    type longexcon
    type scon
    type pat
    type TypeInfo
    eqtype (*pah!*) RuleNum sharing type RuleNum = int
    type (''a, 'b) map
    type CEnv

    datatype DecisionTree =
        LAB_DECOMPOSE of {bind: lvar,
			  parent: lvar,
			  lab: lab,
			  child: DecisionTree,
			  info: TypeInfo
			 }

      | CON_DECOMPOSE of {bind: lvar, parent: lvar, child: DecisionTree}
      | EXCON_DECOMPOSE of {bind: lvar, parent: lvar, child: DecisionTree}

      | CON_SWITCH of {arg: lvar,
		       selections: (con, (TypeInfo * DecisionTree)) map,
		       wildcard: DecisionTree Option
				(* An `option' because we may notice that all
				   the constructors are present. *)
		      }
      | SCON_SWITCH of {arg: lvar,
			selections: (scon, DecisionTree) map,
			wildcard: DecisionTree
		       }
      | EXCON_SWITCH of {arg: lvar,
			 selections: (longexcon * DecisionTree) list,
			 wildcard: DecisionTree
			}

      | END of {ruleNum: RuleNum, environment: CEnv}
      | FAIL
  end;

(*$DECISION_TREE: DECTREE_DT*)

signature DECISION_TREE =
  sig
    include DECTREE_DT
    type Decision

    val decisionTree:
      {pats: pat list, root: lvar, decisions: Decision list} -> DecisionTree

    type StringTree
    val layoutDecisionTree: DecisionTree -> StringTree
  end;
