;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: C32; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This file created by GILT V0.4: The Garnet Interface Builder
;;; on Apr 11, 1991, 4:52 PM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; This file uses the following objects:
;;;     TEXT-BUTTON-PANEL from package GARNET-GADGETS
;;;     MULTI-TEXT from package OPAL
;;;     LINE from package OPAL
;;;     RECTANGLE from package OPAL
;;;     X-BUTTON-PANEL from package GARNET-GADGETS
;;;     LABELED-BOX from package GARNET-GADGETS


#|
(dolist (gadget '("labeled-box-loader"
		  "x-buttons-loader"
		  "text-buttons-loader"
		  ))
  (load (merge-pathnames gadget
			 user::Garnet-Gadgets-PathName)))
;;;
;;;     Functions needed from Gilt
(load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName))
|#


;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter user::*Used-Gilt-Version* "V0.4")

(in-package "C32" :use '("LISP" "KR"))

(defun Write-Obj (obj)
  (if (stringp obj) obj
      (let ((kr::*print-as-structure* NIL))
	(write-to-string obj))))

(defun get-one-line-values (aggrel)
  (let (val1 val2)
    (opal:do-components aggrel
      #'(lambda (obj)
	  (when (g-value obj :active)
	    (push (g-value obj :name1) val1)
	    (push (g-value obj :name2) val2))))
    (list val1 val2)))

(create-instance 'one-line-prompt OPAL:AGGREGADGET
      (:BOX '(18 152 37 25))
      (:LEFT (o-formula (FIRST (GVL :BOX))))
      (:TOP (o-formula (SECOND (GVL :BOX))))
      (:middle-string " referred to as:")
      (:name1 :left)
      (:name2 (o-formula (gvl :string-val :value)))
      (:active T)
      (:parts `((:enabler ,GARNET-GADGETS:X-BUTTON
		 (:string "")
		 (:LEFT ,(o-formula (gvl :parent :left)))
		 (:TOP ,(o-formula (gvl :parent :top)))
		 (:selection-function ,#'(lambda(gadget val)
				      (s-value (g-value gadget :parent) :active
					       val))))
		(:string-val ,GARNET-GADGETS:LABELED-BOX
		 (:MIN-WIDTH 20)
		 (:LABEL-STRING ,(o-formula
				  (concatenate 'simple-string
					       (write-obj
						(gvl :parent :name1))
					       (gvl :parent :middle-string))))
		 (:LEFT ,(o-formula (+ (gvl :parent :left) 42)))
		 (:TOP ,(o-formula (+ (gvl :parent :top) 3))))
		(:legal-p ,OPAL:RECTANGLE
		 (:DRAW-FUNCTION :AND)
		 (:FILLING-STYLE ,OPAL:GRAY-FILL)
		 (:LINE-STYLE NIL)
		 (:visible ,(o-formula (not (gvl :parent :active))))
		 (:LEFT ,(o-formula (gvl :parent :string-val :left)))
		 (:TOP ,(o-formula (gvl :parent :string-val :top)))
		 (:WIDTH ,(o-formula (gvl :parent :string-val :width)))
		 (:HEIGHT ,(o-formula (gvl :parent :string-val :height)))))))
       
(create-instance 'c32-bold-font OPAL:FONT
		 (:FACE :BOLD))

(create-instance 'c32-title-font OPAL:FONT
		 (:SIZE :LARGE)
		 (:FACE :BOLD-ITALIC))

(create-instance 'GENERALIZER-POP-UP OPAL:AGGREGADGET
  (:WINDOW-LEFT 300)
  (:WINDOW-TOP 300)
  (:WINDOW-WIDTH 650)
  (:WINDOW-HEIGHT 253)
  (:FUNCTION-FOR-OK NIL)
  (:EXPORT-P NIL)
  (:WINDOW-TITLE "Generalize")
  (:PACKAGE-NAME "C32")
  (:LEFT 0)
  (:TOP 0)
  (:WIDTH (o-formula (GVL :WINDOW :WIDTH) 835))
  (:obj 'R3)
  (:slot :left)
  (:parts `(
    (:obj-list ,opal:aggrelist
      (:BOX (18 152 37 25))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 18))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 152))
      (:item-prototype ,one-line-prompt)
      (:items 1))
   (:slot-list ,opal:aggrelist
      (:BOX (333 152 37 25 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 18))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 152))
      (:item-prototype ,one-line-prompt)
      (:items 1))
	
    (:lin ,OPAL:LINE
      (:GILT-REF "TYPE-LINE")
      (:DRAW-FUNCTION :COPY)
      (:LINE-STYLE ,OPAL:LINE-2)
      (:POINTS (327 97 327 297 ))
      (:LINE-P T)
      (:GROW-P T)
      (:X1 ,(o-formula (FIRST (GVL :POINTS)) 327))
      (:Y1 ,(o-formula (SECOND (GVL :POINTS)) 97))
      (:X2 ,(o-formula (THIRD (GVL :POINTS)) 327))
      (:Y2 ,(o-formula (max (opal:gv-bottom (gvl :parent :obj-list))
			    (opal:gv-bottom (gvl :parent :slot-list))))))
    (:tit ,OPAL:TEXT
      (:GILT-REF "TYPE-TEXT")
      (:FONT ,c32-title-font)
      (:BOX (22 22 3 3 ))
      (:STRING ,(o-formula (concatenate 'simple-string
					"Generalizing "
					(write-obj (gvl :parent :obj))
					"'s "
					(write-obj (gvl :parent :slot))
					" formula")))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 22))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 22)))
    (:okcancel ,GARNET-GADGETS:TEXT-BUTTON-PANEL
      (:SELECTION-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:GILT-REF "TYPE-OKCANCEL")
      (:ITEMS ("OK" "Cancel" ))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :HORIZONTAL)
      (:BOX (518 60 117 29 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 518))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 24)))
    (:function-name ,GARNET-GADGETS:LABELED-BOX
      (:GILT-REF "TYPE-LABELED-BOX")
      (:LABEL-FONT ,c32-bold-font)
      (:LABEL-OFFSET 5)
      (:MIN-FRAME-WIDTH 300)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 6)
      (:BOX (47 60 182 18 ))
      (:MIN-WIDTH 20)
      (:LABEL-STRING "New Function Name:")
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 47))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 60)))
    (:generalizeobjects ,GARNET-GADGETS:X-BUTTON
      (:INDENT 0)
      (:H-SPACING 5)
      (:GRAY-WIDTH 3)
      (:TEXT-ON-LEFT-P T)
      (:V-SPACING 5)
      (:BUTTON-HEIGHT 20)
      (:FIXED-HEIGHT-P NIL)
      (:PIXEL-MARGIN NIL)
      (:RANK-MARGIN NIL)
      (:TEXT-OFFSET 5)
      (:SHADOW-OFFSET 5)
      (:BUTTON-WIDTH 20)
      (:FONT ,c32-bold-font)
      (:FIXED-WIDTH-P T)
      (:BOX (48 105 148 25 ))
      (:string "Generalize Objects?")
      (:selection-function
       ,#'(lambda (gadget val)
	    (let ((objlist (g-value gadget :parent :obj-list)))
	      (opal:do-components objlist #'(lambda (obj)
					 (s-value obj :active val)
					 (g-value obj :enabler :value)
					 (s-value (g-value obj :enabler) :value
						  val))))))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 48))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 105)))
    (:generalizeslots ,GARNET-GADGETS:X-BUTTON
      (:STRING "Generalize Slots?")
      (:BOX (412 103 148 25 ))
      (:FIXED-WIDTH-P T)
      (:FONT ,c32-bold-font)
      (:BUTTON-WIDTH 20)
      (:SHADOW-OFFSET 5)
      (:TEXT-OFFSET 5)
      (:RANK-MARGIN NIL)
      (:PIXEL-MARGIN NIL)
      (:FIXED-HEIGHT-P NIL)
      (:BUTTON-HEIGHT 20)
      (:V-SPACING 5)
      (:TEXT-ON-LEFT-P T)
      (:GRAY-WIDTH 3)
      (:H-SPACING 5)
      (:INDENT 0)
      (:selection-function
       ,#'(lambda (gadget val)
	    (let ((objlist (g-value gadget :parent :slot-list)))
	      (opal:do-components objlist #'(lambda (obj)
					 (s-value obj :active val)
					 (g-value obj :enabler :value)
					 (s-value (g-value obj :enabler) :value
						  val))))))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 412))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 103))))))


(defun Init-Value (obj val)
  (g-value obj :value)
  (s-value obj :value val))

(defun Set-one-line-prompts (aggrel oldnames newnames)
  (s-value aggrel :items (length oldnames))
  (opal:notice-items-changed aggrel)
  (do* ((oldns oldnames (cdr oldns))
	(oldn (car oldns)(car oldns))
	(newns newnames (cdr newns))
	(newn (write-obj (car newns))(write-obj (car newns)))
	(gadgets (get-values aggrel :components) (cdr gadgets))
	(gadget (car gadgets)(car gadgets))
	)
       ((null oldns))
    (s-value gadget :name1 oldn)
    (init-value (g-value gadget :string-val) newn)
    (s-value gadget :active T)
    (init-value (g-value gadget :enabler) T)))


(defun Show-generalize (for-obj for-slot old-objs new-objs old-slots
				new-slots func)
  (s-value GENERALIZER-POP-UP :obj for-obj)
  (s-value GENERALIZER-POP-UP :slot for-slot)
  
  (s-value (g-value GENERALIZER-POP-UP :function-name) :value "")
  (Init-Value (g-value GENERALIZER-POP-UP :generalizeobjects)
	      (if old-objs T NIL))
  (Init-Value (g-value GENERALIZER-POP-UP :generalizeslots)
	      (if old-slots T NIL))
  
  (Set-one-line-prompts (g-value GENERALIZER-POP-UP :obj-list)
			old-objs new-objs)
  (Set-one-line-prompts (g-value GENERALIZER-POP-UP :slot-list)
			old-slots new-slots)
  (s-value GENERALIZER-POP-UP :function-for-ok func)
  (let ((h (+ 30 (g-value GENERALIZER-POP-UP :height))))
    (s-value GENERALIZER-POP-UP :window-height h))
  (gilt:show-in-window GENERALIZER-POP-UP))

	
