/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _partition.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



//------------------------------------------------------------------------------
// partition.c
// implementation of data type partition
// (union find with weighted union rule and path compression)
//
// S. Naeher     1989
//------------------------------------------------------------------------------

#include <LEDA/partition.h>


void partition::clear()
{ // delete all used items

  partition_item p = used_items; 
  while (used_items)
  { p = used_items;
    used_items = used_items->next;
    clear_inf(p->info);
    delete p;
   }
 }
  


partition_item partition::find(partition_item it) 
{ // find with path compression

  partition_item x,root = it;

  while (root->father) root = root->father;

  while (it!=root)
  { x = it->father;
    it->father = root;
    it = x;
   }
  return root;
 }

void partition::union_blocks(partition_item a, partition_item b)
{ // weighted union

  a = find(a);
  b = find(b);

  if (a==b) return;

  if (a->size > b->size)
       { b->father = a;
         a->size += b->size; }
  else { a->father = b;
         b->size += a->size; }

 }

