/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  stream.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_STREAMH
#define LEDA_STREAMH

#include <LEDA/basic.h>



#if defined (__GNUG__)

struct file_ostream : public ostream 
{ file_ostream(string s) : ostream(~s,io_writeonly,a_create) {}
  file_ostream(char*  s) : ostream(s,io_writeonly,a_create) {}
  bool open(string s) 
  { ostream::open(~s,io_writeonly,a_create); return !fail(); }
};

struct file_istream : public istream
{ file_istream(string s) : istream(~s,io_readonly,a_useonly) {}
  file_istream(char*  s) : istream(s,io_readonly,a_useonly) {}
  bool open(string s)  
  { istream::open(~s,io_readonly,a_useonly); return !fail(); }
 };


struct string_istream : public istream 
{ string_istream(string s)  : istream(s.length(),~s) {}
  string_istream(char*  s)  : istream(strlen(s),s) {}
  string_istream(int argc, char** argv) 
                            : istream(512,~string(argc,argv)) {}
 };


class string_ostream : public ostream 
{ private:
  char buffer[2048];
  public:
  string_ostream() : ostream(2048,buffer) {};
  string str()     { return buffer; };
 };


#else  /* AT&T stream library */

#if defined (__ZTC__) 
#include <fstream.hpp>
#include <strstream.hpp>

/* bug in ZORTECH library ? 
   cannot derive from streams */

typedef ifstream   file_istream;
typedef ofstream   file_ostream;
typedef istrstream string_istream;
typedef ostrstream string_ostream;


#else  
#include <fstream.h>
#include <strstream.h>

struct file_ostream : public ofstream 
{ file_ostream(string s) : ofstream(~s) {}
  file_ostream(char*  s) : ofstream(s) {}
  bool open(string s)  { ofstream::open(~s); return !fail(); }
 };

struct file_istream : public ifstream
{ file_istream(string s) : ifstream(~s) {}
  file_istream(char*  s) : ifstream(s) {}
  bool open(string s)  { ifstream::open(~s); return !fail(); }
 };

struct string_istream : public istrstream 
{ string_istream(string s) : istrstream(~s) {}
  string_istream(char* s)  : istrstream(s) {}
  string_istream(int argc, char** argv) 
                           : istrstream(~string(argc,argv)) {}

 };


struct string_ostream : public ostrstream 
{ string_ostream() {};
  string str()     { return ostrstream::str(); };
 };


#endif
#endif


#if defined(__MSDOS__)   /* there is no "popen" */
typedef file_ostream cmd_ostream;
typedef file_istream cmd_istream;

#else
#if defined(__GNUG__)
struct cmd_ostream : public ostream 
{ cmd_ostream(string cmd) : ostream(fileno(popen(~cmd,"w"))) {}  };

struct cmd_istream : public istream 
{ cmd_istream(string cmd) : istream(fileno(popen(~cmd,"r"))) {}  };

#else
struct cmd_ostream : public ofstream 
{ cmd_ostream(string cmd) : ofstream(fileno(popen(~cmd,"w"))) {}
  cmd_ostream(char*  cmd) : ofstream(fileno(popen(cmd,"w"))) {} 
 };

struct cmd_istream : public ifstream 
{ cmd_istream(string cmd) : ifstream(fileno(popen(~cmd,"r"))) {}
  cmd_istream(char*  cmd) : ifstream(fileno(popen(cmd,"r"))) {} 
 };

#endif
#endif


#endif
