/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  queue.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef QUEUEH
#define QUEUEH

//------------------------------------------------------------------------------
// queue                                                                
//------------------------------------------------------------------------------

#include <LEDA/basic.h>

#ifndef SLISTH
#include <LEDA/slist.h>
#endif


#define queue(type) name2(type,queue)

#define queuedeclare(type)\
struct queue(type) : SLIST\
{\
  type name2(type,X);\
\
  void copy_el(GenPtr& x)  const { x=Copy(ACCESS(type,x)); }\
  void clear_el(GenPtr& x) const { Clear(ACCESS(type,x)); }\
\
  queue(type)() {}\
  queue(type)(const queue(type)& Q) : SLIST((SLIST&) Q) {}\
 ~queue(type)() { clear(); }\
\
  void append(type x) { SLIST::append(Convert(x)); }\
  type top()   const  { return ACCESS(type,SLIST::head()); }\
  type pop()          { type x=top(); SLIST::pop(); return x; }\
  int  size()  const  { return SLIST::length(); }\
  int  empty() const  { return SLIST::empty(); }\
  void clear()        { SLIST::clear(); }\
\
  queue(type)& operator=(const queue(type)& Q)\
  { return (queue(type)&)SLIST::operator=((SLIST&) Q); }\
};

#endif
