(*^
*)
WheelEllipse[Line[{p_, q_}], {noselength_?NumberQ, earlength_?NumberQ}] := 
Module[{triples, furthest, nose, perptofurthest, ear}, 
triples = Flatten[ 
		List @@ PreDraw3D @ Translate[(p + q) / 2][ 
					      Circle3D[$o, $i, $j]], 
		1 
	  ]; 
furthest = Flatten @ 
	Take[ 
		Select[triples, 
			Norm @ #[[{1, 2}]]  >=  
			Max[Map[Norm, #[[{1, 2}]]& /@ triples]] & 
		], 
		1 
	]; 
nose = ((p + q) / 2) + noselength Unit[(furthest - ((p + q) / 2))]; 
perptofurthest = Translate[(p + q) / 2][ 
	Cross[ 
		Vector[Line[{(p + q) / 2, nose}]], 
		Vector[Line[{p, q}]] 
	] 
			      ]; 
ear = ((p + q) / 2)  + earlength Unit[(perptofurthest - ((p + q) / 2))]; 
Circle3D[(p + q) / 2,  nose,  ear]  
]


(*


^*)